require('mydump')

ControlSumm = {}

local function sub(result, v)
	local h, l
	h = math.floor(v / 10)
	l = v % 10
	result = result - h - l
	if (result <= 0) then
		result = result + 10
	end
	result = result % 10
	if (result == 0) then
		result = 9
	end
	return result
end

function ControlSumm.GetFlashcodeKS(p)
	local temp
	local result = 0
	for i = 1, #p do
		temp = p[i]
		result = sub(result, bit32.lshift(bit32.rshift(temp, 4), 1))
		result = sub(result, bit32.band(temp, 0x0F))
	end
	return result
end

function ControlSumm.CRC_16(p, count)
	local temp
	local result = 0
	--if (length(data) - idx) < count {5} then exit

	for i = 1, count do
		for j = 0, 7 do
			temp = p[i]
			temp = bit32.rshift(temp, j)
			temp = bit32.bxor(temp, result)
			if (bit32.band(temp, 1) ~= 0) then
				result = bit32.bxor(bit32.rshift(result, 1), 0xCF)
			else
				result = bit32.rshift(result, 1)
			end
		end
	end
	return result
end

function ControlSumm.PlainCS(p, offs, len)
	--print(p, offs, len)
	--mydump.dumpPkt(p, 'PlainCS')
	local result = 0
	for i = offs, offs + len - 1 do
		result = result + p[i]
		result = bit32.band(result, 0xFF)
	end
	return result
end

function ControlSumm.SbepCS(p, len)
	return 0xFF - ControlSumm.PlainCS(p, 1, len)
end
