xmlobj = {}

-- recursively parses a Lua table for a substatement fitting to the provided tag and attribute
function xmlobj.find(var, tag, attributeKey,attributeValue)
  -- check input:
  if type(var) ~= "table" then return end
  if type(tag) == "string" and #tag == 0 then tag = nil end
  if type(attributeKey) ~= "string" or #attributeKey == 0 then attributeKey = nil end
  if type(attributeValue) == "string" and #attributeValue == 0 then attributeValue = nil end
  -- compare this table:
  if tag ~= nil then
    if var[0] == tag and (attributeValue == nil or var[attributeKey] == attributeValue) then
      --setmetatable(var,{__index=xml, __tostring=xml.str})
      return var
    end
  else
    if attributeValue == nil or var[attributeKey] == attributeValue then
      --setmetatable(var,{__index=xml, __tostring=xml.str})
      return var
    end
  end
  -- recursively parse subtags:
  for k, v in ipairs(var) do
    if type(v) == "table" then
      local ret = xmlobj.find(v, tag, attributeKey, attributeValue)
      if ret ~= nil then return ret end
    end
  end
end

function xmlobj.setprops_from_xml(obj, t)
	if not(obj) or not(t) or type(t) ~= "table" then
		return
	end
		
	for k, v in ipairs(t) do
		local propName = v[0]
		local value = v.value
		--print('Prop', propName, value)
		
		if propName and value ~= nil then
			--print('SetProp', propName, value)
			obj:SetProp(propName, value)
		end
	end
end

function xmlobj.obj_from_xml(xUi, v, parentName, customName, ignoreVirtual)
	if not(v) or type(v) ~= "table" then
		return
	end
	
	local controlType = v[0]
	local name 
	if customName then
		name = customName
	else
		name = v.name		
		if name and parentName then
			name = name:gsub("parent%$", parentName)
		end
	end
	local inherits = v.inherits
	local virtual = v.virtual
	--print(controlType, name, virtual, inherits, ignoreVirtual)
	if controlType and name and inherits then
		--print("Searching virtual", controlType, inherits)
		local vobj = xmlobj.find(xUi, controlType, "name", inherits)
		--print("vobj", vobj)
		if vobj then
			--print("Making virtual", name)
			controlType = vobj[0]
			local ct = _G[controlType]
			--print("Creating", controlType, name, parentName)
			_G[name] = ct(name, parentName)				
			xmlobj.make_from_xml(xUi, vobj, name)
			xmlobj.make_from_xml(xUi, v, name)
		end
	elseif controlType and name and (not(virtual) or ignoreVirtual) then
		local ct = _G[controlType]
		--print("Creating", controlType, name, parentName)
		_G[name] = ct(name, parentName)
		xmlobj.make_from_xml(xUi, v, name)
	end
	
	if controlType == "Layout" then
		local obj = _G[parentName]
		--print("Setting props", obj, parentName, v[0])
		xmlobj.setprops_from_xml(obj, v)
	end
end

function xmlobj.make_from_xml(xUi, t, parentName, customName)
	if not(t) or type(t) ~= "table" then
		return
	end
	
	for k, v in ipairs(t) do
		xmlobj.obj_from_xml(xUi, v, parentName, customName)
	end
end
