mydump = {}

local function fill_deep(d)
	local s = ''
	for i = 1, d - 1 do
		s = s..'  '
	end
	return s
end

function mydump.dump(tbl, deep, maxdeep)
	if not(deep) then
		deep = 1
	end
	if not(maxdeep) then
		maxdeep = 3
	end
	for k, v in pairs(tbl) do
		local k_str = tostring(k)
		if type(k) == "string" then
			k_str = '"'..k_str..'"'
		end
		k_str = '['..k_str..']'
		
		if type(v) == "table" then
			if deep <= maxdeep then
				print(fill_deep(deep)..k_str..' = {')
				mydump.dump(v, deep + 1, maxdeep)
				print(fill_deep(deep)..'},')
			end
		elseif type(v) == "number" then
			print(fill_deep(deep)..k_str..' = '..tostring(v)..',')
		else 
			print(fill_deep(deep)..k_str..' = "'..tostring(v)..'",')
		end
	end
end

local function toHex(v)
	return string.format("%.2X", v)
end

local function addSign(str, sign)
	if sign and sign ~= "" then
		return "("..sign..") "..str
	else
		return str
	end
end

function mydump.dumpPkt(v, sign, zerobased)
	if not(v) then
		print("dumpPkt data is nil")
	elseif type(v) ~= "table" then
		print("data type is "..type(v))
	elseif #v > 0 then
		--print(sign.." dump, length "..#v..", data:")
		local temp = ""
		local low, high, wrap
		if zerobased then
			low, high = 0, #v
			wrap = 0x0F
		else
			low, high = 1, #v
			wrap = 0
		end
		
		for i = low, high do
			temp = temp..toHex(v[i]).." "
			if i % 0x10 == wrap then
				--temp = temp.."\n"
				print(addSign(temp, sign))
				temp = ""
			end
		end
		if temp ~= "" then
			--temp = temp.."\n"
			print(addSign(temp, sign))
		end
	end
end
