require('winFileGui')
require('dXml')
require('lua/mydump')
require('lua/ObjFromXml')
require('scripts/fdb_descr')
require('scripts/settings')
require('scripts/sb9600')

--[[m = TMemo("MemoLog") --MemoLog required for "print" function
m:SetProp("Align", "alClient")
m:SetProp("Lines.Text", "")
m:SetProp("ScrollBars", "ssBoth")
m:SetProp("WordWrap", false)
m:SetProp("Font.Name", "Courier New")]]

local xUi = dXml.totable('scripts/mainform.xml')

--mydump.dump(xUi, 1, 10)

xmlobj.make_from_xml(xUi, xUi, "", false)

PanelTopSpeedButtonOpen:Invoke("Glyph.LoadFromFile", "images\\open_document_32.bmp")
PanelTopSpeedButtonSave:Invoke("Glyph.LoadFromFile", "images\\save_32.bmp")
PanelTopSpeedButtonSaveAs:Invoke("Glyph.LoadFromFile", "images\\save_green_32.bmp")
PanelTopSpeedButtonRead:Invoke("Glyph.LoadFromFile", "images\\refresh_doc_32.bmp")
PanelTopSpeedButtonWrite:Invoke("Glyph.LoadFromFile", "images\\properties_doc_32.bmp")

PanelTopSpeedButtonSave:SetProp("Enabled", false)
PanelTopSpeedButtonSaveAs:SetProp("Enabled", false)
PanelTopSpeedButtonWrite:SetProp("Enabled", false)

--PageControl1TabSheetGridStringGrid:SetProp("Cells[1,1]", "test")

StatusBar1:Invoke("Panels.Add")
StatusBar1:Invoke("Panels.Add")
StatusBar1:SetProp("Panels[0].Width", 60)
StatusBar1:SetProp("Panels[0].Text", "flashcode")
StatusBar1:SetProp("Panels[1].Width", 150)
StatusBar1:SetProp("Panels[1].Text", "")

local panels = {}
local TITLE_TEMPLATE = "FDB tool"
local gfName
local gFilterIndex
local fdbOffset = 0x200
local DBF_SIZE = 35
local flashcode_len = 6
local flashcode_offs = 29
local data = {}
local sb9600 = class(SB9600)


PageControl1TabSheetMainScrollBox:SetRedraw(false)
for i = DBF_SIZE - 1, 1, -1 do
	panels[i] = {}
	local p = panels[i]
	local name = "PanelInfo"..tostring(i)
	local xp = xmlobj.find(xUi, "TPanel", "name", "PanelBoxTemplate")
	--mydump.dump(xp, 1, 10)
	if xp then
		--print("calling make_from_xml", xp, name)
		xmlobj.obj_from_xml(xUi, xp, "PageControl1TabSheetMainScrollBox", name, true)
		p.panel = _G[name]
		--p.panel = TPanel(name, )
		p.hdr = _G[name.."PanelHdr"]
		p.label = _G[name.."PanelHdr".."Label"]
		p.label:SetProp("Caption", tostring(i))
		p.datapanels = {}
		for j = 0, 7 do
			p.datapanels[j] = {}
			local pd = p.datapanels[j]
			--pd.panel = _G[name.."Panel"..tostring(j)]
			pd.bit = _G[name.."Panel"..tostring(j).."LabelBit"]
			pd.checkbox = _G[name.."Panel"..tostring(j).."CheckBox"]
			pd.descr = _G[name.."Panel"..tostring(j).."LabelDescr"]
			pd.bit:SetProp("Caption", tostring(j))
			local descr = fdb_descr[i][j]
			if descr then
				pd.descr:SetProp("Caption", descr)
			end
		end
	end
end
PageControl1TabSheetMainScrollBox:SetRedraw(true)

local function CheckboxesToArray()
	local buf = {}
	for i = 1, DBF_SIZE - 1 do
		local temp = 0
		local p = panels[i]
		for j = 0, 7 do
			local pd = p.datapanels[j]
			local is_checked = pd.checkbox:GetProp("Checked")
			if is_checked == true then
				temp = bit32.bor(temp, bit32.lshift(1, j))
			end
		end
		buf[i] = bit32.band(temp, 0xFF)
	end
	--mydump.dumpPkt(buf, "flashcode")
	return buf
end

local function ShowFlashcode()
	local cb_buf = CheckboxesToArray()
	local fc_buf = {}
	ArrayCopyExt(cb_buf, flashcode_offs, fc_buf, 1, flashcode_len)
	--mydump.dumpPkt(fc_buf, "flashcode")
	local ks = ControlSumm.GetFlashcodeKS(fc_buf)
	local text = string.format("%.2X%.2X%.2X-%.2X%.2X%.2X-%d",
	fc_buf[1],
	fc_buf[2],
	fc_buf[3],
	fc_buf[4],
	fc_buf[5],
	fc_buf[6],
	ks)
	StatusBar1:SetProp("Panels[1].Text", text)
end

local function EnableOnChange()
	for i = flashcode_offs, flashcode_offs + flashcode_len - 1 do
		local p = panels[i]
		for j = 0, 7 do
			local pd = p.datapanels[j]
			pd.checkbox:SetEvent("OnClick", ShowFlashcode)
		end
	end
end

local function DisableOnChange()
	for i = flashcode_offs, flashcode_offs + flashcode_len - 1 do
		local p = panels[i]
		for j = 0, 7 do
			local pd = p.datapanels[j]
			pd.checkbox:SetEvent("OnClick", nil)
		end
	end
end

local function ApplyBitsToView()
	local offs = fdbOffset
	if data[offs] == 0x22 then
		DisableOnChange()
		PageControl1TabSheetMainScrollBox:SetRedraw(false)
		for i = 1, DBF_SIZE - 1 do
			local v = data[offs + i]
			--print(offs + i, v)
			if v then
				local p = panels[i]
				for j = 0, 7 do
					local pd = p.datapanels[j]
					local is_checked = bit32.band(1, bit32.rshift(v, j)) == 1
					pd.checkbox:SetProp("Checked", is_checked)
				end
			end
		end
		PageControl1TabSheetMainScrollBox:SetRedraw(true)
		EnableOnChange()
	end
end

local function SendMemacsRequest(IsNormal, WithReset, dev, group_addr)
	local buf = {}
	local temp = 0

	if not(IsNormal) then
		temp = 1
	end
	if (WithReset) then
		temp = bit32.bor(temp, 0x80)
	end
	-- D3-D2: = 00 when modifying EEPROM
	-- 01 when modifying RAM
	-- 10 when modifying OPTION DEVICE 1
	-- 11 when modifying OPTION DEVICE 2
	temp = bit32.bor(temp, bit32.lshift(bit32.band(dev, 3), 1))

	buf[1] = 0x00
	buf[2] = temp
	buf[3] = group_addr
	buf[4] = 0x08
	buf[5] = ControlSumm.CRC_16(buf, 4, 0x00FF) -- ks

	return sb9600:SendRepeatAndWait(buf)
end

local function FillReadReq(size, dev, addr)
	local buf = {}
	-- F5#11#02#00#00#02#F5
	buf[1] = 0xF5
	buf[2] = 0x11
	buf[3] = size
	buf[4] = bit32.band(bit32.bor(dev, bit32.band(bit32.rshift(addr, 16), 0xF)), 0xF)
	buf[5] = bit32.band(bit32.rshift(addr, 8), 0xFF)
	buf[6] = bit32.band(addr, 0xFF)
	buf[7] = ControlSumm.SbepCS(buf, 6)
	return buf
end

local function FillWriteReq(bdata, size, dev, addr)
	local len = 7 + size + 1
	local data_len = size + 4
	local buf = {}

	-- FF#17.......
	buf[1] = 0xFF
	buf[2] = 0x17
	buf[3] = bit32.band(bit32.rshift(data_len, 8))
	buf[4] = bit32.band(data_len)
	buf[5] = bit32.band(bit32.bor(dev, bit32.band(bit32.rshift(addr, 16), 0xF)))
	buf[6] = bit32.band(bit32.rshift(addr, 8))
	buf[7] = bit32.band(addr, 0xFF)
	-- data
	ArrayCopyExt(bdata, 1, buf, 8, size)
	--mydump.dumpPkt(buf, 'buf')
	buf[len] = ControlSumm.SbepCS(buf, len - 1)
	return buf
end

local function SaveFile()
	local cb_buf = CheckboxesToArray()
	ArrayCopyExt(cb_buf, 1, data, fdbOffset + 1, #cb_buf)

	DisableOnChange()
	if gFilterIndex == 1 then
		local buf = {}
		ArrayCopyExt(data, 0, buf, 1, #data + 1)
		local written = winFileGui.FileWrite(gfName, buf)
		print(string.format('written %d', written))
	else
		local temp = ""
		local reading_at = 0
		local buf_at = 0
		local f = io.open(gfName, "w")
		while (buf_at <= #data) do --zero based array, size + 1
			local reading_len = #data + 1 - buf_at
			if (reading_len > 0x20) then
				reading_len = 0x20
			end
			--print(buf_at, reading_len)
			temp = string.format("S1%.2X%.4X", reading_len + 3, reading_at)
			for i = 0, reading_len - 1 do
				temp = temp..string.format("%.2X", data[buf_at + i])
			end
			local ks = ControlSumm.PlainCS(data, buf_at, reading_len)
			ks = ks + bit32.band(3 + reading_len + bit32.rshift(reading_at, 8) + bit32.band(reading_at, 0xFF), 0xFF)
			temp = temp..string.format("%.2X", bit32.band(0xFF - ks, 0xFF)).."\n"
			f:write(temp)

			buf_at = buf_at + reading_len
			reading_at = reading_at + reading_len
		end
		temp = "S9030000FC"
		f:write(temp)
		f:close()
	end
	EnableOnChange()
end

local function SaveFileDlg()
	local asIndex = 1
	local fHandle = PanelTop:GetProp('Parent.Handle')
	-- parentHandle, Title, InitialDir, FileName, Filter, DefExt, FilterIndex
	local result, fname, filterIndex = winFileGui.FileSaveDialog(fHandle, "Save eeprom as ...", "", "", "Binary *.bin|*.bin|Intel hex *.s19|*.s19", "bin", asIndex)
	
	if result and fname then
		gfName = fname
		gFilterIndex = filterIndex
		PanelTopSpeedButtonSave:SetProp("Enabled", true)
		SaveFile()
	end
end
--[[local function BrowseFolderDlg()
	local fHandle = PanelTop:GetProp('Parent.Handle')
	-- parentHandle, Title, InitialDir, FileName, Filter, DefExt, FilterIndex
	local folder = winFileGui.BrowseFolderDialog(fHandle, "It's dialog")
	
	print(folder)
end]]

local function OpenFileDlg()
	local fHandle = PanelTop:GetProp('Parent.Handle')
	-- parentHandle, Title, InitialDir, FileName, Filter, DefExt, FilterIndex
	local result, fname, filterIndex = winFileGui.FileOpenDialog(fHandle, "Open eeprom", "", "", "Binary *.bin|*.bin|Intel hex *.s19|*.s19", "")
	
	if result and fname then
		gfName = fname
		gFilterIndex = filterIndex
		if filterIndex == 1 then
			data = winFileGui.FileRead(fname)
			--mydump.dumpPkt(data, "", true)
		else
			for s in io.lines(fname) do
				if (#s >= 10) then
					local s_size = s:sub(3, 4)
					local s_offs = s:sub(5, 8)
					local s_data = s:sub(9, #s - 2)
					local s_ks_data = s:sub(3, #s)
	
					local d_size = tonumber(s_size, 16)
					local d_offs = tonumber(s_offs, 16)
					print(s)
					--print(s_size, s_offs, s_data, s_ks_data, d_size, d_offs)
	
					local data_len = bit32.rshift(#s_data, 1)
					local b_data = {}
					for i = 1, data_len do
						local start = (i - 1) * 2 + 1
						local hx = s_data:sub(start, start + 1)
						b_data[i] = tonumber(hx, 16)
					end
					--mydump.dumpPkt(b_data, 'b_data')
	
					if (s:sub(1, 2) == 'S1') then
						local ks_data_len = bit32.rshift(#s_ks_data, 1)
						local ks_data = {}
						for i = 1, ks_data_len do
							local start = (i - 1) * 2 + 1
							local hx = s_ks_data:sub(start, start + 1)
							ks_data[i] = tonumber(hx, 16)
						end
						--mydump.dumpPkt(ks_data, 'ks_data')
	
						local ks = ControlSumm.PlainCS(ks_data, 1, #ks_data)
						--print(ks)
						if (ks ~= 0xFF) then
							error(string.format('wrong ks %.2X at %s', ks, s))
						end
	
						ArrayCopyExt(b_data, 1, data, d_offs, data_len)
					end
				end
			end
		end
		ApplyBitsToView()
		ShowFlashcode()
		PanelTopSpeedButtonSave:SetProp("Enabled", true)
		PanelTopSpeedButtonSaveAs:SetProp("Enabled", true)
		PanelTopSpeedButtonWrite:SetProp("Enabled", true)
		PanelTop:SetProp("Parent.Caption", TITLE_TEMPLATE..": "..tostring(winFileGui.ExtractFileName(fname)))
	end
end

local function Read_Click()
	local mem_read_req
	local mem_base, mem_len, mem_end, reading_at, buf_at, reading_len, retry_cnt
	local core_len, bonus_len
	local dev
	local pure_len, data_offs
	local out_buf
	local isDone = false
	local bonus_at = 0x2A6

	PageControl1:SetProp("TabIndex", 1)
	if not(sb9600:OpenPort("COM"..tostring(settings.port.Number),
		settings.port.Baud, 
		settings.port.Bits, 
		settings.port.StopBits, 
		settings.port.Parity, 
		false, false)) then
		print("Cannot open COM"..tostring(settings.port.Number))
		return
	end

	if not(SendMemacsRequest(false, false, 0, 1)) then
		return
	end
	if not(sb9600:EnterSbepMode(1)) then
		return
	end

	dev = 0

	-- reading sizes
	mem_read_req = FillReadReq(2, dev, 2)
	if not(sb9600:SendRepeatAndWait(mem_read_req)) then
		sb9600:ClosePort()
		return
	end
	if (#sb9600.RecvPkt < 6) then
		return
	end
	core_len = bit32.lshift(sb9600.RecvPkt[6], 8) + sb9600.RecvPkt[7]
	print(string.format("core len %X", core_len))
	-- reading bonus
	mem_read_req = FillReadReq(2, dev, bonus_at)
	if not(sb9600:SendRepeatAndWait(mem_read_req)) then
		sb9600:ClosePort()
		return
	end
	if (#sb9600.RecvPkt < 6) then
		return
	end
	bonus_len = bit32.lshift(sb9600.RecvPkt[6], 8) + sb9600.RecvPkt[7]
	print(string.format("bonus len %X4", bonus_len))
	mem_len = core_len + bonus_len

	out_buf = {}
	mem_base = fdbOffset
	reading_at = 0
	buf_at = 0
	retry_cnt = 0
	mem_end = mem_base + mem_len
	while (reading_at < mem_end) do
		reading_len = mem_end - reading_at
		if (reading_len > 0x40) then
			reading_len = 0x40
		end

		print(string.format("reading at %X", reading_at))
		mem_read_req = FillReadReq(reading_len, dev, reading_at)
		if not(sb9600:SendRepeatAndWait(mem_read_req)) then
			sb9600:ClosePort()
			return
		end

		local is_success, pkt_len, pkt_data_len
		if (sb9600.RecvPkt) and (#sb9600.RecvPkt > 0) then
			is_success, pkt_len, pkt_data_len = sb9600:GetSbepPktLen(sb9600.RecvPkt, #sb9600.RecvPkt)
		else
			is_success = false
		end
		if (sb9600.SbepResp ~= SB9600.SBEP_ACK) or not(is_success) then
			retry_cnt = retry_cnt + 1
			if (retry_cnt > 2) then
				print(string.format("failed GetSbepPktLen at retry %d", retry_cnt))
				return
			end
		else
			retry_cnt = 0
			if (pkt_len <= 0xE) then
				data_offs = 6
			else
				data_offs = 8
			end
			pure_len = pkt_data_len - 4

			ArrayCopyExt(sb9600.RecvPkt, data_offs, out_buf, buf_at, pure_len)

			buf_at = buf_at + reading_len
			reading_at = reading_at + reading_len
		end
	end
	print("success")
	ArrayCopyExt(out_buf, 0, data, 0, #out_buf + 1)
	--PanelTopSpeedButtonSave:SetProp("Enabled", true)
	PanelTopSpeedButtonSaveAs:SetProp("Enabled", true)
	PanelTopSpeedButtonWrite:SetProp("Enabled", true)
	PanelTop:SetProp("Parent.Caption", TITLE_TEMPLATE..": Radio")
	isDone = true

	sb9600:LeaveSbepMode()
	SendMemacsRequest(true, false, 0, 1)
	sb9600:ClosePort()
	

	if (isDone) then
		ApplyBitsToView()
		ShowFlashcode()
		SaveFileDlg()
	end
end

local function Write_Click()
	local mem_write_req, temp_arr
	local mem_base, mem_len, mem_end, writing_at, buf_at, writing_len, retry_cnt
	local dev
	local pkt_len, pkt_data_len
	local out_buf
	local temp, ks, op

	PageControl1:SetProp("TabIndex", 1)
	if not(sb9600:OpenPort("COM"..tostring(settings.port.Number),
		settings.port.Baud, 
		settings.port.Bits, 
		settings.port.StopBits, 
		settings.port.Parity, 
		true, true)) then
		print("Cannot open COM"..tostring(settings.port.Number))
		return
	end

	if not(SendMemacsRequest(false, false, 0, 1)) then
		return
	end
	if not(sb9600:EnterSbepMode(1)) then
		return
	end

	dev = 0
	mem_len = 0x24

	out_buf = {}
	out_buf[0] = 0x22

	for i = 1, DBF_SIZE - 1 do
		temp = 0
		local p = panels[i]
		for j = 0, 7 do
			local pd = p.datapanels[j]
			local is_checked = pd.checkbox:GetProp("Checked")
			if is_checked == true then
				temp = bit32.bor(temp, bit32.lshift(1, j))
			end
			--print(i, j, is_checked, type(is_checked), string.format('%.2X', temp))
		end
		out_buf[i] = bit32.band(temp, 0xFF)
	end
	ks = ControlSumm.PlainCS(out_buf, 1, mem_len - 2)
	out_buf[mem_len - 1] = bit32.band(ks - 0x33, 0xFF)
	--mydump.dumpPkt(out_buf, 'out_buf', true)

	mem_base = fdbOffset
	writing_at = mem_base
	buf_at = 0
	retry_cnt = 0
	mem_end = mem_base + mem_len
	while (writing_at < mem_end) do
		writing_len = mem_end - writing_at
		if (writing_len > 0x20) then
			writing_len = 0x20
		end

		print(string.format("writing at %.2X, writing_len %.2X", writing_at, writing_len))
		temp_arr = {}
		ArrayCopyExt(out_buf, buf_at, temp_arr, 1, writing_len)
		mem_write_req = FillWriteReq(temp_arr, writing_len, dev, writing_at)
		if not(sb9600:SendRepeatAndWait(mem_write_req)) then
			sb9600:ClosePort()
			return
		end

		-- returns ack, GOOD_WRITE_REPLY or BAD_WRITE_REPLY
		-- 50
		-- F4 84 00 02 80 05
		local is_success, pkt_len, pkt_data_len
		if (sb9600.RecvPkt) and (#sb9600.RecvPkt > 0) then
			is_success, pkt_len, pkt_data_len = sb9600:GetSbepPktLen(sb9600.RecvPkt, #sb9600.RecvPkt)
		else
			is_success = false
		end
		if (sb9600.SbepResp ~= sb9600.SBEP_ACK) or not(is_success) then
			retry_cnt = retry_cnt + 1
			if (retry_cnt > 2) then
				print(string.format("failed GetSbepPktLen at retry %d", retry_cnt))
				return
			end
		else
			op = sb9600.RecvPkt[2]
			--print(string.format('op %.2X', op))
			if (op == sb9600.GOOD_WRITE_REPLY) then
				retry_cnt = 0

				buf_at = buf_at + writing_len
				writing_at = writing_at + writing_len
				--print(string.format("buf_at %.2X, writing_at %.2X", buf_at, writing_at))
			else
				retry_cnt = retry_cnt + 1
				if (retry_cnt > 2) then
					print(string.format("failed GetSbepPktLen at retry %d", retry_cnt))
					return
				end
			end
		end
	end
	print("success")
	sb9600:LeaveSbepMode()
	SendMemacsRequest(true, false, 0, 1)
	sb9600:ClosePort()
end

PanelTopSpeedButtonOpen:SetEvent('OnClick', OpenFileDlg)
PanelTopSpeedButtonSave:SetEvent('OnClick', SaveFile)
PanelTopSpeedButtonSaveAs:SetEvent('OnClick', SaveFileDlg)
PanelTopSpeedButtonRead:SetEvent('OnClick', Read_Click)
PanelTopSpeedButtonWrite:SetEvent('OnClick', Write_Click)
