p1 = TPanel('Panel1')
p1:SetProp('Align', 'alTop')
p1:SetProp('Caption', '')
p1:SetProp('Height', 160)
--print(tostring(p1:GetProp('Anchors')))
p1:SetProp('Parent.Width', 500)
p1:SetProp('Parent.Height', 500)
p1:SetProp('Parent.Position', 'poDesktopCenter')

c = TComboBox('ComboBox1', 'Panel1')
c:SetProp('Top', 100)
c:SetProp('Left', p1:GetProp('Width') / 2 - c:GetProp('Width') / 2)
c:SetProp('Items.Text', '+\n-\n*\n/')
c:SetProp('ItemIndex', 0)
--print(tostring(c:GetProp('Items.Text')))

p2 = TPanel('Panel2')
p2:SetProp('Align', 'alBottom')
p2:SetProp('Caption', '')

e1 = TEdit('Edit1', 'Panel1')
e1:SetProp('Top', 40)
e1:SetProp('Left', p1:GetProp('Width') / 2 - e1:GetProp('Width') / 2)
e1:SetProp('Text', '100')

e2 = TEdit('Edit2', 'Panel1')
e2:SetProp('Top', 70)
e2:SetProp('Left', p1:GetProp('Width') / 2 - e2:GetProp('Width') / 2)
e2:SetProp('Text', '200')

l = TLabel('Label1', 'Panel1')
l:SetProp('Top', 130)
l:SetProp('Left', e1:GetProp('Left'))
l:SetProp('Caption', '')

b = TButton('Button1', 'Panel2')
b:SetProp('Caption', 'Click me!')
b:SetProp('Top', p2:GetProp('Height') / 2 - b:GetProp('Height') / 2)
b:SetProp('Left', p2:GetProp('Width') / 2 - b:GetProp('Width') / 2)
--print(tostring(b:GetProp('Anchors')))
b:SetProp('Anchors', '[akRight,akBottom]')
b:SetProp('Visible', 'True')

p3 = TPanel('Panel3')
p3:SetProp('Align', 'alClient')
p3:SetProp('Caption', '')

m = TMemo('Memo1', 'Panel3')
m:SetProp('Align', 'alClient')
m:SetProp('Lines.Text', 'line 1\nline 2\nline 3')
m:SetProp('ScrollBars', 'ssBoth')

function fill_deep(d)
	local s = ''
	for i = 1, d - 1 do
		s = s..'  '
	end
	return s
end

function dump(tbl, deep, maxdeep)
	for k, v in pairs(tbl) do
		if type(v) == "table" then
			if deep <= maxdeep then
				print(fill_deep(deep)..'k '..tostring(k).." table:")
				dump(v, deep + 1, maxdeep)
			end
		else 
			print(fill_deep(deep)..'k '..tostring(k)..', v '..tostring(v))
		end
	end
end

--print('metatable = ', tostring(getmetatable(t)))
dump(_G, 1, 2)

print(tostring(m:GetProp('Lines.Count')))
print('result: '..tostring(m:Invoke('Lines.Add', 'text')))

function b:OnClick()
	local ii = c:GetProp('ItemIndex')
	local a, b, r = tonumber(e1:GetProp('Text')), tonumber(e2:GetProp('Text')), nil
	if ii == 0 then -- +
		r = a + b
	elseif ii == 1 then -- -
		r = a - b
	elseif ii == 2 then -- *
		r = a * b
	elseif ii == 3 then -- /
		r = a / b
	end
	
	l:SetProp('Caption', tostring(r))
	self:SetProp('Caption', 'Done')
end

function ComboboxesOnChange(self)
	print(tostring(self:GetProp('ItemIndex')))
end

--simple function to dump available properties
print(p1:GetProp('Name')..'.Parent properties:')
a = p1:EnumProperties('Parent')
for k, v in ipairs(a) do
	print(v)
end

b:SetEvent('OnClick', b.OnClick)
c:SetEvent('OnChange', ComboboxesOnChange)