#ifndef _CONNECTION_MANAGER_H_
#define _CONNECTION_MANAGER_H_
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2015 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: ConnectionManager.h
#
# --------------------------- General Description -----------------------------
# This file contains the declarations for connection manager's state and
# inter-task messages between connection manager and other managers
#
*--------------------------- Revision History ----------------------------------
*
* AUTHOR           Date Modified CR Tracking Number Description
* YewFoong         09/06/2010    CCMPD01384903      Added new state "IDLE_STATE", and updated
*                                                   naming convention of inter-task messages sent
*                                                   between Connection manager and other managers
* YewFoong         10/06/2010   CCMPD01398513       Updated the definition based on the new state diagram
* YewFoong         10/18/2010   CCMPD01403711       Created new macros for BT Manager to handle internal state sequence
*                                                   and define SPP_CONNECT_FIRST to allow dongle to connect with SPP first
* YewFoong         10/22/2010   CCMPD01407520       Removed the macros for SPP_CONNECT_FIRST which was defined temporary
*                                                   for SPP connnect first.
*                                                   Added macro for BT_HS_RING_TIMEOUT
* Tan Seng Kai     10/27/2010   CCMPD01407568       Add HSP and SPP pairing state
* YewFoong         10/29/2010   CCMPD01408237       Added macro for BT_STOP_SPP_CONNECT_REQUEST, BT_HS_ACCEPT_CKPD_CMND_REQUEST,
*                                                   and sppDevStateType.
* YewFoong         10/29/2010   CCMPD01408762       Added new macro for handling user requested pairing validation
* YK - JWPM67      Nov/15/2010  CCMPD01413200       Added new inter-task messages USER_PTT_PRESS_DETECTED_ACK,
*                                                   USER_VALID_PAIRING_REQUEST_ACK, and USER_INVALID_PAIRING_REQUEST_ACK,
* Guru Mahesh      11/24/2010   CCMPD01414087       Message added for MPP
*                                                   MPP_INIT_HOST_MPP_PKT_REQ,
*                                                   MPP_HOST_CONN_ALLOC_RES_DB_REQ,
*                                                   MPP_READY_PAIR,
*                                                   MPP_SUCC_PAIR.
* JJ Low           11/30/2010   CCMPD01446399       Add Test Commander Pairng Mode command
* YewFoong         11/03/2010   CCMPD01409995       Added new macro for Device Discovery Type
* YewFoong         11/10/2010   CCMPD01412657       Added new macro for CP_SELECT_ON & CP_SELECT_OFF
* YewFoong         12/12/2010   CCMPD01413554       Added new macro for Headset Pairing fail scenario
* YewFoong         11/18/2010   CCMPD01411683       Added new macro for Bluetooth Qualification Test Mode scenario
* YewFoong         11/24/2010   CCMPD01419110       Added new macro for DONGLE_LONG_PTT_PRESSED_ACK for BQB test
* YewFoong         12/10/2010   CCMPD01452415       Added new macro for idle state
* Tan Seng Kai     17/12/2010   CCMPD01455488       Remove reconnection request for R1.4
* YewFoong         12/20/2010   CCMPD01455955       Added new macro for fatal error handling
* Mahes            Jan/06/2011  CCMPD01460340       Software catch-up to dongle R1.2 version R01.00.00
* Mahesh           07-Jan-2011  CCMPD01460638       Added  initial MPP inter task messages
* Mahesh           14-Jan-2011  CCMPD01462973       added Inter task timer to update link key ( randomizer )
* PeiSee Toh       01/17/2011   CCMPD01462570       Added messages for BT connection request after MPP pairing
* Tan Seng Kai     01/25/2011   CCMPD01466195       Implement Multiple pairing state machine for MPP base pairing
* Mahesh           09-Feb-2011  CCMPD01471861       new message added for audio device con/disconn
*                                                   (1)AUDIO_DEVICE_CONNECTED_STATE_UPDATE(2)DEVICE_CONNECTED_STATE_UPDATE (3)AUDIO_DEVICE_DISCONNECTED_STATE_UPDATE
* Tan Seng Kai     02/11/2011    CCMPD01471859      Implement align to new MSC diagram. SecureWireless_R2.1_R2.0_R2.3_data_connection.pdf
* Tan Seng Kai     02/17/2011   CCMPD01474548       Handing for device with same bluetooth address but different profile
* Tan Seng Kai     03/04/2011   CCMPD01481275       Add intertask message BT_NORMAL_LED_MODE and BT_LED_DARK_MODE
* Tan Seng Kai     29/04/2011   CCMPD01503017       add new intertast message BT_CONNECT_ACL_SUCCESS_ACK
* Toh PeiSee       16/12/2011   CCMPD01592074       Add intertask message of BT_SET_DEFAULT_TRANSMIT_POWER_REQUEST
* Sean             08/29/2013   CCMPD01806989       Define new Msg MPP_REENABLE_TIMER 
* WRN637           17/09/2013   CCMPD01815073       Add Button handling for R2.17 Wireless Gateway P0B board
* wrn637           17/9/2013    CCMPD01815076       Remove Low power reconnection feature
* Abhishek Trivedi 10/16/2013   CCMPD01827271       XNL-XCMP Host implementation
* wrn637           10/16/2013   CCMPD01826478       Audio detection handling
* WRN637           12/20/2013   CCMPD01833277       WPTT state machine
* WRN637           01/07/2014   CCMPD01849957       Volume tone request
* WRN637           06/01/2014   CCMPD01849533       Standard pairing fixes  
* WRN637           01/22/2014   CCMPD01854392       Move XCMP related handling to HSP_XNL_XCMP_MANAGER_TASK to prevent multiple access to XCMP decoder at the same time    
* Abhishek Trivedi 03/10/2014   CCMPD01870625       CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi 03/18/2014	CCMPD01873731	    Resolve 2 device connection issue
* Aneeket Patkar   03/28/2014   CCMPD01877631       Remove Volume ramp feature as per the updated design
* Abhishek Trivedi 04/04/2014   CCMPD01880139       Reset on DSP Command failure
* Abhishek Trivedi 04/04/2014   CCMPD01882874       Interchip Ping and CSR Version Check
* Abhishek Trivedi 04/18/2014   CCMPD01885148       System Ping Timeout
* Abhishek Trivedi 10/22/2014   CCMPD01938895       Audio Switch
* Abhishek Trivedi 06/05/2014   CCMPD01900617       Version Request Support
* Abhishek Trivedi 10/24/2014   CCMPD01941655       Audio Switch Redesign
* Abhishek Trivedi 11/02/2014   CCMPD01943851       Codeplug Read Request for Talk Permit Tone issue
* Abhishek Trivedi 11/11/2014   CCMPD01945832       Edge of Range Support
* Abhishek Trivedi 01/14/2015   CCMPD01958122       GW supports infinte pairing
*--------------------------- End of History Template-----------------------------
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "bt_common.h"
#include "bluetooth_manager.h"
/*===============================================================================================
                                      DEFINITIONS
================================================================================================*/


/* Inter-task messages between MPP Manager, Connection Manager, Bluetooth Manager and Control Manager */
enum{     //Change to enum from define. CCMPD01414087 (Mahesh 17Nov2010)
  BT_DISCOVERABLE_MODE_REQUEST = 50,
  BT_PAIRING_INFO,
  BT_CLEAR_PAIRING_INFO,
  
  BT_INIT_SUCCESS_ACK,
  BT_INIT_FAILED_ACK,
  BT_INIT_CSR_VERSION_MISMATCH,
  
  BT_DISCOVERY_AND_PAIRING_REQUEST,
  BT_PAIRING_STARTED_ACK,
  BT_PAIRING_SUCCESS_ACK,
  BT_HEADSET_PAIRING_FAIL_ACK,
  BT_PAIRING_COMPLETE_ACK,
  
  BT_START_CONNECT_REQUEST,       //61
  BT_CONNECT_ACL_SUCCESS_ACK,
  BT_CONNECT_SUCCESS_ACK,
  BT_CONNECT_TIMEOUT_ACK,
  BT_DEV_CONNECTION_REQUEST_ALLOW,
  BT_DEV_CONNECTION_ALLOW,
  
  BT_DISCONNECT_REQUEST,
  BT_LINKLOST_DISCONNECTED_ACK,
  BT_DISCONNECTED_ACK,
  BT_DEVICE_INQUIRY_TIMEOUT_ACK,
  BT_CONNECT_REQUEST,
  BT_DEV_CONNECTION_REQUEST_DISALLOW,
  
  FATAL_ERROR_ACK,
  SYSTEM_WARM_RESET,
  
  IDLE_STATE_UPDATE,
  
  INIT_STATE_UPDATE,
  PAIRING_STANDBY_STATE_UPDATE,
  PAIRING_STATE_UPDATE,
  PAIRED_SUCCESS_STATE_UPDATE,
  BT_CONNECTED_STATE_UPDATE,
  BT_CONNECTING_STATE_UPDATE,
  BT_DISCONNECTED_STATE_UPDATE,
  BT_QUAL_TEST_MODE_STANDBY_UPDATE,
  BT_QUAL_TEST_MODE_UPDATE,
  FATAL_ERROR_STATE_UPDATE,
  BT_DISCONNECTED_RESET_STATE_UPDATE,
  BT_DISCONNECT_SYSTEM_RESET,
  BT_INIT_CSR_FW_MISMATCH_UPDATE,
  
  /* Messages within Connection Manager Task */
  CONN_MGR_INIT,
  CODEPLUG_INIT_FAILED_ACK,
  CONN_MGR_SPP_CHECK,
  CONN_MGR_WATCHDOG_RESET,        //91
  
  BT_TEST_CONNECTED,
  BT_TEST_DISCONNECTED,
  
  /* Bluetooth Manager state to handle internal state sequence */
  BT_MNGR_HS_PAIRING_START_REQ,
  BT_MNGR_SPP_PAIRING_START_REQ,
  BT_MNGR_HS_PAIRING_SUCCESS_ACK,
  BT_MNGR_HS_PAIRING_UNSUCCESS_ACK,
  BT_MNGR_R1_4_PAIRING_SUCCESS_ACK,
  BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK,
  
  BT_HS_RING_TIMEOUT,
  BT_STOP_SPP_CONNECT_REQUEST,
  BT_HS_ACCEPT_CKPD_CMND_REQUEST,
  
  /* For handling user pairing request */
  USER_PTT_PRESS_DETECTED_ACK,
  USER_PTT_RELEASE_DETECTED_ACK,
  USER_INVALID_PAIRING_REQUEST_ACK,
  
  BT_QUAL_TEST_MODE_REQUEST,
  DONGLE_PTT_PRESSED_ACK,
  DONGLE_LONG_PTT_PRESSED_ACK,
  
  /* R2.1 dongle: For handling Audio route switch selection request, CCMPD01413200 */
  USER_MESSAGE_AUDIO_ROUTE_SWITCH_SELECTED_DONGLE,
  USER_MESSAGE_AUDIO_ROUTE_SWITCH_SELECTED_RADIO,
  
  /* For handlding MPP Message */ 
  MPP_INIT_HOST_MPP_PKT_REQ,
  MPP_HOST_CONN_ALLOC_RES_DB_REQ,
  MPP_READY_PAIR,
  MPP_SUCC_PAIR,
  NEW_HEADSET_CONNECTION_REQUEST_TIMEOUT_ACK,
  NEW_WIRELESSPTT_CONNECTION_REQUEST_TIMEOUT_ACK,
  
  /* For handling TestCommander Message */ 
  TC_STANDARD_PAIRING_MODE,
  TC_MPP_PAIRING_MODE,
  
  BT_Send_Read_BDADD,
  BT_READ_BD_ADDR_COMPLETE_EVENT,
  TC_ATMEL_TEST_MODE_OFF,
  TC_ATMEL_TEST_MODE_ON,
  
  AUDIO_DEVICE_CONNECTED_STATE_UPDATE,
  DEVICE_CONNECTED_STATE_UPDATE,
  AUDIO_DEVICE_DISCONNECTED_STATE_UPDATE,
  
  MPP_UPDATE_LINKKEY_TIMER,
  
  TIME_DELAY,
  
  BT_NORMAL_LED_MODE,
  BT_LED_DARK_MODE,
  // Data Interface Messages
  XNL_XCMP_INITIALIZATION_COMPLETE,
  HSP_XCMP_VOL_STEP_SIZE_MSG,
  SPP_XCMP_VOL_STEP_SIZE_MSG,
  HSP_XCMP_BT_CONFIG_REQ_RCVD_FAIL,
  SPP_XCMP_BT_CONFIG_REQ_RCVD_FAIL,
  HSP_XCMP_BT_CONFIG_REQ_RCVD_SUCC,
  SPP_XCMP_BT_CONFIG_REQ_RCVD_SUCC,
  HSP_XCMP_HW_VER_REQ_MSG,
  HSP_XCMP_HW_VER_REPLY_NOT_RCVD,
  HSP_SEND_SW_VER_REQ_MSG,
  HSP_XCMP_BT_CONFIG_REQUEST_ZERO_TIMEOUT,
  SPP_XCMP_BT_CONFIG_REQUEST_ZERO_TIMEOUT,
  HSP_XCMP_PING_MSG,
  SPP_XCMP_PING_MSG,
  HSP_SEND_XCMP_VOL_BCAST,
  SPP_SEND_XCMP_VOL_BCAST, 
  SEND_XCMP_VOL_BCAST_NO_TONE,
  HSP_SEND_XCMP_VOL_RPLY,
  SPP_SEND_XCMP_VOL_RPLY,
  SEND_XCMP_TONE_RQST_START,
  SEND_XCMP_TONE_RQST_STOP,
  SPP_XCMP_BATT_LVL_LOW,
  SPP_XCMP_BATT_LVL_OKAY,
  HSP_XCMP_RADIO_STATUS_MSG,
  SPP_XCMP_RADIO_STATUS_MSG, 
  HSP_XCMP_UNSUPPORTED_MSG,
  SPP_XCMP_UNSUPPORTED_MSG,
  HSP_RCVD_XCMP_INVALID_MSG,
  SPP_RCVD_XCMP_INVALID_MSG,
  HSP_XCMP_VER_REQ_RCVD,
  SPP_XCMP_VER_REQ_RCVD,
  SPP_REQ_TONE_CONNECTED,
  SPP_REQ_TONE_DISCONNECTED,
  SPP_REQ_TONE_DISCON_CLN_XNL_LINK,  
  HSP_XCMP_VER_PRD_ID_REQ_RCVD,
  SPP_XCMP_VER_PRD_ID_REQ_RCVD,
  HSP_SEND_XCMP_VOL_NEG_RPLY,
  SPP_SEND_XCMP_VOL_NEG_RPLY,  
  GW_TPT_DELAY_CPLG_READ_REQ,
  GW_TPT_DELAY_CPLG_READ_REPLY_RCVD,
  GW_PTT_TMO_CPLG_READ_REPLY_RCVD,
  GW_NEVER_REPAIR_CPLG_READ_REPLY_RCVD,
  HSP_XCMP_BT_CONFIG_BCAST_INF_PAIRING,
  SPP_XCMP_BT_CONFIG_BCAST_INF_PAIRING,
  HSP_SW_VER_REPLY_RCVD_MSG,
  /* ### Control Manager Global ### */
  PTT_BUTTON_BUTTON_PRESSED,
  AUDIO_DET_ACTIVATED,
  ONE_DOT_BUTTON_PRESSED,
  TWO_DOT_BUTTON_PRESSED,
  PTT_BUTTON_BUTTON_RELEASED,
  AUDIO_DET_DEACTIVATED,
  ONE_DOT_BUTTON_RELEASED,
  TWO_DOT_BUTTON_RELEASED,
  MUTE_DELAY_TIME_TIMEOUT,
  CSR_DSP_AUDIO_DET_ACTIVATED,
  CSR_DSP_AUDIO_DET_DEACTIVATED,
  TPT_DELAY_TIMEOUT,
  SEND_HID_REPORT_MESSAGE, 

  /* ### Connection Manager Global ### */
  SPP_DISCONNECT_REQUEST_DELAY_TIMEOUT,
  HSP_DISCONNECT_REQUEST_DELAY_TIMEOUT,
  
  INTERCHIP_PING_TIMEOUT,
  SEND_INTERCHIP_PING_MSG, 
  
  HSP_DATA_COMM_ERROR,
  SPP_DATA_COMM_ERROR,
  
  HSP_SYSTEM_PING_TIMER_EXPIRED,
  SPP_SYSTEM_PING_TIMER_EXPIRED,
  
  HSP_NIBBLER_PTT_PRESS_TMO,
  
  HS_USER_PTT_PRESS_DETECTED,
  SWITCH_TO_LOCAL_AUDIO,
  CONNECTED_DEV_TOUCH_ACTION_MUTE,
  CONNECTED_DEV_TOUCH_ACTION_UNMUTE,
  CONNECTED_WPTT_PTT_PRESS_ROUTE_AUDIO,
  HS_USER_SPKR_UNMUTED_RQST,
  HS_USER_SPKR_UNMUTED_BCAST,
  HS_USER_PTT_PRESS_PLAY_BAD_BONK
};



#define CP_SELECT_OFF                                 0x0
#define CP_SELECT_ON                                  0x1

#define PAIRING_PAIRING_MODE_MPP                      0x01
#define PAIRING_PAIRING_MODE_STANDARD                 0x02

#define INIT_DEVICE_MPP_PKT_RPLY_SIZE                 sizeof(device_pkt)
#define MESSAGE_SIZE_ZERO                               0

#define ALWAYS_REPAIR                                   0
#define BT_ADDR_BYTES                                   6
#define MAX_HSP_CONN_RETRY                              3
#define MAX_SPP_CONN_RETRY                              3


#define GET_PAIRING_TYPE()                     PAIRING_PAIRING_MODE_STANDARD

/*====================================================================================================
                                    GLOBAL VARIABLES, TYPEDEFS & ENUMS
==================================================================================================*/
typedef enum {
   OFF_STATE,
   INIT_STATE,
   PAIRING_STANDBY_STATE,
   PAIRING_STATE,
   BT_CONNECTING_STATE,
   BT_CONNECTED_STATE,
   PAIRED_SUCCESS_STATE,
   BT_DISCONNECTED_STATE,
   BT_QUAL_TEST_MODE,
   IDLE_STATE,
   FATAL_ERROR_STATE,
   BT_DISCONNECTED_RESET_STATE
}connectionManagerStateType;

typedef enum {
  DISCOVERY_ALL,
  DISCOVERY_HSP_ONLY,
  DISCOVERY_SPP_ONLY
}discoveryType;

typedef enum{
  DB_EMPTY,                  /* hspdev empty, temphspdev empty  */
  NEW_DEV_CONNECTING,                 /* temphspdev filled, hspdev empty */
  PAIRED_DEV_CONNECTING,
  DEV_CONNECTED,                      /* temphspdev empty, hspdev filled */
  SECOND_DEV_PAIRED_TOUCH_ACTION,     /* temphspdev empty, hspdev filled */ 
  SECOND_DEV_PAIRED_SWAP,             /* temphspdev filled, hspdev filled*/
  SPP_SWITCH_TO_HSP,                  
  HSP_SWITCH_TO_SPP,
  DEV_DISCONNECTING,                  /* temphspdev empty, hspdev filled */
  DEV_PTT_PRESS_DISCONNECTING,
  BLUETOOTH_DATABASE_ERROR,           /* unexpected error */
}device_status;

typedef enum xnl_tx_supported_msgs
{
  VOL_LVL_REQ_MSG = 0,
  HSP_BT_CFG_RPLY_MSG,
  SPP_BT_CFG_RPLY_MSG,
  HSP_VOL_LVL_REP_MSG,
  SPP_VOL_LVL_REP_MSG,
  HSP_PING_MSG,
  SPP_PING_MSG,
  HSP_VOL_BCAST_MSG,
  HSP_TONE_REQ_MSG,
  SPP_VOL_BCAST_MSG,
  SPP_TONE_REQ_MSG,
  ONE_DOT_BCAST,
  TWO_DOT_BCAST,
  VER_REQ_MSG,
  HW_VER_REQ_MSG,
  HSP_RAD_STAT_MSG,
  SPP_RAD_STAT_MSG,
  HSP_UNSUPPORTED_REQ_MSG,
  SPP_UNSUPPORTED_REQ_MSG,
  HSP_RCVD_INVALID_MSG,
  SPP_RCVD_INVALID_MSG,
  HSP_VER_REQ_RCVD,
  SPP_VER_REQ_RCVD,
  SPP_BATT_LVL_RCVD,
  HSP_SPKR_CTRL_MSG,
  HSP_BAD_BONK_TONE_REQ_MSG,
  HSP_VER_PRD_ID_REQ_RCVD,
  SPP_VER_PRD_ID_REQ_RCVD,  
  HSP_CPLG_READ_REQ,
  HSP_BT_CFG_BCAST_MSG,
  //Keep adding here
  NUMBER_OF_XNL_TX_SUPPORTED_MSGS
} xnl_tx_supported_msgs_t;

typedef enum vol_msgs
{
  HSP_VOL_PRESS = 0,
  HSP_VOL_TIMEOUT,
  SPP_VOL_PRESS,
  SPP_VOL_TIMEOUT,
  //Keep adding here
  NUMBER_OF_VOL_TIMERS
} vol_msgs_t;

typedef enum
{
  GW_NOT_CONNECTED_LOCAL_AUDIO = 0,
  GW_CONNECTED_LOCAL_AUDIO,
  GW_CONNECTED_REMOTE_AUDIO,
  GW_CONNECTED_PTT_PRESSED_LOCAL_AUDIO,
  GW_LOCAL_AUDIO_SPKR_ON_MSG_SEND_FAILED,
  GW_LOCAL_AUDIO_SPKR_OFF_MSG_SEND_FAILED
}audio_transfer_state_t;

#define    RETRY_XCMP_MSG_TIMER(TIMER, MSG_ID, TIMER_VAL, DATA_PTR)      TaskCancelTimer(&xnl_msg_retry_timer[TIMER]);\
           xnl_msg_retry_timer[TIMER].TimerMatchValue = \
           SYSTEM_TIME + TIMER_VAL; \
           xnl_msg_retry_timer[TIMER].TaskToNotify = CONNECTION_MANAGER; \
           xnl_msg_retry_timer[TIMER].MessageID = MSG_ID; \
           xnl_msg_retry_timer[TIMER].Message = DATA_PTR; \
           xnl_msg_retry_timer[TIMER].Next = NULL; \
           ScheduleTimer(&xnl_msg_retry_timer[TIMER])
#define CANCEL_RETRY_XCMP_MSG_TIMER(TIMER)          TaskCancelTimer(&xnl_msg_retry_timer[TIMER])

/*=====================================================================================
                                      FUNCTIONS
======================================================================================*/
bool check_new_mpp_audio_device(host_succ_mpp * mpp_ptr2message);
void audio_transfer_state_machine(unsigned char msg_id);
#endif
