/*******************************************************************************
*
*                F U N C T I O N   S P E C I F I C A T I O N
*             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
*                    MOTOROLA CONFIDENTIAL PROPRIETARY
*                       C TEMPLATE VERSION R01.01
*
********************************************************************************
*
*  FILE NAME: TaskConfig.c
*
*---------------------------------- PURPOSE ------------------------------------
*  Task Configuration
*
*
*--------------------------- PROJECT SPECIFIC DATA -----------------------------
*
*
*
*----------------------------- REVISION HISTORY --------------------------------
*
* Date      Core ID   Tracking#      Description
* --------  --------  -------------  -------------------------------------------
* 02/17/10  boz016	  CCMPD01310912  Changes for ROS OSAL
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* Aneeket Patkar    05/07/2010          CCMPD01344099           Added Radio Data Manager Task 
* Aneeket Patkar    05/14/2010          CCMPD01347254           Porting to Secure Wireless
* Phong Tran        06/14/2010          CCMPD01355429           Changed Debug Manager priority to 6
* PeiSee Toh        06/24/2010          CCMPD01373324           Initial draft for non-secure wireless dongle1.2
* PeiSee Toh        08/04/2010          CCMPD01376817           Comment out the interchip manager
* NiravKumar Rabara 08/20/2010          CCMPD01383800           Modified Stack size for bt_manager & bt_timer
* YewFoong Lim      09/06/2010          CCMPD01384903           Rename Connection Mananger task name, 
*                                                               and modidfied stack size for bt_timer
* Tan Seng Kai      10/06/2010          CCMPD01399559           RADIO_INTERFACE_MANAGER_TASK,MPP_TASK,NIBBLER_TASK Compile sw 
*                                                               added to remove Radio interface and mpp task
* JJ Low            11/17/2010          CCMPD01412613           Rearranging R2.1 task priority
* Tan Seng Kai      11/25/2010          CCMPD01419120           Increase stack size for Control manager, put it into safer zone
* Tan Seng Kai      12/08/2010          CCMPD01451448           Increase queue size for bluetooth manager and connection manager,
*                                                               Due to increasing message when sending Link key
* Mahes             Jan/06/2011         CCMPD01460340           Software catch-up to dongle R1.2 version R01.00.00
* Sevuhan.R         12/21/2011          CCMPD01594785           added defn for usb_hid_dev_task 
* WRN637	        9/11/2013           CCMPD01808031           REMOVE USB HID Support
* Abhishek Trivedi  09/02/2013          CCMPD01827271           HSP and SPP XNL tasks
* Abhishek Trivedi  11/8/2013           CCMPD01834482           Updates for XNL-XCMP SPP Task
* WRN637            11/20/2013          CCMPD01838036           Resolve Gateway Reset issue
* WRN637            01/22/2014          CCMPD01854392           Remove SPP_XNL_XCMP_MANAGER_TASK to prevent multiple access to XCMP decoder at the same time    
* Abhishek Trivedi  03/18/2014	        CCMPD01873731	        Resolve 2 device connection issue
* Aneeket Patkar    03/26/2014          CCMPD01876782           Initialization Sequence update - Create MPP State Machine after BT initialization
* Phong Tran        04/16/2014          CCMPD01880773           Fixed communication with XNL/XCMP Tester
*
*--------------------------- End of History Template----------------------------
*
*--------------------------- HEADER FILE INCLUDES ----------------------------*/

#include "TaskConfig.h"
#include "osal.h"
#ifndef SIMULATOR
#include "TypeDef.h"
#else
#include "./../Simulator_OB/Header/typeDef.h"
#include "./../Simulator_OB/Tasks/Init_Mgr/InitManager.h"
#endif
#include "systemLogger.h"
#ifdef MPP_TASK
#include "mpp_utilities.h"
#endif

extern void connection_manager_task( void *pvParameters );
extern void TimerHandler(void);
extern void hsp_xnl_xcmp_manager_task(void *pvParameters);
extern void spp_xnl_xcmp_manager_task(void *pvParameters);
extern void hsp_xnl_xcmp_timers_task(void *pvParameters);
extern void usb_task(void *pvParameters);
extern void usb_device_task(void *pvParameters);
extern void debug_manager_task(void *pvParameters);
extern void test_commands_manager_task(void *pvParameters);
extern void test_commands_queue_task(void *pvParameters);
extern void interchip_manager(void *pvParameters);
extern void controls_manager_task(void *pvParameters);
extern void bt_manager_task(void *pvParameters);

#ifdef MPP_TASK
extern void mpp_state_machine( void *pvParameters );
//extern void mpp_gui( void *pvParameters );
#endif

extern void bt_timer_task(void *pvParameters);

#ifdef NIBBLER_TASK
extern void nibbler_manager(void *pvParameters);
#endif

unsigned char MppTaskID;


/*---------------------------- LOCAL CONSTANTS -------------------------------*/

/*--------------------------- LOCAL ENUMERATIONS -----------------------------*/

/*----------------------------- LOCAL DATA TYPES -----------------------------*/

// Task table, defined in ob_tasks.h

TASK_MANAGER task_manager[] = {
// name                  stack size              priority                            function queue len   queue item size   q_handle  t_handle  init
{"vNoTask",                     100,                    1,                    (void *)vNoTask,   0,                 50,  NULL,      NULL,     0 },
{"RTC Task ",                   300, configMAX_PRIORITIES,                   (void *)vRTCTask,  10,      sizeof (void*), NULL,      NULL,     0 },
#ifdef MPP_TASK
{"mpp_state_machine",           150,                    4,          (void *)mpp_state_machine,   6,      sizeof (void*), NULL,      NULL,     0 },  // CCMPD01412613 (JJ 18/11/2010)
//{"mpp_gui",                   100,                    3,                    (void *)mpp_gui,   5,      sizeof (void*), NULL,      NULL,     0 },
#endif
{"connection_manager_task",     400,                    3,    (void *)connection_manager_task,  20,      sizeof (void*), NULL,      NULL,     0 },
{"interchip_manager",           100,                    3,          (void *)interchip_manager,   6,      sizeof (void*), NULL,      NULL,     0 },
{"usb_task",                    200,                    2,                   (void *)usb_task,   6,      sizeof (void*), NULL,      NULL,     0 },
{"usb_device_task",             200,                    2,            (void *)usb_device_task,   6,      sizeof (void*), NULL,      NULL,     0 },
{"debug_manager_task",          200,                    2,         (void *)debug_manager_task,   6,      sizeof (void*), NULL,      NULL,     0 },
{"test_commands_manager_task",  350,                    2, (void *)test_commands_manager_task,   6,      sizeof (void*), NULL,      NULL,     0 },
{"test_commands_queue_task",    100,                    2,   (void *)test_commands_queue_task,   6,      sizeof (void*), NULL,      NULL,     0 },
{"hsp_xnl_xcmp_manager_task",   400,                    3,  (void *)hsp_xnl_xcmp_manager_task, 100,      sizeof (void*), NULL,      NULL,     0 },
{"spp_xnl_xcmp_manager_task",   300,                    3,  (void *)spp_xnl_xcmp_manager_task, 100,      sizeof (void*), NULL,      NULL,     0 },
{"hsp_xnl_xcmp_timers_task",    300,                    3,  (void *)hsp_xnl_xcmp_timers_task,    6,      sizeof (void*), NULL,      NULL,     0 },
{"TimerHandler",                150,                    7,               (void *)TimerHandler,   6,      sizeof (void*), NULL,      NULL,     0 },
{"controls_manager_task",       150,                    3,      (void *)controls_manager_task,   6,      sizeof (void*), NULL,      NULL,     0 },
{"bt_manager_task",             400,                    3,            (void *)bt_manager_task,  30,      sizeof (void*), NULL,      NULL,     0 },
{"bt_timer",                    500,                    3,              (void *)bt_timer_task,   6,      sizeof (void*), NULL,      NULL,     0 },

#ifdef NIBBLER_TASK
{"nibbler_task",                100,                    2,            (void *)nibbler_manager,   6,      sizeof (void*), NULL,      NULL,     0 }
#endif
};

/*------------------------ LOCAL FUNCTION PROTOTYPES -------------------------*/

/*
*+
******************************************************************************
*
*  FUNCTION NAME: SetQueueHandle
*
*  USAGE:
*  void SetQueueHandle (int taskId, xQueueHandle queueHandle)
*
*  INPUT PARAMETERS:
*    None.
*
*  OUTPUT PARAMETERS:
*    None.
*
*  RETURN VALUE:
*    None.
*
*  FUNCTIONS CALLED:
*    None.
*
*  GLOBAL DATA REFERENCED:
*
*  DESCRIPTION:
*    Associate a queue with a task id
*
*  CAUTIONS:
*    None.
*
*  TRACEABILITY MATRIX:
*    ?
*
******************************************************************************
*
*  FUNCTION MODIFICATION HISTORY:
*
*  Date        Core ID   Tracking#       Description
*  --------   ---------  ---------       -----------
* 02/17/10     boz016	 CCMPD01310912   Add valid task check
******************************************************************************
*-
*/

void SetQueueHandle (int taskId, xQueueHandle queueHandle)
{
/*----------------------------- LOCAL VARIABLES ------------------------------*/
/*---------------------------------- CODE ------------------------------------*/

	if (VALID_TASK(taskId))
	{
		task_manager[taskId].queueHandle = queueHandle;
	}
}

/*
*+
******************************************************************************
*
*  FUNCTION NAME: SetTaskHandle
*
*  USAGE:
*  void SetTaskHandle (int taskId, xTaskHandle taskHandle)
*
*  INPUT PARAMETERS:
*    taskId - the task id
*    taskHandle - The task handle to be associate with the task id
*
*  OUTPUT PARAMETERS:
*    None.
*
*  RETURN VALUE:
*    None.
*
*  FUNCTIONS CALLED:
*    None.
*
*  GLOBAL DATA REFERENCED:
*
*  DESCRIPTION:
*    Associate a task id with RTOS task handle
*
*  CAUTIONS:
*    None.
*
*  TRACEABILITY MATRIX:
*    ?
*
******************************************************************************
*
*  FUNCTION MODIFICATION HISTORY:
*
*  Date        Core ID   Tracking#       Description
*  --------   ---------  ---------       -----------
* 02/17/10     boz016	 CCMPD01310912   Add valid task check
******************************************************************************
*-
*/
void SetTaskHandle (int taskId, xTaskHandle taskHandle)
{
/*----------------------------- LOCAL VARIABLES ------------------------------*/
/*---------------------------------- CODE ------------------------------------*/
	if (VALID_TASK(taskId))
	{
		task_manager[taskId].taskHandle = taskHandle;
	}
}


/*
*+
******************************************************************************
*
*  FUNCTION NAME: GetQueueHandle
*
*  USAGE:
*  xQueueHandle GetQueueHandle (int taskId)
*
*  INPUT PARAMETERS:
*    Task id
*
*  OUTPUT PARAMETERS:
*    The queue handle
*
*  RETURN VALUE:
*    None.
*
*  FUNCTIONS CALLED:
*    None.
*
*  GLOBAL DATA REFERENCED:
*
*  DESCRIPTION:
*    Get handle to the task queue
*
*  CAUTIONS:
*    None.
*
*  TRACEABILITY MATRIX:
*    ?
*
******************************************************************************
*
*  FUNCTION MODIFICATION HISTORY:
*
*  Date        Core ID   Tracking#       Description
*  --------   ---------  ---------       -----------
* 02/17/10     boz016	 CCMPD01310912   Add valid task check
******************************************************************************
*-
*/

xQueueHandle GetQueueHandle (int taskId)
{
/*----------------------------- LOCAL VARIABLES ------------------------------*/
/*---------------------------------- CODE ------------------------------------*/
	if (VALID_TASK(taskId))
	{
		return task_manager[taskId].queueHandle;
	}
	else
	{
		return (NULL);
	}
}

/*
*+
******************************************************************************
*
*  FUNCTION NAME: Task_Create
*
*  USAGE:
*  int Task_Create (int taskId)
*
*  INPUT PARAMETERS:
*    Task id
*
*  OUTPUT PARAMETERS:
*    None
*
*  RETURN VALUE:
*    OS_TASK_NOT_EXIST - if task ID not exist.
*	 OS_TASK_CREATION_FAIL
*    OS_SUCCESS
*
*  FUNCTIONS CALLED:
*    None.
*
*  GLOBAL DATA REFERENCED:
*
*  DESCRIPTION:
*    create a task
*
*  CAUTIONS:
*    None.
*
*  TRACEABILITY MATRIX:
*    ?
*
******************************************************************************
*
*  FUNCTION MODIFICATION HISTORY:
*
*  Date        Core ID   Tracking#       Description
*  --------   ---------  ---------       -----------
* 02/17/10     boz016	 CCMPD01310912   Add valid task check, suspend other tasks
******************************************************************************
*-
*/
int Task_Create (int taskId)
{
/*----------------------------- LOCAL VARIABLES ------------------------------*/
	int res = OS_SUCCESS;
/*---------------------------------- CODE ------------------------------------*/
	DBG_MSG("Entered Task Create Limor\n");
	if (!VALID_TASK(taskId))
	{
		return OS_TASK_NOT_EXIST;
	}
        vTaskSuspendAll();
	if (task_manager[taskId].uxQueueLength > 0)
	{

	    task_manager[taskId].queueHandle = OS_QueueCreate (
		            task_manager[taskId].task_name,
		            0,
					task_manager[taskId].uxQueueLength,
					(unsigned int)task_manager[taskId].uxItemSize
					);
	}
	task_manager[taskId].taskHandle = OS_TaskCreate (task_manager[taskId].priority,
		           task_manager[taskId].p_func,
				   task_manager[taskId].stack_size,
				   task_manager[taskId].task_name,
				   NULL,
				   &task_manager[taskId]
				   );
	xTaskResumeAll();
	DBG_MSG("After Task Create Limor\n");
	if (task_manager[taskId].taskHandle != NULL) {
		task_manager[taskId].initialize = 1;
		res = OS_SUCCESS;
		}
	else {
		res = OS_TASK_CREATION_FAIL;
	}
	//DBG_MSG("Return from Task Create Limor\n");
	return res;

}

/*
*+
******************************************************************************
*
*  FUNCTION NAME: Task_Delete
*
*  USAGE:
*  int Task_Delete (int taskId)
*
*  INPUT PARAMETERS:
*    Task id
*
*  OUTPUT PARAMETERS:
*    None
*
*  RETURN VALUE:
*    OS_TASK_NOT_EXIST if not a valid task
*    OS_SUCCESS if deleted successfully
*
*
*  FUNCTIONS CALLED:
*    None.
*
*  GLOBAL DATA REFERENCED:
*
*  DESCRIPTION:
*    delete a task
*
*  CAUTIONS:
*    None.
*
*  TRACEABILITY MATRIX:
*    ?
*
******************************************************************************
*
*  FUNCTION MODIFICATION HISTORY:
*
*  Date        Core ID   Tracking#       Description
*  --------   ---------  ---------       -----------
* 02/17/10     boz016	 CCMPD01310912   Add valid task check, suspend other tasks
******************************************************************************
*-
*/

int Task_Delete (int taskId)
{
/*----------------------------- LOCAL VARIABLES ------------------------------*/
	xTaskHandle task_handle;
	xQueueHandle queue_handle;
/*---------------------------------- CODE ------------------------------------*/
	if (!VALID_TASK(taskId))
	{
		return OS_TASK_NOT_EXIST;
	}
	taskDISABLE_INTERRUPTS();
	task_handle = task_manager[taskId].taskHandle;
	queue_handle = task_manager[taskId].queueHandle;
	task_manager[taskId].taskHandle = NULL;
	task_manager[taskId].queueHandle = NULL;
	OS_QueueDelete (queue_handle);
	task_manager[taskId].initialize = 0;
	OS_TaskDelete (task_handle);
	task_manager[taskId].taskHandle = NULL;
	taskENABLE_INTERRUPTS();

	return OS_SUCCESS;

}

/*
*+
******************************************************************************
*
*  FUNCTION NAME: GetTaskId
*
*  USAGE:
*  int GetTaskId (xTaskHandle taskHandle)
*
*  INPUT PARAMETERS:
*    task handle
*
*  OUTPUT PARAMETERS:
*    None
*
*  RETURN VALUE:
*    Task ID
*     -1 if task not exists
*
*
*  FUNCTIONS CALLED:
*    None.
*
*  GLOBAL DATA REFERENCED:
*
*  DESCRIPTION:
*    Get task ID by task handle
*
*  CAUTIONS:
*    None.
*
*  TRACEABILITY MATRIX:
*    ?
*
******************************************************************************
*
*  FUNCTION MODIFICATION HISTORY:
*
*  Date        Core ID   Tracking#       Description
*  --------   ---------  ---------       -----------
* 02/17/10     boz016	 CCMPD01310912   Add valid task check, suspend other tasks
******************************************************************************
*-
*/
int GetTaskId (xTaskHandle taskHandle)
{
/*----------------------------- LOCAL VARIABLES ------------------------------*/
	int taskId;
/*---------------------------------- CODE ------------------------------------*/
	for (taskId = 0; taskId < MAX_TASK; ++taskId)
	{
		if (task_manager[taskId].taskHandle == taskHandle) return taskId;
	}

	return -1;
}




/*For merge with OSAL*/
/******************************************************/
void vNoTask			(void *pvParameters)
{
}

void send_msg_to_task(unsigned char task_id, unsigned char message_id, void *message, unsigned short message_size)
{
   ms_task_msg_t *msg ;
   /* fill in the buffer*/
   msg = (ms_task_msg_t *) Get_Buf(Get_Res_Pool_Id(POOL_USER_MSG));
                    
                      msg->ros_msg.radio_if_msg.msg_hdr.msg_type  = USER_MSG; /* application message*/
                      msg->ros_msg.radio_if_msg.msg_hdr.op_code   = MPP_OSAL_MSG; /*system level op code*/
                      msg->ros_msg.radio_if_msg.sub_opcode        = message_id; /* task level sub opcode*/
                      msg->ros_msg.radio_if_msg.data              = message; /* pointer to message*/
                      msg->ros_msg.radio_if_msg.data_len          = message_size; /* size of message which may or maynot be used as data struct are shared*/

   Put_Msg( (BUF_PTR)msg, Get_Task_Id(task_id)); /* send to connection manager task*/

}



int OS_QueueSend_from_isr (int taskId, void *msg)

{

	xQueueHandle qh;
	qh = GetQueueHandle (taskId);
        xQueueSendToFrontFromISR(qh, msg, 0);

	return OS_SUCCESS;
}



void send_msg_to_task_from_isr(unsigned char task_id, unsigned char message_id, void *message, unsigned short message_size)
{
   ms_task_msg_t *msg ;
   /* fill in the buffer*/
   msg = (ms_task_msg_t *) Get_Buf(Get_Res_Pool_Id(POOL_USER_MSG));
                    
                      msg->ros_msg.radio_if_msg.msg_hdr.msg_type  = USER_MSG; /* application message*/
                      msg->ros_msg.radio_if_msg.msg_hdr.op_code   = MPP_OSAL_MSG; /*system level op code*/
                      msg->ros_msg.radio_if_msg.sub_opcode        = message_id; /* task level sub opcode*/
                      msg->ros_msg.radio_if_msg.data              = message; /* pointer to message*/
                      msg->ros_msg.radio_if_msg.data_len          = message_size; /* size of message which may or maynot be used as data struct are shared*/
   OS_QueueSend_from_isr (Get_Task_Id(task_id), (BUF_PTR *)&msg);

}

void sendtoQueuefromISR(INT32_T taskId, BUF_PTR msg, UINT16_T message_size)
{
  xQueueHandle qh;
  qh = GetQueueHandle (taskId);
  
  xQueueSendToFrontFromISR(qh, (BUF_PTR *)&msg, 0);
}

void initialize_tasks(void)
{
    vr_create_task(RTC_ID);
    vr_create_task(TIMER_HANDLER); 
    //vr_create_task(INTERCHIP_MANAGER);
    vr_create_task(HSP_XNL_XCMP_MANAGER_TASK);
    vr_create_task(SPP_XNL_XCMP_MANAGER_TASK);
    vr_create_task(HSP_XNL_XCMP_TIMERS_TASK);
//    vr_create_task(SPP_XNL_XCMP_TIMERS_TASK);    
    vr_create_task(CONTROLS_MANAGER_TASK);
    vr_create_task(CONNECTION_MANAGER);
    vr_create_task(BLUETOOTH_MANAGER_TASK); //cwc034

#ifdef NIBBLER_TASK
    vr_create_task(NIBBLER_TASK_ID);
#endif		
#ifdef MPP_TASK
    //vr_create_task(MPP_GUI_MGR); 
#endif
}
