/*******************************************************************************
*
*                  H E A D E R   S P E C I F I C A T I O N
*             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
*                    MOTOROLA CONFIDENTIAL PROPRIETARY
*                     C HEADER TEMPLATE VERSION R01.02
*
********************************************************************************
*
*  FILE NAME : TaskConfig.h
*
*-------------------------------- PURPOSE --------------------------------------
*  Commonly used types and definitions
*
*--------------------------- DEPENDENCY COMMENTS -------------------------------
*
*
*-------------------------- PROJECT SPECIFIC DATA ------------------------------
*
*
*----------------------------- REVISION HISTORY --------------------------------
*
* Date      Core ID   Tracking#      Description
* --------  --------  -------------  -------------------------------------------
* 02/17/10  boz016    CCMPD01310912  Additions for ROS OSAL
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	  CR Tracking Number 	Description
* Aneeket Patkar    05/07/2010      CCMPD01344099       Added Radio Data Manager Task 
* YewFoong Lim      06/25/2010      CCMPD01373314       Initial draft for non secure wireless dongle1.2
* YewFoong Lim      09/06/2010      CCMPD01384903       Added "SEND_MESSAGE_TO_BLUETOOTH_MANAGER" & 
*                                                       "SEND_MESSAGE_TO_BLUETOOTH_MANAGER_FROM_ISR"    
* Tan Seng Kai      10/06/2010      CCMPD01399559       RADIO_INTERFACE_MANAGER_TASK,MPP_TASK,NIBBLER_TASK Compile sw 
*                                                       added to remove Radio interface and mpp task
* Tan Seng Kai      10/07/2010      CCMPD01397694       Enable Nibbler Task
* JJ Low            11/16/2010      CCMPD01412613       R2.1 MPP state machine
* Tan Seng Kai      11/25/2010      CCMPD01419120       Remove compile switch for Nibbler task
* Mahes             Jan/06/2011     CCMPD01460340       Software catch-up to dongle R1.2 version R01.00.00
* WRN637		    9/11/2013       CCMPD01808031       REMOVE USB HID Support
* Sevuhan.R         12/21/2011      CCMPD01594785           added USB_HID_DEV_MGR 
* Abhishek Trivedi  09/02/2013      CCMPD01827271       XNL tasks for HSP and SPP
* Abhishek Trivedi  03/18/2014	    CCMPD01873731	Resolve 2 device connection issue
*--------------------------- End of History Template----------------------------
*******************************************************************************/


#ifndef TASK_CONFIG_H
#define TASK_CONFIG_H


/*-------------------------- HEADER FILE INCLUDES ----------------------------*/
#ifdef SIMULATOR
#ifdef __cplusplus
   extern "C"
   {
#endif
#endif /*SIMULATOR */
    #include "Rtos_Includes.h"
	   void vRadioIF (void *pvParameters);
#include "Typedef.h"
#include "osal.h"
#include "mpp_init.h" // CCMPD01412613 (JJ 16/11/2010)
           
#ifdef SIMULATOR
#ifdef __cplusplus
   }
#endif
#endif
/*------------------------------ CONSTANTS -----------------------------------*/
#define OSAL2
#define OSAL_USED                       // To inlclude OSAL implementation files

/*-------------------------- ENUMERATED TYPES --------------------------------*/

/*--------------------------- BASIC DATA TYPES -------------------------------*/

/*---------------------- STRUCTURE/UNION DATA TYPES --------------------------*/

//#define RADIO_INTERFACE_MANAGER_TASK

#ifdef MPP_HOST // CCMPD01412613 (JJ 12/11/2010)
#define MPP_TASK
#endif

//#define NIBBLER_TASK

typedef enum  {
  NO_TASK	= 0,
  RTC_ID,
  
  #ifdef MPP_TASK
  MPP_STATE_MACHINE,
  //MPP_GUI_MGR,
  #endif
  
  CONNECTION_MANAGER,
  INTERCHIP_MANAGER,
  USB_CDC,
  USB_DEVICE,
  USB_DEBUG_MGR,
  USB_TEST_CMD_MGR,
  USB_TEST_CMD_QUEUE,
  HSP_XNL_XCMP_MANAGER_TASK,
  SPP_XNL_XCMP_MANAGER_TASK,
  HSP_XNL_XCMP_TIMERS_TASK,
//  SPP_XNL_XCMP_TIMERS_TASK,
  TIMER_HANDLER,
  CONTROLS_MANAGER_TASK,
  BLUETOOTH_MANAGER_TASK,
  BT_TIMER_TASK,
  
  #ifdef NIBBLER_TASK
  NIBBLER_TASK_ID,
  #endif
  
  MAX_TASK
}taskID_type;



typedef enum {
  OS_SUCCESS = 0,
  OS_QUEUE_NOT_EXIST,
  OS_TASK_NOT_EXIST,
  OS_TASK_CREATION_FAIL,
  OS_LAST_MSG
} OSALerr_type;


typedef struct  {
  char *task_name;
  unsigned portSHORT stack_size;
  int priority;
  void * p_func;
  int uxQueueLength;
  int uxItemSize;
  xQueueHandle queueHandle;
  xTaskHandle taskHandle;
  int initialize;
}TASK_MANAGER;

/*------------------------ GLOBAL DATA DECLARATIONS --------------------------*/

/*------------------------------- MACROS -------------------------------------*/

#define OS_EnterCriticalSection    taskDISABLE_INTERRUPTS
/*
* Disable all the interrupts
*/
#define OS_LeaveCriticalSection    taskENABLE_INTERRUPTS
/*
* Enable all the interrupts
*/
#define OS_GetNumberOfTasks        uxTaskGetNumberOfTasks
/*
* Returns the number of the tasks in the system
*/

#define OS_QueueDelete             vQueueDelete
/*
* Delete a queue based on it's handle (not name!!!)
*/

#define OS_TaskDelete               vTaskDelete
/*
*  Delete a task by handle
*/

#define OS_QueueMassagesWaiting    uxQueueMessageWaiting
/*
* Queries the number of messages in the queue
*/

#define OS_GetTaskId               GetTaskId
/*
*  Get task ID by task handle
*    Input parameter:
*       task handle
*    Returns:
*       Task ID
*       -1 if task not exists
*/
#define OS_GetCurrentTaskId()    (OS_GetTaskId (xTaskGetCurrentTaskHandle()))

#define VALID_TASK(x) ((x > 0) && (x < (INT) MAX_TASK))

#define DBG_MSG(log)  // CCMPD01412613 (JJ 16/11/2010)
/*------------------------ FUNCTION PROTOTYPE(S) -----------------------------*/

#ifdef __cplusplus
  extern "C"
  {
#endif// Tasks entry points

void vRTCTask(void *pvParameters);

void vNoTask (void *pvParameters);

// ob_tasks.c prototypes
int Task_Delete (int taskId);

int Task_Create (int taskId);
/* Creates a task by taskID
*  Input:
*    taskID
*  Returns:
*     OS_TASK_NOT_EXIST - if task ID not exist.
*	  OS_TASK_CREATION_FAIL
*     SUCCESS
*/

xQueueHandle GetQueueHandle (int taskId);

/*
*  Get handle to the task queue
*  Input:
*	Task id
*  Returns:
*	The queue handle
*/

void SetQueueHandle (int taskId, xQueueHandle queueHandle);
/*
*  Associate a queue with a task
*	Input:
*		taskId - the task id
*		queueHandle - The queue to be associate with the task
*	Return:
*		None
*/

void SetTaskHandle (int taskId, xTaskHandle taskHandle);
/*
*  Associate a task handle with a task id
*	Input:
*		taskId - the task id
*		taskHandle - The task handle to be associate with the task id
*	Return:
*		None
*/

/*
*  Tasks ID list
*/

int GetTaskId (xTaskHandle taskHandle);


xTaskHandle OS_TaskCreate (int priority, void *thread, unsigned portSHORT stackSize, char *name, void *stackAddress, void *data);
/*
* priority - task priority
* thread - pointer to task code
* stackSize - stack size
* data - pinter to parameter to this task
* name - task name (for debug purpose)
* Return value: task handle
*
*/

void OS_TaskDelay(int timeout);
/*
* Put the task in sleep mode
* timeout - delay in ms.
*/


void OS_TaskDelete (xTaskHandle TaskHandle);
/*
* delete a task by handle
*/

#ifdef TBD
void *OS_GetTaskId (void)
/*
* Get current task thread
*/
#endif

xQueueHandle OS_QueueCreate (char *name, int guaranteedSameAddressSpace, unsigned int maxMsgs, unsigned int maxMsgSize);
/*
* Creates a queue
* Input parameters:
* 	name - the queue name
* 	guaranteedSameAddressSpace - not used, shoule be 0
* 	maxMsgs - The number of messages that can be in the queue
* 	maxMsgSize - The size of the message
*/

#ifdef OSAL2
int OS_QueueSend (int taskId, BUF_PTR msg, BOOL isr, BOOL priority);
#else
int OS_QueueSend (int taskId, void *msg);
#endif /* OSAL2 */

/* Send data pointer to task queue
* Inpute parameters:
*   taskID - Tasl ID as defined in ob_tasks.h
*   msg - pointer to the message
* Returns:
*   0 - success
*   1 - queue not exists
*/

INT OS_capture_semaphore(INT sem_num, BOOL time_usage, unsigned int time);


#ifdef OSAL2

BUF_PTR OS_QueueReceive (xQueueHandle q, BOOL isr);

BUF_PTR OS_Get_Msg(BOOL isr, BOOL time_usage, unsigned int time);

#else
void  * OS_QueueReceive (xQueueHandle q);
#endif /* OSAL2 */

#ifdef SIMULATOR
#ifdef __cplusplus
  }
#endif
#endif
  
#include "timers.h"  
  
void initialize_tasks(void);  
  
void send_msg_to_task(unsigned char task_id, 
                      unsigned char message_id, 
                      void *message, 
                      unsigned short message_size);

void send_msg_to_task_from_isr(unsigned char task_id, 
                               unsigned char message_id, 
                               void *message, 
                               unsigned short message_size);


#ifdef MPP_HOST
#define SEND_MESSAGE_TO_MPP_MNGR(message_id, ptr_to_message, message_size)    \
  send_msg_to_task(MPP_STATE_MACHINE, message_id, ptr_to_message, message_size);
#endif

#define SEND_MESSAGE_TO_INTERCHIP_MNGR(message_id, ptr_to_message, message_size) \
  send_msg_to_task(INTERCHIP_MANAGER, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_CONNECTION_MNGR(message_id, ptr_to_message, message_size) \
  send_msg_to_task(CONNECTION_MANAGER, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_TESTCOMMAND_MNGR(message_id, ptr_to_message, message_size) \
  send_msg_to_task(USB_TEST_CMD_MGR, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_HSP_XNL_XCMP_MNGR(message_id, ptr_to_message, message_size) \
  send_msg_to_task(HSP_XNL_XCMP_MANAGER_TASK, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_SPP_XNL_XCMP_MNGR(message_id, ptr_to_message, message_size) \
  send_msg_to_task(SPP_XNL_XCMP_MANAGER_TASK, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_HSP_XNL_XCMP_TIMER(message_id, ptr_to_message, message_size) \
  send_msg_to_task(HSP_XNL_XCMP_TIMERS_TASK, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_SPP_XNL_XCMP_TIMER(message_id, ptr_to_message, message_size) \
  send_msg_to_task(SPP_XNL_XCMP_TIMERS_TASK, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_TIMER_HANDLER(message_id, ptr_to_message, message_size) \
  send_msg_to_task(TIMER_HANDLER, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_CONTROLS_MANAGER(message_id, ptr_to_message, message_size) \
  send_msg_to_task(CONTROLS_MANAGER_TASK, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_BLUETOOTH_MANAGER(message_id, ptr_to_message, message_size) \
  send_msg_to_task(BLUETOOTH_MANAGER_TASK, message_id, ptr_to_message, message_size);
#ifdef NIBBLER_TASK
#define SEND_MESSAGE_TO_NIBBLER_TASK_MANAGER(message_id, ptr_to_message, message_size) \
  send_msg_to_task(NIBBLER_TASK_ID, message_id, ptr_to_message, message_size);
#endif
/************ SAME DEFINITIONS AS ABOVE BUT FOR ISR *******************/
#ifdef MPP_HOST
#define SEND_MESSAGE_TO_MPP_MNGR_FROM_ISR(message_id, ptr_to_message, message_size)    \
  send_msg_to_task_from_isr(MPP_STATE_MACHINE, message_id, ptr_to_message, message_size);
#endif

#define SEND_MESSAGE_TO_INTERCHIP_MNGR_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(INTERCHIP_MANAGER, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_CONNECTION_MNGR_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(CONNECTION_MANAGER, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_TESTCOMMAND_MNGR_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(USB_TEST_CMD_MGR, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_TIMER_HANDLER_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(TIMER_HANDLER, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_CONTROLS_MANAGER_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(CONTROLS_MANAGER_TASK, message_id, ptr_to_message, message_size);
#define SEND_MESSAGE_TO_BLUETOOTH_MANAGER_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(BLUETOOTH_MANAGER_TASK, message_id, ptr_to_message, message_size);
#ifdef NIBBLER_TASK
#define SEND_MESSAGE_TO_NIBBLER_TASK_FROM_ISR(message_id, ptr_to_message, message_size) \
  send_msg_to_task_from_isr(NIBBLER_TASK_ID, message_id, ptr_to_message, message_size);
#endif
//#define ScheduleTimer(timer) send_msg_to_task(TIMER_HANDLER, TIMER_SCHEUDLE, timer, sizeof(void *))

void ScheduleTimer(TimerDescriptorType * timer);

#define SYSTEM_TIME (xTaskGetTickCount())
#define SUSPEND_INDEFFINATELY                  0xffffffff


#endif /* TASK_CONFIG_H */
