/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <bluetooth_config.c>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* Chia Weng Sun		 		08/06/2010   	CCMPD01379068		Initial Creation
* Niravkumar Rabara  08/20/2010     CCMPD01383800           Removed HFP_HP related config  
* Niravkumar Rabara	09/23/2010	    CCMPD01394958       Headset Profile Audio Gateway implementation. 
* Niravkumar Rabara	10/18/2010	    CCMPD01402008       Added Serial Port Profile
* Tan Seng Kai	    10/20/2010      CCMPD01394399		Move H5 defination to bt_portability
* Niravkumar Rabara	10/27/2010			CCMPD01405413        Modify HCI_Control function to HCI_Control_21
* Tan Seng Kai      11/03/2010    CCMPD01409994       HCI_NO_OF_MANAGED_SCO_CONNECTIONS change to 1 to give more bandwidth for ACL
* Niravkumar Rabara 11/19/2010    CCMPD01415880       Modify HSP_AG minimum frame size to 24 from 48 to meet Bluetooth Qualification Test
* Tan Seng Kai      12/08/2010    CCMPD01451448       Change SEC behavior
* Abhishek Trivedi  03/18/2014	  CCMPD01873731	      Resolve 2 device connection issue
* Abhishek Trivedi  11/14/2014	  CCMPD01958065	      Improve GW Reconnection timing
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/
/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "bluetooth_int.h" /* cwc034 added */
#include "bt_lp.h"
#include "hsp_ag.h" 
#include "spp.h"

#ifdef UART_H4
#include "uart_transport_avr32.h"
#endif

#ifdef UART_H5
#include "twu_transport_avr32.h"
#endif

/*****************************************************************************/
/* Private macros                                                            */
/*****************************************************************************/
#define SEC2_MODE_SETTINGS                      ( SEC_INCOMING_AUTHENTICATION_REQUIRED \
                                                | SEC_INCOMING_ENCRYPTION_REQUIRED \
                                                | SEC_OUTGOING_AUTHENTICATION_REQUIRED \
                                                | SEC_OUTGOING_ENCRYPTION_REQUIRED)

#define BTCOM_CSR_USB_PORT_PREFIX       "\\\\.\\csr"

/*****************************************************************************/
/* Private types                                                             */
/*****************************************************************************/

/*****************************************************************************/
/* Public constants & variables                                              */
/*****************************************************************************/

/*
 *  Values for all integer type configuration options for all modules.
 *	See the reference manual for the different modules.
 */
BT_ConfigIntEntry configInts[]= 
{   
    /*
     * General stack configuration
     */
    {BT_MAX_NO_OF_APPS,                         1 },
    {BT_MAX_NO_OF_PROFILES,                     3 }, /* HCI Link handler part, HSP_HS */

    {BT_MAX_NO_OF_LOG_FILTERS,                  40 },     
    {BT_LOG_PARAMETER_SIZE,                     1024},
    {BT_MAX_BLOCK_TIME,                         900},
    {BT_NOT_CONGESTED_EVENTS,                   1},

    {BTTL_MAX_RX_PACKET_SIZE,                   800},
    {BTTL_MAX_TX_PACKET_SIZE,                   800},

#ifdef UART_H4 //cwc034
    {BTTL_UART_INITIAL_BR,                      57600},
    {BTTL_UART_NO_OF_TX_BUFFERS,                1},
#endif

//    {BTTL_CSR_INITIAL_BR,                       115200}, cwc034: commented for CSR specific
//    {BTTL_CSR_USB_NO_OF_TX_BUFFERS,             1}, cwc034: commented for CSR specific

#ifdef UART_H5
	  {BTTL_TWU_MAX_WINDOW_SIZE,                 1},
    {BTTL_TWU_BEHAVIOUR,                       0},
    {BTTL_TWU_MAX_ACK_DELAY_TIMER,             0},
    {BTTL_TWU_MAX_RESEND_RELIABLE_TIMER,      75},
    {BTTL_TWU_MAX_PACKET_PAYLOAD_SIZE,       370},
    {BTTL_TWU_MAX_SCO_PACKET_PAYLOAD_SIZE,   300},
    {BTTL_TWU_MAX_WRITE_BLOCK_SIZE,          380},
    {BTTL_TWU_SYNC_TX_PERIOD,                250},
    {BTTL_TWU_NO_OF_PACKET_BUFFERS,            1},
    {BTTL_TWU_NO_OF_SCO_PACKET_BUFFERS,        3},
    {BTTL_TWU_RESENDS_BEFORE_UNRESPONSIVE_IND, 0},
#endif
            
  
    {HCI_INQUIRY_CACHE_SIZE,                    8},
    {HCI_MAX_NO_OF_CONNECTED_DEVICES,           2},
    {HCI_RESET_DELAY,                           400},
    {HCI_MAX_NO_OF_USERS,                       8},

    {HCI_BEHAVIOUR,                             0},
    {HCI_CONTROLLER_RESPONSE_TIMEOUT,           0},
    {HCI_NO_OF_MANAGED_SCO_CONNECTIONS,         1},

    /*
     * Optional HCI Link handler part 
     */
    { HCI_LH_PARK_MIN_INTERVAL,             256 },
    { HCI_LH_PARK_MAX_INTERVAL,             2000 },
    

    { HCI_LH_SNIFF_MIN_INTERVAL,            100 },
    { HCI_LH_SNIFF_MAX_INTERVAL,            240  },
    
    { HCI_LH_SNIFF_ATTEMPT,                 0x01 },
    { HCI_LH_SNIFF_TIMEOUT,                 0x04 },

    { HCI_LH_INACTIVITY_POLL_TIME,          1000 },
    { HCI_LH_INACTIVITY_POLL_THRESHOLD,     2 },
    
    /*
     * SEC configuration
     */ 
    {SEC_SECURITY_MODE,                         SEC_SECURITY_MODE_2},
    {SEC_MODE_3_ENCRYPTION,                     HCI_ENCRYPTION_DISABLED},

    {SEC_PIN_TYPE,                              SEC_VARIABLE_PIN},
    {SEC_MAX_NO_OF_SERVICES,                    8},/*SDP*2, HSP*2*/
    {SEC_MAX_NO_OF_MUX_PROTOCOLS,               2},
    {SEC_MAX_NO_OF_DEVICES,                     4},
    //{SEC_BEHAVIOUR,                             SEC_LINK_KEY_NO_KEYS_ON_HOST |
    //                                            SEC_LINK_KEY_AUTOSTORE |
    //                                            SEC_GET_REMOTE_DEVICE_NAMES},
    {SEC_BEHAVIOUR,                             SEC_GET_REMOTE_DEVICE_NAMES |
                                                SEC_SEND_SEC_LINK_KEY_REQUEST_IND |
                                                SEC_SEND_SEC_LINK_KEY_NOTIFICATION_IND },
    {SEC_DELAY_TIME_RESENDING_HCI_COMMAND,      200},
    {SEC_REPEATED_ATTEMPTS_INTERVAL,            100}, //cwc034: Added based on OB
 
    /*
     * L2CAP configuration
     */
    { L2CA_MAX_NO_OF_CHANNELS,                  4 },
    { L2CA_MAX_NO_OF_CONNECTED_DEVICES,         3 },
    { L2CA_MTU_CNL,                             0 },  
    { L2CA_INCOMING_CNO_MPS,                   672},
    { L2CA_OUTGOING_CNO_MPS,                   672},     
    { L2CA_MTU_SIG,                             48 },
    { L2CA_DELAY_TIME_RESENDING_LP_PACKET,      100 },
    { L2CA_RTX_TIMEOUT,                         30000 },
    { L2CA_ERTX_TIMEOUT,                        150000 },
    { L2CA_MAX_TIME_CONFIG_CONNECTION,          120000 },
    { L2CA_MAX_NO_OF_USERS,                     3 },
    { L2CA_MAX_NO_OF_GROUPS,                    0 },

    /*
     * SDP configuration
     */
    { SDP_MAX_SERVER_BUFFER_SIZE,               127 }, 
    { SDP_MAX_CLIENT_BUFFER_SIZE,               127 }, 
    { SDP_MAX_SERVICE_RECORDS,                  8 },
    { SDP_MAX_NO_OF_SEARCH_SESSIONS,            2 },
    { SDP_DELAY_TIME_RESENDING_L2CA_COMMAND,    200 },

    /*
     * SDAP configuration
     */
    { SDAP_MAX_INQUIRY_RESULTS,                 BT_MNGR_MAX_INQUIRY_RESULTS },
    { SDAP_DELAY_TIME_RESENDING,                200 },
    { SDAP_MAX_REM_NAME_LENGTH,                 BT_MNGR_MAX_NAME_LENGTH },
    { SDAP_MAX_SEARCH_PATTERN_SIZE,             48 }, 
    { SDAP_MAX_ATTR_ID_LIST_SIZE,               48 }, 
    { SDAP_SDP_SEARCH_TIMEOUT,                  2000 },
    { SDAP_MAX_TRANSACTION_INACTIVITY,          0 },
    { SDAP_MAX_RECEIVE_BUFFER_SIZE,             672 }, 

    /*
     * RFCOMM configuration
     */
    {RFCOMM_MAX_BT_DEVICES, 3},
    {RFCOMM_MAX_PORTS, 1},
    {RFCOMM_MAX_FRAME_SIZE, 672},
    {RFCOMM_TIMEOUT_T1, 60000},
    {RFCOMM_TIMEOUT_T1_AUTH , 60000},

    {RFCOMM_TIMEOUT_T2, 60000},
    {RFCOMM_SEC_LEVEL, 0},
    {RFCOMM_MAX_DATA_REQ, 4},
    {RFCOMM_L2CAP_TIMEOUT, 100},
    {RFCOMM_SEC_TIMEOUT, 100},
    {RFCOMM_RESEND_QUEUE_SIZE, 2},

    /*
     * PADAPT configuration
     */
    { PADAPT_MAX_NO_OF_SERVICES,    5 },
    { PADAPT_MAX_NO_OF_CONNECTIONS, 5 },
    { PADAPT_DELAY_TIME_RESENDING_RFCOMM_COMMAND, 100 },
    { PADAPT_MAX_NO_OF_DEVICES, 3 },
    { PADAPT_RESEND_QUEUE_SIZE, 1 }, 

    /*
     * HSP_AG configuration
     */

    {HSP_AG_SECURITY_LEVEL,                     SEC2_MODE_SETTINGS},
    {HSP_AG_FRAME_SIZE,				127},
    {HSP_AG_MIN_FRAME_SIZE,                     48},
    {HSP_AG_MAX_FRAME_SIZE,                     256},
    {HSP_AG_INITIAL_CREDITS,                    7},
    {HSP_AG_CREDITS_TO_SEND,                    127},
    {HSP_AG_MIN_CREDITS,                        126},
    {HSP_AG_RESEND_TIME,                        10},
    {HSP_AG_AT_COMMAND_MAX_SIZE	,               127},
    {HSP_AG_LINK_HANDLER_SETTINGS,                (HCI_LH_PREVENT_HOLD | HCI_LH_AUTO_ENTER_SNIFF | HCI_LH_PREVENT_PARK | 
                                                         HCI_LINK_POLICY_ENABLE_MASTER_SLAVE_SWITCH  )},
    
    {SPP_DEV_SECURITY_LEVEL,                     SEC_SECURITY_LEVEL_1},
    {SPP_DEV_FRAME_SIZE,			127},
    {SPP_DEV_MIN_FRAME_SIZE,                    48},
    {SPP_DEV_MAX_FRAME_SIZE,                   256},
    {SPP_DEV_INITIAL_CREDITS,                    7},
    {SPP_DEV_CREDITS_TO_SEND,                    127},
    {SPP_DEV_MIN_CREDITS,                        126},
    {SPP_DEV_RESEND_TIME,                        10},
    {SPP_DEV_AT_COMMAND_MAX_SIZE,               127},// qbdx84 modified
    {SPP_DEV_LINK_HANDLER_SETTINGS,             ( HCI_LINK_POLICY_ENABLE_SNIFF_MODE \
                                                | HCI_LH_PREVENT_MS_SWITCH 
												//| HCI_LINK_POLICY_ENABLE_MASTER_SLAVE_SWITCH \
                                               // | HCI_LH_AUTO_ENTER_SNIFF \
                                                | HCI_LH_AUTO_EXIT_LPM 

												)},
    
    /*
     * End mark
     */
    {0, 0}

};

/* Config strings for UART and BCSP */
BT_ConfigStrEntry configStrs[]= 
{   

#ifdef UART_H4
    {BTTL_UART_COM_PORT, "COMx:"},
#endif
    
//    {BTTL_CSR_USB_PORT, ""}, cwc034: commented out for USB specific

    {0, ""}
};

/*
 * Array of control functions. Only modules
 * whose control functions are in this array
 * will be activated.
 * Unless the application code includes other references
 * to a module, it will not even be included
 * in the build if it is removed below.
 */
BT_ControlFunc controlFuncs[] = 
{
    TSRV_Control,

#ifdef UART_H4 //cwc034
    BTTL_UartControl,
#endif
    
#ifdef UART_H5 //cwc034
    BTTL_TwuControl,
#endif

    HCI_LH_Control,
    HCI_Control_21,
    LP_Control,
    SEC_Control,
    L2CA_Control, 
    RFCOMM_Control, 
    SDP_Control,
    SDAP_Control,
    PADAPT_Control, 
    HSP_AG_Control,
    SPP_DEV_Control,
    BT_MNGR_Control,
    0
};


/*****************************************************************************/
/* Private constants & variables                                             */
/*****************************************************************************/

/*****************************************************************************/
/* Private function prototypes                                               */
/*****************************************************************************/

/*****************************************************************************/
/* Callback or Interrupt functions                                           */
/*****************************************************************************/


/*****************************************************************************/
/* Private functions                                                         */
/*****************************************************************************/
#if 0         // CCMPD01410054 (JJ 8/11/2010)
/* ===========================================================================
 * Function:    ChangeConfigInt
 * Description: Change the value of a configuration parameter
 *
 * Returns:     - 
 * =========================================================================== */
static void ChangeConfigInt( BT_ConfigIntEntry *configEntry, 
                            BT_ConfigId configId,
                            BT_S32      configVal)
{
    BT_BOOL     found = BT_FALSE;

    /* Try to locate entry */
    while( !found
          && (configEntry->configId != 0) )
    {
        if ( configEntry->configId == configId )
        {
            found = BT_TRUE;        
        }
        else
        {
            configEntry++;
        }
    }

    /* Check bounds */
    if ( found )
    {
        configEntry->val = configVal;
    }
}


/* ===========================================================================
 * Function:    ChangeConfigStr
 * Description: Change the value of a configuration parameter
 *
 * Returns:     - 
 * =========================================================================== */
static void ChangeConfigStr( BT_ConfigStrEntry *configEntry, 
                            BT_ConfigId configId,
                            BT_U8       *configVal)
{
    BT_BOOL     found = BT_FALSE;

    /* Try to locate entry */
    while( !found
          && (configEntry->configId != 0) )
    {
        if ( configEntry->configId == configId )
        {
            found = BT_TRUE;        
        }
        else
        {
            configEntry++;
        }
    }

    /* Check bounds */
    if ( found )
    {
        configEntry->str = (const char*)configVal;
    }
}

/* ===========================================================================
 * Function:    SetTlControlFunc
 * Description: Change the transport layer control function to the requested one
 *
 * Returns:     - 
 * =========================================================================== */
static void SetTlControlFunc( BT_ControlFunc controlFunc  )
{
    BT_BOOL     found = BT_FALSE;
    BT_U8       i = 0;

    /* Try to locate entry */
    while( !found
          && (controlFuncs[i] != 0) )
    {
#ifdef UART_H4    	
        if ( controlFuncs[i] == BTTL_UartControl )
#endif

#ifdef UART_H5
        if (    controlFuncs[i] == BTTL_TwuControl)
#endif
        //||  controlFuncs[i] == BTTL_CsrUsbControl //cwc034: commented for compilation ERROR
        {
            found = BT_TRUE;        
        }
        else
        {
            i++;
        }
    }

    /* Check bounds */
    if ( found )
    {
        controlFuncs[i] = controlFunc;
    }
}
#endif        // CCMPD01410054 (JJ 8/11/2010)

/*****************************************************************************/
/* Private tasks                                                             */
/*****************************************************************************/
	
/*****************************************************************************/
/* Public API functions                                                      */
/*****************************************************************************/

/* ===========================================================================
 * Function: 	
 * Description: 
 * Returns:
 * =========================================================================== */
void BT_MNGR_ChangeTransportConfig(BT_MNGR_TransportSettings *tlSettings)
{
	//static char port[30];   // CCMPD01410054 (JJ 8/11/2010)
    
	switch ( tlSettings->transportLayer )
    {
/*
#ifdef UART_H4
    case BTCOM_TRANSPORT_UART:
        sprintf(port,"COM%s:", tlSettings->port);
        ChangeConfigStr(configStrs, BTTL_UART_COM_PORT, (BT_U8*)port);
        ChangeConfigInt(configInts, BTTL_UART_INITIAL_BR, tlSettings->baudRate );
        SetTlControlFunc(BTTL_UartControl);     
        
		break;
		//BTCOM_TRANSPORT_TWU
		
#endif

#ifdef UART_H5
    case BTCOM_TRANSPORT_TWU:
        sprintf(port,"COM%s:", tlSettings->port);
        ChangeConfigStr(configStrs, BTTL_TWU_AVR32_COM_PORT, (BT_U8*)port);
        ChangeConfigInt(configInts, BTTL_TWU_AVR32_BAUD_RATE, tlSettings->baudRate );
        SetTlControlFunc(BTTL_TwuControl);     
        
		break;
		
#endif

                
*/                

/* //cwc034: commented for compilation ERROR
    case BTCOM_TRANSPORT_CSR_USB:       
        sprintf(port,"%s%s",BTCOM_CSR_USB_PORT_PREFIX,tlSettings->port);
        ChangeConfigStr(configStrs, BTTL_CSR_USB_PORT, (BT_U8*)port);
        SetTlControlFunc(BTTL_CsrUsbControl);
        break;
*/
    default:
    	break;
    }

}

/* ===========================================================================
 * Function:    BTCOM_SetupLogFilter
 * Description: Configures the log and trace filtering 
 * =========================================================================== */
void BTCOM_SetupLogFilter()
{
    /* 
     * Remove all filters 
     */
    BT_SetLogDefault( BT_ENABLE_ALL );
    BT_ResetLogFilter( );

    /*
     * Remove all HCI event subscriptions fom log
     */
    BT_AddFnCallFilter( 0, BT_HCI,  0 );

    
    BT_AddMsgClassFilter( BTTL_MSG_CLASS);
    BT_AddMsgClassFilter( LP_MSG_CLASS );
    BT_AddMsgClassFilter( HCI_MSG_CLASS );
    BT_AddMsgClassFilter( HCI_CMD_MSG_CLASS );
    BT_AddMsgClassFilter( L2CA_MSG_CLASS );
    BT_AddMsgClassFilter( PADAPT_MSG_CLASS );
    //BT_AddMsgClassFilter( SEC_MSG_CLASS );
    //BT_AddMsgClassFilter( RFCOMM_MSG_CLASS );
    //BT_AddMsgClassFilter( SDP_MSG_CLASS );
    BT_AddMsgClassFilter( TSRV_MSG_CLASS );

    BT_AddMsgFilter( 0, 0, LP_DATA_REQ );
    BT_AddMsgFilter( 0, 0, LP_DATA_EVENT );
    BT_AddMsgFilter( 0, 0, HCI_ACL_DATA_REQ );
    BT_AddMsgFilter( 0, 0, HCI_ACL_DATA_IND );
    BT_AddMsgFilter( 0, 0, L2CA_DATA_REQ );
    BT_AddMsgFilter( 0, 0, L2CA_DATA_IND ); 
    BT_AddMsgFilter( 0, 0, RFCOMM_DATA_REQ );
    BT_AddMsgFilter( 0, 0, RFCOMM_DATA_IND );

    BT_AddSignalFilter( BT_L2CA );
    BT_AddSignalFilter( BT_RFCM );
    //BT_AddSignalFilter( BT_SDP );
    BT_AddSignalFilter( BT_TL );

    BT_AddFnCallFilter(BT_HCI, BT_TSRV, "BT_TimeoutReq");
    BT_AddFnCallFilter(BT_HCI, BT_TSRV, "BT_TimeoutCancel");
    BT_AddFnCallFilter(BT_CTRL, BT_TSRV, "BT_TimeoutReq");
    BT_AddFnCallFilter(BT_LookupProfile(BT_HSP_HS), BT_TSRV, "BT_TimeoutCancel");
    BT_AddFnCallFilter(BT_LookupProfile(BT_HSP_HS), BT_TSRV, "BT_TimeoutReq");
    BT_AddFnCallFilter(BT_HSP_HS, BT_HCI, "HCI_RegisterUser");
    BT_AddFnCallFilter(BT_SPP_DEV, BT_HCI, "HCI_RegisterUser");
    BT_AddFnCallFilter(_BT_HCI, BT_TSRV, "BT_TimeoutReq");
    BT_AddFnCallFilter(_BT_HCI, BT_TSRV, "BT_TimeoutCancel");
        
}
