#ifndef BLUETOOTH_INT_H
#define BLUETOOTH_INT_H

/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <bluetooth_int.h>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* Chia Weng Sun     08/06/2010    CCMPD01379068       Initial Creation
* Tan Seng Kai      08/30/2010    CCMPD01388039       Added in typedef for BCCMD
* Niravkumar Rabara 09/09/2010    CCMPD01389372       Added typedef for HFP_AG removed HGP_HF & changed BTCOM to BT_MNGR
* Tan Seng Kai      09/22/2010    CCMPD01394890       Added configuration for BQB and RTTE test
* Niravkumar Rabara 09/23/2010    CCMPD01394958       Headset Profile Audio Gateway implementation. 
* Niravkumar Rabara 10/04/2010    CCMPD01398596       AT Command Implementation for R1.3 Headset Test
* Tan Seng Kai      10/07/2010    CCMPD01397694       Implement Nibbler and Reverse Nibbler
* Niravkumar Rabara 10/08/2010    CCMPD01400432       Modified RING AT Command to 10 times as per MSC
* Niravkumar Rabara 10/11/2010    CCMPD01400996       Bug Fix related to 1.3 Remote PTT Nibble
* Niravkumar Rabara 10/15/2010    CCMPD01402008
* Tan Seng Kai      10/27/2010    CCMPD01407568       Move static prototype into bluetooth manager
* Tan Seng Kai      10/29/2010    CCMPD01408084       Clean up test code that use for dubugging RSSI and Reverse Nibbler
* Tan Seng Kai      11/03/2010    CCMPD01409994       Add in define for BT_HCI_PAGE_TIMEOUT, MAX_PAIRING_RETRY, MAX_SERVICE_NAME_RETRY
* Niravkumar Rabara 11/14/2010    CCMPD01413929       Add sendSppAtCmdRsp fuction prototype
* Tan Seng Kai      11/18/2010    CCMPD01415437       Typedef status to keep HSP status
* Tan Seng Kai      11/23/2010    CCMPD01418684       Add defination for "AT+MPTT=0\r"                                        
* Tan Seng Kai      11/25/2010    CCMPD01421182       Add prototype for BT_GetReverseNibbler                                        
* Tan Seng Kai      12/06/2010    CCMPD01450321       Reduce pairing retry and service name retry count to 1
* Tan Seng Kai      12/08/2010    CCMPD01451448       Assign as gobal variable for btDevInfo
* Tan Seng Kai      12/10/2010    CCMPD01452429       Reduce page time out to 0x2000 to reduce attemp to reconnect time
* Tan Seng Kai      12/10/2010    CCMPD01452526       Function add in to handle AT command over nibbler
* Tan Seng Kai      12/17/2010    CCMPD01455489       BT_MNGR_SendHciQosSetup prototype define
* Tan Seng Kai      12/20/2010    CCMPD01455949       BT_HCI_PAGE_TIMEOUT revert back to 0x8000 due to some hs not connect properly
* Mahes             Jan/06/2011   CCMPD01460340       Software catup to dongle R1.2 version R01.00.00
* Maheswaran        12/20/2010    CCMPD01414087       Added BT_MNGR_Send_Read_BDADD ,HCI_READ_BD_ADDR_COMPLETE_EVENT
* Tan Seng Kai      01/17/2011    CCMPD01463409       Added in AT praser for Data over nibbler
* Tan Seng Kai      01/25/2011    CCMPD01466195       Change flag name for device status
* Niravkumar Rabara 01/27/2011    CCMPD01467325       Added flag for AT handshaking status
* Tan Seng Kai      02/11/2011    CCMPD01471859       Implement align to new MSC diagram. SecureWireless_R2.1_R2.0_R2.3_data_connection.pdf
* Niravkumar Rabara 02/11/2011    CCMPD01473401       Added Structure for VolumeContol
* Toh Pei See       15/12/2011    CCMPD01592074       Added typedef for BCCMD to read max tx power & set the default tx power 
* Sean              08/28/2013    CCMPD01806989       Added boolean for Is_LinkLost
* wrn637            17/9/2013     CCMPD01815076       Remove Low power reconnection feature
* Abhishek Trivedi  11/8/2013     CCMPD01834482       Updates for XNL-XCMP Host
* WRN637            07/11/2013    CCMPD01825398       MPP Class 1 RFPA handling
* WRN637            06/01/2014    CCMPD01849533       Resolve compilation warming
* Abhishek Trivedi  01/10/2014    CCMPD01851442       Add flag for XNL-XCMP link
* WRN637            01/22/2014    CCMPD01854392       Improve ACL message sending      
* Abhishek Trivedi  03/10/2014	  CCMPD01870625       CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi  04/04/2014    CCMPD01882874       Version Check on CSR
* Abhishek Trivedi  04/15/2014    CCMPD01883363       Interchip Ping part 2
* Abhishek Trivedi  05/28/2014    CCMPD01897875       Fix Klocwork Issues
* Abhishek Trivedi  11/11/2014    CCMPD01945832       Edge of Range Support
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "bluetooth_manager.h"//cwc034 added
#include "bt_common.h"
#include "bt_hci.h"
#include "sdap.h"
#include "bt_security_manager.h"
/*****************************************************************************/
/* Public macros                                                             */
/*****************************************************************************/

/*
 * Define for HCI PAGE TIMEOUT for Paring
 */
#define BT_HCI_PAGE_TIMEOUT         0x8000

/*
 * Define maximum Pairing retry
 */
#define MAX_PAIRING_RETRY           1

/*
 * Define maximum service name retry
 */
#define MAX_SERVICE_NAME_RETRY      1

#define BT_MNGR_MAX_NAME_LENGTH 40

#define BT_MNGR_HCI_RAWPKT_SIZE_WO_PAYLOAD      4 //Header + Param Total Length + Payload Descriptor
/*
 * Define for HCI RAW REQUEST
 */
#define BT_MNGR_HCI_HEADER			0xFC00

/* Payload Descriptor - Fragment */
#define BT_MNGR_HCI_FIRSTFRAGMENT		0x01
#define BT_MNGR_HCI_LASTFRAGMENT		0x01
/* Payload Descriptor - Channel */
#define BT_MNGR_HCI_CHANNELID_BCCMD 	        0x02
#define BT_MNGR_HCI_CHANNELID_VM                0x0D

/*
 * Define for Bluecore command - CCMPD01388039
 */
/* Data Access Control */
#define BCCMD_TYPE_GETREQ			0x0000
#define BCCMD_TYPE_GETRESP			0x0001
#define BCCMD_TYPE_SETREQ			0x0002

/* VARI ID */
#define BCCMD_VARID_PS_Size			0x3006
#define BCCMD_VARID_WARMRESET		        0x4002
#define BCCMD_VARID_DUT2				0x4016
#define BCCMD_VARID_DUT1				0x401F

#define BCCMD_VARID_LED0			0x484A
#define BCCMD_VARID_LED1			0x484B
#define BCCMD_VARID_RADIOTEST		        0x5004
#define BCCMD_VARID_PS				0x7003

/* Command Statud */
#define BCCMD_STATUS_OK				0x0000
#define BCCMD_STATUS_NO_SUCH_VARID		0x0001
#define BCCMD_STATUS_TOO_BIG			0x0002
#define BCCMD_STATUS_NO_VALUE			0x0003
#define BCCMD_STATUS_BAD_REQ			0x0004
#define BCCMD_STATUS_NO_ACCESS			0x0005
#define BCCMD_STATUS_READ_ONLY			0x0006
#define BCCMD_STATUS_WRITE_ONLY			0x0007
#define BCCMD_STATUS_ERROR			0x0008
#define BCCMD_STATUS_PERMISSION_DENIED	        0x0009

/* PSKEY */
#define PSKEY_HOST_INTERFACE			0x01f9
#define PSKEY_USR38                             0x02b0

/* PSKEY Store type */
#define PSKEY_STORE_DEFAULT			0x0000
#define PSKEY_STORE_ALL                         0x000f

/* PSKEY Value for PSKEY_HOST_INTERFACE */
#define PSKEY_VALUE_DUMMY			0x0000
#define PSKEY_VALUE_USBLINK			0x0002
#define PSKEY_VALUE_H4				0x0003
#define PSKEY_VALUE_H5				0x0006


/*****************************************************************************/
/* Public types                                                              */
/*****************************************************************************/

/*
 * Identifiers for Bluetoth transport layers that 
 * can be activated by this application
 */
typedef enum
{   
    BT_MNGR_TRANSPORT_UART = 0,   
    BT_MNGR_TRANSPORT_CSR_USB,
    BT_MNGR_TRANSPORT_TWU,
} BT_MNGR_TransportLayer;

/*
 * Structure describing different transport layers
 */
typedef struct
{
    BT_MNGR_TransportLayer transportLayer;
    char                *port;
    BT_U32              baudRate;
} BT_MNGR_TransportSettings;
/*
 * // qbdx84 -Nirav  AT CMD enum
 */
typedef enum 
{
	RING_AT_CMD,
	OK_AT_CKPD_CMD,
	CGMM_AT_CMD_IND,
        OK_AT_NIBBLER_CMD,
	REVERSE_NIBBLER,
	HSP_XCMP_REVERSE_NIBBLER,
        NULL_NIBBLER
}AG_AT_CMD_IND;
typedef enum 
{
	RING_CMD,
	OK_CKPD_CMD,
	CGMM_CMD_RSP,
	OK_NIBBLER_CMD,
	REVERSE_NIBBLER_BYTE,    
        ECHO_NULL_NIBBLER_BYTE
}AG_AT_CMD_RSP;

typedef enum {
  NO_DEVICE,
  HSP,
  SPP,
}DEV_PROFILE;

typedef enum 
{
  NOT_PAIR = 1,    
  SERVICE_NAME_MISMATCH,
  SERVICE_NAME_MATCH,
  PAIRED_FAIL,
  PAIRED,
}DEV_STAT;

/* BCCMD - PSKEY structur - CCMPD01388039*/
typedef struct
{
	BT_U16	pskey;
	BT_U16	len;
	BT_U16 	stores;
	BT_U16	data;
}BT_MNGR_HCI_BCCMD_PSKEY;

/* 
 * Union type for BCCMD
 */
typedef union
{
	BT_MNGR_HCI_BCCMD_PSKEY ps;
	BT_U16			data[4];
} BT_MNGR_HCI_BCCMDDATA;

/* BCCMD with all type of BCCMD - CCMPD01388039 */
typedef struct
{
	BT_U16				type;
	BT_U16				pdulen;
	BT_U16 				seqno;
	BT_U16				varid;
	BT_U16				status;
	BT_MNGR_HCI_BCCMDDATA		d;			//data
}BT_MNGR_HCI_BCCMD;

typedef struct
{
	BT_U16	pskey;
	BT_U16	len;
	BT_U16 	stores;
	BT_U16	data[4];
} BT_MNGR_HCI_BCCMD_USR_PSKEYDATA;

/* BCCMD with all type of BCCMD - CCMPD01388039 */
typedef struct
{
	BT_U16				type;
	BT_U16				pdulen;
	BT_U16 				seqno;
	BT_U16				varid;
	BT_U16				status;
	BT_MNGR_HCI_BCCMD_USR_PSKEYDATA ps;			//pskey data
}BT_MNGR_HCI_BCCMD_USR_PSKEY;

/* Payload Descriptor for HCI RAW REQ - CCMPD01388039 */
typedef union
{
	BT_U8 all;
}BT_MNGR_HCI_PayloadDescriptor;

/* HCI RAW REQ warping with BCCMD - CCMPD01388039 */
typedef struct
{
	BT_U16				Header;
	BT_U8				Parameter_Total_Length;
	BT_MNGR_HCI_PayloadDescriptor 	PayloadDescriptor;
	BT_MNGR_HCI_BCCMD		BCCMDPDU;
}BT_MNGR_HCI_BCCMDPKT;

typedef struct
{
	BT_U16				Header;
	BT_U8				Parameter_Total_Length;
	BT_MNGR_HCI_PayloadDescriptor 	PayloadDescriptor;
	BT_MNGR_HCI_BCCMD_USR_PSKEY	BCCMDUSRPSKEYPDU;
}BT_MNGR_HCI_BCCMD_USR_PSKEYPKT;

/* HCI RAW REQ warping with BCCMD - CCMPD01388039 */
typedef struct
{
	BT_U16				Header;
	BT_U8				Parameter_Total_Length;
	BT_MNGR_HCI_PayloadDescriptor 	PayloadDescriptor;
        BT_U8			        payload[15];
}BT_MNGR_HCI_RAWPKT;

typedef struct
{
  BT_BOOL    Is_connection_allow;
  BT_BOOL    Is_connected;
  BT_BOOL    Is_SPP_connected;
  BT_BOOL    Is_SPP_flow_enable;
  BT_BOOL    Is_SCO_connected; 
  BT_BOOL    Is_NIBBLER_enable;
  BT_BOOL    Is_AT_Handshaking_done;
  BT_U8      AT_cmd_state;  
  BT_U8      AT_cmd_retry_cnt;
  BT_BOOL    Is_LinkLost;
  BT_BOOL    Is_nibbler_decoding_done;
  BT_BOOL    Is_comm_over_xnl_xcmp;
}BT_MNGR_DEVICE_STATUS;

typedef struct {
  BT_BdAddr             addr;
  DEV_PROFILE           profile;
  HCI_LinkKey           linkkey;
  HCI_KeyType           keyType;
  SEC_PairingType       pairingType;
  BT_BOOL               IsNibblerDefaultON;
  BT_BOOL               IsDeviceClass1;
}btDevInfo;

typedef struct {
  char       volAtCmd[20];
  BT_BOOL    isVolCntrlCmdPending;
}volInfo;  

/* 
 *	BT_MNGR_Device, structure used to store addresses and names.
 */
typedef struct
{
    btDevInfo             devinfo;
    BT_U8                 name[BT_MNGR_MAX_NAME_LENGTH];    
    HCI_ClassOfDevice     classOfDevice;
    BT_S8                 rssi;
    DEV_STAT              status;
    BT_U8                 service_name_count;    
    BT_U8                 paring_retry_count;
}   BT_MNGR_Device;


/*****************************************************************************/
/* Public constant & variable prototypes                     	             */
/*****************************************************************************/
extern BT_ModuleId    appSenderId;
extern  BT_ConfigIntEntry configInts[];
extern  BT_ConfigStrEntry configStrs[];
extern  BT_ControlFunc controlFuncs[];
/*****************************************************************************/
/* Public API function prototypes                                            */
/*****************************************************************************/

/* SEC Send functions */
BT_Result BT_MNGR_SendCreateBondReq(BT_BdAddr bdAddr, BT_BOOL createTrust);
BT_Result BT_MNGR_SendSecPinRequestRsp(BT_BdAddr bdAddr, BT_BOOL acceptPairing);
BT_Result BT_MNGR_SendSecWriteDiscoverableReq(BT_BOOL accept,BT_U16 scanInterval, BT_U16 scanWindow);
BT_Result BT_MNGR_SendSecWriteConnectableReq(BT_BOOL accept,BT_U16 scanInterval, BT_U16 scanWindow);


/* HCI Send functions */
BT_Result BT_MNGR_RemoveLinkKeys(void);
BT_Result BT_MNGR_SendHciWriteScanEnable(HCI_ScanEnable scanEnable);
BT_Result BT_MNGR_SendHciWriteClassOfDevice(HCI_ClassOfDevice classOfDevice);
BT_Result SendHciWritePageTimeout(BT_U16 pageTimeout);
BT_Result BT_MNGR_SendReadDeviceInfoReq(void);
BT_Result BT_MNGR_SendHciControllerRestartedRsp(void);
void BT_MNGR_HCIRawEventHandler(HCI_RawEventInd* event); 
BT_Result BT_MNGR_Send_Read_BDADD(void);              //CCMPD01414087 (GM_20Dec2010)
BT_Result BT_MNGR_SendHciReadClassOfDevice();

/* SDAP Send functions */
BT_Result BT_MNGR_SendSdapTerminatePrimReq(BT_Primitive primitive);
BT_Result BT_MNGR_SendSdapServiceSearchAttrReq(BT_BdAddr addr);
BT_Result BT_MNGR_SendSdapEnumRemDevReq(void);

/* HSP_AG functions */
BT_Result BT_MNGR_SendHspAgConnectReq(BT_BdAddr);
BT_Result BT_MNGR_SendHspAgConnectRsp(BT_BOOL accept);
BT_Result BT_MNGR_SendHspAgDisconnectReq(void);
BT_Result BT_MNGR_SendHsAgDataReq(BT_U8 data);
BT_Result BT_MNGR_SendSppDataReq(BT_U8 data);
BT_Result BT_MNGR_SendHsAgAudioConnectReq();
BT_Result BT_MNGR_SendHsAgAudioDisconnectReq();
BT_Result BT_MNGR_SendHsAgAudioConnectRsp(BT_BOOL); // CCMPD01400441_ckpd36_Framework_V2 (11 Oct 2010)

/* HCI RAW Send Function */
BT_Result BT_MNGR_SendHci_BCCMD			(BT_MNGR_HCI_BCCMD CMD);
BT_Result BT_MNGR_Send_hci_raw_cmd( const BT_U8 *hcivmCmd, BT_U8 size );
BT_Result BT_MNGR_SendSppConnectRsp(BT_BOOL accept);
BT_Result BT_MNGR_SendRssiInqCfg    (void);
BT_Result BT_MNGR_SendHciwritepagetimeout (void);
BT_Result BT_MNGR_SendHciWriteInquiryResponseTransmitPowerLevel(BT_S8 ReqPwr);
BT_Result BT_MNGR_SendSeclinkkeyreqrsp( btDevInfo* device, BT_BOOL accept);
BT_Result BT_MNGR_SendHciQosSetup(BT_U16 connectionHandle, BT_U32 pollrate);
BT_Result BT_MNGR_SendHci_UsrPskey_BCCMD(BT_MNGR_HCI_BCCMD_USR_PSKEY CMD);
BT_Result BT_MNGR_SendHciReadInquiryResponseTransmitPowerLevel(void);

/* BCCMD preparation */
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_USBTL		(BT_U16 GETSET, BT_U16 SEQNO);
BT_MNGR_HCI_BCCMD_USR_PSKEY BT_MNGR_BCCMD_VER_CHECK(BT_U16 GETSET, BT_U16 SEQNO);
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_SETWARMRESET	(BT_U16 SEQNO);
#ifdef BT_ENABLE_DUT
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_TXRXTEST	(BT_U16 SEQNO, BT_MNGR_HCI_BCCMDDATA* parameter);
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_DUT(BT_U16 SEQNO, BT_U8 step);
#endif



void BT_MNGR_ChangeTransportConfig(BT_MNGR_TransportSettings *tlSettings);
void BT_MNGR_SetupLogFilter();

BT_Result    BT_MNGR_Control(BT_ControlCommand cmd);
void BT_MNGR_InitBluetooth(   BT_MNGR_TransportSettings *tlSettings);

BT_U8 BT_GetHSPReverseNibbler(BT_U8* Data_out);
BT_U8 BT_GetSPPReverseNibbler(BT_U8* Data_out);

	
#endif /*BLUETOOTH_INT_H*/
