/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <bluetooth_manager.c>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR              Date Modified CR Tracking Number  Description
* Chia Weng Sun       08/06/2010    CCMPD01379068       Initial Creation
* Niravkumar Rabara   08/20/2010    CCMPD01383800       Added Audio routing code
* Tan Seng Kai        08/30/2010    CCMPD01388039       Added in Task message handler and USB swtching.
* Niravkumar Rabara   09/08/2010    CMPD01389372        Device Discovery with filter, restructured the code & changed BTCOM to BT_MNGR
* Niravkumar Rabara   09/15/2010    CCMPD01392414       Changed Class Of Device of Dongle to Miscellaneous device.
* Tan Seng Kai        09/22/2010    CCMPD01394890       Added configuration for BQB and RTTE test
* Niravkumar Rabara   09/23/2010    CCMPD01394958       Headset Profile Audio Gateway implementation.
* Niravkumar Rabara   10/04/2010    CCMPD01398596       AT Command Implementation for R1.3 Headset Test
* Tan Seng Kai        10/06/2010    CCMPD01399559       RADIO_INTERFACE_MANAGER_TASK,MPP_TASK,NIBBLER_TASK Compile sw
*                                                       added to remove Radio interface and mpp task
* Tan Seng Kai        10/07/2010    CCMPD01397694       Implement Nibbler and Reverse Nibbler
* Niravkumar Rabara   10/07/2010    CCMPD01400006       Modified RING AT Command implementation
* Niravkumar Rabara   10/08/2010    CCMPD01400432       Modified RING AT Command to 10 times as per MSC
* Niravkumar Rabara   10/11/2010    CCMPD01400996       Bug Fix related to 1.3 Remote PTT Nibble
* Niravkumar Rabara   10/06/2010    CCMPD014000437      Added in Task message to get the BT device Info, and
*                                                       handled a request to set Dongle to DISCOVERABLE_MODE
* Niravkumar Rabara   10/18/2010    CCMPD01402008       Added Serial Port Profile
* Tan Seng Kai        10/20/2010    CCMPD01394399		    Add in function for reset CSR IC
* Niravkumar Rabara   10/22/2010    CCMPD01405968       Modify nibbler variable name
* Niravkumar Rabara   10/27/2010    CCMPD01407554       Implemented the RING timeout handling
* Tan Seng Kai        10/27/2010    CCMPD01407568       Implement RSSI checking for pairing
* Tan Seng Kai        10/29/2010    CCMPD01408084       Add in Nibbler counter to do sync for unmute,
*                                                       add PTT key release if do not receive any nibbler
*
* Tan Seng Kai	      10/20/2010    CCMPD01394399       Add in function for reset CSR IC
* Tan Seng Kai        10/27/2010    CCMPD01407568       Implement RSSI checking for pairing
* YewFoong            10/29/2010    CCMPD01408237       Implemented SCO establishment for previously connected Headset
*                                                        when receive AT+CKPD=200 after RING expired
* Tan Seng Kai        10/29/2010    CCMPD01408859       Get Device Inquiry value from codeplug and base on this timer to do searching
* Tan Seng Kai        11/01/2010    CCMPD01408792       Send Nibbler initia byte to Headset once get connected
* YewFoong            11/01/2010    CCMPD01409093       Defined the tempDevInfo variable
* Tan Seng Kai        11/01/2010    CCMPD01409147       Wait until Service name close connection only restart service search
* JJ Low              11/08/2010    CCMPD01410054       Compiler warning resolution for R2.1
* mahesh guru         11/18/2010    CCMPD01414087       MPP state machine integration to Bluetooth Manager

* Tan Seng Kai        11/03/2010    CCMPD01409994       Extend page timeout time as for some device It might take longer time for pairing
* Tan Seng Kai        11/04/2010    CCMPD01410165       Send the Reverse Nibber every 100ms once Nibber link establish
*
* Niravkumar Rabara   11/03/2010    CCMPD01410613       Reject incoming connection request if Dongle is not in connecting state
* YewFoong            11/10/2010    CCMPD01412689       Updated the link lost timeout from 8s to 5s
* Tan Seng Kai        11/12/2010    CCMPD01413546       Allocate more timer slow for more stability in heavy load
* Tan Seng Kai        11/12/2010    CCMPD01413566       Exception handling for service name search fail
* Tan Seng Kai        11/12/2010    CCMPD01413554       Exception handling for HSP pairing fail
* Niravkumar Rabara   11/14/2010    CCMPD01413929       Add R1.4 Reconnectin handling & SPP mesg handling
* Niravkumar Rabara   11/19/2010    CCMPD01415880       Add Bluetooth Qualification Mode.
* Tan Seng Kai        11/18/2010    CCMPD01415437       Reverse Nibbler Handling while Out of range
* Tan Seng Kai        11/23/2010    CCMPD01418684       Change AT command to "AT+NIBBLER=0" and add in "AT+MPTT=0\r"
* YewFoong            11/25/2010    CCMPD01421145       Set r1_4ConnectingTimerId=NULL when Headset is disconnected
* Tan Seng Kai        11/25/2010    CCMPD01419120       Move PTT Trigger macro from Nibbler task to Bluetooth manager
* Tan Seng Kai        11/25/2010    CCMPD01421182       Change sequencing for Reverse nibbler and also add in Data over nibbler.
* Niravkumar Rabara 11/30/2010  CCMPD01446330       Add Endphse for R1.4 Reconnection & Linkstatus
* Chia Weng Sun       12/03/2010    CCMPD01450072       Lower Down Inquiry Response Transmit Power Level during Device Inquiry.
* Tan Seng Kai        12/08/2010    CCMPD01451448       added Linkey handleer
* Tan Seng Kai        12/09/2010    CCMPD01452089       Exception handling for R1.4 connect fail
* Tan Seng Kai        12/09/2010    CCMPD01452429       Change controlling for HS reconnection
* YewFoong            12/10/2010    CCMPD01452415       Added Device Inquiry Timeout for Dongle to enter IDLE_STATE 
* Tan Seng Kai        12/10/2010    CCMPD01452526       Nibbler data processing for R1.3 and R1.4
* Tan Seng Kai        17/12/2010    CCMPD01455488       Remove reconnection request for R1.4*
* Tan Seng Kai        12/17/2010    CCMPD01455489       Qos Setup for 12 slot
* Tan Segn Kai        12/20/2010    CCMPD01455949       Remove BT_CONGESTED retry for reverse nibbler
* Tan Seng Kai        12/20/2010    CCMPD01455955       Fatal error handling
* Chia Weng Sun       12/18/2010    CCMPD01455486       Locked down value for Inquiry Response Transmit Power after new Power Table created by Hardware Team.
* Toh PeiSee	      12/20/2010    CCMPD01455948	Change the poll rate from 12 slots to 18 slots
* Mahes               Jan/06/2011      CCMPD01460340    Software catup to dongle R1.2 version R01.00.00
* Maheswaran          12/20/2010    CCMPD01414087       Added BT_MNGR_Send_Read_BDADD ,HCI_READ_BD_ADDR_COMPLETE_EVENT
* Mahesh              07-Jan-2011   CCMPD01460638       Added  initial MPP inter task messages
* Tan Seng Kai        01/07/2011    CCMPD01460652     Reverse Order for Local bt address, Fixes for R2.0 Connection establish sequence
* Tan Seng Kai        01/17/2011    CCMPD01463409       Added in AT praser for Data over nibbler
* Tan Seng Kai        01/19/2011    CCMPD01464287       Implement bluetooth manager and connection manager interaction message for mpp pairing
* Tan Seng Kai        01/25/2011    CCMPD01466195       Handle mpp pairing and change headset status flag
* Tan Seng Kai        01/27/2010    CCMPD01467357       Qos Setup for device which is Default turn on Nibbler
* Niravkumar Rabara   01/27/2011    CCMPD01467325       MPTT tone play handling for diffection connection scenario 
* Niravkumar Rabara   02/01/2011    CCMPD01468914       Code resturcture of Bluetooth Qualification Test 
* Tan Seng Kai        01-02-2011    CCMPD01468916       Support R1.3 and R1.4 (standard pairing)
* Tan Seng Kai        02/11/2011    CCMPD01471859       Implement align to new MSC diagram. SecureWireless_R2.1_R2.0_R2.3_data_connection.pdf
* Niravkumar Rabara   02/11/2011    CCMPD01473401       Added AT+VGS=<gain> handling 
* Tan Seng Kai        02/17/2011    CCMPD01474549       Fixes for RF Qualification Test
* Tan Seng Kai        02/17/2011    CCMPD01474548       BT_CLEAR_PAIRING_INFO added to clear database
* Tan Seng Kai        02/21/2011    CCMPD01475746       Remove HS connection checking on WirelessPTT nibbler decoder
* Tan Seng Kai        02/21/2011    CCMPD01475738       Fixes, +vgs sending out to wireless PTT before handshaking
* Tan Seng Kai        02/24/2011    CCMPD01478037       Fixes, AT+MPTT sending out to headset before handshaking
* Tan Seng Kai        03/04/2011    CCMPD01481275       Implement AT+LED handling
* Tan Seng Kai        03/07/2011    CCMPD01481262       Initialize isAudioDetectMute and spkr_prev_state as TRUE, which is Mute at initial state
* Tan Seng Kai        29/04/2011    CCMPD01503017       Resolve connection manager and bluetooth manager syncronization issue.
* Sevuhan Ramanathan  08/08/2011    CCMPD01541572       Added the fix in SPP_DEV_FLOW_IND for connection of R1.4 when R2.19 is in Std pairing mode
* Toh Pei See         12/01/2011    CCMPD01587273       Disable the support of EDR packets, support only Basic Rate packets for ACL link
* Toh PeiSee          15/12/2011    CCMPD01592074       Added the low power reconnection mechanism in R2.17 Gateway
* Abhishek Trivedi    09/02/2013    CCMPD01827271       Design Change to include XNL-XCMP host
* Sean                08/28/2013    CCMPD01806989       Added new Is_LinkLost(to differentiate between normal disconnection or link lost disconnection)
* wrn637              17/9/2013     CCMPD01815076       Remove Low power reconnection feature
* wrn637              10/16/2013    CCMPD01826478       Audio detection handling
* Abhishek Trivedi    11/8/2013     CCMPD01834482       Updates for XNL-XCMP support
* WRN637              07/11/2013    CCMPD01825398       MPP Class 1 RFPA handling
* Phong Tran          12/06/2013    CCMPD01837173       Added support for XNL/XCMP simulator.
* WRN637              12/20/2013    CCMPD01833277       WPTT state machine
* WRN637              06/01/2014    CCMPD01849533       Resolve compilation warming
* WRN637              07/01/2014    CCMPD01849957       Adding debug log
* WRN637              27/01/2014    CCMPD01856259       Disable_EDR
* Abhishek Trivedi    01/10/2014    CCMPD01851442       Add flag for XNL-XCMP link
* WRN637              01/22/2014    CCMPD01854392       Improve ACL message sending      
* Abhishek Trivedi    03/10/2014    CCMPD01870625       CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi    03/18/2014    CCMPD01873731       Resolve 2 device connection issue
* Aneeket Patkar      03/26/2014    CCMPD01876782       Initialization Sequence update - Create MPP State Machine after BT initialization
* Aneeket Patkar      03/27/2014    CCMPD01867590       Initialization updates, Audio detect message handler bit location updates
* Abhishek Trivedi    03/27/2014	CCMPD01877540		Fix the Standard Pairing Issue with N4010A
* wrn637              03/28/2014    CCMPD01879434       P3_Board_HW_Setting                             
* Abhishek Trivedi    04/04/2014    CCMPD01880219       Allow EDR for std_pairing
* Abhishek Trivedi    04/04/2014    CCMPD01880139       Reset on DSP Command failure
* Abhishek Trivedi    04/04/2014    CCMPD01882874       Interchip Ping 
* wrn637              04/07/2014    CCMPD01880383       Reduce_Link_Supervision_Timer
* Abhishek Trivedi    04/15/2014    CCMPD01883363       Interchip Ping part 2
* csy032c             04/22/2014    CCMPD01824434       BQB Test Mode
* Abhishek Trivedi    04/24/2014    CCMPD01886810       Change CSR Audio Detect Gain values
* Phong Tran          05/12/2014    CCMPD01885130       Modified to support XXT device
* Abhishek Trivedi    05/16/2014    CCMPD01894043       BT disconnect on Nibbler PTT keyup bit timeout
* Abhishek Trivedi    05/22/2014    CCMPD01896550       Add Nibbler PTT timeout to codeplug
* Abhishek Trivedi    10/22/2014    CCMPD01938895       Audio Switch
* Abhishek Trivedi    11/02/2014    CCMPD01943851       Codeplug Read Request for Talk Permit Tone issue
* Abhishek Trivedi    11/11/2014    CCMPD01945832       Edge of Range Support
* Abhishek Trivedi    11/29/2014    CCMPD01957210       WPTT Support for Audio Switch
* *********************************************************************************/

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "taskconfig.h"
#include "bluetooth_manager.h"
#include "codeplug_ui.h"
#include "spp.h"
#include "hsp_ag.h"         // CCMPD01410054 (JJ 8/11/2010)
#include "controls.h"       // CCMPD01410054 (JJ 8/11/2010)

#ifdef NIBBLER_TASK
#include "nibbler_task.h"
#endif

#include "nibbler.h"
#include "xnl.h"
#include "xnl_config.h"
#include "usb_standard_request.h"

/*****************************************************************************/
/* Public constants & variables                                              */
/*****************************************************************************/
static BT_U16 R1_3_connectionHandle = 0; //cwc034: QoS Test
static BT_U16 R1_4_connectionHandle = 0; //cwc034: QoS Test
static BT_U32 POLL_RATE = 0x00002BF2; 

// Default is 0x003FFDD6 (4193750)- cwc034: QoS Test
// 0x000030D4 = 20 slots (625us per slot = 12.5ms)
// 0x0000186A = 10 slots (625us per slot = 6.25ms)
// 0x00000EA6 = 6  slots (625us per slot = 3.75ms)
// 0x00001D4C = 12 slots (7.5ms)
// 0x00002BF2 = 18 slots (11.25ms)
// 0x00003A98 = 24 slots (15ms)

static HCI_ClassOfDevice classOfDevice =
                          {
                                  MINOR_DEVICE_CLASS_UNCATEGORIZED, /*Minor device class Uncategorized*/
                                  MAJOR_DEVICE_CLASS_MISC, /*Major device class Miscellaneous*/
                                  MAJOR_SERVICE_CLASS_AUDIO  /*Major service class Audio*/	
                          };
/*
 * The identifier this application uses when communicating
 * with the stack. It is initialised by a call to BT_RegisterApplication
 * during init phase.
 */
BT_ModuleId                  appSenderId;

#ifdef NIBBLER_BUFFER_USED
static data_buffer_struct_t headset_nibbler_decoder;
static UNSIGNED_8BIT headset_nibbler_decoder_in_buffer[NIBBLER_BUFFER_MAX_SIZE_BYTES];
static const ptr_data_buffer_struct_t ptr_to_headset_nibbler_decoder_in_buffer = (ptr_data_buffer_struct_t)&headset_nibbler_decoder;
 

static data_buffer_struct_t wirelessPTT_nibbler_decoder;
static UNSIGNED_8BIT wirelessPTT_nibbler_decoder_in_buffer[NIBBLER_BUFFER_MAX_SIZE_BYTES];
static const ptr_data_buffer_struct_t ptr_to_wirelessPTT_nibbler_decoder_in_buffer = (ptr_data_buffer_struct_t)&wirelessPTT_nibbler_decoder;
#endif

static BT_U8 prev_ptt_state;
BT_U8  echo_seq_no = 0;
BT_BdAddr Rem_BTAdd;

extern UINT16_T device_1_id;
extern UINT16_T device_2_id;
extern tc_flags_t tc_flags;
extern cplg_param_t hw_audio_detect;
extern xQueueHandle hsp_xnl_xcmp_data_rx_Q; 
extern xQueueHandle spp_xnl_xcmp_data_rx_Q;
extern bool local_PttPress;
/*****************************************************************************/
/* Private constants & variables                                             */
/*****************************************************************************/
/*
 * BT_TRUE if fatal error has been received from the stack, false otherwise.
 */
static  BT_BOOL                     fatalErrorReceived = BT_FALSE;

/*
 * Phase and state variables
 */
static BT_MNGR_StartupState                  startupState = BT_MNGR_STATE_NOT_INITIATED;
static BT_MNGR_StartupPhase                  startupPhase = 0;

static BT_MNGR_CtrlRequestState              ctrlState = BT_MNGR_CONTROL_NONE;
static BT_MNGR_CtrlRequestPhase              ctrlPhase = 0;

static BT_MNGR_HspRequestState               hspState = BT_MNGR_HSP_NONE;
static BT_MNGR_HspRequestPhase               hspPhase = 0;

static BT_MNGR_SppRequestState               sppState = BT_MNGR_HSP_NONE;
static BT_MNGR_SppRequestPhase               sppPhase = 0;

static BT_MNGR_HciRequestState               hciState = BT_MNGR_HCI_NONE;
static BT_MNGR_HciRequestPhase               hciPhase = 0;

extern bool  isDetAudmute;  /* false = unmute, true = mute */
bool spkr_prev_state = true; /* false = unmute, true = mute */
/*
 *	Found devices
 */
//#define DEBUG_DEVICE_DISCOVERY

#ifdef DEBUG_DEVICE_DISCOVERY
static BT_MNGR_Device     m_foundDevices[BT_MNGR_MAX_INQUIRY_RESULTS];
static BT_U16             m_foundDevicesCount = 0;
#endif

static BT_MNGR_Device     foundedHS[BT_MNGR_MAX_INQUIRY_RESULTS];
static BT_U16             foundedHSCount = 0;

static BT_MNGR_Device     foundedR1_4[BT_MNGR_MAX_INQUIRY_RESULTS];
static BT_U16             foundedR1_4Count = 0;

static btDevInfo          progressingDevInfo;
static btDevInfo          tempDevInfo;
static btDevInfo          LinkKeyReqDevice;
static BT_BdAddr          PinCodeReqDevice;

static btDevInfo          device_database[MAX_DEV_DATABASE];

#ifdef MPP_PROTOCOL_TO_ENABLE_EDR
/*
 * Default setup for an audio connect request  (Class 1.5) 
 */
static const HCI_LH_AudioSetupOptions scoSetupSettings_Class15[] = 
{
    { 
      BT_FALSE,
      HCI_LINK_TYPE_ESCO_CONNECTION,
      8000,
      8000,
      10,                                             //maxLatency
      0,
      HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,
      HCI_SYNCHRONOUS_EV3 
    },
    {
      BT_FALSE,
      HCI_LINK_TYPE_ESCO_CONNECTION,
      8000,
      8000,
      10,
      0,
      HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,
      HCI_SYNCHRONOUS_EV4 | HCI_SYNCHRONOUS_EV5
    },
    { 
      BT_FALSE,
      HCI_LINK_TYPE_SCO_CONNECTION,
      8000,
      8000, 
      7,
      0,
      HCI_NO_RETRANSMISSIONS,
      HCI_SYNCHRONOUS_HV2
      | HCI_SYNCHRONOUS_HV3
      },
      { 
      BT_TRUE,
      HCI_LINK_TYPE_SCO_CONNECTION,
      8000,
      8000,
      7,
      0,
      HCI_NO_RETRANSMISSIONS,
      HCI_SYNCHRONOUS_HV1
    }

};

/*
 * Default setup for an audio connect response (Class 1.5)     
 */ 
static const HCI_LH_AudioAcceptOptions scoAcceptSettings_Class15 =
{
  8000,   /* transmitBandwidth */
  8000,   /* receiveBandwidth */
  10,     /* maxLatency in ms */
  0x00,   /* aircoding: CVSD */
  HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER, /* retransmissionEffort */
    HCI_SYNCHRONOUS_HV1
  | HCI_SYNCHRONOUS_HV2
  | HCI_SYNCHRONOUS_HV3
  | HCI_SYNCHRONOUS_EV3
  | HCI_SYNCHRONOUS_EV4
  | HCI_SYNCHRONOUS_EV5 /* packet type */
};
#endif

/*
 * Default setup for an audio connect request  (Class 1)          
 */
static const HCI_LH_AudioSetupOptions scoSetupSettings_Class1[] = 
{
  { 
    BT_FALSE,
    HCI_LINK_TYPE_ESCO_CONNECTION,
    8000,
    8000,
    10, //maxLatency
    0,
    HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,
    HCI_SYNCHRONOUS_EV3 
    | HCI_SYNCHRONOUS_DISALLOW_2_EV3
    | HCI_SYNCHRONOUS_DISALLOW_3_EV3
    | HCI_SYNCHRONOUS_DISALLOW_2_EV5
    | HCI_SYNCHRONOUS_DISALLOW_3_EV5                  /* packet type */
  },
  {
    BT_FALSE,
    HCI_LINK_TYPE_ESCO_CONNECTION,
    8000,
    8000,
    10,
    0,
    HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,
    HCI_SYNCHRONOUS_EV4 | HCI_SYNCHRONOUS_EV5
    | HCI_SYNCHRONOUS_DISALLOW_2_EV3
    | HCI_SYNCHRONOUS_DISALLOW_3_EV3
    | HCI_SYNCHRONOUS_DISALLOW_2_EV5
    | HCI_SYNCHRONOUS_DISALLOW_3_EV5                  /* packet type */
  },
  { 
    BT_FALSE,
    HCI_LINK_TYPE_SCO_CONNECTION,
    8000,
    8000, 
    7,
    0,
    HCI_NO_RETRANSMISSIONS,
    HCI_SYNCHRONOUS_HV2
    | HCI_SYNCHRONOUS_DISALLOW_2_EV3
    | HCI_SYNCHRONOUS_DISALLOW_3_EV3
    | HCI_SYNCHRONOUS_DISALLOW_2_EV5
    | HCI_SYNCHRONOUS_DISALLOW_3_EV5                  /* packet type */
  },
  { 
    BT_TRUE,
    HCI_LINK_TYPE_SCO_CONNECTION,
    8000,
    8000,
    7,
    0,
    HCI_NO_RETRANSMISSIONS,
    HCI_SYNCHRONOUS_HV1
    | HCI_SYNCHRONOUS_DISALLOW_2_EV3
    | HCI_SYNCHRONOUS_DISALLOW_3_EV3
    | HCI_SYNCHRONOUS_DISALLOW_2_EV5
    | HCI_SYNCHRONOUS_DISALLOW_3_EV5                  /* packet type */
  }
};

/*
 * Default setup for an audio connect response  (Class 1)     
 */ 
static const HCI_LH_AudioAcceptOptions scoAcceptSettings_Class1 =
{
  8000,   /* transmitBandwidth */
  8000,   /* receiveBandwidth */
  10,     /* maxLatency in ms */
  0x00,   /* aircoding: CVSD */
  HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,    /* retransmissionEffort */
    HCI_SYNCHRONOUS_HV1
  | HCI_SYNCHRONOUS_HV2
  | HCI_SYNCHRONOUS_HV3
  | HCI_SYNCHRONOUS_EV3
  | HCI_SYNCHRONOUS_EV4
  | HCI_SYNCHRONOUS_EV5
  | HCI_SYNCHRONOUS_DISALLOW_2_EV3
  | HCI_SYNCHRONOUS_DISALLOW_3_EV3
  | HCI_SYNCHRONOUS_DISALLOW_2_EV5
  | HCI_SYNCHRONOUS_DISALLOW_3_EV5            /* packet type */
};

/*
 * Default setup for an audio connect request with EDR (Class 1)          
 */
static const HCI_LH_AudioSetupOptions scoSetupSettings_AllowEDR_Class1[] = 
{
  { 
    BT_FALSE,
    HCI_LINK_TYPE_ESCO_CONNECTION,
    8000,
    8000,
    10, //maxLatency
    0,
    HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,
    HCI_SYNCHRONOUS_EV3  /* packet type */
  },
  {
    BT_FALSE,
    HCI_LINK_TYPE_ESCO_CONNECTION,
    8000,
    8000,
    10,
    0,
    HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,
    HCI_SYNCHRONOUS_EV4 | HCI_SYNCHRONOUS_EV5     /* packet type */
  },
  { 
    BT_FALSE,
    HCI_LINK_TYPE_SCO_CONNECTION,
    8000,
    8000, 
    7,
    0,
    HCI_NO_RETRANSMISSIONS,
    HCI_SYNCHRONOUS_HV2      /* packet type */
  },
  { 
    BT_TRUE,
    HCI_LINK_TYPE_SCO_CONNECTION,
    8000,
    8000,
    7,
    0,
    HCI_NO_RETRANSMISSIONS,
    HCI_SYNCHRONOUS_HV1        /* packet type */
  }
};

/*
 * Default setup for an audio connect response with EDR  (Class 1)     
 */ 
static const HCI_LH_AudioAcceptOptions scoAcceptSettings_AllowEDR_Class1 =
{
  8000,   /* transmitBandwidth */
  8000,   /* receiveBandwidth */
  10,     /* maxLatency in ms */
  0x00,   /* aircoding: CVSD */
  HCI_AT_LEAST_ONE_RETRANSMISSION_OPT_FOR_POWER,    /* retransmissionEffort */
    HCI_SYNCHRONOUS_HV1
  | HCI_SYNCHRONOUS_HV2
  | HCI_SYNCHRONOUS_HV3
  | HCI_SYNCHRONOUS_EV3
  | HCI_SYNCHRONOUS_EV4
  | HCI_SYNCHRONOUS_EV5            /* packet type */
};

#ifdef MPP_PROTOCOL_TO_ENABLE_EDR
static const HCI_LH_AudioSetupOptions  *audioSetupOptions = 0;
static const HCI_LH_AudioAcceptOptions *audioAcceptOptions = 0;
#endif

/*
 * Flag for checking initalize process, after the define period
 * If it is not initialize, the system will set this flag to TRUE.
 */
static BT_U8                                f_IsInitializefail = BT_FALSE;
/*
 *	Paired devices
 */
static BT_MNGR_Device m_pairedDevices[BT_MNGR_MAX_INQUIRY_RESULTS];
static BT_U16       m_pairedDevicesCount=0;
/*
 *	Storage for passkey, selectedBdAddr, number to dial and scan state requested.
 */
static BT_BOOL m_discoverable = BT_FALSE;
/*
 *    Ag Local supported features
*/
static BT_U32 ag_supportedFeatures = 0x00;

#define HSP_AG_SERVICE_NAME "DONGLE R12"
#define REVERSE_NIBBLER_MUTE      0x20
#define REVERSE_NIBBLER_UNMUTE    0x60

#define PTT_KEYUPDOWN_MASK                  0x40
#define PTT_KEYUP_BIT                       0x40
#define PTT_KEYDOWN_BIT                     0x00

#define MUTE_UNMUTE_NIBBLER_MASK            0x40
#define UNMUTE_NIBBLER_BIT                  0x40
#define MUTE_NIBBLER_BIT                    0x00

#define UPPER_LOWER_NIBBLER_DATA_MASK       0x80
#define UPPER_NIBBLER_DATA_BIT              0x80
#define LOWER_NIBBLER_DATA_BIT              0x00

#define NIBBLER_DATA_PRESENCE_MASK          0x20
#define NIBBLER_DATA_NOT_PRESENCE_BIT       0x20
#define NIBBLER_DATA_PRESENCE_BIT           0x00

#define AT_CMD_STATE_NON                    0x00
#define AT_CMD_STATE_MPTT_CONNECTED         0x01
#define AT_CMD_STATE_MPTT_DISCONNECTED      0x02
#define AT_CMD_STATE_INITIALIZE_VGS         0x03

nibbler_struct_t headset_nibbler;
nibbler_struct_t wirelessPTT_nibbler;


static const BT_U8 spp_disconnect_at_cmd[]  = "AT+MPTT=0\r";
static const BT_U8 spp_connect_at_cmd[]     = "AT+MPTT=1\r";
static const BT_U8 error_at_cmd[]           = "\r\nERROR\r\n";
static const BT_U8 ok_at_cmd[]              = "\r\nOK\r\n";
static const BT_U8 led_off_at_cmd_rpy[]     = "+LED=0\r";
static const BT_U8 led_on_at_cmd_rpy[]      = "+LED=1\r";

// CSR DSP Audio Detect Commands 
static const BT_U8 ping_cmd[]                 = { 0x05, 0x00, 0x56, 0x00, 0x02, 0x00, 0x10, 0x00, 0x00, 0x00 };
static BT_U8 load_dsp_app[]                   = { 0x05, 0x00, 0x56, 0x00, 0x02, 0x00, 0x20, 0x00, 0x00, 0x00 }; //Need to append the sco_handle reply data
static BT_U8 unload_dsp_app[]                 = { 0x05, 0x00, 0x56, 0x00, 0x02, 0x00, 0x21, 0x00, 0x00, 0x00 };  //Need to append the sco_handle reply data
static const BT_U8 enable_audio_detection[]   = { 0x04, 0x00, 0x56, 0x00, 0x01, 0x00, 0x30, 0x00 }; 
static const BT_U8 disable_audio_detection[]  = { 0x04, 0x00, 0x56, 0x00, 0x01, 0x00, 0x31, 0x00 }; 
static BT_U8 set_output_gain_cmd[]            = { 0x05, 0x00, 0x56, 0x00, 0x02, 0x00, 0x40, 0x00, 0x00, 0x00 }; //Append gain (0x0000 to 0x000f). Default is 0x000f.
static BT_U8 set_input_gain_cmd[]             = { 0x05, 0x00, 0x56, 0x00, 0x02, 0x00, 0x41, 0x00, 0x00, 0x00 }; //Append gain (0x0000 to 0x000f). Default is 0x000f.
static BT_U8 set_delay_cmd[]                  = { 0x05, 0x00, 0x56, 0x00, 0x02, 0x00, 0x51, 0x00, 0x00, 0x00 }; //Append delay in ms. Default value is 0.
static BT_U8 set_threshold_cmd[]              = { 0x06, 0x00, 0x56, 0x00, 0x03, 0x00, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00 }; /*Append linear threshold value split in two 16bit words. Linear threshold can be up to 24 bits long. It is the hexadecimal 	
										  representation of the linear threshold in Q.23 fixed point number representation. 
                                                                                  Default value is 0x07C41A corresponding to 0.060672. (Which corresponds to roughly -24dBFS). */
// CSR DSP Command sizes
#define PING_CMD_DATA_SIZE              (sizeof(ping_cmd))
#define LOAD_DSP_CMD_DATA_SIZE          (sizeof(load_dsp_app))
#define ENABLE_AUD_DET_CMD_DATA_SIZE    (sizeof(enable_audio_detection))
#define UNLOAD_DSP_CMD_DATA_SIZE        (sizeof(unload_dsp_app))
#define DISABLE_AUD_DET_CMD_DATA_SIZE   (sizeof(disable_audio_detection))
#define SET_OUTPUT_GAIN_CMD_DATA_SIZE   (sizeof(set_output_gain_cmd))
#define SET_INPUT_GAIN_CMD_DATA_SIZE    (sizeof(set_input_gain_cmd))
#define SET_INPUT_DELAY_CMD_DATA_SIZE   (sizeof(set_delay_cmd))
#define SET_THRESHOLD_CMD_DATA_SIZE     (sizeof(set_threshold_cmd))

//Codeplug variables
static BT_U16 sco_handle           = 0x0000;
cplg_param_t dsp_speaker_gain      = 0x09;
cplg_param_t dsp_mic_gain          = 0x05;
cplg_param_t dsp_audio_line_delay  = 0x00;
cplg_param_t dsp_aud_det_threshold = 0x00007C41;

// Error Codes
#define	CSR_DSP_COMMAND_SUCCESS             0x00
#define	CSR_DSP_ERROR_UNKNOWN_COMMAND       0x01
#define	CSR_DSP_ERROR_WRONG_LENGTH          0x02
#define	CSR_DSP_ERROR_WRONG_SCO_HANDLE      0x03
#define	CSR_DSP_ERROR_AUDIO_CONNECTED       0x04
#define	CSR_DSP_ERROR_AUDIO_NOT_CONNECTED   0x05

vm_cmd_send_t vm_cmd_send_state = PING_CMD;;

#define GW_LINK_SUPERVISION_TIMEOUT         5000
/*
 *  Buffers that is used for AG SDP registration
 */
static BT_U8                    hspHsAgSdpAttributes[HSP_AG_SERVICE_RECORD_SIZE + sizeof(HSP_AG_SERVICE_NAME)];
static SDP_AttributeList        hspAgAttributeList;
static BT_U8 agAtCmdInd;


static bool isRingOn;
static bool isAcceptCKPD;
static BT_TimerId ringTimerId = NULL; 
static BT_TimerId r1_4PairingTimer = NULL;
static BT_TimerId hsPairingTimer = NULL;
static BT_TimerId ReverseNibblerSyncTimer = NULL;
static BT_TimerId hsConnectingTimerId = NULL; 
static BT_TimerId r1_4ConnectingTimerId = NULL; 
static BT_TimerId r1_4ConnectingDelay = NULL; 
static BT_TimerId r1_3NibblerTimer;
static BT_TimerId servicename_TMO = NULL; 
static BT_TimerId audiodev_atfail_TMO = NULL; 
static BT_TimerId nonaudiodev_atfail_TMO = NULL; 
static BT_TimerId mptt_reply_TMO = NULL; 
static BT_TimerId hsp_atcommand_retry_TMO = NULL;
static BT_TimerId spp_atcommand_retry_TMO = NULL;
static BT_TimerId hci_ping_retry_TMO = NULL;
static BT_TimerId hsp_null_nibble_retry_TMO = NULL;
BT_TimerId bt_chip_HCIreset_complete_event_timer = NULL; /*Timer to check if the HCI RESET complete event is received from CSR*/

static BT_U8 ringCnt;
static BT_MNGR_DEVICE_STATUS headset_status;
static BT_MNGR_DEVICE_STATUS wirelessPTT_status;
volInfo broadcastVolInfo;

static bool isHsConnected = BT_FALSE;
static bool isAudioDetectMute = BT_TRUE;
BT_BOOL isHsConnIncomming;
BT_BOOL isBQBModeOn;
static discoveryType discoverymode = DISCOVERY_ALL;
static BT_U8 devSearchFailCount = 0;

static BT_U8 sppAtCmdInd;
static BT_TimerId r1_4NibblerTimer;
static BT_BOOL isR1_3awaitingTMO = BT_FALSE;
static BT_BOOL isR1_4awaitingTMO = BT_FALSE;

#ifdef BT_ENABLE_DUT
static BT_MNGR_HCI_BCCMDDATA		dut_para;
#endif

#define NIBBLER_DATA_OUT_BUFFER   100
static BT_U8 headsetNibblerDataOut[NIBBLER_DATA_OUT_BUFFER];
BT_U8 headsetReverseNibblerOutSize  = 0;     // 2 * size

static BT_U8 wirelessPTTNibblerDataOut[NIBBLER_DATA_OUT_BUFFER];
BT_U8 wirelessPTTReverseNibblerOutSize  = 0;     // 2 * size


BT_U8 DeviceInquiryTimerValue  = 8;
static cplg_param_t pairing_mode      = PAIRING_PAIRING_MODE_MPP;
static cplg_param_t std_pairing_edr_enabled = 0x00;

static BT_S8 ReqInquiryTxPower  = 0xD8; //-40dBm as (2's compliment) for setting Inquiry Response Transmit Power

BT_BdAddr  Local_BTAddress;   /* Local BT address for MPP */

static xSemaphoreHandle xACLAccess = NULL;
//Nibbler PTT Press Timeout 
BT_U16 nibbler_ptt_press_timeout;
bool null_data_nibble_rxd = false;
/*****************************************************************************/
/* Public API functions                                                      */
/*****************************************************************************/
extern void bluetooth_manager_init(void);
extern BT_MNGR_SendHspAgAudioDisconnectReq(void); // CCMPD01410054 (JJ 8/11/2010)
extern BT_Result BT_MNGR_SendSppDevConnectReq(BT_BdAddr addr);
extern BT_Result BT_MNGR_SendSppDevDisconnectReq(void);
extern void fatal_error_reset(void);
extern bool check_csr_version(UINT16_T * ver_info);
extern void bt_chip_ping_received(void);
extern BT_BOOL SPP_DEV_RegisterService(BT_ModuleId user, const char *securityServiceName, RFCOMM_ServerChannel *rfcommServerChannel);

static void store_headset_nibbler_decoded_data_byte_in_buffer( unsigned char datain );
static void store_wirelessPTT_nibbler_decoded_data_byte_in_buffer( unsigned char datain );

/*****************************************************************************/
/* Private API functions                                                      */
/*****************************************************************************/
#ifdef DEBUG_DEVICE_DISCOVERY
static BT_MNGR_Device* CheckIfAlreadyFound(BT_BdAddr addr);
#endif

static BT_MNGR_Device* CheckHSIfAlreadyFound(BT_BdAddr addr);
static BT_MNGR_Device* CheckSPPIfAlreadyFound(BT_BdAddr addr);

static BT_U8 HandleServiceSearchAttrRsp(SDAP_ServiceSearchAttrRsp *rsp);
static void BT_MNGR_RssiSort(BT_MNGR_Device * database, BT_U16 size);
static void BT_swap( BT_MNGR_Device* A, BT_MNGR_Device* B );
#ifdef BT_ENABLE_SW_TST_UART
static void BT_PrintDeviceDiscoveryDatabase(BT_MNGR_Device * database, BT_U16 size);
#endif
static BT_MNGR_Device* GetNextHS(void);
static BT_MNGR_Device* GetNextSPP(void);
static BT_MNGR_Device* GetNextFilteredSPP(void);
static BT_MNGR_Device* GetPairedHSP(void);
static BT_MNGR_Device* GetPairedSPP(void);
static void BT_PrintDeviceInfo(BT_MNGR_Device * database);
static BT_BOOL BT_SetheadsetReverseNibblerDataOut(BT_U8* Data, BT_U8 length);
static BT_BOOL BT_SetwirelessPTTReverseNibblerDataOut(BT_U8* Data, BT_U8 length);
static void LoadPrevConnectDevInfo(btDevInfo *);
static void RemovePrevConnectDevInfo(btDevInfo * ptr2message);
static void BT_DebugUnknownPermitive(BT_U16 Premitive);
static BT_BOOL BT_SetDeviceDatabase(btDevInfo* dev);
static BT_BOOL BT_ClearDeviceDatabase(btDevInfo* dev);
static btDevInfo* BT_GetDevProfileInfo(DEV_PROFILE profile);
static btDevInfo* BT_GetDevAddrInfo(BT_BdAddr addr);
static void BT_HSP_ATPraser(BT_U8 *datain, BT_U8 length);
static void BT_SPP_ATPraser(BT_U8 *datain, BT_U8 length);
static void BT_MNG_Clear_Audiodev_NibblerBuffer( void );
static void BT_MNG_Clear_NonAudiodev_NibblerBuffer( void );
static void BT_HSSPKR_controller( void );
static void BT_reverse_nibbler_resend( void );
BT_Result sendHspAgAtCmdRsp(AG_AT_CMD_IND cmd);
BT_Result sendSppAtCmdRsp(SPP_AT_CMD_IND cmd);

/* ===========================================================================
 * Function:    bt_manager_task
 * Description: Bluetooth Manager Task, a single entity for accesing MECEL Stack
 * Returns:     NEVER
 * =========================================================================== */

void bt_manager_task(void *pvParameters)
{
    ms_task_msg_t             *msg;
    BT_U8                     message_id;
    cplg_param_t              cp_parameter_value;
    void                      *ptr2message;
    BT_U16                    message_len;
    BT_MNGR_TransportSettings tlSettings;
    BT_MNGR_Device*           devptr;
    btDevInfo*                tempDevInfo;
    btDevInfo*                dev;

    semaphore_init(BTMNG_SHARE_DB, BINARY, NULL);

    codeplugGetParameter(PAIRING_METHOD, &pairing_mode, 0);
    codeplugGetParameter(POLL_RATE_SETTING, &cp_parameter_value, 0);  
    if( cp_parameter_value != 0 )
    {
      POLL_RATE = cp_parameter_value;
    }

    /* Device discovery is not code plug configuable */
    if( CODEPLUG_OK == codeplugGetParameter(TIME_DEVICE_INQUIRY, &cp_parameter_value, 0) )
    {
      DeviceInquiryTimerValue = (BT_U8)cp_parameter_value;
    }
    else
    {
      /* default is 8 * 1.28 = 10.24 if value get from code plug fail */
      DeviceInquiryTimerValue = 8;
    }

    if( CODEPLUG_OK == codeplugGetParameter(RF_TEST_CONFIGURATION_1, &cp_parameter_value, 0) )
    {
      dut_para.data[0] = (BT_U16)((cp_parameter_value >> 16) & 0xFFFF);
      dut_para.data[1] = (BT_U16)(cp_parameter_value & 0xFFFF);
    }
    else
    {
      dut_para.data[0] = 0;
      dut_para.data[1] = 0;
    }

    if( CODEPLUG_OK == codeplugGetParameter(RF_TEST_CONFIGURATION_2, &cp_parameter_value, 0) )
    {
      dut_para.data[2] = (BT_U16)((cp_parameter_value >> 16) & 0xFFFF);
      dut_para.data[3] = (BT_U16)(cp_parameter_value & 0xFFFF);
    }
    else
    {
      dut_para.data[2] = 0;
      dut_para.data[3] = 0;
    }

    if( pairing_mode == PAIRING_PAIRING_MODE_STANDARD )
    {
      if( CODEPLUG_OK == codeplugGetParameter(ENABLE_EDR_STD_PAIRING, &cp_parameter_value, 0) )
      {
        std_pairing_edr_enabled = (BT_U8)cp_parameter_value;
      }
      else
      {
        std_pairing_edr_enabled = 0x00;
      }
    }
    
    if( CODEPLUG_OK == codeplugGetParameter(NIBBLER_PTT_TIMEOUT, &cp_parameter_value, 0) )
    {
      nibbler_ptt_press_timeout = (BT_U16)cp_parameter_value;
    }
    else
    {
      nibbler_ptt_press_timeout = 300;
    }
    
    headset_nibbler = nibbler_init();
    nibbler_set_store_decode_callback_func(&headset_nibbler, store_headset_nibbler_decoded_data_byte_in_buffer);
    nibbler_set_ptt_press_callback_func(&headset_nibbler, wirelessR1_3ptt_handler);
    BT_MNG_Clear_Audiodev_NibblerBuffer();

    wirelessPTT_nibbler = nibbler_init();
    nibbler_set_store_decode_callback_func(&wirelessPTT_nibbler, store_wirelessPTT_nibbler_decoded_data_byte_in_buffer);
    nibbler_set_ptt_press_callback_func(&wirelessPTT_nibbler, wirelessR1_4ptt_handler);
    BT_MNG_Clear_NonAudiodev_NibblerBuffer();

    /* Get the BT chip out of reset*/
    bluetooth_manager_init();
    /* Insert a delay of 400 msec to allow the BT chip to complete initialization before the Stack sends RESET HCI command*/
    vTaskDelay(400);  

    BT_MNGR_InitBluetooth(&tlSettings); /* Intialization of MECEL*/

   for(;;)
    {
          msg = (ms_task_msg_t *)Get_Msg_w_Time_Out(SUSPEND_INDEFFINATELY);
          if(NULL != msg)
          {
              message_id = msg->ros_msg.radio_if_msg.sub_opcode;  /* get sub opcode*/
              ptr2message = msg->ros_msg.radio_if_msg.data; /* get the pointer to data */
              message_len = msg->ros_msg.radio_if_msg.data_len; /* get the pointer to data */
              message_len = message_len; // CCMPD01410054 (JJ 8/11/2010)

              OS_free(msg);
              switch ( message_id )
              {

                   case BT_PAIRING_INFO:
                    LoadPrevConnectDevInfo(ptr2message);
                    tempDevInfo = ptr2message;
                    #ifdef MPP_PROTOCOL_TO_ENABLE_EDR
                    if(tempDevInfo->profile == HSP)
                    {
                      if( tempDevInfo->IsDeviceClass1 == BT_TRUE)
                      {
                        /* Do not support 2EV3 3EV3 2EV5 3EV5 */
                        audioSetupOptions = &scoSetupSettings_Class1[0];
                        audioAcceptOptions = &scoAcceptSettings_Class1;
                      }
                      else
                      {                                
                        /* Support 2EV3 3EV3 2EV5 3EV5 */
                        audioSetupOptions = &scoSetupSettings_Class15[0];
                        audioAcceptOptions = &scoAcceptSettings_Class15;
                      }
                    }
                    HSP_AG_ConfigureAudio( audioSetupOptions, audioAcceptOptions );
                    #endif
                    break;

                  case BT_CLEAR_PAIRING_INFO:
                    RemovePrevConnectDevInfo(ptr2message);
                    break;

                  /* Make 1.2 Discoverable */
                  case BT_DISCOVERABLE_MODE_REQUEST:
                      m_discoverable = BT_TRUE;
                      ctrlState = BT_MNGR_CONTROL_SEND_WRITE_DISCOVERABLE;
                      RunCtrlStateMachine();
                      break;

                  /* Start Device Descovery */
                  case BT_DISCOVERY_AND_PAIRING_REQUEST:
                      if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                      {
                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->BT_MNGR - >BT_DISCOVERY_AND_PAIRING_REQUEST\n");
                        #endif
                        
                        if( message_len == sizeof(discoveryType) )
                        {
                          discoverymode = *(discoveryType*)ptr2message;
                          if( discoverymode > DISCOVERY_SPP_ONLY )
                          {
                            discoverymode = DISCOVERY_ALL;
                          }
                        }
                        else
                        {
                          discoverymode = DISCOVERY_ALL;
                        }

                        #ifdef DEBUG_DEVICE_DISCOVERY
                        m_foundDevicesCount       = 0;
                        memset( m_foundDevices,     0, sizeof(m_foundDevices) );
                        #endif

                        foundedHSCount            = 0;
                        foundedR1_4Count          = 0;
                        memset( foundedHS,          0, sizeof(foundedHS) );
                        memset( foundedR1_4,        0, sizeof(foundedR1_4) );
                        BT_ClearDeviceDatabase(NULL);

                        ctrlPhase = BT_MNGR_CONTROL_PHASE_DISCOVERY;
                        ctrlState = BT_MNGR_CONTROL_SEND_RSSI_CFG;
                        
                        RunCtrlStateMachine();
                      }
                      else
                      {
                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->Error: BT_DISCOVERY_AND_PAIRING_REQUEST\n");
                        #endif
                      }
                      break;	

                  /* Start Pairing */
                  case BT_MNGR_START_PAIRING:
                    if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                    {
                        /*
                        * Before start pairing Check whether HS & R1.4 found
                        * Priority is HS, so first Paired HS then R1.4
                        */
                          /* HS first priority */
                          if( GetNextHS() != NULL )
                          {
                            #ifdef BT_ENABLE_SW_TST_UART
                            BT_RawLog("--->Output message : BT_MNGR_HS_PAIRING_START_REQ\n");
                            #endif
                            SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_HS_PAIRING_START_REQ
                              ,NULL
                              ,0);
                          }
                          else if( GetNextSPP() != NULL ) 
                          {
                            #ifdef BT_ENABLE_SW_TST_UART
                            BT_RawLog("--->Output message : BT_MNGR_SPP_PAIRING_START_REQ\n");
                            #endif
                            SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_SPP_PAIRING_START_REQ
                              ,NULL
                              ,0);
                          }
                          
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->Output message : BT_PAIRING_STARTED_ACK\n");
                          #endif
                          SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_STARTED_ACK, NULL ,0);
                    }
                    else
                    {
                      #ifdef BT_ENABLE_SW_TST_UART
                      BT_RawLog("--->Error: BT_MNGR_START_PAIRING\n");
                      #endif
                    }
                    break;

                 case BT_MNGR_HS_PAIRING_START_REQ:
                  if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                  {
                     if( (devptr = GetNextHS()) != NULL )
                     {
                       ctrlState = BT_MNGR_CONTROL_SEND_HS_CREATE_BOND;
                       ctrlPhase = BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS;

                       #ifdef BT_ENABLE_SW_TST_UART
                       BT_RawLog("--->Start paring with HSP\n");
                       BT_RawLog("--->=====================\n");
                       BT_PrintDeviceInfo(devptr);
                       #endif

                       if( hsPairingTimer != NULL ) BT_TimeoutCancel(hsPairingTimer);
                       hsPairingTimer = BT_TimeoutReq(appSenderId,
                         TIMER_ID_RUN_HS_PAIRING_STATE_MACHINE, /* user timer id */
                         0,                                     /* userTimerData */
                         12000);                                 /* msTimeout */

                       RunCtrlStateMachine();
                     }
                  }
                  else
                  {
                    #ifdef BT_ENABLE_SW_TST_UART
                    BT_RawLog("--->Error: BT_MNGR_HS_PAIRING_START_REQ\n");
                    #endif
                  }
                  break;

                 case BT_MNGR_SPP_PAIRING_START_REQ:
                   if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                   {
                     if( (devptr = GetNextSPP()) != NULL)
                     {
                       ctrlState = BT_MNGR_CONTROL_SEND_SDAP_SERVICE_SEARCH;
                       ctrlPhase = BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP;

                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->Start paring with SPP\n");
                        BT_PrintDeviceInfo(devptr);
                        #endif

                        if( r1_4PairingTimer != NULL )BT_TimeoutCancel(r1_4PairingTimer);
                        r1_4PairingTimer = BT_TimeoutReq(appSenderId,
                            TIMER_ID_RUN_R1_4_PAIRING_STATE_MACHINE, /* user timer id */
                            0,                                       /* userTimerData */
                            12000);                                   /* msTimeout */
                        RunCtrlStateMachine();
                     }
                   }
                   else
                   {
                     #ifdef BT_ENABLE_SW_TST_UART
                     BT_RawLog("--->Error: BT_MNGR_SPP_PAIRING_START_REQ\n");
                     #endif
                   }
                   break;


                 case BT_MNGR_HS_PAIRING_SUCCESS_ACK:
                   if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                   {
                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->BT_MNGR_HS_PAIRING_SUCCESS_ACK \n" );
                        #endif
                        /* If HS paired & R1.4 if found Conti with R1.4 */
                        /* Else send Pairing Complete ACK to Connection Manager */
                        if( (devptr = GetPairedHSP()) != NULL )
                        {
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->Paring success with HSP\n");                         
                          BT_RawLog("--->=======================\n");                         
                          BT_PrintDeviceInfo(devptr);

                          BT_RawLog("--->Output message : BT_PAIRING_SUCCESS_ACK\n");
                          #endif
                          
                          SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_SUCCESS_ACK
                              ,&devptr->devinfo
                              ,sizeof(btDevInfo));
                        }
                        else
                        {
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->Error in state machine: %s \n", devptr->name );
                          #endif
                        }

                        if( (devptr = GetNextSPP()) != NULL )
                        {
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->Output message : BT_MNGR_SPP_PAIRING_START_REQ\n");
                          #endif
                          SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_SPP_PAIRING_START_REQ
                              ,NULL
                              ,0);
                        }
                        else
                        {
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->Output message : BT_PAIRING_COMPLETE_ACK\n");
                          #endif
                          SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_COMPLETE_ACK
                               ,NULL
                               ,0);
                        }
                    }
                   else
                   {
                     #ifdef BT_ENABLE_SW_TST_UART
                     BT_RawLog("--->Error: BT_MNGR_HS_PAIRING_SUCCESS_ACK\n");
                     #endif
                   }
                   break;

                 case BT_MNGR_HS_PAIRING_UNSUCCESS_ACK:
                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->BT_MNGR_HS_PAIRING_UNSUCCESS_ACK \n" );
                        #endif
                       /*
                        * If Headset Pairing is UNSUCCESSFUL
                        * keep trying untill Pairing Timer Timeout
                        * Conti. with R1.4 pairing
                        */
                        if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                        {
                          if( (devptr = GetNextHS()) != NULL
                            && (hsPairingTimer != NULL) )
                          {
                            #ifdef BT_ENABLE_SW_TST_UART
                            BT_PrintDeviceInfo(devptr);
                            BT_RawLog("--->Output message : BT_MNGR_HS_PAIRING_START_REQ\n");
                            #endif
                            SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_HS_PAIRING_START_REQ
                              ,NULL
                              ,0);
                          }
                          else
                          {
                            if( (devptr = GetNextSPP()) != NULL )
                            {
                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_PrintDeviceInfo(devptr);
                              BT_RawLog("--->Output message : BT_HEADSET_PAIRING_FAIL_ACK\n");
                              #endif
                              
                              SEND_MESSAGE_TO_CONNECTION_MNGR(BT_HEADSET_PAIRING_FAIL_ACK,NULL,0); 

                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->Output message : BT_MNGR_SPP_PAIRING_START_REQ\n");
                              #endif

                              SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_SPP_PAIRING_START_REQ
                                ,NULL
                                ,0);
                            }
                            else
                            {
                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->Output message : BT_HEADSET_PAIRING_FAIL_ACK\n");
                              #endif

                              SEND_MESSAGE_TO_CONNECTION_MNGR(BT_HEADSET_PAIRING_FAIL_ACK,NULL,0);

                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->Output message : BT_PAIRING_COMPLETE_ACK\n");
                              #endif

                              SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_COMPLETE_ACK,NULL,0);
                            }
                          }
                        }
                        else
                        {
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->Error: BT_MNGR_HS_PAIRING_UNSUCCESS_ACK\n");
                          #endif
                        }
                       break;

                 case BT_MNGR_R1_4_PAIRING_SUCCESS_ACK:

                     if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                     {
                       if( (devptr = GetPairedSPP()) != NULL )
                       {
                         #ifdef BT_ENABLE_SW_TST_UART
                         BT_RawLog("--->Paring success with SPP\n");                         
                         BT_RawLog("--->=======================\n");                         
                         BT_PrintDeviceInfo(devptr);

                         BT_RawLog("--->Output message : BT_PAIRING_SUCCESS_ACK\n");
                         #endif

                         SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_SUCCESS_ACK ,&devptr->devinfo, sizeof(btDevInfo));

                         #ifdef BT_ENABLE_SW_TST_UART
                         BT_RawLog("--->Output message : BT_PAIRING_COMPLETE_ACK\n");
                         #endif

                         SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_COMPLETE_ACK,NULL,0);
                        }
                      }
                     else
                     {
                       #ifdef BT_ENABLE_SW_TST_UART
                       BT_RawLog("--->Error: BT_MNGR_R1_4_PAIRING_SUCCESS_ACK\n");
                       #endif
                     }
                      break;

                  /*
                   * If R1.4 Pairing is UNSUCCESSFUL
                   * keep trying untill Pairing Timer Timeout
                   */
                  case BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK:
                    if( ctrlPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                    {
                      #ifdef BT_ENABLE_SW_TST_UART
                      BT_RawLog("--->BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK \n" );
                      #endif

                      if( (devptr = GetNextSPP()) != NULL 
                            && (r1_4PairingTimer != NULL) )
                      {
                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->Output message : BT_MNGR_SPP_PAIRING_START_REQ\n");
                        #endif

                        SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_SPP_PAIRING_START_REQ
                          ,NULL
                          ,0);
                      }
                      else
                      {
                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->Output message : BT_PAIRING_COMPLETE_ACK\n");
                        #endif

                        /* Send Connection Manager Pairing Complete */
                        SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_COMPLETE_ACK,NULL,0);
                      }
                    }
                    else
                    {
                      #ifdef BT_ENABLE_SW_TST_UART
                      BT_RawLog("--->Error: BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK\n");
                      #endif
                    }
                    break;

                  case BT_START_CONNECT_REQUEST:
                          #ifdef BT_ENABLE_SW_TST_UART
                          BT_RawLog("--->BT_MNGR - >BT_START_CONNECT_REQUEST\n");
                          #endif

                          memcpy(&progressingDevInfo,(btDevInfo *)ptr2message,sizeof(btDevInfo));
                          /* If Connection REQ is for HS */
                          if(progressingDevInfo.profile == HSP)
                          {
                            if( hspPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                            {
                              hspPhase = BT_MNGR_HSP_CONNECT_OR_DISCONNECT;
                              hspState = BT_MNGR_HSP_SEND_CONNECT_REQ;

                              /* reset all statu */
                              headset_status.Is_LinkLost              = BT_FALSE;
                              headset_status.Is_connected             = BT_FALSE;
                              headset_status.Is_SPP_connected         = BT_FALSE;
                              headset_status.Is_SPP_flow_enable       = BT_FALSE;
                              headset_status.Is_SCO_connected         = BT_FALSE;
                              headset_status.Is_NIBBLER_enable        = BT_FALSE;    
                              headset_status.Is_AT_Handshaking_done   = BT_FALSE;
                              headset_status.AT_cmd_state             = AT_CMD_STATE_NON;
                              headset_status.AT_cmd_retry_cnt         = 0;
                              headset_status.Is_nibbler_decoding_done = FALSE;
                              headset_status.Is_comm_over_xnl_xcmp    = FALSE;
                              BT_MNG_Clear_Audiodev_NibblerBuffer();

                              isR1_3awaitingTMO = BT_FALSE;
                              
                              BT_SetDeviceDatabase(&progressingDevInfo);
                              
                              if( hsConnectingTimerId != NULL )BT_TimeoutCancel(hsConnectingTimerId);
                              hsConnectingTimerId =  BT_TimeoutReq(appSenderId,
                                                  TIMER_ID_RUN_HS_CONNECTING_STATE_MACHINE, /* user timer id */
                                                  0,                           /* userTimerData */
                                                  15000);   /* msTimeout */
                              
                              RunHspStateMachine();

                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->BT_START_CONNECT_REQUEST 1\n");
                              #endif
                            }
                            else
                            {
                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->Error: BT_START_CONNECT_REQUEST 1\n");
                              #endif
                            }
                          }
                          else if(progressingDevInfo.profile == SPP)
                          {
                            if( sppPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                            {
                              sppPhase = BT_MNGR_SPP_CONNECT_OR_DISCONNECT;
                              sppState = BT_MNGR_SPP_SEND_CONNECT_REQ;

                              
                              wirelessPTT_status.Is_LinkLost              = BT_FALSE;
                              wirelessPTT_status.Is_connected             = BT_FALSE;
                              wirelessPTT_status.Is_SPP_connected         = BT_FALSE;
                              wirelessPTT_status.Is_SPP_flow_enable       = BT_FALSE;
                              wirelessPTT_status.Is_SCO_connected         = BT_FALSE;
                              wirelessPTT_status.Is_NIBBLER_enable        = BT_FALSE;    
                              wirelessPTT_status.Is_AT_Handshaking_done   = BT_FALSE;
                              wirelessPTT_status.AT_cmd_state             = AT_CMD_STATE_NON;
                              wirelessPTT_status.AT_cmd_retry_cnt         = 0;
                              wirelessPTT_status.Is_nibbler_decoding_done = FALSE;
                              wirelessPTT_status.Is_comm_over_xnl_xcmp    = FALSE;
                              BT_MNG_Clear_NonAudiodev_NibblerBuffer();

                              isR1_4awaitingTMO = BT_FALSE;
                              
                              BT_SetDeviceDatabase(&progressingDevInfo);

                              if( r1_4ConnectingDelay != NULL ) BT_TimeoutCancel(r1_4ConnectingDelay);
                              r1_4ConnectingDelay = BT_TimeoutReq(appSenderId,
                                                       TIMER_ID_RUN_R1_4_CONNECTING_DELAY, /* user timer id */
                                                              0,                           /* userTimerData */
                                                              1000);   /* msTimeout */
                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->BT_START_CONNECT_REQUEST 2\n");
                              #endif
                            }
                            else
                            {
                              #ifdef BT_ENABLE_SW_TST_UART
                              BT_RawLog("--->Error: BT_START_CONNECT_REQUEST 2\n");
                              #endif
                            }
                          }                          
                          else
                          {
                            #ifdef BT_ENABLE_SW_TST_UART
                            BT_RawLog("--->Error: BT_START_CONNECT_REQUEST 3\n");
                            #endif
                         }
                          break;

                  case BT_DISCONNECT_REQUEST:
                         memcpy(&progressingDevInfo,((btDevInfo *)ptr2message),sizeof(btDevInfo));
                         if(progressingDevInfo.profile == SPP)
                         {
                              sppState = BT_MNGR_SPP_SEND_DISCONNECT_REQ;
                              RunSppStateMachine();
                         }
                         else if(progressingDevInfo.profile == HSP)
                         {
                           if(GetScoStatus(progressingDevInfo.addr) == SCO_CONNECTED)
                           {
                             hspPhase = BT_MNGR_HSP_CONNECT_OR_DISCONNECT;
                             hspState = BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ;
                             RunHspStateMachine();
                           }
                           else
                           {
                             hspPhase = BT_MNGR_HSP_CONNECT_OR_DISCONNECT;
                             hspState = BT_MNGR_HSP_SEND_DISCONNECT_REQ;
                             RunHspStateMachine();
                           }
                         }
                        break;

                  case DONGLE_LONG_PTT_PRESSED_ACK:
                    if(isBQBModeOn)
                    {
                          ctrlState = BT_MNGR_CONTROL_SEND_SDAP_SERVICE_SEARCH;
                          RunCtrlStateMachine();
                     }
                    break;
 
                  case DONGLE_PTT_PRESSED_ACK:
                    if(isBQBModeOn)
                    {  
                      if((dev = BT_GetDevProfileInfo(HSP)) != NULL)
                      {     
                        if(GetScoStatus(dev->addr)==UNKNOWN_CONNECTION)
                        {
                          hspPhase = BT_MNGR_HSP_CONNECT_OR_DISCONNECT;
                          hspState = BT_MNGR_HSP_SEND_CONNECT_REQ;
                          RunHspStateMachine();
                        }
                        else if(GetScoStatus(dev->addr)==SCO_CONNECTED)
                        {
                          /* Disconnect SCO */
                          hspState = BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ;
                          RunHspStateMachine();
                       }
                      }
                    }                      
                    break;
                                        
                case BT_QUAL_TEST_MODE_REQUEST:
                      isBQBModeOn = BT_TRUE;
                      m_discoverable = BT_TRUE;
                      ctrlState = BT_MNGR_CONTROL_SEND_WRITE_DISCOVERABLE;                               
                      RunCtrlStateMachine();
                      break;
                    
                  case BT_STOP_SPP_CONNECT_REQUEST: /* SPP device is still in connecting state, stop the connec process */
                    #ifdef BT_ENABLE_SW_TST_UART
                    BT_RawLog("--->BT_MNGR - >BT_STOP_SPP_CONNECT_REQUEST\n");
                    #endif
                    if( r1_4ConnectingDelay != NULL ) 
                    {
                      BT_TimeoutCancel(r1_4ConnectingDelay);
                      r1_4ConnectingDelay = NULL;
                    }
                    if(r1_4ConnectingTimerId != NULL)
                    {
                      BT_TimeoutCancel(r1_4ConnectingTimerId);
                      r1_4ConnectingTimerId = NULL;
                    }                    
                    EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );
                    break;

                  case BT_HS_ACCEPT_CKPD_CMND_REQUEST: /* Dongle shall accept the AT+CKPD=200 for SCO link establishment */
                    isAcceptCKPD=BT_TRUE;
                    break;


                  case HEADSET_SPKR_CONTROL: 
                    BT_HSSPKR_controller();
                    break;

                  case SWITCH_TRANSPORT_LAYER_REQUEST:
                          if( hciPhase == 0 && startupState == BT_MNGR_STATE_INITIATED )
                          {
                                  hciPhase = BT_MNGR_HCI_SETUSB_TRANSPORT;
                                  hciState = BT_MNGR_HCI_SETUSBTL;
                                  RunHciStateMachine();
                          }
                          else if( f_IsInitializefail == BT_TRUE )
                          {

                            /*
                            * Unable to initialize, Hence it will fail also for BCCMD sending.
                            * Skip the BCCMD sending and proceed for USB switching
                            */
                            #ifdef BT_ENABLE_SW_TST_UART
                            BT_RawLog("--->Output message : DFU_MODE_RSP_RECEIVED_FROM_CSR\n");
                            #endif
                            
                            SEND_MESSAGE_TO_TESTCOMMAND_MNGR(DFU_MODE_RSP_RECEIVED_FROM_CSR,
                              NULL,
                              0);
                          }
                          else
                          {
                             #ifdef BT_ENABLE_SW_TST_UART
                             BT_RawLog("--->Output message : NULL to test command manager\n");
                             #endif
                             
                                  SEND_MESSAGE_TO_TESTCOMMAND_MNGR(0,NULL, 0);
                          }		
                          break;

                case DEVICE_UNDER_TEST_REQUEST:
                    if( hciPhase == 0
                       && ( startupState == BT_MNGR_STATE_INITIATED
                          || startupState == BT_MNGR_STATE_DEVICE_UNDER_TEST ))
                  {
                          hciPhase = BT_MNGR_HCI_DEVICE_TEST;
                          hciState = BT_MNGR_HCI_DEVTEST_1;
                          RunHciStateMachine();
                  }
                  break;

#ifdef BT_ENABLE_DUT
                      case DEVICE_TEST_USING_CODEPLUG:
                        {
                          hciPhase = BT_MNGR_HCI_SEND_BCCMD;
                          hciState = BT_MNGR_HCI_CUSTOM_CMDSEND;
                          RunHciStateMachine();
                        }
                        break;
#endif

              case DEVICE_SEND_VM_CMD:
                {
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();
                }
                break;
                
              case CHECK_CSR_VERSION_REQ:
                {
                  hciPhase = BT_MNGR_HCI_SEND_BCCMD;
                  hciState = BT_MNGR_HCI_CSR_VER_CHECK;
                  RunHciStateMachine();
                }
                break;
                
              case HCI_PING_GET_BT_CHIP_RESPONSE:
                if(BT_MNGR_SendHciReadClassOfDevice() == BT_CONGESTED)
                {
                  //Cancel the previous retry timer if scheduled  
                  if(hci_ping_retry_TMO != 0 )BT_TimeoutCancel(hci_ping_retry_TMO);                           
                  // Schedule a timer to resend the message if congested
                  hci_ping_retry_TMO = BT_TimeoutReq(appSenderId,
                                               TIMER_ID_BT_CHIP_HCI_PING_RETRY_TMO, /* user timer id */
                                               0,                           /* userTimerData */
                                               RUN_STATE_MACHINE_DELAY);   /* msTimeout */
                }
                break;
                
              case BT_DEV_CONNECTION_REQUEST_ALLOW:
                tempDevInfo = ptr2message;

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->BT_MNGR - > BT_DEV_CONNECTION_REQUEST_ALLOW\n");
                #endif
                if( tempDevInfo->profile == HSP )
                {
                  headset_status.Is_connection_allow = BT_TRUE;
                }
                else if( tempDevInfo->profile == SPP )
                {
                  wirelessPTT_status.Is_connection_allow = BT_TRUE;
                }
                break;

              case BT_DEV_CONNECTION_REQUEST_DISALLOW:
                tempDevInfo = ptr2message;

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->BT_MNGR - > BT_DEV_CONNECTION_REQUEST_DISALLOW\n");
                #endif
                if( tempDevInfo->profile == HSP )
                {
                  headset_status.Is_connection_allow = BT_FALSE;
                }
                else if( tempDevInfo->profile == SPP )
                {
                  wirelessPTT_status.Is_connection_allow = BT_FALSE;
                }
                break;
        
                
              default:
              break;
              }
          }

	}
}
void LoadPrevConnectDevInfo(btDevInfo * ptr2message)
{
       BT_U8            devType;
       devType  = ptr2message->profile;

  if( capture_time_semaphore( CONNMNG_SHARE_DB, portMAX_DELAY) == SEM_RET_SUCCESS )
  {
    if(devType == HSP)
    {
      BT_SetDeviceDatabase(ptr2message);
    }
    else if(devType == SPP)
    {
      BT_SetDeviceDatabase(ptr2message);
    }   
    release_semaphore( CONNMNG_SHARE_DB );
  }
}

/* ===========================================================================
* Function:    RemovePrevConnectDevInfo
* Description: To remove pairing info in database
* =========================================================================== */
void RemovePrevConnectDevInfo(btDevInfo * ptr2message)
{
  BT_ClearDeviceDatabase(ptr2message);
}

/* ===========================================================================
 * Function:    BT_MNGR_Control
 * Description: See the Bluetooth SDK Reference Manual
 * =========================================================================== */
BT_Result BT_MNGR_Control(BT_ControlCommand cmd)
{
    switch ( cmd )
    {
    case BT_INITIALISE:
        /*
         * Register as HCI user to make it possible to subscribe to
         * HCI events.
         */
        if ( HCI_RegisterUser(appSenderId) != BT_OK )
        {
            fprintf(stderr, "failed to register as HCI user\n");
            BT_FatalError(0);
        }

        HCI_EventSubscribe(appSenderId, HCI_QOS_SETUP_COMPLETE_EVENT);//cwc034: QoS test
        HCI_EventSubscribe(appSenderId, HCI_CONTROLLER_RESTARTED_IND);
        HCI_EventSubscribe(appSenderId, HCI_RETURN_LINK_KEYS_EVENT);
        HCI_EventSubscribe(appSenderId, HCI_NUMBER_OF_COMPLETED_PACKETS_EVENT);
        HCI_EventSubscribe(appSenderId, HCI_RAW_EVENT_IND);

        /*
         * Allocate a resend timer
         */
        BT_AllocateTimers(appSenderId, TIMER_ID_RUN_MAX);

        /*
         * H5 Initialize check, After time define by RUN_INITIALIZE_CHK_DELAY
         * If the system is not initialize, it is consider file. Probally because
         * of H5 transport layer change to USB transport layer
         */
        BT_TimeoutReq(appSenderId,
          TIMER_ID_RUN_INITIALIZE_CHECK,  /* user timer id */
          0,                              /* userTimerData */
          RUN_INITIALIZE_CHK_DELAY);      /* msTimeout */
        /* Start a Timer to verify that BT Chip responds with 'HCI_RESET_COMPLETE_EVENT ' event .If not, 
           force a Watchdog reset*/ 
         if (!Is_device_enumerated())
         {
           if(bt_chip_HCIreset_complete_event_timer != 0 )BT_TimeoutCancel(bt_chip_HCIreset_complete_event_timer);
           bt_chip_HCIreset_complete_event_timer = BT_TimeoutReq(appSenderId,
                                    TIMER_ID_BT_CHIP_HCIRESET_COMPLETE_FAIL_TMR,
                                    0,                                      
                                    BT_STACK_TASK_INITIALIZATION_TIMEOUT_PERIOD);
         }

				
        break;

    case BT_REGISTER:
        break;

    case BT_START:
        break;
    }

    return BT_CONTROL_CMD_COMPLETE;
}

/* ===========================================================================
 * Function:    BT_MNGR_InitBluetooth
 * Description: Starts initialisation of the bluetooth stack.
 *              Initialsation is complete when a CTRL_CMD_CFM
 *              message has been received.
 * Returns:     BT_TRUE if success, otherwise false;
 * =========================================================================== */
void BT_MNGR_InitBluetooth(   BT_MNGR_TransportSettings *tlSettings  )
{
    BT_Config           config;
    static CTRL_InitReq initReq;

    BT_ClearDeviceDatabase(NULL);
    memset( &headset_status, 0, sizeof(headset_status));
    memset( &wirelessPTT_status, 0, sizeof(wirelessPTT_status));

    config.configIntEntries = configInts;
    config.configStrEntries = configStrs;

    BT_MNGR_ChangeTransportConfig(tlSettings);

    /*
     * Override standard log handler
     */

    #ifdef BT_ENABLE_TRACE
    BT_SetCustomLogOutput(BT_AtmelLogOutputFunc);
    #endif

    #ifdef BT_ENABLE_SW_TST_UART
    BT_SetCustomLogOutput(BT_AtmelLogOutputFunc);
    #endif

    #ifdef BT_ENABLE_BINARY_TRACE
    BT_SetCustomBinaryTraceOutput(BT_CustomBinaryTraceOutput);
    #endif

    /*
     * Basic stack configuration and initialisation
     */
    if ( BT_Init(&config, controlFuncs) != BT_OK )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->Output message : BT_INIT_FAILED_ACK\n");
      #endif
      
      SEND_MESSAGE_TO_CONNECTION_MNGR(BT_INIT_FAILED_ACK, NULL, 0);
    }
    else
    {
        startupState = BT_MNGR_STATE_INITIATING;

        /*
         * Register this application
         */
        appSenderId = BT_RegisterApplication( "Bluetooth_Manager_Task",
                                        MsgHandler );
        /*
         * Setup log filter
         */
        BTCOM_SetupLogFilter();

        /*
         * Trigger the stack start sequence
         */
        initReq.header.primitive    = CTRL_INIT_REQ;
        initReq.header.receiver     = BT_CTRL;
        initReq.header.sender       = appSenderId;

        vSemaphoreCreateBinary( xACLAccess );

        if ( BT_INVOKE(&initReq) != BT_OK && xACLAccess == NULL )
        {
            fprintf(stderr, "Failed to send int request to stack\n");
            startupState = BT_MNGR_STATE_NOT_INITIATED;
            
            SEND_MESSAGE_TO_CONNECTION_MNGR(BT_INIT_FAILED_ACK,NULL,0);          
        }
    }
}

/*===========================================================================
 *  Function:       RunStartupStateMachine
 *  Description:    Runs startup handling startupState machine
 *  Returns:        None.
 *===========================================================================*/
static void RunStartupStateMachine()
{
  BT_Result res = BT_CALL_ERROR;
  BT_U8 newState = 0;

  switch ( startupState )
  {
  case BT_MNGR_STATE_SEND_WRITE_CLASS_OF_DEVICE:
    res = BT_MNGR_SendHciWriteClassOfDevice(classOfDevice);
    break;

  case BT_MNGR_STATE_SEND_WRITE_CONNECTABLE:
    res = BT_MNGR_SendSecWriteConnectableReq(BT_TRUE, 0x0800, 0x0012);
    break;

  case BT_MNGR_STATE_SEND_WRITE_DISCOVERABLE:
    res = BT_MNGR_SendSecWriteDiscoverableReq(m_discoverable, 0x0800, 0x0012);
    break;

  case BT_MNGR_STATE_SEND_WRITE_PAGE_TIMEOUT:
    res = BT_MNGR_SendHciwritepagetimeout();
    break;
    
  case BT_MNGR_STATE_SEND_WRITE_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL:
  res = BT_MNGR_SendHciWriteInquiryResponseTransmitPowerLevel(ReqInquiryTxPower);
  break;
  
  case BT_MNGR_STATE_SEND_READ_LOCAL_BTADDR:
  res = BT_MNGR_Send_Read_BDADD();
  break;
  }

  if ( res == BT_OK )
	{
		startupState = newState;
	}
	else if ( res == BT_CONGESTED )
	{
		BT_TimeoutReq(appSenderId,
                   TIMER_ID_RUN_STATE_MACHINE, /* user timer id */
                   0,                           /* userTimerData */
                    RUN_STATE_MACHINE_DELAY);   /* msTimeout */
  }
}

/*===========================================================================
 *  Function:       RunCtrlStateMachine
 *  Description:    Runs state machine for user control requests
 *  Returns:        None.
 *===========================================================================*/
static void RunCtrlStateMachine()
{
	BT_Result res = BT_CALL_ERROR;
	BT_U8 newState = 0;
  BT_MNGR_Device* devptr;
  btDevInfo* dev;

  switch ( ctrlState )
  {
  case BT_MNGR_CONTROL_SEND_RSSI_CFG:	
    res =  BT_MNGR_SendRssiInqCfg();
    break;
      
  case BT_MNGR_CONTROL_SEND_SDAP_ENUM:
    res = BT_MNGR_SendSdapEnumRemDevReq();
    break;

  case BT_MNGR_CONTROL_SEND_HS_CREATE_BOND:
    if( (devptr = GetNextHS()) != NULL )
    {
      res = BT_MNGR_SendCreateBondReq( devptr->devinfo.addr, 1 );
    }
    break;

  case BT_MNGR_CONTROL_SEND_R1_4_CREATE_BOND:
    if( (devptr = GetNextFilteredSPP()) != NULL )
    {
      res = BT_MNGR_SendCreateBondReq( devptr->devinfo.addr, 1) ;
    }
    break;

  case BT_MNGR_CONTROL_SEND_CREATE_BOND:
    if((dev = BT_GetDevProfileInfo(HSP)) != NULL)
    {  
      res = BT_MNGR_SendCreateBondReq(dev->addr,1);
    }
    break;

  case BT_MNGR_CONTROL_SEND_HS_PASSKEY_RSP:
    res = BT_MNGR_SendSecPinRequestRsp(PinCodeReqDevice, BT_TRUE);
    break;
                
  case BT_MNGR_CONTROL_SEND_R1_4_PASSKEY_RSP:
    res = BT_MNGR_SendSecPinRequestRsp(PinCodeReqDevice, BT_TRUE);
    break;

  case BT_MNGR_CONTROL_SEND_REJECT_PASSKEY_RSP:
    res = BT_MNGR_SendSecPinRequestRsp(PinCodeReqDevice, BT_FALSE);
    break;   

  case BT_MNGR_CONTROL_SEND_PASSKEY_RSP:
    if((dev = BT_GetDevProfileInfo(HSP)) != NULL)
    {
      res = BT_MNGR_SendSecPinRequestRsp(dev->addr, BT_TRUE);
    }
    break;

	case BT_MNGR_CONTROL_SEND_WRITE_DISCOVERABLE:
		res = BT_MNGR_SendSecWriteDiscoverableReq(m_discoverable, 0x0800, 0x0012);
		break;

	case BT_MNGR_CONTROL_SEND_SDAP_TERMINATE:
		res = BT_MNGR_SendSdapTerminatePrimReq(SDAP_ENUMERATE_REM_DEV_REQ);
		break;

  case BT_MNGR_CONTROL_SEND_SDAP_SERVICE_SEARCH:
    if(isBQBModeOn)
    {
      if((dev = BT_GetDevProfileInfo(HSP)) != NULL)
      {
        res = BT_MNGR_SendSdapServiceSearchAttrReq(dev->addr);
      }
    }
    else
    {
      if( (devptr = GetNextSPP()) != NULL )
      {      
        #ifdef BT_ENABLE_SW_TST_UART
        BT_RawLog("--->Service Name search\n");
        BT_RawLog("--->===================\n");
        BT_PrintDeviceInfo(devptr);
        #endif
        
        res = BT_MNGR_SendSdapServiceSearchAttrReq(devptr->devinfo.addr);
      }
      else
      {
        #ifdef BT_ENABLE_SW_TST_UART
        BT_RawLog("--->Error in getting next SPP device\n"); 
        #endif
      }
    }
    break;

   case BT_MNGR_CONTROL_SEND_LINKKEY_REQ:
     res = BT_MNGR_SendSeclinkkeyreqrsp( &LinkKeyReqDevice, BT_FALSE);      
     break;

   case BT_MNGR_CONTROL_SEND_LINKKEY_RSP:
     res = BT_MNGR_SendSeclinkkeyreqrsp( &LinkKeyReqDevice, BT_TRUE);      
     break;

   default:
    break;
  }                

  if ( res == BT_OK )
  {
    ctrlState = newState;
  }
  else if ( res == BT_CONGESTED )
  {
    BT_TimeoutReq(appSenderId,
      TIMER_ID_RUN_CTRL_STATE_MACHINE, /* user timer id */
      0,                           /* userTimerData */
      100);   /* msTimeout */ 
  }
  else
  {
    ctrlPhase = 0;
  }
}

/*===========================================================================
 *  Function:       RunHspStateMachine
 *  Description:    Runs state machine for hsp requests
 *  Returns:        None.
 *===========================================================================*/
static void RunHspStateMachine()
{
	BT_Result res = BT_CALL_ERROR;
	BT_U8 newState = 0;
  btDevInfo* dev;

     
  switch ( hspState )
  {
	  case BT_MNGR_HSP_QOS_SETUP: //cwc034: QoS Test
          res = BT_MNGR_SendHciQosSetup(R1_3_connectionHandle, POLL_RATE);
	  break;
					
    case BT_MNGR_HSP_SEND_CONNECT_REQ:
    if( (dev = BT_GetDevProfileInfo(HSP)) != NULL )
    {
      res = BT_MNGR_SendHspAgConnectReq( dev->addr );
    }
    
    break;    
    
    case BT_MNGR_HSP_SEND_DISCONNECT_REQ:
    res = BT_MNGR_SendHspAgDisconnectReq();
    break;
    
    case BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ:
    res= BT_MNGR_SendHspAgAudioDisconnectReq();
    break;

    case BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ:
    res= BT_MNGR_SendHsAgAudioConnectReq();
    break;
    
    default:
      break;    
  }
  if ( res == BT_OK )
  {
    ctrlState = newState;
  }
  else if ( res == BT_CONGESTED )
  {
    BT_TimeoutReq(appSenderId,
                  TIMER_ID_RUN_HSP_STATE_MACHINE, //user timer id
                  0,                           //userTimerData
                  RUN_STATE_MACHINE_DELAY);   // msTimeout
  }
  else
  {
    hspPhase = 0;
  }
}
/*===========================================================================
 *  Function:       RunSppStateMachine
 *  Description:    Runs state machine for spp requests
 *  Returns:        None.
 *===========================================================================*/
static void RunSppStateMachine()
{
  BT_Result res = BT_CALL_ERROR;
  BT_U8 newState = 0;
  btDevInfo* dev;

  switch(sppState)
  {
    case BT_MNGR_SPP_QOS_SETUP: //cwc034: QoS Test
      res = BT_MNGR_SendHciQosSetup(R1_4_connectionHandle, POLL_RATE);
      break;

    case BT_MNGR_SPP_SEND_CONNECT_REQ:
      if( (dev = BT_GetDevProfileInfo(SPP)) != NULL )
      {
        res = BT_MNGR_SendSppDevConnectReq(dev->addr);
      }
      else
      {
        #ifdef BT_ENABLE_SW_TST_UART
        BT_RawLog("--->Error : BT_MNGR_SPP_SEND_CONNECT_REQ\n");
        #endif
      }
      break;

    case BT_MNGR_SPP_SEND_DISCONNECT_REQ:
      res = BT_MNGR_SendSppDevDisconnectReq();
      break;
   
  }

  if ( res == BT_OK )
  {
    ctrlState = newState;
  }
  else if ( res == BT_CONGESTED )
  {
    BT_TimeoutReq(appSenderId,
               TIMER_ID_RUN_SPP_STATE_MACHINE,  //user timer id 
               0,                           // userTimerData 
               RUN_STATE_MACHINE_DELAY);   // msTimeout 
  }
  else
  {
    sppPhase = 0;
  }
}
 /*===========================================================================
 *  Function:       HS_AG_RegisterService (cwc034)
 *  Description:    Configures HSP_ag and registers hsp_ag service with SDP database.
 *  Returns:        None.
 *===========================================================================*/
static void HS_AG_RegisterService(void)
{
    BT_Result               res = BT_FAILED;
    RFCOMM_ServerChannel    sCh = HSP_RFCOMM_CH;
    HSP_AG_ServiceRecord    serviceRecord;
    BT_U8                   *pos;
    SDP_RecordHandle        dummyHandle = 0;

    if ( BT_LookupProfile(BT_HSP_AG) && HSP_AG_RegisterService(appSenderId, "", &sCh) )
    {
         /*
         * Create and register service record for HS_AG
         */
        serviceRecord.validAttributes   = HSP_AG_VALID_SERVICE_NAME |
                                          HSP_AG_VALID_PROFILE_DESCRIPTOR_LIST;
        serviceRecord.serverChannel     = sCh;
        serviceRecord.serviceName       = "R1.2 Dongle";
        serviceRecord.supportedFeatures = ag_supportedFeatures;

        pos = hspHsAgSdpAttributes;
	
        (void)HSP_AG_AddServiceRecordAttributes(&pos,
                                         HSP_AG_SERVICE_RECORD_SIZE + sizeof(HSP_AG_SERVICE_NAME),
                                         HSP_AG_VERSION_1_2,
                                         &serviceRecord,
                                         &hspAgAttributeList.noOfAttr);

        hspAgAttributeList.attrList    = hspHsAgSdpAttributes;

        res = SDP_RegisterServiceRecord(&hspAgAttributeList,
                                        0,
                                        &dummyHandle);

        if ( res != BT_OK )
        {
            LOG_INFO((appSenderId, "Failed to register HSP AG service record"));
        }
        L2CA_SetLinkTimeout(GW_LINK_SUPERVISION_TIMEOUT);
        
    }
    else
    {
        LOG_INFO((appSenderId, "Failed to register at HSP AG"));
    }
}
  /*===========================================================================
 *  Function:       SPP_DEV_RegisterService
 *  Description:    Configures SPP 
 *  Returns:        None.
 *===========================================================================*/
static void SPP_RegisterService(void)
{
    RFCOMM_ServerChannel    sCh = SPP_RFCOMM_CH;

    if ( BT_LookupProfile(BT_SPP_DEV))
    {
    	 SPP_DEV_RegisterService(appSenderId, "", &sCh);
    }
    else
    {
        LOG_INFO((appSenderId, "Failed to register at SSP DEV"));
    }
	
}
/* ===========================================================================
 * Function:    HandleCtrlMessages
 * Description: Handler for all CTRL messages from bluetooth stack.
 * =========================================================================== */
static void HandleCtrlMessages(CTRL_IndConf *msg)
{		
       switch ( msg->header.primitive )
    {
    case CTRL_CMD_CFM:
        if ( !fatalErrorReceived )
        {
            SEC_RegisterIncomingService("SDP Server", /* SEC Service name */
                                                    0, /* SEC level */
                                                    SEC_ID_L2CAP, /* SEC Protocol */
                                                    BT_PSM_SDP); /* SEC Channel */
            SEC_RegisterOutgoingService("SDP Client", /* SEC Service name */
                                                    0, /* SEC level */
                                                    SEC_ID_L2CAP, /* SEC Protocol */
                                                    BT_SDP); /* SEC Service */
            /*
             * Set packet type when intiating connections from
             * l2cap based protocols
             */
            HCI_SetAclPacketType(PACKET_TYPE);
            
            /*
             * Register application with security manager
             */
            SEC_RegisterEsce(appSenderId);
            HCI_AcceptAsMaster ( BT_TRUE );
            HCI_AllowRoleSwitch ( BT_FALSE );
            
            SPP_RegisterService();
            if(!isBQBModeOn)
            HS_AG_RegisterService();
            startupState = BT_MNGR_STATE_SEND_WRITE_CLASS_OF_DEVICE;

            SEC_SetPairingMode(SEC_PAIRABLE);
            RunStartupStateMachine();

            #ifndef MPP_PROTOCOL_TO_ENABLE_EDR
            /* Allow EDR packets for Gateway to work with N4010A box for testing */
            if(std_pairing_edr_enabled == 0x01)
            {
              HSP_AG_ConfigureAudio( &scoSetupSettings_AllowEDR_Class1[0], &scoAcceptSettings_AllowEDR_Class1 );
            }
            else
            {
            HSP_AG_ConfigureAudio( &scoSetupSettings_Class1[0], &scoAcceptSettings_Class1 );
            }
            #endif
                    

        }
        break;

    case CTRL_FATAL_ERROR_IND:
        fatalErrorReceived = BT_TRUE;
        SEND_MESSAGE_TO_CONNECTION_MNGR(FATAL_ERROR_ACK,NULL,0);          
        BT_DebugUnknownPermitive (msg->header.primitive);  
        break;
    }
}

/* ===========================================================================
 * Function:    HandleTsrvMessages
 * Description: Handler for messages from timeout server from bluetooth stack
 * =========================================================================== */
static void HandleTsrvMessages(BT_TimeoutInd *tsrv)
{
  BT_MNGR_Device * devptr;
  btDevInfo* dev;
    /*
     * Check if the timer has been cancelled while
     * processing another thread
     */
  if ( !BT_TimeoutIsCancelled(tsrv->timerId) )
  {
    switch ( tsrv->userTimerId )
    {
    case TIMER_ID_RUN_STATE_MACHINE:
      RunStartupStateMachine();
      break;

    case TIMER_ID_RUN_CTRL_STATE_MACHINE:
      RunCtrlStateMachine();
      break;

    case TIMER_ID_RUN_HSP_STATE_MACHINE:
      RunHspStateMachine();
      break;

    case TIMER_ID_RUN_SPP_STATE_MACHINE:
      /* If Connection Timer Running? Try Again */
      RunSppStateMachine();
      break;  
                      
    case TIMER_ID_RUN_HSP_AG_AT_CMD_STATE_MACHINE:
      hsp_atcommand_retry_TMO = NULL;
      sendHspAgAtCmdRsp(agAtCmdInd);
      break;

    case TIMER_ID_RUN_HSP_NULL_NIBBLE_RETRY:
      hsp_null_nibble_retry_TMO = NULL;
      sendHspAgAtCmdRsp(NULL_NIBBLER);
      break;
      
    case TIMER_ID_RUN_REPEAT_R1_4_ATCMD:
      spp_atcommand_retry_TMO = NULL;
      sendSppAtCmdRsp(sppAtCmdInd);
      break;

    case TIMER_ID_RUN_HCI_STATE_MACHINE:  
      RunHciStateMachine();
      break;

    case TIMER_ID_RUN_RING_CMD_STATE_MACHINE:
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->ttttt Ring time out \n"); 
      #endif
      ringTimerId = NULL;
      SendRINGCommand();
      break;

    case TIMER_ID_RUN_HS_PAIRING_STATE_MACHINE:
      /* Pairing State time out */
      hsPairingTimer = NULL;
      break;
                      
    case TIMER_ID_RUN_R1_4_PAIRING_STATE_MACHINE:
      /* Pairing State time out */
      r1_4PairingTimer = NULL;
      break;  
                
    case TIMER_ID_RUN_R1_4_RFCOMM_ATCMD_RSP:
      sendSppAtCmdRsp(RFCOMM_CHNL_IND);
      break;

    case TIMER_ID_RUN_R1_4_CONNECTING_DELAY:
      r1_4ConnectingDelay = NULL;
      if( r1_4ConnectingTimerId != NULL ) BT_TimeoutCancel(r1_4ConnectingTimerId);
      r1_4ConnectingTimerId = BT_TimeoutReq(appSenderId,
                                            TIMER_ID_RUN_R1_4_CONNECTING_STATE_MACHINE, /* user timer id */
                                            0,                           /* userTimerData */
                                            15000);    /* msTimeout */
      RunSppStateMachine();
      
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->BT_START_CONNECT_REQUEST 3\n");
      #endif
      break;
                      
    case TIMER_ID_RUN_HS_CONNECTING_STATE_MACHINE:
      /* Connecting State time */
      hsConnectingTimerId = NULL;
      if( (isR1_3awaitingTMO == BT_TRUE) && ((dev = BT_GetDevProfileInfo(HSP)) != NULL) )
      {
        /* should end phanse so that can start 2nd round of reconnection 
         * Need to put some handler here, don't kow where connection request come from
        */
        EndPhase( &hspPhase,BT_MNGR_HSP_CONNECT_OR_DISCONNECT ); 
                
        SEND_MESSAGE_TO_CONNECTION_MNGR(BT_CONNECT_TIMEOUT_ACK, dev , sizeof(btDevInfo));

        #ifdef BT_ENABLE_SW_TST_UART
        BT_RawLog("--->Output message : BT_CONNECT_TIMEOUT_ACK HS_15000\n");
        #endif
      }
      break;

                      
    case TIMER_ID_RUN_R1_4_CONNECTING_STATE_MACHINE:
      /* R1.4 Connecting time out */
      r1_4ConnectingTimerId = NULL;
      if( (isR1_4awaitingTMO == BT_TRUE) && ((dev = BT_GetDevProfileInfo(SPP)) != NULL) )
      {          
        EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );
      
        SEND_MESSAGE_TO_CONNECTION_MNGR(BT_CONNECT_TIMEOUT_ACK, dev , sizeof(btDevInfo));
      
        #ifdef BT_ENABLE_SW_TST_UART
        BT_RawLog("--->Output message : BT_CONNECT_TIMEOUT_ACK R14_15000\n");
        #endif
      }
      break;
          
    case TIMER_ID_RUN_INITIALIZE_CHECK:
      if( startupState != BT_MNGR_STATE_INITIATED )
      {
        f_IsInitializefail = BT_TRUE;
      }
      break;
                        
    case TIMER_ID_RUN_R1_4_NIBBLER_STATE_MACHINE:
      /* Release PTT and send nibbler to R1.4 */
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->PTT Time out release");
      #endif
      
      r1_4NibblerTimer = NULL;
      nibbler_ptt_state_decoder(&wirelessPTT_nibbler, PTT_KEYDOWN_BIT);
      //Disconnect the link as Nibbler PTT timeout occured
      SEND_MESSAGE_TO_CONNECTION_MNGR(SPP_DATA_COMM_ERROR, NULL, 0);      
      break;
   
    case TIMER_ID_RUN_R1_3_NIBBLER_STATE_MACHINE:
      /* Release PTT and send nibbler to R1.3 */
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->PTT Time out release\n");
      #endif
      
      r1_3NibblerTimer = NULL;
      nibbler_ptt_state_decoder(&headset_nibbler, PTT_KEYDOWN_BIT);
      //Disconnect the link as Nibbler PTT timeout occured
      SEND_MESSAGE_TO_CONNECTION_MNGR(HSP_NIBBLER_PTT_PRESS_TMO, NULL, 0);
      break;

    case TIMER_ID_RUN_DONGLE_PTT_PRESSED_STATE:
      /* Send Mute to R1.3 every 100 msec */
      ReverseNibblerSyncTimer = 0;
      if(nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE 
          && headset_status.Is_SPP_flow_enable == BT_TRUE)
      {  
          sendHspAgAtCmdRsp(REVERSE_NIBBLER);

          BT_reverse_nibbler_resend();
      }
      break;
      case TIMER_ID_RUN_SERVICE_NAME_CLOSE_CONN_TMO:
        if( (devptr = GetNextFilteredSPP()) != NULL)
        {          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Start paring with SPP\n");
          BT_PrintDeviceInfo(devptr);
          #endif
        
          ctrlState = BT_MNGR_CONTROL_SEND_R1_4_CREATE_BOND;
          RunCtrlStateMachine();
        }
        else if( (devptr = GetNextSPP()) != NULL)
        {            
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Service Name search\n");
          BT_RawLog("--->===================\n");
          BT_PrintDeviceInfo(devptr);
          #endif
        
          ctrlState = BT_MNGR_CONTROL_SEND_SDAP_SERVICE_SEARCH;
          RunCtrlStateMachine();
        }
        else
        {
          EndPhase ( &ctrlPhase, BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP );                
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Output message : BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK\n");
          #endif
          SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK, NULL , 0);
        }
      break;
    case TIMER_ID_RUN_AUDIODEV_AT_ESTABLISH_FAIL_TMO:      
      audiodev_atfail_TMO = NULL;
      if( (dev = BT_GetDevProfileInfo(HSP)) != NULL )
      {
        SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_DISCONNECT_REQUEST, dev, sizeof(btDevInfo));
      }
      
      break;
      
    case TIMER_ID_RUN_NONAUDIODEV_AT_ESTABLISH_FAIL_TMO:
      nonaudiodev_atfail_TMO = NULL;    
      if( (dev = BT_GetDevProfileInfo(SPP)) != NULL )
      {
        SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_DISCONNECT_REQUEST, dev, sizeof(btDevInfo));
      }
      
      break;

    case TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO:
      mptt_reply_TMO = NULL;
      
      if( headset_status.AT_cmd_state == AT_CMD_STATE_MPTT_CONNECTED )
      {
        if( headset_status.AT_cmd_retry_cnt++ < 3 )
        {
          if( headset_status.Is_AT_Handshaking_done == BT_TRUE
              && headset_status.Is_SPP_flow_enable == BT_TRUE 
              && headset_status.Is_comm_over_xnl_xcmp == BT_FALSE  
              && BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&spp_connect_at_cmd[0]
                  , sizeof(spp_connect_at_cmd) - 1) == BT_TRUE )
          {
            mptt_reply_TMO = BT_TimeoutReq(appSenderId,
                        TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO, /* user timer id */
                        0,                                /* userTimerData */
                        500);                             /* msTimeout */
          
            sendHspAgAtCmdRsp(REVERSE_NIBBLER);
          
            BT_reverse_nibbler_resend();
          }
        }
        else
        {
          headset_status.AT_cmd_state = AT_CMD_STATE_NON;
        }
      }
      else if( headset_status.AT_cmd_state == AT_CMD_STATE_MPTT_DISCONNECTED )
      {
        if( headset_status.AT_cmd_retry_cnt++ < 3 )
        {
          if( headset_status.Is_AT_Handshaking_done == BT_TRUE
              && headset_status.Is_SPP_flow_enable == BT_TRUE 
              && headset_status.Is_comm_over_xnl_xcmp == BT_FALSE  
              && BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&spp_disconnect_at_cmd[0]
                  , sizeof(spp_disconnect_at_cmd) - 1) == BT_TRUE )
          {
            mptt_reply_TMO = BT_TimeoutReq(appSenderId,
                        TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO, /* user timer id */
                        0,                                /* userTimerData */
                        500);                             /* msTimeout */
          
            sendHspAgAtCmdRsp(REVERSE_NIBBLER);
          
            BT_reverse_nibbler_resend();
          }
        }
        else
        {
          headset_status.AT_cmd_state = AT_CMD_STATE_NON;
        }
      }
      

      break;

    case TIMER_ID_BT_CHIP_HCIRESET_COMPLETE_FAIL_TMR :
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->Output message : BT RESET FAILURE \n");
      #endif
      
      SEND_MESSAGE_TO_CONNECTION_MNGR(BT_INIT_FAILED_ACK, NULL, 0);
      break;

    case TIMER_ID_BT_CHIP_HCI_PING_RETRY_TMO:
      //Retry the interchip ping message
      SEND_MESSAGE_TO_BLUETOOTH_MANAGER(HCI_PING_GET_BT_CHIP_RESPONSE, NULL, 0);
      break;
    default:
      break;
	}
    }
}
/* ===========================================================================
 * Function:    Cancel_HS_NibbleTimer
 * Description: Cancel NibblerTimer
 * =========================================================================== */
void Cancel_HS_NibbleTimer(void)
{
  BT_TimeoutCancel(r1_3NibblerTimer);
  r1_3NibblerTimer = NULL; 
}
/* ===========================================================================
 * Function:    Cancel_WPTT_NibbleTimer
 * Description: Cancel NibblerTimer
 * =========================================================================== */
void Cancel_WPTT_NibbleTimer(void)
{
  BT_TimeoutCancel(r1_4NibblerTimer);
  r1_4NibblerTimer = NULL; 
}
/* ===========================================================================
 * Function:    RestartR1_3NibbleTimer
 * Description: Restart NibblerTimer
 * =========================================================================== */
void RestartR1_3NibbleTimer(void )
  {
  if( r1_3NibblerTimer != NULL ) BT_TimeoutCancel(r1_3NibblerTimer);
  r1_3NibblerTimer = BT_TimeoutReq(appSenderId,
                      TIMER_ID_RUN_R1_3_NIBBLER_STATE_MACHINE, /* user timer id */
                      0,                                       /* userTimerData */
                      nibbler_ptt_press_timeout);              /* msTimeout */
}

/* ===========================================================================
 * Function:    RestartR1_4NibbleTimer 
 * Description: Restart NibblerTimer 
 * =========================================================================== */
void RestartR1_4NibbleTimer(void)
{
  if(r1_4NibblerTimer != NULL) BT_TimeoutCancel(r1_4NibblerTimer);
  r1_4NibblerTimer = BT_TimeoutReq(appSenderId,
                      TIMER_ID_RUN_R1_4_NIBBLER_STATE_MACHINE,  /* user timer id */
                      0,                                        /* userTimerData */
                      nibbler_ptt_press_timeout);               /* msTimeout */
      
}
/* ===========================================================================
 * Function:    store_data_for_hsp_xnl 
 * Description: Copy the decoded nibbler data for XNL layer processing 
 * =========================================================================== */
void send_data_for_hsp_xnl()
{
  BT_U8 i;
  BT_U8 temp_buffer[NIBBLER_BUFFER_MAX_SIZE_BYTES];
  BT_U8 temp_size = 0; 

  for( i = ptr_to_headset_nibbler_decoder_in_buffer->out_buffer_index
      ; i !=  ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index
      ; i++, i%= NIBBLER_BUFFER_MAX_SIZE_BYTES )
  {
    if (tc_flags.simulator_enable && tc_flags.simulator_type == TC_SIM_HOST)
    {    
      temp_buffer[temp_size++] = headset_nibbler_decoder_in_buffer[i];
    }
    else
    {
      xQueueSend( hsp_xnl_xcmp_data_rx_Q, &headset_nibbler_decoder_in_buffer[i], 0 ); 
    }
  }
  ptr_to_headset_nibbler_decoder_in_buffer->out_buffer_index = ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index;  

  
  #ifdef BT_ENABLE_SW_TST_UART
  //BT_U8 j;
  //BT_RawLog("DEV_2");
  //for ( j = 0; j < temp_size; j++)  BT_RawLog(" %.2x", temp_buffer[j]);
  //BT_RawLog("\n");  
  #endif
  if (tc_flags.simulator_enable && tc_flags.simulator_type == TC_SIM_HOST)
  {
    send_data_to_pc(temp_buffer, temp_size);
  }
}
/* ===========================================================================
 * Function:    store_data_for_spp_xnl 
 * Description: Copy the decoded nibbler data for XNL layer processing 
 * =========================================================================== */
void send_data_for_spp_xnl()
{
  BT_U8 i;

  for( i = ptr_to_wirelessPTT_nibbler_decoder_in_buffer->out_buffer_index
      ; i !=  ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index
      ; i++, i%= NIBBLER_BUFFER_MAX_SIZE_BYTES )
  {
    xQueueSend( spp_xnl_xcmp_data_rx_Q, &wirelessPTT_nibbler_decoder_in_buffer[i], 0 ); 
  }
  ptr_to_wirelessPTT_nibbler_decoder_in_buffer->out_buffer_index = ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index;  


  #ifdef BT_ENABLE_SW_TST_UART
  //BT_U8 j;
  //BT_RawLog("DEV_2");
  //for ( j = 0; j < temp_size; j++)  BT_RawLog(" %.2x", temp_buffer[j]);
  //BT_RawLog("\n");  
  #endif
}
/* ===========================================================================
 * Function:    HandleHspAgMessages
 * Description: Handler for messages from HSP HS profile
 * =========================================================================== */
static void HandleHspAgMessages(HSP_AG_IndConf *msg)
{

    char *str;
    btDevInfo* dev;
    BT_U8 NibblerData;
    BT_U8 NibblerSize;
    
    switch ( msg->header.primitive )
    {
          case HSP_AG_CONNECT_CFM:
              if( msg->connectCfm.result == HSP_AG_OK)
              {
                headset_status.Is_connected = BT_TRUE;
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->AG Connection Successful  !!!!\n");
                #endif
                
                /* If Connection Timer is still Running Stop Connecting Timer */
                if(hsConnectingTimerId != NULL)
                {
                  BT_TimeoutCancel(hsConnectingTimerId );
                  hsConnectingTimerId = NULL;
                }  
                isHsConnIncomming = BT_FALSE;
              }  
              else 
              {
                headset_status.Is_connected = BT_FALSE;
                if((dev = BT_GetDevProfileInfo(HSP)) != NULL)
                {
                 /* If Connection Timer is Running we will try again to
                  * To get connected with previosly Connected Device 
                  *
                  */
                  #ifdef BT_ENABLE_SW_TST_UART
                  BT_RawLog("--->AG Connection Failed  !!!!\n");
                  #endif
                  
                  if( hsConnectingTimerId == NULL )
                  {
                    /* should end phanse so that can start 2nd round of reconnection 
                     * Need to put some handler here, don't kow where connection request come from
                    */
                    EndPhase( &hspPhase,BT_MNGR_HSP_CONNECT_OR_DISCONNECT ); 

                    #ifdef BT_ENABLE_SW_TST_UART
                    BT_RawLog("--->Output message : BT_CONNECT_TIMEOUT_ACK HS_15000\n");
                    #endif
                    
                    SEND_MESSAGE_TO_CONNECTION_MNGR(BT_CONNECT_TIMEOUT_ACK, dev , sizeof(btDevInfo));
                  }
                  else
                  {
                    isR1_3awaitingTMO = BT_TRUE;
                  }
                }
              }
              break;

          case HSP_AG_CONNECT_IND:
              if(isBQBModeOn)
              {
                 BT_MNGR_SendHspAgConnectRsp(BT_TRUE);
                 isHsConnIncomming = BT_TRUE;
              } 
              else
              {
                if( (dev = BT_GetDevProfileInfo(HSP)) != NULL )
                {
                  if( CompareBTAddress( dev->addr, msg->connectInd.bdAddr) 
                    && (headset_status.Is_connection_allow == BT_TRUE) )
                  {
                    if(hsConnectingTimerId != NULL)
                    {
                      BT_TimeoutCancel(hsConnectingTimerId );
                      hsConnectingTimerId = NULL;
                    }  

                    headset_status.Is_LinkLost              = BT_FALSE;
                    headset_status.Is_connected             = BT_FALSE;
                    headset_status.Is_SPP_connected         = BT_FALSE;
                    headset_status.Is_SPP_flow_enable       = BT_FALSE;
                    headset_status.Is_SCO_connected         = BT_FALSE;
                    headset_status.Is_NIBBLER_enable        = BT_FALSE;    
                    headset_status.Is_AT_Handshaking_done   = BT_FALSE;
                    headset_status.AT_cmd_state             = AT_CMD_STATE_NON;
                    headset_status.AT_cmd_retry_cnt         = 0;
                    headset_status.Is_nibbler_decoding_done = FALSE;
                    headset_status.Is_comm_over_xnl_xcmp    = BT_FALSE; 
                    BT_MNG_Clear_Audiodev_NibblerBuffer();
                    
                    BT_MNGR_SendHspAgConnectRsp(BT_TRUE);
                  }
                  else
                  {
                    BT_MNGR_SendHspAgConnectRsp(BT_FALSE);
                  }
                }
                else
                {
                  /* bluetooth address not in database */
                  BT_MNGR_SendHspAgConnectRsp(BT_FALSE);
                }
              }
              break;

          case HSP_AG_LINK_STATUS_IND:
              /* Check for the ACL Connection */
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->AG Connection HSP_AG_LINK_STATUS_IND \n");
              #endif
              
              if(msg->linkStatusInd.aclStatus !=  HSP_AG_CONNECTED)
              {                
                  headset_status.Is_SPP_connected = BT_FALSE;
                  if( headset_status.Is_SCO_connected == BT_FALSE )
                  {
                    headset_status.Is_connected = BT_FALSE;
                  }
                  
                  isRingOn= BT_FALSE;
                  EndPhase( &hspPhase,BT_MNGR_HSP_CONNECT_OR_DISCONNECT );
                  memcpy(tempDevInfo.addr,msg->linkStatusInd.bdAddr,sizeof(BT_BdAddr));

                  #ifdef BT_ENABLE_SW_TST_UART
                  BT_RawLog("--->Output message : BT_DISCONNECTED_ACK 1\n");
                  #endif
                  
                  if( r1_4ConnectingDelay != NULL ) 
                  {
                    BT_TimeoutCancel(r1_4ConnectingDelay);
                    r1_4ConnectingDelay = NULL;
                  }
                  if(r1_4ConnectingTimerId != NULL)
                  {
                    BT_TimeoutCancel(r1_4ConnectingTimerId);
                    r1_4ConnectingTimerId = NULL;
                  }
                  if( audiodev_atfail_TMO != NULL ) 
                  {
                    BT_TimeoutCancel(audiodev_atfail_TMO);
                    audiodev_atfail_TMO = NULL;
                  }


                  if( headset_status.Is_connected == BT_FALSE )
                  {
				  //VGXT68: Disconnect message when link lost or normal disconnection
                    if(headset_status.Is_LinkLost == BT_TRUE)
                    {
                      SEND_MESSAGE_TO_CONNECTION_MNGR( BT_LINKLOST_DISCONNECTED_ACK, &tempDevInfo , sizeof(btDevInfo));
                    }
                    else
                    {
                      SEND_MESSAGE_TO_CONNECTION_MNGR( BT_DISCONNECTED_ACK, &tempDevInfo , sizeof(btDevInfo));
                    }
                  }
                  isHsConnected = BT_FALSE;
              }
              else
              {              
                headset_status.Is_SPP_connected = BT_TRUE;
              }     
              break;

         case HSP_AG_CONFIG_IND:
              /* other side of the connection has requested a change of framesize */
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->AG Connection HSP_AG_CONFIG_IND \n");
              #endif
              break;

         case HSP_AG_FLOW_IND:
              if( ((dev = BT_GetDevProfileInfo(HSP)) != NULL)
                && (CompareBTAddress( dev->addr, msg->flowInd.bdAddr)) )
              {
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->AG Connection HSP_AG_FLOW_IND = %d\n", msg->flowInd.remoteReadyToReceive);
                #endif
            
                SEND_MESSAGE_TO_CONNECTION_MNGR( BT_CONNECT_ACL_SUCCESS_ACK, dev, sizeof(btDevInfo)); 

                if(msg->flowInd.remoteReadyToReceive == TRUE)
                {
                  if(isBQBModeOn)
                  {  
                    if(!isHsConnIncomming)
                    {   
                      #ifdef BT_ENABLE_SW_TST_UART
                      BT_RawLog("ttttt Send Ring \n");
                      #endif

                      sendHspAgAtCmdRsp(RING_AT_CMD);
                    }
                  }
                  else
                  {
                    headset_status.Is_SPP_flow_enable = BT_TRUE;
                    if( headset_status.Is_SPP_connected != BT_TRUE )
                    {
                      headset_status.Is_SPP_connected = BT_TRUE;
                    }
                    if( headset_status.Is_connected != BT_TRUE )
                    {
                      headset_status.Is_connected = BT_TRUE;
                    }

                    if(GetScoStatus(msg->flowInd.bdAddr) == SCO_NOT_CONNECTED)
                    {
                      if( pairing_mode == PAIRING_PAIRING_MODE_STANDARD )
                      {
                        /*Start Sending Ring Command */
                        isRingOn= BT_TRUE;
                        isAcceptCKPD = BT_FALSE;
                        ringCnt = 0;
                        SendRINGCommand();
                      }  
                      else
                      {
                        if( dev->IsNibblerDefaultON == BT_TRUE )
                        {
                          enable_nibbler(&headset_nibbler);
                          headset_status.Is_NIBBLER_enable      = BT_TRUE;

                          if( audiodev_atfail_TMO != NULL )BT_TimeoutCancel(audiodev_atfail_TMO);
                          audiodev_atfail_TMO = BT_TimeoutReq(appSenderId,
                                      TIMER_ID_RUN_AUDIODEV_AT_ESTABLISH_FAIL_TMO, /* user timer id */
                                      0,                                           /* userTimerData */
                                      10000);                                      /* msTimeout */
                          
                          if(GetScoStatus(msg->flowInd.bdAddr) == SCO_NOT_CONNECTED)
                          {
                              hspState = BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ;
                              RunHspStateMachine();
                          }
                        }
                      }
                        
                      /* initialize state for controm manager */              
                      nibbler_ptt_state_decoder(&headset_nibbler, PTT_KEYDOWN_BIT);
                        
                    }
                    else if(nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE)
                    {
                      /* resume 100 syncronize time */
                      sendHspAgAtCmdRsp(REVERSE_NIBBLER);
                      
                      BT_reverse_nibbler_resend();
                    }
                  }
                }
                else
                {
                  /* ACL link busy */

                  headset_status.Is_SPP_flow_enable = BT_FALSE;
                  if( nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE )
                  {
                    if( ReverseNibblerSyncTimer != 0 )
                    {
                      BT_TimeoutCancel(ReverseNibblerSyncTimer);
                      ReverseNibblerSyncTimer = 0;
                    }
                  }
                }
              }
              else
              {
                if(msg->flowInd.remoteReadyToReceive == TRUE)
                {
                  hspState = BT_MNGR_HSP_SEND_DISCONNECT_REQ;  /* disconnect ACL */
                  RunHspStateMachine();

                  #ifdef BT_ENABLE_SW_TST_UART
                  BT_RawLog("---> BT_MNGR_HSP_SEND_DISCONNECT_REQ 1\n");
                  #endif
                }
              }
              break;


         case HSP_AG_NIBBLER_IND: 
              for( NibblerSize = 0; NibblerSize < msg->nibblerInd.size; NibblerSize++)
              {
                NibblerData = msg->nibblerInd.nibbler[NibblerSize];

                //#ifdef BT_ENABLE_SW_TST_UART
                //BT_RawLog("0N%.2x ", NibblerData);
                //#endif
                
                nibbler_ptt_state_decoder(&headset_nibbler, NibblerData);
                if(prev_ptt_state != (NibblerData & NIBBLER_PTT_STATE_MASK))
                {
                  prev_ptt_state = (NibblerData & NIBBLER_PTT_STATE_MASK);
                }
                else
                {
                  if((NibblerData & NIBBLER_DATA_BIT_MASK) && (prev_ptt_state != NIBBLER_PTT_STATE_MASK)) 
                  {
                    reverse_nibbler_tx_null_nibble(NibblerData);
                    null_data_nibble_rxd = true;
                  }
                }
                nibbler_data_decoder(&headset_nibbler, NibblerData);
                headset_status.Is_nibbler_decoding_done = TRUE;
              }
              // Send the data to XNL Layer
              if(headset_status.Is_AT_Handshaking_done == BT_TRUE)
              {
                if(headset_status.Is_nibbler_decoding_done == TRUE)
                {
                  // Only if there is new data available 
                  if(ptr_to_headset_nibbler_decoder_in_buffer->out_buffer_index != 
                                    ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index)
                  {
                    send_data_for_hsp_xnl();
                  }
                  headset_status.Is_nibbler_decoding_done = FALSE;
                }
              }
              if((NibblerData & PTT_KEYUPDOWN_MASK) == PTT_KEYUP_BIT )
              {
                /*Do not Schedule Timeout Timer as Local GW PTT is pressed */
                if(local_PttPress == FALSE)
                {
                  RestartR1_3NibbleTimer();
                }
              }
              else
              {
                if( r1_3NibblerTimer != NULL )
                {
                  BT_TimeoutCancel(r1_3NibblerTimer);
                  r1_3NibblerTimer = NULL; 
                }
              }
              break;

         case HSP_AG_AT_IND:
              str = msg->atInd.details;
            
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->AG Connection HSP_AG_AT_IND  = %s \n",str);
              #endif
              
              /* Check for AT CommandS*/
              if(!strcmp(str,"AT+CKPD=200"))
              {
                  if(isBQBModeOn)
                  {
                      sendHspAgAtCmdRsp(OK_AT_CKPD_CMD);
                      
                      if((dev = BT_GetDevProfileInfo(HSP)) != NULL)
                      {
                        if(GetScoStatus(dev->addr) == SCO_NOT_CONNECTED)
                        {  
                            hspState = BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ;
                            RunHspStateMachine();
                        }    
                        else if(GetScoStatus(dev->addr) == SCO_CONNECTED)
                        {
                            hspState = BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ;
                            RunHspStateMachine();
                        }
                      }
                  } 
                  else
                  {
                      
                      if(isRingOn)
                      {	
                        isRingOn = BT_FALSE;
                        ringCnt = 0;

                        sendHspAgAtCmdRsp(OK_AT_CKPD_CMD);
      
                        hspState = BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ;
                        RunHspStateMachine();
                      }
                      else if(isAcceptCKPD)
                      {
                        sendHspAgAtCmdRsp(OK_AT_CKPD_CMD);
                        isAcceptCKPD = BT_FALSE;
      
                        hspState = BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ;
                        RunHspStateMachine();
                      }
                      else
                      {
                        sendHspAgAtCmdRsp(OK_AT_CKPD_CMD);
                      }
                   }                  
              }
              else if(!strcmp(str,"AT+CGMM"))
              {
                  sendHspAgAtCmdRsp(CGMM_AT_CMD_IND);
              }

              else if(!strcmp(str,"AT+NIBBLER=0"))
              {
                  sendHspAgAtCmdRsp(OK_AT_NIBBLER_CMD);
                  enable_nibbler(&headset_nibbler);
                  headset_status.Is_NIBBLER_enable = BT_TRUE;
                  
                  if(GetScoStatus(msg->flowInd.bdAddr) == SCO_NOT_CONNECTED)
                  {
                      hspState = BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ;
                      RunHspStateMachine();

                  }
              }
             break;
	
          case HSP_AG_NOT_CONGESTED_IND:
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->AG Connection HSP_AG_NOT_CONGESTED_IND \n");
              #endif
           break;

         /* Audio related cases */
          case HSP_AG_AUDIO_CONNECT_CFM:
               #ifdef BT_ENABLE_SW_TST_UART
               BT_RawLog("--->AG AUDIO Connection established !!!!\n");
               #endif
               break;


          case HSP_AG_AUDIO_DISCONNECT_CFM:
             break;

          case HSP_AG_AUDIO_CONNECT_IND:
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("--->AG AUDIO Connection HSP_AG_AUDIO_CONNECT_IND\n");
            #endif
            if( (dev = BT_GetDevProfileInfo(HSP)) != NULL )
            {
              if(CompareBTAddress( dev->addr, msg->connectInd.bdAddr) )
              {
                BT_MNGR_SendHsAgAudioConnectRsp(BT_TRUE);
              }
              else
              {
                BT_MNGR_SendHsAgAudioConnectRsp(BT_FALSE);
              }
            }
            break;

         case HSP_AG_AUDIO_CONNECTION_STATUS_IND:
      if( ((dev = BT_GetDevProfileInfo(HSP)) != NULL)
          && (CompareBTAddress( dev->addr, msg->audioConnectionStatusInd.bdAddr)) )
      {
        if(msg->audioConnectionStatusInd.audioConnected == BT_TRUE)
        {
          /* SCO link connected */
          headset_status.Is_SCO_connected = BT_TRUE;
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Connection Status = TRUE\n");
          #endif

          EndPhase( &hspPhase,BT_MNGR_HSP_CONNECT_OR_DISCONNECT );

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Output message : BT_CONNECT_SUCCESS_ACK 1\n");
          #endif

          SEND_MESSAGE_TO_CONNECTION_MNGR( BT_CONNECT_SUCCESS_ACK, dev, sizeof(btDevInfo)); 

          /* Copy the SCO Handle and Load the CSR DSP using the SCO Handle */
          sco_handle = (BT_U16)msg->audioConnectionStatusInd.audioConnectionHandle;
          if(hw_audio_detect == CP_SELECT_OFF)
          {          
            vm_cmd_send_state = LOAD_DSP_CMD;
            SEND_MESSAGE_TO_BLUETOOTH_MANAGER(DEVICE_SEND_VM_CMD, NULL, 0);    
          }

          if( pairing_mode == PAIRING_PAIRING_MODE_MPP
            && dev->IsNibblerDefaultON == BT_TRUE )
          {
            if( ((dev = BT_GetDevProfileInfo(HSP)) != NULL)
              && (HCI_GetConnectionHandle( dev->addr,&R1_3_connectionHandle) == BT_TRUE) )
            {  
              hspPhase = BT_MNGR_HSP_SETUP_QOS;
              hspState = BT_MNGR_HSP_QOS_SETUP;
              RunHspStateMachine();
            }     
          }

          isHsConnected = BT_TRUE;
        }
        else
        {
          /* SCO link NOT connected */
          headset_status.Is_SCO_connected       = BT_FALSE;
          if( headset_status.Is_SPP_connected == BT_FALSE )
          {
            headset_status.Is_connected = BT_FALSE;
          }
			/*Get the audion connection status reason( HCI_CONNECTION_TIMEOUT = Link Lost)*/
          if( msg->audioConnectionStatusInd.reason == HCI_CONNECTION_TIMEOUT )
          {
            headset_status.Is_LinkLost = BT_TRUE;
          }
          else
          {      
            headset_status.Is_LinkLost = BT_FALSE;
          }
          
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Connection Status = FALSE\n");
          #endif

          if( hspPhase == BT_MNGR_HSP_CONNECT_OR_DISCONNECT )
          {
            hspState = BT_MNGR_HSP_SEND_DISCONNECT_REQ;
            RunHspStateMachine();

            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("---> BT_MNGR_HSP_SEND_DISCONNECT_REQ 3\n");
            #endif
          }
          EndPhase( &hspPhase,BT_MNGR_HSP_CONNECT_OR_DISCONNECT );

          disable_nibbler(&headset_nibbler);

          headset_status.Is_NIBBLER_enable = BT_FALSE;
          headset_status.Is_AT_Handshaking_done = BT_FALSE;
          headset_status.Is_nibbler_decoding_done = FALSE;
          headset_status.Is_comm_over_xnl_xcmp = BT_FALSE;
          
          memcpy(tempDevInfo.addr,msg->audioConnectionStatusInd.bdAddr,sizeof(BT_BdAddr));

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Output message : BT_DISCONNECTED_ACK 2\n");
          #endif

          if( r1_4ConnectingDelay != NULL ) 
          {
            BT_TimeoutCancel(r1_4ConnectingDelay);
            r1_4ConnectingDelay = NULL;
          }
          if( r1_4ConnectingTimerId != NULL)
          {
            BT_TimeoutCancel(r1_4ConnectingTimerId);
            r1_4ConnectingTimerId = NULL;
          }          
 
          if( headset_status.Is_connected == BT_FALSE )
          {
		  //VGXT68: Disconnect message when link lost or normal disconnection
            if( headset_status.Is_LinkLost == BT_TRUE)
            {     
              SEND_MESSAGE_TO_CONNECTION_MNGR( BT_LINKLOST_DISCONNECTED_ACK, &tempDevInfo , sizeof(btDevInfo));
            }
            else
            {           
              SEND_MESSAGE_TO_CONNECTION_MNGR( BT_DISCONNECTED_ACK, &tempDevInfo , sizeof(btDevInfo));
            }
            
         }

          
          isHsConnected = BT_FALSE;
        }
      }
      else                                                                  /* bt address is not in the database */
      {
        if(msg->audioConnectionStatusInd.audioConnected == BT_TRUE)         /* SCO connected */
        {
          hspState = BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ;                 /* disconnect SCO */
          RunHspStateMachine();

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ\n");
          #endif
        }
        else                                                                /* SCO disconnected */
        {
          hspState = BT_MNGR_HSP_SEND_DISCONNECT_REQ;                       /* disconnect ACL */
          RunHspStateMachine();

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> BT_MNGR_HSP_SEND_DISCONNECT_REQ 2\n");
          #endif
        }
      }
      break;

    default:
      BT_DebugUnknownPermitive (msg->header.primitive);  
      break;
  }
}

/* ===========================================================================
 * Function:    HandleSppDevMessages
 * Description: Handler for SPP
 * =========================================================================== */
static void HandleSppDevMessages(SPP_DEV_IndConf *msg)
{
    char *str;
    BT_U8 nibblerByte;
    BT_U8 nibblerSize;
    btDevInfo* dev;
      
    switch ( msg->header.primitive )
    {
         
          case SPP_DEV_CONNECT_CFM:
            if( (dev = BT_GetDevProfileInfo(SPP)) != NULL )
            {
              if(msg->connectCfm.result == SPP_DEV_OK)
              {
                  
                 if( r1_4ConnectingDelay != NULL ) 
                 {
                    BT_TimeoutCancel(r1_4ConnectingDelay);
                    r1_4ConnectingDelay = NULL;
                 }
                 if(r1_4ConnectingTimerId != NULL)
                 {
                   BT_TimeoutCancel(r1_4ConnectingTimerId);
                   r1_4ConnectingTimerId = NULL;
                 } 

                 /* initialize state for control manager */              
                 nibbler_ptt_state_decoder(&wirelessPTT_nibbler, PTT_KEYDOWN_BIT);
          
                 EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );

                 #ifdef BT_ENABLE_SW_TST_UART
                 BT_RawLog("--->Output message : BT_CONNECT_SUCCESS_ACK 2\n");                 
                 #endif

                 SEND_MESSAGE_TO_CONNECTION_MNGR( BT_CONNECT_SUCCESS_ACK, dev , sizeof(btDevInfo)); 
              }
              else
              {
                  /* Connection Failed */
                  /* Check wheather R1.4 Connecting Timer is Running */
                  if(r1_4ConnectingTimerId == NULL)
                  {
                    if( (dev = BT_GetDevProfileInfo(SPP)) != NULL )
                    {
                      
                      EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );

                      SEND_MESSAGE_TO_CONNECTION_MNGR(BT_CONNECT_TIMEOUT_ACK, dev , sizeof(btDevInfo));

                      #ifdef BT_ENABLE_SW_TST_UART
                      BT_RawLog("--->Output message : BT_CONNECT_TIMEOUT_ACK R14_15000\n");
                      #endif
                    }
                  }                  
                  else
                  {
                    isR1_4awaitingTMO = BT_TRUE;
                  }
              } 
            }
            else
            {
              sppState = BT_MNGR_SPP_SEND_DISCONNECT_REQ;
              RunSppStateMachine();

              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->Error : SPP_DEV_CONNECT_CFM 2\n");
              #endif
            }
            break;

           case SPP_DEV_CONNECT_IND:
              if ((dev = BT_GetDevProfileInfo(SPP)) != NULL)
              {
                if( (CompareBTAddress( dev->addr, msg->connectInd.bdAddr))
                  && (wirelessPTT_status.Is_connection_allow == BT_TRUE) )
                {
                        if( r1_4ConnectingDelay != NULL ) 
                        {
                           BT_TimeoutCancel(r1_4ConnectingDelay);
                           r1_4ConnectingDelay = NULL;
                        }
                        if(r1_4ConnectingTimerId != NULL)
                        {
                          BT_TimeoutCancel(r1_4ConnectingTimerId);
                          r1_4ConnectingTimerId = NULL;
                        } 

                        wirelessPTT_status.Is_LinkLost              = BT_FALSE;
                        wirelessPTT_status.Is_connected             = BT_FALSE;
                        wirelessPTT_status.Is_SPP_connected         = BT_FALSE;
                        wirelessPTT_status.Is_SPP_flow_enable       = BT_FALSE;
                        wirelessPTT_status.Is_SCO_connected         = BT_FALSE;
                        wirelessPTT_status.Is_NIBBLER_enable        = BT_FALSE;    
                        wirelessPTT_status.Is_AT_Handshaking_done   = BT_FALSE;
                        wirelessPTT_status.AT_cmd_state             = AT_CMD_STATE_NON;
                        wirelessPTT_status.AT_cmd_retry_cnt         = 0;
                        wirelessPTT_status.Is_nibbler_decoding_done = FALSE;
                        wirelessPTT_status.Is_comm_over_xnl_xcmp    = BT_FALSE;
                        BT_MNG_Clear_NonAudiodev_NibblerBuffer();

                        BT_MNGR_SendSppConnectRsp(BT_TRUE);

                        #ifdef BT_ENABLE_SW_TST_UART
                        BT_RawLog("--->Spp connection accept 1\n");
                        #endif
                        
                    }
                    else
                    {
                  BT_MNGR_SendSppConnectRsp(BT_FALSE);
                  #ifdef BT_ENABLE_SW_TST_UART
                  BT_RawLog("--->Spp connection reject 1\n");
                  #endif
                }
              }
              else
              {
                BT_MNGR_SendSppConnectRsp(BT_FALSE);
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Spp connection reject 2\n");
                #endif
              }
              break;
              
          case SPP_DEV_FLOW_IND:
            if( (dev = BT_GetDevProfileInfo(SPP)) != NULL )
            {
              if(msg->flowInd.remoteReadyToReceive)
              {
                wirelessPTT_status.Is_SPP_flow_enable = BT_TRUE;

                if( r1_4ConnectingDelay != NULL ) 
                {
                  BT_TimeoutCancel(r1_4ConnectingDelay);
                  r1_4ConnectingDelay = NULL;
                }
                if(r1_4ConnectingTimerId != NULL)
                {
                  BT_TimeoutCancel(r1_4ConnectingTimerId);
                  r1_4ConnectingTimerId = NULL;
                }
                if( pairing_mode == PAIRING_PAIRING_MODE_MPP )
                {  
                if( nonaudiodev_atfail_TMO != NULL )BT_TimeoutCancel(nonaudiodev_atfail_TMO);
                nonaudiodev_atfail_TMO = BT_TimeoutReq(appSenderId,
                            TIMER_ID_RUN_NONAUDIODEV_AT_ESTABLISH_FAIL_TMO, /* user timer id */
                            0,                                              /* userTimerData */
                            10000);                                         /* msTimeout */
                }
                if(isHsConnected == BT_TRUE 
                  && nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE )
                {
                  if(  headset_status.Is_AT_Handshaking_done == BT_TRUE
                       && headset_status.Is_SPP_flow_enable == BT_TRUE 
                       && headset_status.Is_comm_over_xnl_xcmp == BT_FALSE  
                       && BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&spp_connect_at_cmd[0]
                    , sizeof(spp_connect_at_cmd) - 1) == BT_TRUE)
                  {
                  
                    headset_status.AT_cmd_state = AT_CMD_STATE_MPTT_CONNECTED;
                    headset_status.AT_cmd_retry_cnt = 0;
                    if( mptt_reply_TMO != NULL )BT_TimeoutCancel(mptt_reply_TMO);
                    mptt_reply_TMO = BT_TimeoutReq(appSenderId,
                                TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO, /* user timer id */
                                0,                                /* userTimerData */
                                500);                             /* msTimeout */


                    sendHspAgAtCmdRsp(REVERSE_NIBBLER);
                
                    BT_reverse_nibbler_resend();
                  }
                }                  
                if( dev->IsNibblerDefaultON == BT_TRUE )
                {
                  enable_nibbler(&wirelessPTT_nibbler);
                }

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_CONNECT_SUCCESS_ACK 3\n");
                #endif

                EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );
                SEND_MESSAGE_TO_CONNECTION_MNGR(BT_CONNECT_SUCCESS_ACK,dev , sizeof(btDevInfo)); 

                if( pairing_mode == PAIRING_PAIRING_MODE_MPP
                  && dev->IsNibblerDefaultON == BT_TRUE )
                {
                  if( ((dev = BT_GetDevProfileInfo(SPP)) != NULL)
                    && (HCI_GetConnectionHandle( dev->addr,&R1_4_connectionHandle) == BT_TRUE) )
                  {  
                    sppPhase = BT_MNGR_SPP_SETUP_QOS;
                    sppState = BT_MNGR_SPP_QOS_SETUP;
                    RunSppStateMachine();
                  }     
                }                
              }
              else
              {
                wirelessPTT_status.Is_SPP_flow_enable = BT_FALSE;
                
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_CONNECT_SUCCESS_ACK 3\n");
                #endif
              }
            }
            else
            {
              /* if device not in database, then just disconnect that device */
              sppState = BT_MNGR_SPP_SEND_DISCONNECT_REQ;
              RunSppStateMachine();

              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->Error : SPP_DEV_FLOW_IND fail\n");
              #endif
            }
            break;
              
          case SPP_DEV_LINK_STATUS_IND:
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("--->AG Connection SPP_DEV_LINK_STATUS_IND \n");
            #endif
            
            if( (dev = BT_GetDevProfileInfo(SPP)) != NULL )
            {
              /* Check for the ACL Connection */
              if(msg->linkStatusInd.aclStatus ==  SPP_DEV_CONNECTED)
              {

                wirelessPTT_status.Is_connected = BT_TRUE;

                if(isHsConnected == BT_TRUE 
                  && nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE )
                {
                  if( headset_status.Is_AT_Handshaking_done == BT_TRUE 
                    && headset_status.Is_SPP_flow_enable == BT_TRUE 
                    && headset_status.Is_comm_over_xnl_xcmp == BT_FALSE
                    && BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&spp_connect_at_cmd[0]
                        , sizeof(spp_connect_at_cmd) - 1) == BT_TRUE )
                  {
                    sendHspAgAtCmdRsp(REVERSE_NIBBLER);

                    
                    headset_status.AT_cmd_state = AT_CMD_STATE_MPTT_CONNECTED;
                    headset_status.AT_cmd_retry_cnt = 0;
                    if( mptt_reply_TMO != NULL )BT_TimeoutCancel(mptt_reply_TMO);
                    mptt_reply_TMO = BT_TimeoutReq(appSenderId,
                                TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO, /* user timer id */
                                0,                                /* userTimerData */
                                500);                             /* msTimeout */
                
                    BT_reverse_nibbler_resend();
                  }
                }                  

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_CONNECT_SUCCESS_ACK 4\n");
                #endif

                EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );
                SEND_MESSAGE_TO_CONNECTION_MNGR(BT_CONNECT_SUCCESS_ACK, dev, sizeof(btDevInfo)); 
              }
              else
              {
                wirelessPTT_status.Is_connected = BT_FALSE;
                wirelessPTT_status.Is_SPP_flow_enable = BT_FALSE;

                if( nonaudiodev_atfail_TMO != NULL ) 
                {
                  BT_TimeoutCancel(nonaudiodev_atfail_TMO);
                  nonaudiodev_atfail_TMO = NULL;
                }

                if(isHsConnected == BT_TRUE 
                  && nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE )
                {
                  if( headset_status.Is_AT_Handshaking_done == BT_TRUE
                     && headset_status.Is_SPP_flow_enable == BT_TRUE
                     && headset_status.Is_comm_over_xnl_xcmp == BT_FALSE
                     && BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&spp_disconnect_at_cmd[0]
                    , sizeof(spp_disconnect_at_cmd) - 1) == BT_TRUE)
                  {
                    sendHspAgAtCmdRsp(REVERSE_NIBBLER);

                    headset_status.AT_cmd_state = AT_CMD_STATE_MPTT_DISCONNECTED;
                    headset_status.AT_cmd_retry_cnt = 0;
                    if( mptt_reply_TMO != NULL )BT_TimeoutCancel(mptt_reply_TMO);
                    mptt_reply_TMO = BT_TimeoutReq(appSenderId,
                                TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO, /* user timer id */
                                0,                                /* userTimerData */
                                500);                             /* msTimeout */

                    BT_reverse_nibbler_resend();
                  }
                }                  
                disable_nibbler(&wirelessPTT_nibbler);
                  
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_DISCONNECTED_ACK 3\n");
                #endif

                EndPhase (&sppPhase, BT_MNGR_SPP_CONNECT_OR_DISCONNECT );
                SEND_MESSAGE_TO_CONNECTION_MNGR(BT_DISCONNECTED_ACK, dev, sizeof(btDevInfo)); 
              }
            }
            else
            {
              sppState = BT_MNGR_SPP_SEND_DISCONNECT_REQ;
              RunSppStateMachine();
            }
            break;
 
          case SPP_DEV_AT_IND:
              str = msg->atInd.details;
                 
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->#### SPP_AT_CMD  = %s \n",str);
              #endif
              
              /* Check for AT CommandS */
              if(!strcmp(str,"AT+RFCOMM=?"))
              {
                  sendSppAtCmdRsp(RFCOMM_IND);
                    
              } 
              else if(!strcmp(str,"AT+CGMM"))
              {
                  sendSppAtCmdRsp(CGMM_IND);
              }
              else if(!strcmp(str,"AT+NIBBLER=0"))
              {
                  sendSppAtCmdRsp(NIBBLER_IND);
              }
              break;
      
          case SPP_DEV_NIBBLER_IND: 
            for( nibblerSize = 0; nibblerSize < msg->nibblerInd.size; nibblerSize++ )
            {
              nibblerByte = msg->nibblerInd.nibbler[nibblerSize];

              //#ifdef BT_ENABLE_SW_TST_UART
              //BT_RawLog("0n%.2x ", nibblerByte);
              //#endif

              nibbler_ptt_state_decoder(&wirelessPTT_nibbler, nibblerByte);
              nibbler_data_decoder(&wirelessPTT_nibbler, nibblerByte);
              wirelessPTT_status.Is_nibbler_decoding_done = TRUE;
            }
            // Send the data to XNL Layer
            if(wirelessPTT_status.Is_AT_Handshaking_done == BT_TRUE)
            {
              if(wirelessPTT_status.Is_nibbler_decoding_done == TRUE)
              {
                // Only if there is new data available 
                if(ptr_to_wirelessPTT_nibbler_decoder_in_buffer->out_buffer_index != 
                                  ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index)
                {
                  send_data_for_spp_xnl();
                }
                wirelessPTT_status.Is_nibbler_decoding_done = FALSE;
              }
            }            
            if((nibblerByte & PTT_KEYUPDOWN_MASK) == PTT_KEYUP_BIT )
            {
              RestartR1_4NibbleTimer();
            }
            else
            {
              if( r1_4NibblerTimer != NULL )
              {
                BT_TimeoutCancel(r1_4NibblerTimer);
                r1_4NibblerTimer = NULL;
              }
            }
              break;


      default:
        BT_DebugUnknownPermitive (msg->header.primitive);  
        break;
   }
}

/* ===========================================================================
 * Function:    SendRINGCommand
 * Description: Send Repeated Ring Commands
 * =========================================================================== */
void SendRINGCommand()
{
  ringCnt++;   
  if(isRingOn && (ringCnt <= MAX_RING_INDICATION))
  {
    #ifdef BT_ENABLE_SW_TST_UART
    BT_RawLog("--->ttttt Send Ring \n");
    #endif

    sendHspAgAtCmdRsp(RING_AT_CMD);
    
    if( ringTimerId != NULL )BT_TimeoutCancel(ringTimerId);
    ringTimerId = BT_TimeoutReq(appSenderId,
    TIMER_ID_RUN_RING_CMD_STATE_MACHINE,  //user timer id 
                0,                           // userTimerData 
                3000);   // msTimeout 
    ringTimerId = ringTimerId; // CCMPD01410054 (JJ 8/11/2010)
  }
  else if(ringCnt > MAX_RING_INDICATION)
  {
    isRingOn = BT_FALSE;
    ringCnt = 0;
    #ifdef BT_ENABLE_SW_TST_UART
    BT_RawLog("--->Output message : BT_HS_RING_TIMEOUT\n");
    #endif
    SEND_MESSAGE_TO_CONNECTION_MNGR( BT_HS_RING_TIMEOUT, NULL, 0); 
  }  
}

/* ===========================================================================
 * Function:    CompareBTAddress
 * Description: Compare Bluetooth Address
 * =========================================================================== */
BT_BOOL CompareBTAddress(BT_U8 *addr1, BT_U8 *addr2)
{
  if(addr1[0] == addr2[0] &&
     addr1[1] == addr2[1] &&
     addr1[2] == addr2[2] &&
     addr1[3] == addr2[3] &&
     addr1[4] == addr2[4] &&
     addr1[5] == addr2[5] )
    return BT_TRUE;
  else
    return BT_FALSE;

}

/* ===========================================================================
 * Function:    CompareBTAddress
 * Description: Compare Bluetooth Address with a successed paired address
 * Note       : The address sequencing is reversed when it passed from MPP manager
 * =========================================================================== */
BT_BOOL ComparePairedBTAddress(BT_U8 *addr1, BT_U8 *addr2)
{
  if(addr1[0] == addr2[5] &&
     addr1[1] == addr2[4] &&
     addr1[2] == addr2[3] &&
     addr1[3] == addr2[2] &&
     addr1[4] == addr2[1] &&
     addr1[5] == addr2[0] )
    return BT_TRUE;
  else
    return BT_FALSE;

}

/* ===========================================================================
 * Function:    HandleHciMessages
 * Description: Handler for messages from HCI Driver
 * =========================================================================== */
static void HandleHciMessages(HCI_Event *msg)
{
    int i;
    btDevInfo* dev;

    switch ( msg->header.primitive )
    {
    	  //cwc034: QoS Test - Ensure recieve setup completion
      case HCI_QOS_SETUP_COMPLETE_EVENT:
        if( hspPhase == BT_MNGR_HSP_SETUP_QOS )
        {
          EndPhase (&hspPhase, BT_MNGR_HSP_SETUP_QOS );
          if(nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE 
              && headset_status.Is_SPP_flow_enable == BT_TRUE)
          {
            /* Send Mute to R1.3 Headset */
            sendHspAgAtCmdRsp(REVERSE_NIBBLER);
            
            BT_reverse_nibbler_resend();
          }  
        }
        if( sppPhase == BT_MNGR_SPP_SETUP_QOS )
        {
          EndPhase (&sppPhase, BT_MNGR_SPP_SETUP_QOS );
        }
    	  break;
    	  
        case HCI_READ_BD_ADDR_COMPLETE_EVENT :                       
          Local_BTAddress[0] = msg->readBdAddrCompleteEvent.bdAddress[5];
          Local_BTAddress[1] = msg->readBdAddrCompleteEvent.bdAddress[4];
          Local_BTAddress[2] = msg->readBdAddrCompleteEvent.bdAddress[3];
          Local_BTAddress[3] = msg->readBdAddrCompleteEvent.bdAddress[2];
          Local_BTAddress[4] = msg->readBdAddrCompleteEvent.bdAddress[1];
          Local_BTAddress[5] = msg->readBdAddrCompleteEvent.bdAddress[0];

          startupState = BT_MNGR_STATE_SEND_WRITE_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL;
          RunStartupStateMachine();
        break;
        

        case HCI_WRITE_PAGE_TIMEOUT_COMPLETE_EVENT:
        	  startupState = BT_MNGR_STATE_SEND_READ_LOCAL_BTADDR;
            RunStartupStateMachine();
            break;
        	
        	
        	
        case HCI_WRITE_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL_COMPLETE_EVENT:
          /*
           *  If we are in restarting phase, then we should
           *  send a controller restarted rsp.
           */
          if ( startupPhase == BT_MNGR_PHASE_RESTARTING )
          {
              BT_MNGR_SendHciControllerRestartedRsp();
              startupPhase = 0;
          }

#ifdef BT_ENABLE_DUT
          if( ( 0 < dut_para.data[0] && dut_para.data[0] <= 99 )
                  || dut_para.data[0] == 0x1234 )
          {
            startupState = BT_MNGR_STATE_DEVICE_UNDER_TEST;
            EndPhase( &ctrlPhase,BT_MNGR_CONTROL_PHASE_SET_DISCOVERABLE );

            if( dut_para.data[0] == 0x1234 )
            {
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->Output message : DEVICE_UNDER_TEST_REQUEST\n");
              #endif
              SEND_MESSAGE_TO_BLUETOOTH_MANAGER(DEVICE_UNDER_TEST_REQUEST, NULL , 0); 
            }
            else
            {
              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("--->Output message : DEVICE_TEST_USING_CODEPLUG\n");
              #endif
              SEND_MESSAGE_TO_BLUETOOTH_MANAGER(DEVICE_TEST_USING_CODEPLUG, NULL , 0); 
            }

            
            //#ifdef BT_ENABLE_SW_TST_UART
            //BT_RawLog("--->Output message : BT_INIT_FAILED_ACK\n");
            //#endif
            //SEND_MESSAGE_TO_CONNECTION_MNGR( BT_INIT_FAILED_ACK, NULL, 0);
            break;
          }
#endif
          startupState = BT_MNGR_STATE_INITIATED;
          EndPhase( &ctrlPhase,BT_MNGR_CONTROL_PHASE_SET_DISCOVERABLE );
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Output message : BT_INIT_SUCCESS_ACK\n");
          #endif
          
          /* Do the last check to get the version info of the BT chip */          
          SEND_MESSAGE_TO_BLUETOOTH_MANAGER(CHECK_CSR_VERSION_REQ, NULL , 0); 
          break;
      
        case HCI_WRITE_INQUIRY_MODE_COMPLETE_EVENT:
          ctrlState = BT_MNGR_CONTROL_SEND_SDAP_ENUM;
          RunCtrlStateMachine();
          break;


        case HCI_WRITE_SCAN_ENABLE_COMPLETE_EVENT:

            break;

        case HCI_CONTROLLER_RESTARTED_IND:
            /*
                     *	The bluetooth controller has restarted. We need to
                     *	re-initialise everything. In this case we should
                     *	start to set the controller discoverable and connectable.
                     */
            startupPhase  = BT_MNGR_PHASE_RESTARTING;
            startupState = BT_MNGR_STATE_SEND_WRITE_CLASS_OF_DEVICE;
            RunStartupStateMachine();
            break;

        case HCI_WRITE_CLASS_OF_DEVICE_COMPLETE_EVENT:
              /* Only executed as part of initialisation */
              startupState = BT_MNGR_STATE_SEND_WRITE_CONNECTABLE;
              RunStartupStateMachine();
              break;
              
        case HCI_READ_CLASS_OF_DEVICE_COMPLETE_EVENT:
            if(msg->readClassOfDeviceCompleteEvent.status == HCI_OK)
            {
              //Check if the class of device matches
              if((msg->readClassOfDeviceCompleteEvent.classOfDevice[0] == MINOR_DEVICE_CLASS_UNCATEGORIZED)
                 && (msg->readClassOfDeviceCompleteEvent.classOfDevice[1] == MAJOR_DEVICE_CLASS_MISC)
                 && (msg->readClassOfDeviceCompleteEvent.classOfDevice[2] == MAJOR_SERVICE_CLASS_AUDIO))
              {
                //Reset the interchip ping timeout timer
                bt_chip_ping_received();
              }
            }
            break;      

        case HCI_RETURN_LINK_KEYS_EVENT:

            for ( i = 0; i < msg->returnLinkKeysEvent.numKeys;i++)
            {
                memcpy(m_pairedDevices[m_pairedDevicesCount++].devinfo.addr, msg->returnLinkKeysEvent.keyMap[i].bdAddr, sizeof(BT_BdAddr));
            }
            break;

        case HCI_READ_STORED_LINK_KEY_COMPLETE_EVENT:

            for ( i = 0; i < m_pairedDevicesCount ; i++ )
            {
                char buf[BT_MNGR_MAX_NAME_LENGTH];
                BdAddrImg(buf,m_pairedDevices[i].devinfo.addr );
            }
            /* End control phase */
            EndPhase (&ctrlPhase, BT_MNGR_CONTROL_PHASE_READ_PAIRED );
            break;

        case HCI_RAW_EVENT_IND:
            BT_MNGR_HCIRawEventHandler(&msg->rawEventInd);
            break;

       case HCI_NUMBER_OF_COMPLETED_PACKETS_EVENT:
          if( agAtCmdInd == OK_AT_NIBBLER_CMD  )
          {
            //cwc034: QoS Test
            headset_status.Is_NIBBLER_enable = BT_TRUE;
            
            if( ((dev = BT_GetDevProfileInfo(HSP)) != NULL)
              && (HCI_GetConnectionHandle( dev->addr,&R1_3_connectionHandle) == BT_TRUE) )
            {  
              hspPhase = BT_MNGR_HSP_SETUP_QOS;
              hspState = BT_MNGR_HSP_QOS_SETUP; //cwc034: QoS test
              RunHspStateMachine();
            }     
          }

          if( sppAtCmdInd == NIBBLER_IND )
          {
            sppAtCmdInd = SEND_R1_4_REVERSE_NIBBLER;
            if( ((dev = BT_GetDevProfileInfo(SPP)) != NULL)
              && (HCI_GetConnectionHandle( dev->addr,&R1_4_connectionHandle) == BT_TRUE) )
            {  
              sppPhase = BT_MNGR_SPP_SETUP_QOS;
              sppState = BT_MNGR_SPP_QOS_SETUP;
              RunSppStateMachine();
            }     
          }

          break;
          

      default:
        BT_DebugUnknownPermitive (msg->header.primitive);  
        break;

    }
}

/* ===========================================================================
 * Function:    HandleSdapMessages
 * Description: Handler for messages from SDAP
 * =========================================================================== */
static void HandleSdapMessages(SDAP_Rsp *msg)
{
    BT_MNGR_Device * devptr;

    switch (msg->header.primitive )
    {
      case SDAP_REMOTE_DEVICE_RSP:
      #ifdef DEBUG_DEVICE_DISCOVERY
      if ( !CheckIfAlreadyFound(msg->remoteDeviceRsp.bdAddr) )
      #endif
      {
        /* If CoD is for HS.*/
        /* Is CoD is HS( Refer:- Assigned Numbers - Bluetooth Baseband document) */
        if(((msg->remoteDeviceRsp.classOfDevice[2] == 0x20) &&		/* compare Major Service Class */		
            (msg->remoteDeviceRsp.classOfDevice[1] == 0x04) &&		/* compare Major Device  Class */
            (msg->remoteDeviceRsp.classOfDevice[0] == 0x04)))	    /* compare Minor Device  Class */	
        {	
          /* copy needed data into HSP database */
          memcpy( foundedHS[foundedHSCount].devinfo.addr
            , msg->remoteDeviceRsp.bdAddr
            , sizeof(BT_BdAddr));

          memcpy( foundedHS[foundedHSCount].classOfDevice
            , msg->remoteDeviceRsp.classOfDevice
            , sizeof(HCI_ClassOfDevice));

          foundedHS[foundedHSCount].rssi = msg->remoteDeviceRsp.rssi;
          foundedHS[foundedHSCount].devinfo.profile = HSP;
          foundedHS[foundedHSCount].status = NOT_PAIR;
          foundedHSCount++;
        }

        
        /* If CoD is for Wireless 1.4 Fast PTT.*/
        if(((msg->remoteDeviceRsp.classOfDevice[2] == 0x80) &&		/* compare Major Service Class */		
            (msg->remoteDeviceRsp.classOfDevice[1] == 0x05) &&		/* compare Major Device  Class */
              (msg->remoteDeviceRsp.classOfDevice[0] == 0x0C))      /* compare Minor Device  Class */
              && 
              (discoverymode == DISCOVERY_ALL || discoverymode == DISCOVERY_SPP_ONLY) ) /* Discovery All profile       */
        {	
          /* copy Needed data into database */
          memcpy(foundedR1_4[foundedR1_4Count].devinfo.addr
            ,msg->remoteDeviceRsp.bdAddr
            ,sizeof(BT_BdAddr));

          memcpy(foundedR1_4[foundedR1_4Count].classOfDevice
            ,msg->remoteDeviceRsp.classOfDevice
            ,sizeof(HCI_ClassOfDevice));

          foundedR1_4[foundedR1_4Count].rssi = msg->remoteDeviceRsp.rssi;
          foundedR1_4[foundedR1_4Count].devinfo.profile = SPP;
          foundedR1_4[foundedR1_4Count].status = NOT_PAIR;
          foundedR1_4Count++;
        }

        #ifdef DEBUG_DEVICE_DISCOVERY
        /* copy Needed data into database */
        memcpy(m_foundDevices[m_foundDevicesCount].devinfo.addr
          ,msg->remoteDeviceRsp.bdAddr
          ,sizeof(BT_BdAddr));

        memcpy(m_foundDevices[m_foundDevicesCount].classOfDevice
          ,msg->remoteDeviceRsp.classOfDevice
          ,sizeof(m_foundDevices[m_foundDevicesCount].classOfDevice));

        m_foundDevices[m_foundDevicesCount].rssi = msg->remoteDeviceRsp.rssi;
        m_foundDevices[m_foundDevicesCount].status = NOT_PAIR;
        m_foundDevicesCount++;
        #endif
      }
      break;


      case SDAP_ENUM_REM_DEV_NAME_RSP:

        #ifdef DEBUG_DEVICE_DISCOVERY
        /* device name get while searching, for debug purposes only */
        if ( (devptr = CheckIfAlreadyFound(msg->enumRemDevNameRsp.bdAddr)) != 0 )
        {
          if ( msg->enumRemDevNameRsp.remDevName )
          {
            strncpy( (char *)devptr->name
                    , (char *)msg->enumRemDevNameRsp.remDevName
                    , BT_MNGR_MAX_NAME_LENGTH );
          }
          else
          {
            strcpy( (char *)devptr->name, "");
          }					
        }
        #endif

        if ( (devptr = CheckHSIfAlreadyFound(msg->enumRemDevNameRsp.bdAddr)) != 0 )
        {
          if ( msg->enumRemDevNameRsp.remDevName )
          {
            strncpy( (char *)devptr->name
                    , (char *)msg->enumRemDevNameRsp.remDevName
                    , BT_MNGR_MAX_NAME_LENGTH );
          }
          else
          {
            strcpy( (char *)devptr->name, "");
          }					
        }

        if ( (devptr = CheckSPPIfAlreadyFound(msg->enumRemDevNameRsp.bdAddr)) != 0 )
        {
          if ( msg->enumRemDevNameRsp.remDevName )
          {
            strncpy( (char *)devptr->name
                    , (char *)msg->enumRemDevNameRsp.remDevName
                    , BT_MNGR_MAX_NAME_LENGTH );
          }
          else
          {
            strcpy( (char *)devptr->name, "");
          }					
        }
        break;

      /* search complete */
      case SDAP_ENUMERATE_REM_DEV_RSP:
        if( msg->enumRemDevRsp.result == SDAP_OK )
        {
          #ifdef DEBUG_DEVICE_DISCOVERY
          BT_MNGR_RssiSort( m_foundDevices, m_foundDevicesCount );

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->All device Database \n");
          BT_RawLog("--->=================== \n");
          BT_PrintDeviceDiscoveryDatabase( m_foundDevices, m_foundDevicesCount );
          #endif
          #endif

          BT_MNGR_RssiSort( foundedHS, foundedHSCount );
          BT_MNGR_RssiSort( foundedR1_4, foundedR1_4Count );

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->HSP device Database \n");
          BT_RawLog("--->=================== \n");
          BT_PrintDeviceDiscoveryDatabase( foundedHS, foundedHSCount );

          BT_RawLog("--->SPP device Database \n");
          BT_RawLog("--->=================== \n");
          BT_PrintDeviceDiscoveryDatabase( foundedR1_4, foundedR1_4Count );
          #endif

          /* Found SPP device */
          if ( foundedHSCount != 0 || foundedR1_4Count != 0)
          {
            /* directly go to pair with device */
            EndPhase (&ctrlPhase, BT_MNGR_CONTROL_PHASE_DISCOVERY );
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("--->Output message : BT_MNGR_START_PAIRING\n");
            #endif
            SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_START_PAIRING, NULL , 0);
            devSearchFailCount = 0;
          }
          else
          { 
            devSearchFailCount ++;  
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("--->Device Search Failure Count: %d\n", devSearchFailCount);
            #endif
            
            if (devSearchFailCount < MAX_DEV_INQUIRY_FAIL_CYCLE) /* To check if Device Inquiry Timeout. Timeout = 61.44s = 6 x 10.24 */
             {
               /* restart device search */
               #ifdef BT_ENABLE_SW_TST_UART
               BT_RawLog("--->Restart search\n");
               #endif
               EndPhase (&ctrlPhase, BT_MNGR_CONTROL_PHASE_DISCOVERY );
               #ifdef BT_ENABLE_SW_TST_UART
               BT_RawLog("--->Output message : BT_DISCOVERY_AND_PAIRING_REQUEST\n");
               #endif
               SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_DISCOVERY_AND_PAIRING_REQUEST, &discoverymode, sizeof(discoveryType));   
             }
            else
             {
               /* stop device search */
               #ifdef BT_ENABLE_SW_TST_UART
               BT_RawLog("--->Output message : BT_DEVICE_INQUIRY_TIMEOUT_ACK\n");
               #endif
               SEND_MESSAGE_TO_CONNECTION_MNGR(BT_DEVICE_INQUIRY_TIMEOUT_ACK, NULL , 0); /* Device Inquiry Timeout = 61.44s */
             }         
          }
        }
        else
        {
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Error SDAP_ENUMERATE_REM_DEV_RSP %d\n", msg->enumRemDevRsp.result);
          #endif
          EndPhase (&ctrlPhase, BT_MNGR_CONTROL_PHASE_DISCOVERY );

          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->Output message : BT_DISCOVERY_AND_PAIRING_REQUEST\n");
          #endif
          SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_DISCOVERY_AND_PAIRING_REQUEST, &discoverymode, sizeof(discoveryType));          
        }
        break;

      /* get attribute name */
      case SDAP_SERVICE_SEARCH_ATTR_RSP:
        (void) HandleServiceSearchAttrRsp(&msg->searchAttrRsp);
        break;

      case SDAP_SEARCH_COMPLETE_RSP:
        /* close connection before restart */
        if(!isBQBModeOn)
        {
          if( msg->completeRsp.noOfResults == 0 )
          {
            if( (devptr = GetNextSPP()) != NULL)
            {
              if( ++devptr->service_name_count >= MAX_SERVICE_NAME_RETRY)
              {
                devptr->status = SERVICE_NAME_MISMATCH;              
              }
            }
          }

          /* to wait for SDP_DISCONNECT_REQ  SDP_DISCONNECT_CFM event */
          if( servicename_TMO != 0 )BT_TimeoutCancel(servicename_TMO);
          servicename_TMO = BT_TimeoutReq(appSenderId,
                        TIMER_ID_RUN_SERVICE_NAME_CLOSE_CONN_TMO,  //user timer id 
                        0,                                         // userTimerData 
                        1000);                                     // msTimeout 
        }
        break;

        default:
        BT_DebugUnknownPermitive (msg->header.primitive);  
        break;
    }
}
/* ===========================================================================
 * Function:	HandleSdapServiceSearchAttrRsp
 * Description: Extract attribute values from the search result
 *				returned by SDAP
 * =========================================================================== */
static BT_U8 HandleServiceSearchAttrRsp(SDAP_ServiceSearchAttrRsp *rsp) BT_LARGE
{
  HSP_AG_Position 		BT_RAM position;
  HSP_AG_HsServiceRecord	BT_RAM hsServiceRecord;
  BT_MNGR_Device * devptr;
  BT_U8 retval = BT_FALSE; // CCMPD01410054 (JJ 8/11/2010)

  if(rsp->result == SDAP_OK )
  {
    position = HSP_AG_StartInterpretSearchResult(rsp->dataBuffer);
    while ( position != 0 )
    {
      if ( HSP_AG_InterpretSearchResult(rsp->dataBuffer,  rsp->noOfBytes,
              &hsServiceRecord,
              &position) != BT_OK )
      {
        /* Drop and take the next one if any */
      }
      else if ( !(hsServiceRecord.validAttributes & HSP_AG_VALID_SERVICE_CLASS_ID_LIST) )
      {
        /*
         * The service class id is missing even if it's mandatory.
         * Use the information and hope it's a Serail Port unit.

          con->wlPTTServerChannel = hsServiceRecord.serverChannel; */
      }
      if(!isBQBModeOn)
      {
      if(BT_FALSE == strncmp((char const *)hsServiceRecord.serviceName // CCMPD01410054 (JJ 5/11/2010)
        ,R1_4_SERVICE_NAME
        ,(sizeof(R1_4_SERVICE_NAME)-1)))
      {
        if ( (devptr = CheckSPPIfAlreadyFound(rsp->bdAddr)) != 0 )
        {
          devptr->status = SERVICE_NAME_MATCH;
        }
        retval = BT_TRUE;
      }
      else
      {
        if ( (devptr = CheckSPPIfAlreadyFound(rsp->bdAddr)) != 0 )
        {
          devptr->status = SERVICE_NAME_MISMATCH;
        }
        retval = BT_FALSE;
        }
      }
    }
  }
  else
  {
    if(!isBQBModeOn)
    {
      /* retry 3x if fail */
      if ( (devptr = CheckSPPIfAlreadyFound(rsp->bdAddr)) != 0 )
      {
        if( ++devptr->service_name_count >= MAX_SERVICE_NAME_RETRY)
        {
          devptr->status = SERVICE_NAME_MISMATCH;
        }
      }
      retval = BT_FALSE;
    }
  }
  return retval;
}

/* ===========================================================================
 * Function:    HandleSecMessages
 * Description: Handler for messages from Security Manager
 * =========================================================================== */
static void HandleSecMessages(SEC_IndConf *msg)
{
  BT_MNGR_Device* devptr;
  btDevInfo* dev;


    switch (msg->header.primitive )
    {
      case SEC_PIN_REQUEST_IND:
        if(isBQBModeOn)
        {
            memcpy(tempDevInfo.addr, msg->pinRequestInd.bdAddr,6);
            tempDevInfo.profile = HSP;
            BT_SetDeviceDatabase(&tempDevInfo);
            ctrlState = BT_MNGR_CONTROL_SEND_PASSKEY_RSP;
            RunCtrlStateMachine();
          
        }
        else
        {

            if( (ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS)
              && ((devptr = GetNextHS()) != NULL )
              && (CompareBTAddress(msg->pinRequestInd.bdAddr, devptr->devinfo.addr)) )
            {
              memcpy( &PinCodeReqDevice, &msg->pinRequestInd.bdAddr, sizeof(BT_BdAddr) );

          ctrlState = BT_MNGR_CONTROL_SEND_HS_PASSKEY_RSP;
          RunCtrlStateMachine();

              #ifdef BT_ENABLE_SW_TST_UART
              BT_RawLog("---> Pincode request 1\n");
                BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
                  , msg->pinRequestInd.bdAddr[5]
                  , msg->pinRequestInd.bdAddr[4]
                  , msg->pinRequestInd.bdAddr[3]
                  , msg->pinRequestInd.bdAddr[2]
                  , msg->pinRequestInd.bdAddr[1]
                  , msg->pinRequestInd.bdAddr[0]);
              #endif
            }
            else if( (ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP)
              && ((devptr = GetNextFilteredSPP()) != NULL )
              && (CompareBTAddress(msg->pinRequestInd.bdAddr,devptr->devinfo.addr)) )
            {
                memcpy( &PinCodeReqDevice, &msg->pinRequestInd.bdAddr, sizeof(BT_BdAddr) );
                ctrlState = BT_MNGR_CONTROL_SEND_R1_4_PASSKEY_RSP;
                RunCtrlStateMachine();
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("---> Pincode request 2\n");
                BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
                  , msg->pinRequestInd.bdAddr[5]
                  , msg->pinRequestInd.bdAddr[4]
                  , msg->pinRequestInd.bdAddr[3]
                  , msg->pinRequestInd.bdAddr[2]
                  , msg->pinRequestInd.bdAddr[1]
                  , msg->pinRequestInd.bdAddr[0]);
                #endif
        }
        else
            {
                memcpy( &PinCodeReqDevice, &msg->pinRequestInd.bdAddr, sizeof(BT_BdAddr) );
                ctrlState = BT_MNGR_CONTROL_SEND_REJECT_PASSKEY_RSP;
                RunCtrlStateMachine();
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("---> Pincode Reject 1\n");
                BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
                  , msg->pinRequestInd.bdAddr[5]
                  , msg->pinRequestInd.bdAddr[4]
                  , msg->pinRequestInd.bdAddr[3]
                  , msg->pinRequestInd.bdAddr[2]
                  , msg->pinRequestInd.bdAddr[1]
                  , msg->pinRequestInd.bdAddr[0]);
                #endif
            }
        }
        break;

      case SEC_AUTHORISATION_REQUEST_IND:
          break;

      case SEC_CREATE_BOND_CFM:
        if( ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS
           || ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP )
        {
          if (msg->createBondCfm.bondCreated)
          {
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("--->Pairing OK\n");
            #endif
            /* Check Paired Device is R1.4 */
            if( ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS )
            {
              if( (devptr = CheckHSIfAlreadyFound(msg->createBondCfm.bdAddr)) != NULL )
              {
                devptr->status = PAIRED;
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Pair success with HSP device\n");
                BT_RawLog("--->============================\n");
                BT_PrintDeviceInfo(devptr);
                #endif

                EndPhase ( &ctrlPhase, BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS );

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_MNGR_HS_PAIRING_SUCCESS_ACK\n");
                #endif

                SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_HS_PAIRING_SUCCESS_ACK, NULL , 0);
              }
              else
              {
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Error in HSP address\n");
                #endif

              }
            }
            else if( ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP )
            {
              if( (devptr = CheckSPPIfAlreadyFound(msg->createBondCfm.bdAddr)) != NULL )
              {
                devptr->status = PAIRED;

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->pair success with SPP device\n");
                BT_PrintDeviceInfo(devptr);
                #endif

                EndPhase ( &ctrlPhase, BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP );

                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_MNGR_R1_4_PAIRING_SUCCESS_ACK\n");
                #endif

                SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_R1_4_PAIRING_SUCCESS_ACK, NULL , 0);
              }
              else
              {
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Error in SPP address\n");
                #endif
              }
            }
          }
          else
          {
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("--->Pairing Failed\n");
            #endif
            if( ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS )
            {
              if( (devptr = CheckHSIfAlreadyFound( msg->createBondCfm.bdAddr)) != NULL )
              {
                if( ++devptr->paring_retry_count >= MAX_PAIRING_RETRY )
                {
                  devptr->status = PAIRED_FAIL;
                }
                BT_PrintDeviceInfo(devptr);

                EndPhase ( &ctrlPhase, BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS );
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_MNGR_HS_PAIRING_UNSUCCESS_ACK\n");
                #endif
                SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_HS_PAIRING_UNSUCCESS_ACK, NULL , 0);
               }
              else
              {
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Error in HSP address\n");
                #endif
              }
           }
            else if( ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP )
            {
              if( (devptr = CheckSPPIfAlreadyFound( msg->createBondCfm.bdAddr)) != NULL )
              {
                if( ++devptr->paring_retry_count >= MAX_PAIRING_RETRY )
                {
                  devptr->status = PAIRED_FAIL;
                }
                BT_PrintDeviceInfo(devptr);

                EndPhase ( &ctrlPhase, BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP );
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Output message : BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK\n");
                #endif
                SEND_MESSAGE_TO_BLUETOOTH_MANAGER(BT_MNGR_R1_4_PAIRING_UNSUCCESS_ACK, NULL , 0);
              }
              else
              {
                #ifdef BT_ENABLE_SW_TST_UART
                BT_RawLog("--->Error in SPP address\n");
                #endif
              }
            }
          }
        }
        else if(isBQBModeOn)
        {
                if (msg->createBondCfm.bondCreated)
                {
                  memcpy(tempDevInfo.addr,msg->createBondCfm.bdAddr,sizeof(BT_BdAddr));
                  tempDevInfo.profile = HSP;
                  BT_SetDeviceDatabase(&tempDevInfo);
                  SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_COMPLETE_ACK, &tempDevInfo , sizeof(tempDevInfo));
                }
        }
        break;

	case SEC_WRITE_CONNECTABLE_CFM:
              /* Only executed as part of initialisation */
              startupState = BT_MNGR_STATE_SEND_WRITE_DISCOVERABLE;
              RunStartupStateMachine();		
              break;

  case SEC_WRITE_DISCOVERABLE_CFM:
        startupState = BT_MNGR_STATE_SEND_WRITE_PAGE_TIMEOUT;
        RunStartupStateMachine();   
        break;

    case SEC_LINK_KEY_REQUEST_IND:
      if(isBQBModeOn)
      {
        if((dev = BT_GetDevProfileInfo(HSP))!= NULL)
        {  
          memcpy( &LinkKeyReqDevice, dev , sizeof(btDevInfo) );
          ctrlState = BT_MNGR_CONTROL_SEND_LINKKEY_RSP;
          RunCtrlStateMachine();
        }
        break;
      }
      if( (ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS)
        || (ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP) )
      {
        if( (ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS)
          && ((devptr = GetNextHS()) != NULL )
          && (CompareBTAddress(msg->linkKeyRequestInd.bdAddr, devptr->devinfo.addr)) )
        {
          memcpy( &LinkKeyReqDevice, &devptr->devinfo, sizeof(btDevInfo) );
          
          ctrlState = BT_MNGR_CONTROL_SEND_LINKKEY_REQ;
          RunCtrlStateMachine();
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> Linkkey request 1\n");
          BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
            , devptr->devinfo.addr[5]
            , devptr->devinfo.addr[4]
            , devptr->devinfo.addr[3]
            , devptr->devinfo.addr[2]
            , devptr->devinfo.addr[1]
            , devptr->devinfo.addr[0]);
          #endif
        }
        else if( (ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP)
          && ((devptr = GetNextFilteredSPP()) != NULL )
          && (CompareBTAddress(msg->linkKeyRequestInd.bdAddr,devptr->devinfo.addr)) )
        {
          memcpy( &LinkKeyReqDevice, &devptr->devinfo, sizeof(btDevInfo) );

          ctrlState = BT_MNGR_CONTROL_SEND_LINKKEY_REQ;
          RunCtrlStateMachine();
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> Linkkey request 2\n");
          BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
            , devptr->devinfo.addr[5]
            , devptr->devinfo.addr[4]
            , devptr->devinfo.addr[3]
            , devptr->devinfo.addr[2]
            , devptr->devinfo.addr[1]
            , devptr->devinfo.addr[0]);
          #endif
        }
        else
        {
          memcpy( &LinkKeyReqDevice.addr, &msg->linkKeyRequestInd.bdAddr, sizeof(BT_BdAddr) );
          ctrlState = BT_MNGR_CONTROL_SEND_LINKKEY_REQ;
          RunCtrlStateMachine();
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> Linkkey request 9\n");
          BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
            , msg->linkKeyRequestInd.bdAddr[5]
            , msg->linkKeyRequestInd.bdAddr[4]
            , msg->linkKeyRequestInd.bdAddr[3]
            , msg->linkKeyRequestInd.bdAddr[2]
            , msg->linkKeyRequestInd.bdAddr[1]
            , msg->linkKeyRequestInd.bdAddr[0]);
          #endif
        }
      }
      else
      {      
        if( ((dev = BT_GetDevAddrInfo(msg->linkKeyRequestInd.bdAddr)) != NULL)
          &&((dev->profile == HSP && headset_status.Is_connection_allow == BT_TRUE)
              || (dev->profile == SPP && wirelessPTT_status.Is_connection_allow == BT_TRUE)) )
        {
            memcpy( &LinkKeyReqDevice, dev, sizeof(btDevInfo) );
            ctrlState = BT_MNGR_CONTROL_SEND_LINKKEY_RSP;
            RunCtrlStateMachine();
            
            #ifdef BT_ENABLE_SW_TST_UART
            BT_RawLog("---> Linkkey request 3\n");
            BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
              , dev->addr[5]
              , dev->addr[4]
              , dev->addr[3]
              , dev->addr[2]
              , dev->addr[1]
              , dev->addr[0]);
            #endif
        }
        else
        {
          memcpy( &LinkKeyReqDevice.addr, &msg->linkKeyRequestInd.bdAddr, sizeof(BT_BdAddr) );
          ctrlState = BT_MNGR_CONTROL_SEND_LINKKEY_REQ;
          RunCtrlStateMachine();
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> Linkkey request 8\n");
          BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n"
            , msg->linkKeyRequestInd.bdAddr[5]
            , msg->linkKeyRequestInd.bdAddr[4]
            , msg->linkKeyRequestInd.bdAddr[3]
            , msg->linkKeyRequestInd.bdAddr[2]
            , msg->linkKeyRequestInd.bdAddr[1]
            , msg->linkKeyRequestInd.bdAddr[0]);
          #endif
        }  
      }
      break;

    case SEC_LINK_KEY_NOTIFICATION_IND:
      if(isBQBModeOn)
      {  
        memcpy(tempDevInfo.addr,msg->linkKeyNotificationInd.bdAddr,sizeof(BT_BdAddr));
        memcpy(tempDevInfo.linkkey,msg->linkKeyNotificationInd.linkKey,sizeof(HCI_LinkKey));
        tempDevInfo.profile = HSP;
        tempDevInfo.IsDeviceClass1 = BT_FALSE;
        BT_SetDeviceDatabase(&tempDevInfo);
        SEND_MESSAGE_TO_CONNECTION_MNGR(BT_PAIRING_SUCCESS_ACK, &tempDevInfo , sizeof(tempDevInfo));
      } 
      else if( ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS 
         || ctrlPhase == BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP )
      {
        if( ((devptr = GetNextHS()) != NULL )
            && (CompareBTAddress(msg->linkKeyNotificationInd.bdAddr, devptr->devinfo.addr)) )
        {
          memcpy( &devptr->devinfo.linkkey
                  , msg->linkKeyNotificationInd.linkKey
                  , sizeof(HCI_LinkKey));
          devptr->devinfo.keyType = msg->linkKeyNotificationInd.keyType;
          devptr->devinfo.pairingType = msg->linkKeyNotificationInd.pairingType;
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> Linkkey Notification 1\n");
          #endif
        }
        else if( ((devptr = GetNextFilteredSPP()) != NULL )
            && (CompareBTAddress(msg->linkKeyNotificationInd.bdAddr, devptr->devinfo.addr)) )            
        {
          memcpy( &devptr->devinfo.linkkey
                  , msg->linkKeyNotificationInd.linkKey
                  , sizeof(HCI_LinkKey));
          devptr->devinfo.keyType = msg->linkKeyNotificationInd.keyType;
          devptr->devinfo.pairingType = msg->linkKeyNotificationInd.pairingType;
          
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("---> Linkkey Notification 2\n");
          #endif
        }
      }
      break;

    default:
      BT_DebugUnknownPermitive (msg->header.primitive);  
      break;
      
    }
}

/* ===========================================================================
 * Function:    MsgHandler
 * Description: Top level dispatcher for all messages received by
 *              this application.
 * =========================================================================== */
static BT_Result MsgHandler (const BT_Msg *msg)
{
    BT_MNGR_InMsg *m = (BT_MNGR_InMsg*)msg;

    /*
     * Always take care of CTRL_CMD
     * regardless of fatal error
     */
    if ( BT_MSG_CLASS(msg->header.primitive) == CTRL_MSG_CLASS )
    {
        HandleCtrlMessages(&m->ctrl);
    }
    /*
     * Unless a a fatal error has occured, dispatch
     * message to the appropriate handler
     */
    else if ( !fatalErrorReceived )
    {
        /*
         * Dispatch messages to the appropriate handler
         */
        switch ( BT_MSG_CLASS(msg->header.primitive) )
        {
        case TSRV_MSG_CLASS:
            HandleTsrvMessages(&m->tsrv);
            break;

        case HCI_MSG_CLASS:
            HandleHciMessages(&m->hci);
            break;

        case SEC_MSG_CLASS:
            HandleSecMessages(&m->sec);
            break;

        case SDAP_MSG_CLASS:
            HandleSdapMessages(&m->sdap);
            break;

	case HSP_AG_MSG_CLASS:
            HandleHspAgMessages(&m->hspAg);
	    break;
            
        case SPP_DEV_MSG_CLASS:
            HandleSppDevMessages(&m->sppDev);
            break;

        default:
          BT_DebugUnknownPermitive (msg->header.primitive);  
          break;

        }
    }

    return BT_OK;
}

/*===========================================================================
 *  Function:       BdAddrImg
 *  Description:    Writes a Bluetooth Device Adress to the imgBuffer with
 *                  the LSB to the left.
 *  Returns:        Number of bytes written.
 *===========================================================================*/
static BT_U16 BdAddrImg(char *imgBuffer,const BT_BdAddr addr) BT_LARGE
{
    int BT_RAM size = 0;
    BT_U8   BT_RAM n;

    size = sprintf(imgBuffer, "bdAddr: ");
    for ( n = 0; n < 6; n++ )
    {
        size += sprintf(imgBuffer+size, "%02x%c", (int)addr[5-n],
            (n != 5)?':':' ');
    }

    return (BT_U16)size;
}

/*===========================================================================
 *  Function:       EndPhase
 *  Description:    End the indicated phase if active by clearing phaseVar.
 *  Returns:		
 *===========================================================================*/
static void EndPhase (BT_U8 *phaseVar, BT_U8 phase)
{
	if ( *phaseVar == phase )
	{
		*phaseVar = 0;
	}
}

#ifdef DEBUG_DEVICE_DISCOVERY
/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* CheckIfAlreadyFound(BT_BdAddr addr)
{
	int i;
	BT_MNGR_Device* device = 0;
	for ( i = 0; !device && i < m_foundDevicesCount;i++ )
	{
		if ( memcmp( m_foundDevices[i].devinfo.addr, addr, sizeof(BT_BdAddr)) == 0 )
		{
			device = &m_foundDevices[i];
		}
	}
	
	return device;
}
#endif
/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* CheckHSIfAlreadyFound(BT_BdAddr addr)
{
	int i;
	BT_MNGR_Device* device = 0;

	for ( i = 0; !device && i < foundedHSCount;i++ )
	{
		if ( memcmp( foundedHS[i].devinfo.addr, addr, sizeof(BT_BdAddr)) == 0 )
		{
			device = &foundedHS[i];
		}
	}
	
	return device;
}

/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* CheckSPPIfAlreadyFound(BT_BdAddr addr)
{
	int i;
	BT_MNGR_Device* device = 0;

	for ( i = 0; !device && i < foundedR1_4Count;i++ )
	{
		if ( memcmp( foundedR1_4[i].devinfo.addr, addr, sizeof(BT_BdAddr)) == 0 )
		{
			device = &foundedR1_4[i];
		}
	}
	
	return device;
}
/*===========================================================================
 *  Function:       sendSppAtCmdRsp
 *  Description:    Send At Cmd Response
 *  Returns:        None.
 *===========================================================================*/
BT_Result sendSppAtCmdRsp(SPP_AT_CMD_IND cmd)
{
  BT_Result res = BT_CALL_ERROR;

  if( (xSemaphoreTake( xACLAccess, ( portTickType ) portMAX_DELAY ) == pdTRUE) )
  {
    sppAtCmdInd = cmd;
    
      switch(cmd)
      {
        case RFCOMM_IND:
          res = BT_MNGR_SendSppDataReq(RFCOMM_OK_RSP);
          if(res == BT_OK)
          {
            BT_TimeoutReq(appSenderId,
                TIMER_ID_RUN_R1_4_RFCOMM_ATCMD_RSP,  //user timer id 
                0,    // userTimerData 
                0);   // msTimeout 
          
          }  
          break;
      
        case RFCOMM_CHNL_IND:
          res = BT_MNGR_SendSppDataReq(RFCOMM_CHNL_RSP);
          break;
          
        case CGMM_IND:
          res = BT_MNGR_SendSppDataReq(CGMM_RSP);
          break;

        case NIBBLER_IND:
          res = BT_MNGR_SendSppDataReq(NIBBLER_OK_RSP);
          enable_nibbler(&wirelessPTT_nibbler);
          break;
        
        case SEND_R1_4_REVERSE_NIBBLER:
        case SPP_XCMP_REVERSE_NIBBLER:
          res = BT_MNGR_SendSppDataReq(SEND_REVERSE_NIBBLER_BYTE);
          break;
                    
        default:
          break;
      }
          
      if ( cmd != SEND_R1_4_REVERSE_NIBBLER
           && cmd != SPP_XCMP_REVERSE_NIBBLER
           && res == BT_CONGESTED )
      {
        if( spp_atcommand_retry_TMO != 0 )BT_TimeoutCancel(spp_atcommand_retry_TMO);
        spp_atcommand_retry_TMO = BT_TimeoutReq(appSenderId,
                       TIMER_ID_RUN_REPEAT_R1_4_ATCMD,  //user timer id 
                       0,                           // userTimerData 
                       100);   // msTimeout 
      }

      xSemaphoreGive( xACLAccess );
      return res;
    }
    else
    {
      return BT_CONGESTED;
    }
}

/*===========================================================================
 *  Function:       RunHspAgAtCmdSeq(qbdx84)
 *  Description:    Runs Seq Machine for Ag At commands for SLC setup
 *  Returns:        None.
 *===========================================================================*/
BT_Result sendHspAgAtCmdRsp(AG_AT_CMD_IND cmd)
{
  BT_Result res = BT_CALL_ERROR;

  if( (xSemaphoreTake( xACLAccess, ( portTickType ) portMAX_DELAY ) == pdTRUE) )
  {
    BT_U8 newState = 0;

    agAtCmdInd = cmd;

    switch(cmd)
    {
        case RING_AT_CMD:
          res = BT_MNGR_SendHsAgDataReq(RING_CMD);
          break;

        case OK_AT_CKPD_CMD:
          res = BT_MNGR_SendHsAgDataReq(OK_CKPD_CMD);
          break;

        case OK_AT_NIBBLER_CMD:
          res = BT_MNGR_SendHsAgDataReq(OK_NIBBLER_CMD);
          break;

        case CGMM_AT_CMD_IND:
          res = BT_MNGR_SendHsAgDataReq(CGMM_CMD_RSP);	
          break;

        case REVERSE_NIBBLER:
        case HSP_XCMP_REVERSE_NIBBLER:
          BT_MNGR_SendHsAgDataReq(REVERSE_NIBBLER_BYTE);
          /* remove res - reverse nibbler run on seperate timer */
          break;

        case NULL_NIBBLER:
          res = BT_MNGR_SendHsAgDataReq(ECHO_NULL_NIBBLER_BYTE);
          break;
    }

    if ( res == BT_OK )
    {
      ctrlState = newState;
    }
    else if ( cmd != REVERSE_NIBBLER
              && cmd != HSP_XCMP_REVERSE_NIBBLER
              && cmd != NULL_NIBBLER  
              && res == BT_CONGESTED )
    {
      if( hsp_atcommand_retry_TMO != 0 )BT_TimeoutCancel(hsp_atcommand_retry_TMO);
      hsp_atcommand_retry_TMO = BT_TimeoutReq(appSenderId,
                                               TIMER_ID_RUN_HSP_AG_AT_CMD_STATE_MACHINE,  //user timer id
                                               0,      // userTimerData
                                               100);   // msTimeout
    }
    else if (cmd == NULL_NIBBLER && res == BT_CONGESTED )
    {
      if( hsp_null_nibble_retry_TMO != 0 )BT_TimeoutCancel(hsp_null_nibble_retry_TMO);
      hsp_null_nibble_retry_TMO = BT_TimeoutReq(appSenderId,
                                               TIMER_ID_RUN_HSP_NULL_NIBBLE_RETRY,  //user timer id
                                               0,      // userTimerData
                                               10);   // msTimeout
    }

    xSemaphoreGive( xACLAccess );
    return res;
  }
  else
  { 
    return BT_CONGESTED;
  }
}

/*===========================================================================
 *  Function:       RunHciStateMachine
 *  Description:    Runs Seq Machine for HCI RAW Command
 *  Returns:        BT_Result - status of the message.
 *===========================================================================*/
static void RunHciStateMachine()
{
	BT_Result res = BT_CALL_ERROR;
	BT_U8 newState = 0;

	switch ( hciState )
	{
	case BT_MNGR_HCI_SETUSBTL:
		res = BT_MNGR_SendHci_BCCMD( BT_MNGR_BCCMD_USBTL(BCCMD_TYPE_SETREQ, (BT_U16)((hciPhase << 8) | hciState)) );
		break;

	case BT_MNGR_HCI_GETUSBTL:		
		res = BT_MNGR_SendHci_BCCMD( BT_MNGR_BCCMD_USBTL(BCCMD_TYPE_GETREQ, (BT_U16)((hciPhase << 8) | hciState)) );
		break;

	case BT_MNGR_HCI_SETWARMRESET:	
		res = BT_MNGR_SendHci_BCCMD( BT_MNGR_BCCMD_SETWARMRESET( (BT_U16)((hciPhase << 8) | hciState)) );
		if( res == BT_OK )
    {
      EndPhase (&hciPhase, BT_MNGR_HCI_SETUSB_TRANSPORT );
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->Output message : DFU_MODE_RSP_RECEIVED_FROM_CSR\n");
      #endif
      SEND_MESSAGE_TO_TESTCOMMAND_MNGR(DFU_MODE_RSP_RECEIVED_FROM_CSR, 
                                        NULL, 
                                        0);
    }
    break;

	case BT_MNGR_HCI_DEVTEST_1:	
		res = BT_MNGR_SendHci_BCCMD( BT_MNGR_BCCMD_DUT( (BT_U16)((hciPhase << 8) | hciState), BT_MNGR_HCI_DEVTEST_1 ) );
		break;
		
	case BT_MNGR_HCI_DEVTEST_2:
		res = BT_MNGR_SendHci_BCCMD( BT_MNGR_BCCMD_DUT( (BT_U16)((hciPhase << 8) | hciState), BT_MNGR_HCI_DEVTEST_2 ) );
		break;

	case BT_MNGR_HCI_CUSTOM_CMDSEND:
		res = BT_MNGR_SendHci_BCCMD( BT_MNGR_BCCMD_TXRXTEST( (BT_U16)((hciPhase << 8) | hciState), &dut_para ) );
		break;
                
        case BT_MNGR_HCI_CSR_VER_CHECK:
                res = BT_MNGR_SendHci_UsrPskey_BCCMD( BT_MNGR_BCCMD_VER_CHECK(BCCMD_TYPE_GETREQ, (BT_U16)((hciPhase << 8) | hciState)) );
                break;
                
	case BT_MNGR_HCI_VM_CMDSEND:
                switch(vm_cmd_send_state)
                {
                  case LOAD_DSP_CMD:
                    //flip_sco_handle = (sco_handle >> 8 | sco_handle << 8);
                    load_dsp_app[LOAD_DSP_CMD_DATA_SIZE-1] = (BT_U8)((sco_handle & 0xFF00u) >> 8);
                    load_dsp_app[LOAD_DSP_CMD_DATA_SIZE-2] = (BT_U8)sco_handle;
                    res = BT_MNGR_Send_hci_raw_cmd(&load_dsp_app[0], LOAD_DSP_CMD_DATA_SIZE); 
                    break;
                  case AUDIO_DETECT_ON_CMD:
                    res = BT_MNGR_Send_hci_raw_cmd(&enable_audio_detection[0], ENABLE_AUD_DET_CMD_DATA_SIZE);
                    break;
                  case SET_OUTPUT_GAIN_CMD:
                    set_output_gain_cmd[SET_OUTPUT_GAIN_CMD_DATA_SIZE-2] = dsp_speaker_gain;
                    res = BT_MNGR_Send_hci_raw_cmd(&set_output_gain_cmd[0], SET_OUTPUT_GAIN_CMD_DATA_SIZE);                     
                    break;
                  case SET_INPUT_GAIN_CMD:
                    set_input_gain_cmd[SET_INPUT_GAIN_CMD_DATA_SIZE-2] = dsp_mic_gain;
                    res = BT_MNGR_Send_hci_raw_cmd(&set_input_gain_cmd[0], SET_INPUT_GAIN_CMD_DATA_SIZE);                     
                    break;     
                  case SET_DELAY_CMD:
                    set_delay_cmd[SET_INPUT_DELAY_CMD_DATA_SIZE-2] = dsp_audio_line_delay;
                    res = BT_MNGR_Send_hci_raw_cmd(&set_delay_cmd[0], SET_INPUT_DELAY_CMD_DATA_SIZE);                     
                    break;  
                  case AUDIO_DETECT_OFF_CMD:
                    res = BT_MNGR_Send_hci_raw_cmd(&disable_audio_detection[0], DISABLE_AUD_DET_CMD_DATA_SIZE);
                    break;   
                  case PING_CMD:
                    res = BT_MNGR_Send_hci_raw_cmd(&ping_cmd[0], PING_CMD_DATA_SIZE);
                    break;    
                  case UNLOAD_DSP_CMD:
                    if(sco_handle != 0)
                    {
                    unload_dsp_app[UNLOAD_DSP_CMD_DATA_SIZE-1] = (BT_U8)((sco_handle & 0xFF00u) >> 8);
                    unload_dsp_app[UNLOAD_DSP_CMD_DATA_SIZE-2] = (BT_U8)sco_handle;
                    res = BT_MNGR_Send_hci_raw_cmd(&unload_dsp_app[0], UNLOAD_DSP_CMD_DATA_SIZE); 
                    }
                    break;   
                  case SET_THRESH_CMD:
                    set_threshold_cmd[SET_THRESHOLD_CMD_DATA_SIZE-1] = (BT_U8)((dsp_aud_det_threshold & 0x0000FF00u) >> 8);
                    set_threshold_cmd[SET_THRESHOLD_CMD_DATA_SIZE-2] = (BT_U8)(dsp_aud_det_threshold & 0x000000FFu);
                    set_threshold_cmd[SET_THRESHOLD_CMD_DATA_SIZE-3] = (BT_U8)((dsp_aud_det_threshold & 0xFF000000u) >> 24);
                    set_threshold_cmd[SET_THRESHOLD_CMD_DATA_SIZE-4] = (BT_U8)((dsp_aud_det_threshold & 0x00FF0000u) >> 16);                    
                    res = BT_MNGR_Send_hci_raw_cmd(&set_threshold_cmd[0], SET_THRESHOLD_CMD_DATA_SIZE);                     
                    break;
                  default:
                    break;
                }
		
		break;                
	}

	if ( res == BT_OK )
	{
		hciState = newState;
	}
	else if ( res == BT_CONGESTED )
	{
		BT_TimeoutReq(appSenderId,
                   TIMER_ID_RUN_HCI_STATE_MACHINE, 	/* user timer id */
                   0,                           	/* userTimerData */
                   RUN_STATE_MACHINE_DELAY);   		/* msTimeout */
	}
	else
	{
		hciPhase = 0;
	}

}

/*===========================================================================
 *  Function:       BT_MNGR_HCIRawEventHandler
 *  Description:    This function varify incoming Event Ind by SEQNO, It will check for previously
 *					sent out requenst as varification and change state for HCI state machine.
 *  Returns:        none
 *===========================================================================*/
void BT_MNGR_HCIRawEventHandler(HCI_RawEventInd* event)
{
	BT_MNGR_HCI_BCCMD btcmd;
    BT_MNGR_HCI_BCCMD_USR_PSKEY btcmdusrpskey;
	BT_MNGR_HCI_PayloadDescriptor Descriptor;
    BT_U8 i;
	BT_U8* ptr;
    BT_U16 seq_no = 0x0000;

	Descriptor.all = BT_MNGR_HCI_FIRSTFRAGMENT << 7 |
					 BT_MNGR_HCI_LASTFRAGMENT << 6 |
					 BT_MNGR_HCI_CHANNELID_BCCMD;

	if( (event->hciEventPacket[0] == 0xFF)

		/* Verify Payload Descriptor */
		&& (event->hciEventPacket[2] == Descriptor.all)
		
		/* verify HCI length == BCCMD length */
		&& (event->hciEventPacket[1] - 1) == (event->hciEventPacket[5]*2) )
	{
      seq_no = (((event->hciEventPacket[8] & 0xFF) << 8) | (event->hciEventPacket[7] & 0xFF));
      if(seq_no == ((BT_MNGR_HCI_SEND_BCCMD << 8) | BT_MNGR_HCI_CSR_VER_CHECK ))
      {
        ptr = (BT_U8*)&btcmdusrpskey;
      }
      else
      {
		ptr = (BT_U8*)&btcmd;
      }
		for( i = 0; i < (event->hciEventPacket[5]*2); i += 2)
		{
			ASSIGN_VAR_LE16( &ptr[i], &event->hciEventPacket[3 + i] );
		}
      /* Check if the returned data is for Version Check PSkey data */
      if(seq_no == ((BT_MNGR_HCI_SEND_BCCMD << 8) | BT_MNGR_HCI_CSR_VER_CHECK ))    //0x0308
      {
        if(( btcmdusrpskey.varid == BCCMD_VARID_PS ) &&
           ( btcmdusrpskey.status == BCCMD_STATUS_OK ) &&
           ( btcmdusrpskey.ps.pskey == PSKEY_USR38 ))
        {
          if(check_csr_version((UINT16_T *)&btcmdusrpskey.ps.data))
          {
            /* Cancel the timer to monitor the BT chip initialization timer, since BT stack-chip initialization is complete*/
            if(bt_chip_HCIreset_complete_event_timer != 0 )BT_TimeoutCancel(bt_chip_HCIreset_complete_event_timer);
            SEND_MESSAGE_TO_CONNECTION_MNGR( BT_INIT_SUCCESS_ACK, &Local_BTAddress[0], sizeof(Local_BTAddress) );
          }
          else
          {
            /* Cancel the timer to monitor the BT chip initialization timer, since BT stack-chip initialization is complete*/
            if(bt_chip_HCIreset_complete_event_timer != 0 )BT_TimeoutCancel(bt_chip_HCIreset_complete_event_timer);     
            SEND_MESSAGE_TO_CONNECTION_MNGR( BT_INIT_CSR_VERSION_MISMATCH, NULL, 0 );
          }
        }
        else
        {
          /* Cancel the timer to monitor the BT chip initialization timer, since BT stack-chip initialization is complete*/
          if(bt_chip_HCIreset_complete_event_timer != 0 )BT_TimeoutCancel(bt_chip_HCIreset_complete_event_timer);     
          SEND_MESSAGE_TO_CONNECTION_MNGR( BT_INIT_CSR_VERSION_MISMATCH, NULL, 0 );          
        }
        EndPhase (&hciPhase, BT_MNGR_HCI_SEND_BCCMD );
      }
      /* Rest of the HCI_BCCMD commands go here */
      else
      {
	switch(btcmd.seqno)
	{
  
	case ((BT_MNGR_HCI_SETUSB_TRANSPORT << 8) | BT_MNGR_HCI_SETUSBTL ):			
		if( btcmd.varid == BCCMD_VARID_PS )
		{
			if( btcmd.status == BCCMD_STATUS_OK )
			{
				hciState = BT_MNGR_HCI_GETUSBTL;
			}
			else
			{
				hciState = BT_MNGR_HCI_SETUSBTL;
			}
			RunHciStateMachine();
		}
		else
		{
			/* State machine error */
		}
		break;
		
	case ((BT_MNGR_HCI_SETUSB_TRANSPORT << 8) | BT_MNGR_HCI_GETUSBTL):
		if( btcmd.varid == BCCMD_VARID_PS )
		{
			if( btcmd.status == BCCMD_STATUS_OK )
			{
				if( btcmd.d.ps.data == PSKEY_VALUE_USBLINK )
				{
					hciState = BT_MNGR_HCI_SETWARMRESET;				
				}
				else
				{
					hciState = BT_MNGR_HCI_SETUSBTL;
				}
			}
			else
			{
				hciState = BT_MNGR_HCI_GETUSBTL;
			}			
			RunHciStateMachine();			
		}
		else
		{
			/* State machine error */
		}
		break;

	case ((BT_MNGR_HCI_SETUSB_TRANSPORT << 8) | BT_MNGR_HCI_SETWARMRESET):
		/* GETRESP will not reach here */		
		if( btcmd.varid == BCCMD_VARID_WARMRESET )
		{
			if( btcmd.status == BCCMD_STATUS_OK )
			{
				/* Do not End phase */
				//EndPhase (&hciPhase, BT_MNGR_HCI_SETUSB_TRANSPORT );
			}
			else
			{
				hciState = BT_MNGR_HCI_SETWARMRESET;
				RunHciStateMachine();			
			}			
		}
		else
		{
			/* State machine error */
		}
		break;

	case ((BT_MNGR_HCI_DEVICE_TEST << 8) | BT_MNGR_HCI_DEVTEST_1):
		/* GETRESP will not reach here */		
		if( btcmd.varid == BCCMD_VARID_DUT1 )
		{
			if( btcmd.status == BCCMD_STATUS_OK )
			{
				hciState = BT_MNGR_HCI_DEVTEST_2;
				RunHciStateMachine();			
			}
			else
			{
				hciState = BT_MNGR_HCI_DEVTEST_1;
				RunHciStateMachine();			
			}			
		}
		else
		{
			/* State machine error */
		}
		break;

	case ((BT_MNGR_HCI_DEVICE_TEST << 8) | BT_MNGR_HCI_DEVTEST_2):
		/* GETRESP will not reach here */		
		if( btcmd.varid == BCCMD_VARID_DUT2 )
		{
			if( btcmd.status == BCCMD_STATUS_OK )
			{
				EndPhase (&hciPhase, BT_MNGR_HCI_DEVICE_TEST );
			}
			else
			{
				hciState = BT_MNGR_HCI_DEVTEST_2;
				RunHciStateMachine();			
			}			
		}
		else
		{
			/* State machine error */
		}
		break;	

	case ((BT_MNGR_HCI_SEND_BCCMD << 8) | BT_MNGR_HCI_CUSTOM_CMDSEND):
                if( btcmd.varid == BCCMD_VARID_RADIOTEST )
                {
                        if( btcmd.status == BCCMD_STATUS_OK )
                        {
                                EndPhase (&hciPhase, BT_MNGR_HCI_SEND_BCCMD );
                        }
                        else
                        {
                                hciState = BT_MNGR_HCI_CUSTOM_CMDSEND;
                                RunHciStateMachine(); 		
                        } 		
                }
                else
                {
                        /* State machine error */
                }

		break;


        default:
		break;
	}        
      }
    }
    /* Raw VM packet */
    else
    {
          Descriptor.all = BT_MNGR_HCI_FIRSTFRAGMENT << 7 |
                           BT_MNGR_HCI_LASTFRAGMENT << 6 |
                           BT_MNGR_HCI_CHANNELID_VM;      
          
	  if( (event->hciEventPacket[0] == 0xFF)
              /* verify reply length - always 9 bytes for vendor command reply event */
              && (event->hciEventPacket[1] == 0x09)
              /* Verify Payload Descriptor */
              && (event->hciEventPacket[2] == Descriptor.all))
          {
            /* The reply data is flipped. eg. 0xFF00 is returned as 0x00FF 
              So check for the tenth byte to check command status
              eg: ff 09 cd 04 00 65 00 01 00 00 ff*/
            if( event->hciEventPacket[9] == CSR_DSP_COMMAND_SUCCESS )
            {
              switch(vm_cmd_send_state)
              {
                case LOAD_DSP_CMD:
                  vm_cmd_send_state = AUDIO_DETECT_ON_CMD;
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();            
                  break;
                case AUDIO_DETECT_ON_CMD:
                  vm_cmd_send_state = SET_OUTPUT_GAIN_CMD;
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();                        
                  break;
                case SET_OUTPUT_GAIN_CMD:
                  vm_cmd_send_state = SET_INPUT_GAIN_CMD;
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();                        
                  break;  
                case SET_INPUT_GAIN_CMD:
                  vm_cmd_send_state = SET_THRESH_CMD;
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();                        
                  break;           
                case SET_THRESH_CMD:
                  vm_cmd_send_state = SET_DELAY_CMD;
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();                        
                  break;        
                case SET_DELAY_CMD:
                  break;                           
                case UNLOAD_DSP_CMD:
                  sco_handle = 0x0000;
                  break;
                case AUDIO_DETECT_OFF_CMD:
                  vm_cmd_send_state = UNLOAD_DSP_CMD;
                  hciState = BT_MNGR_HCI_VM_CMDSEND;
                  RunHciStateMachine();   
                  break;
                case PING_CMD:
                  break;
                default:
                  break;
              }
            }
            else
            {
              // Failure Response Received
              fatal_error_reset(); 
            }
          }
    	return;
    }
}

/*===========================================================================
 *  Function:       bluetooth_manager_init
 *  Description:    deassert BT reset
 *  Returns:        none
 *===========================================================================*/
void bluetooth_manager_init(void)
{
  /* Deassert CSR Reset */
  gpio_clr_gpio_pin(UP_RST_BT_GPIO_PIN);
}


/*===========================================================================
 *  Function:       BT_MNGR_HSP_RssiSort
 *  Description:    sorting HSP with rssi value
 *  Returns:        none
 *===========================================================================*/
void BT_MNGR_RssiSort(BT_MNGR_Device * database, BT_U16 size)
{
  BT_U8 i,j;
  BT_BOOL swap;

  /* protection */
  if( size < 2 ) return;
  if( size >= BT_MNGR_MAX_INQUIRY_RESULTS ) return;

  for( i = 0; i < (size - 1); i++ )
  {
    swap = FALSE;
    for( j = 0; j < (size - (i + 1)); j++)
    {
      if(  database[j].rssi < database[j + 1].rssi )
      {
         BT_swap( &database[j], &database[j+1] );
         swap = TRUE;
      }
    }
    if( swap == FALSE )
    {
      break;
    }
  }
}

/*===========================================================================
 *  Function:       BT_swap
 *  Description:    swaping 2 address
 *  Returns:        none
 *===========================================================================*/
void BT_swap( BT_MNGR_Device* A, BT_MNGR_Device* B )
{
  BT_MNGR_Device C;

  memcpy ( &C, B, sizeof(BT_MNGR_Device) );
  memcpy ( B, A, sizeof(BT_MNGR_Device) );
  memcpy ( A, &C, sizeof(BT_MNGR_Device) );
}


#ifdef BT_ENABLE_SW_TST_UART
/*===========================================================================
 *  Function:       BT_swap
 *  Description:    swaping 2 address
 *  Returns:        none
 *===========================================================================*/
void BT_PrintDeviceDiscoveryDatabase(BT_MNGR_Device * database, BT_U16 size)
{
  BT_U8 i;

  /* protection */
  if( size >= BT_MNGR_MAX_INQUIRY_RESULTS ) return;

  for( i = 0; i < size; i++ )
  {
    BT_RawLog("--->%.2d) Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x     RSSI:%d     Name:%s\n"
      , i
      , database[i].devinfo.addr[5]
      , database[i].devinfo.addr[4]
      , database[i].devinfo.addr[3]
      , database[i].devinfo.addr[2]
      , database[i].devinfo.addr[1]
      , database[i].devinfo.addr[0]
      , database[i].rssi
      , database[i].name );
  }
}
#endif


/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* GetNextHS(void)
{
	int i;
	BT_MNGR_Device* device = NULL;

	for ( i = 0; !device && i < foundedHSCount;i++ )
	{
		if(foundedHS[i].status == NOT_PAIR)
		{
			device = &foundedHS[i];
		}
	}
	
	return device;
}

/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* GetNextSPP(void)
{
	int i;
	BT_MNGR_Device* device = NULL;

	for ( i = 0; !device && i < foundedR1_4Count;i++ )
	{
		if(foundedR1_4[i].status == NOT_PAIR)
		{
			device = &foundedR1_4[i];
		}
	}
	
	return device;
}

/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* GetNextFilteredSPP(void)
{
	int i;
	BT_MNGR_Device* device = NULL;

	for ( i = 0; !device && i < foundedR1_4Count;i++ )
	{
		if(foundedR1_4[i].status == SERVICE_NAME_MATCH)
		{
			device = &foundedR1_4[i];
		}
	}
	
	return device;
}

/*===========================================================================
 *  Function:       CheckIfAlreadyFound
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* GetPairedHSP(void)
{
	int i;
	BT_MNGR_Device* device = NULL;

	for ( i = 0; !device && i < foundedHSCount;i++ )
	{
		if(foundedHS[i].status == PAIRED)
		{
			device = &foundedHS[i];
		}
	}
	
	return device;
}

/*===========================================================================
 *  Function:       GetPairedSPP
 *  Description:    Returns the device entry if already in found list.
 *  Returns:		Return pointer to BT_MNGR_Device or NULL if not found.
 *===========================================================================*/
static BT_MNGR_Device* GetPairedSPP(void)
{
	int i;
	BT_MNGR_Device* device = NULL;

	for ( i = 0; !device && i < foundedR1_4Count;i++ )
	{
		if(foundedR1_4[i].status == PAIRED)
		{
			device = &foundedR1_4[i];
		}
	}
	
	return device;
}

/*===========================================================================
 *  Function:       BT_PrintDeviceInfo
 *  Description:    swaping 2 address
 *  Returns:        none
 *===========================================================================*/
void BT_PrintDeviceInfo(BT_MNGR_Device * database)
{
    #ifdef BT_ENABLE_SW_TST_UART
    BT_RawLog("--->Address: %.2x:%.2x:%.2x:%.2x:%.2x:%.2x     RSSI:%d     profile:%d     Name:%s\n"
      , database->devinfo.addr[5]
      , database->devinfo.addr[4]
      , database->devinfo.addr[3]
      , database->devinfo.addr[2]
      , database->devinfo.addr[1]
      , database->devinfo.addr[0]
      , database->rssi
      , database->devinfo.profile
      , database->name );
    #endif
}

/*===========================================================================
 *  Function:       BT_SetReverseNibblerDataOut
 *  Description:    Store Nibbler Data into buffer to send out
 *  Returns:        none
 *===========================================================================*/
BT_BOOL BT_SetheadsetReverseNibblerDataOut(BT_U8* Data, BT_U8 length)
{
  if( (headsetReverseNibblerOutSize == 0) && (length < NIBBLER_DATA_OUT_BUFFER) )
  {
    memcpy( &headsetNibblerDataOut[0], Data, length );
    headsetReverseNibblerOutSize = length * 2;
    
    return BT_TRUE;
  }
  return BT_FALSE;
}

/*===========================================================================
 *  Function:       BT_SetReverseNibblerDataOut
 *  Description:    Store Nibbler Data into buffer to send out
 *  Returns:        none
 *===========================================================================*/
BT_BOOL BT_SetwirelessPTTReverseNibblerDataOut(BT_U8* Data, BT_U8 length)
{
  if( (wirelessPTTReverseNibblerOutSize == 0) && (length < NIBBLER_DATA_OUT_BUFFER) )
  {
    memcpy( &wirelessPTTNibblerDataOut[0], Data, length );
    wirelessPTTReverseNibblerOutSize = length * 2;
    
    return BT_TRUE;
  }
  return BT_FALSE;
}

/*===========================================================================
 *  Function:       BT_GetReverseNibbler
 *  Description:    Get reverse Nibbler Data, Encode data to be send out
 *  Returns:        size of nibbler
 *===========================================================================*/
BT_U8 BT_GetHSPReverseNibbler(BT_U8* Data_out)
{
  BT_U8 NibblerByte = 0;
  BT_U8 size;
  BT_U8 i;


  if( headsetReverseNibblerOutSize == 0 )
  {
    if( isAudioDetectMute == TRUE )
    {
      NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & MUTE_NIBBLER_BIT);
    }
    else
    {
      NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & UNMUTE_NIBBLER_BIT); 
    }

    NibblerByte |= (NIBBLER_DATA_PRESENCE_MASK & NIBBLER_DATA_NOT_PRESENCE_BIT );
    *(Data_out) = NibblerByte; 
    size = 1;

    //#ifdef BT_ENABLE_SW_TST_UART
    //BT_RawLog("0x%.2x ", NibblerByte);
    //#endif
  }
  else
  {
    size = headsetReverseNibblerOutSize;
    for( i = 0; i < headsetReverseNibblerOutSize; i++)
    {
      if( isAudioDetectMute == TRUE )
      {
        NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & MUTE_NIBBLER_BIT);
      }
      else
      {
        NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & UNMUTE_NIBBLER_BIT); 
      }

      NibblerByte |= (NIBBLER_DATA_PRESENCE_MASK & NIBBLER_DATA_PRESENCE_BIT );

      if( (i % 2) == 0 )
      {
        NibblerByte |= (UPPER_LOWER_NIBBLER_DATA_MASK & UPPER_NIBBLER_DATA_BIT );
        NibblerByte |= ((headsetNibblerDataOut[i/2] >> 4)& 0x0F);
      }
      else
      {
        NibblerByte |= (UPPER_LOWER_NIBBLER_DATA_MASK & LOWER_NIBBLER_DATA_BIT );
        NibblerByte |= (headsetNibblerDataOut[i/2] & 0x0F); 
      }
      
      *(Data_out + i) = NibblerByte; 
      //#ifdef BT_ENABLE_SW_TST_UART
      //BT_RawLog("0x%.2x ", NibblerByte);
      //#endif
      NibblerByte = 0;
      
     }
     headsetReverseNibblerOutSize = 0;
  }
  return size;
}

/*===========================================================================
 *  Function:       BT_GetSPPReverseNibbler
 *  Description:    Get reverse Nibbler Data, Encode data to be send out
 *  Returns:        size of nibbler
 *===========================================================================*/
BT_U8 BT_GetSPPReverseNibbler(BT_U8* Data_out)
{
  BT_U8 NibblerByte = 0;
  BT_U8 size;
  BT_U8 i;


  if( wirelessPTTReverseNibblerOutSize == 0 )
  {
    if( isAudioDetectMute == TRUE )
    {
      NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & MUTE_NIBBLER_BIT);
    }
    else
    {
      NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & UNMUTE_NIBBLER_BIT); 
    }

    NibblerByte |= (NIBBLER_DATA_PRESENCE_MASK & NIBBLER_DATA_NOT_PRESENCE_BIT );
    *(Data_out) = NibblerByte; 
    size = 1;

    //#ifdef BT_ENABLE_SW_TST_UART
    //BT_RawLog("0S%.2x ", NibblerByte);
    //#endif
  }
  else
  {
    size = wirelessPTTReverseNibblerOutSize;
    for( i = 0; i < wirelessPTTReverseNibblerOutSize; i++)
    {
      if( isAudioDetectMute == TRUE )
      {
        NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & MUTE_NIBBLER_BIT);
      }
      else
      {
        NibblerByte |= (MUTE_UNMUTE_NIBBLER_MASK & UNMUTE_NIBBLER_BIT); 
      }

      NibblerByte |= (NIBBLER_DATA_PRESENCE_MASK & NIBBLER_DATA_PRESENCE_BIT );

      if( (i % 2) == 0 )
      {
        NibblerByte |= (UPPER_LOWER_NIBBLER_DATA_MASK & UPPER_NIBBLER_DATA_BIT );
        NibblerByte |= ((wirelessPTTNibblerDataOut[i/2] >> 4)& 0x0F);
      }
      else
      {
        NibblerByte |= (UPPER_LOWER_NIBBLER_DATA_MASK & LOWER_NIBBLER_DATA_BIT );
        NibblerByte |= (wirelessPTTNibblerDataOut[i/2] & 0x0F); 
      }
      
      *(Data_out + i) = NibblerByte; 
      //#ifdef BT_ENABLE_SW_TST_UART
      //BT_RawLog("0S%.2x ", NibblerByte);
      //#endif
      NibblerByte = 0;
      
     }
     wirelessPTTReverseNibblerOutSize = 0;
  }
  return size;
}


/*===========================================================================
 *  Function:       BT_DebugUnknownPermitive
 *  Description:    logging for unservice permitive
 *  Returns:        size of nibbler
 *===========================================================================*/
void BT_DebugUnknownPermitive(BT_U16 Premitive)
{
  #ifdef BT_ENABLE_SW_TST_UART
  BT_RawLog("---> UnknownPermitive %d", Premitive);
  #endif
}

/*===========================================================================
 *  Function:       BT_SetDeviceDatabase
 *  Description:    Input for device database
 *  Returns:        TRUE/FALSE
 *===========================================================================*/
BT_BOOL BT_SetDeviceDatabase(btDevInfo* dev)
{
  BT_U8 i;

  if( dev->profile == NO_DEVICE ) return BT_FALSE;
  
  if( capture_time_semaphore( BTMNG_SHARE_DB, portMAX_DELAY) == SEM_RET_SUCCESS )
  {
    /* replace same profile if have any */
    for( i = 0; i < MAX_DEV_DATABASE; i++ )
    {
      if(device_database[i].profile == dev->profile)
      {
        memcpy( &device_database[i], dev, sizeof(btDevInfo));
        release_semaphore( BTMNG_SHARE_DB );
        return BT_TRUE;
      }
    }

    /* add in new entry */
    for( i = 0; i < MAX_DEV_DATABASE; i++ )
    {
      if( device_database[i].profile == NO_DEVICE )
      {
        memcpy( &device_database[i], dev, sizeof(btDevInfo));
        release_semaphore( BTMNG_SHARE_DB );
        return BT_TRUE;
      }
    }
    release_semaphore( BTMNG_SHARE_DB );
  }
  
  return BT_FALSE;
}

/*===========================================================================
 *  Function:       BT_ClearDeviceDatabase
 *  Description:    Input for device database
 *  Returns:        TRUE/FALSE
 *===========================================================================*/
BT_BOOL BT_ClearDeviceDatabase(btDevInfo* dev)
{
  BT_U8 i;

  if( capture_time_semaphore( BTMNG_SHARE_DB, portMAX_DELAY) == SEM_RET_SUCCESS )
  {
    if(dev == NULL) 
    {
      memset( &device_database, 0x00, sizeof(device_database) );
      release_semaphore( BTMNG_SHARE_DB );
      return BT_TRUE;
    }
    else
    {
      for( i = 0; i < MAX_DEV_DATABASE; i++ )
      {
        if( dev->profile == device_database[i].profile )
        {
          memset( &device_database[i], 0x00, sizeof(btDevInfo) );        
          release_semaphore( BTMNG_SHARE_DB );
          return BT_TRUE;
        }
      }      
    }
    release_semaphore( BTMNG_SHARE_DB );
  }  
  return BT_FALSE;
}

/*===========================================================================
 *  Function:       BT_GetDevProfileInfo
 *  Description:    Get information for device database base on profile
 *  Returns:        btDevInfo
 *===========================================================================*/
btDevInfo* BT_GetDevProfileInfo(DEV_PROFILE profile)
{
  BT_U8 i;

  if( capture_time_semaphore( BTMNG_SHARE_DB, portMAX_DELAY) == SEM_RET_SUCCESS )
  {
    for( i = 0; i < MAX_DEV_DATABASE; i++ )
    {
      if( device_database[i].profile == profile )
      {
        release_semaphore( BTMNG_SHARE_DB );
        return &device_database[i];
      }
    }
    release_semaphore( BTMNG_SHARE_DB );
  }
  
  return NULL;
}

/*===========================================================================
*  Function:       BT_GetDevAddrInfo
*  Description:    search for match address
*  Returns:        btDevInfo
*===========================================================================*/
btDevInfo* BT_GetDevAddrInfo(BT_BdAddr addr)
{
  BT_U8 i;

  if( capture_time_semaphore( BTMNG_SHARE_DB, portMAX_DELAY) == SEM_RET_SUCCESS )
  {
    for( i = 0; i < MAX_DEV_DATABASE; i++ )
    {
      if( CompareBTAddress( device_database[i].addr, addr ) )
      {
        release_semaphore( BTMNG_SHARE_DB );    
        return &device_database[i];
      }
    }
    release_semaphore( BTMNG_SHARE_DB );    
  }
  
  return NULL;
}

/*===========================================================================
 *  Function:       store_nibbler_decoded_data_byte_in_buffer
 *  Description:    Clear entire device database
 *  Returns:        void
 *===========================================================================*/
static void store_headset_nibbler_decoded_data_byte_in_buffer( unsigned char datain )
{
  BT_U8 i;
  static BT_U8 temp_buffer[NIBBLER_BUFFER_MAX_SIZE_BYTES];
  BT_U8 temp_size = 0;

  if(headset_status.Is_AT_Handshaking_done == BT_FALSE)
  {
    if( datain != 0x0A )
    {
      headset_nibbler_decoder_in_buffer[ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index++] = datain;
      ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index %= NIBBLER_BUFFER_MAX_SIZE_BYTES;
    }
    
    if( datain == 0x0D )
    {
      memset( temp_buffer, 0, sizeof(temp_buffer) );
  
      for( i = ptr_to_headset_nibbler_decoder_in_buffer->out_buffer_index
          ; i !=  ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index
          ; i++, i%= NIBBLER_BUFFER_MAX_SIZE_BYTES )
      {
        temp_buffer[temp_size++] = headset_nibbler_decoder_in_buffer[i];
      }
      ptr_to_headset_nibbler_decoder_in_buffer->out_buffer_index = ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index;
  
      BT_HSP_ATPraser( &temp_buffer[0], temp_size);
    }
  }
  else //AT Handshaking done for Audio Device -Start XNL-XCMP
  {
    // Check in HSP_AG_NIBBLER_IND to send all the decoded data at once after AT handshake is done
    headset_nibbler_decoder_in_buffer[ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index++] = datain;
    ptr_to_headset_nibbler_decoder_in_buffer->in_buffer_index %= NIBBLER_BUFFER_MAX_SIZE_BYTES;
  }
}

/*===========================================================================
 *  Function:       store_wirelessPTT_nibbler_decoded_data_byte_in_buffer
 *  Description:    Clear entire device database
 *  Returns:        void
 *===========================================================================*/
static void store_wirelessPTT_nibbler_decoded_data_byte_in_buffer( unsigned char datain )
{
  BT_U8 i;
  static BT_U8 temp_buffer[NIBBLER_BUFFER_MAX_SIZE_BYTES];
  BT_U8 temp_size = 0;

  if(wirelessPTT_status.Is_AT_Handshaking_done == BT_FALSE)
  {
    if( datain != 0x0A )
    {
      wirelessPTT_nibbler_decoder_in_buffer[ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index++] = datain;
      ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index %= NIBBLER_BUFFER_MAX_SIZE_BYTES;
    }
    
    if( datain == 0x0D )
    {
      memset( temp_buffer, 0, sizeof(temp_buffer) );
  
      for( i = ptr_to_wirelessPTT_nibbler_decoder_in_buffer->out_buffer_index
          ; i !=  ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index
          ; i++, i%= NIBBLER_BUFFER_MAX_SIZE_BYTES )
      {
        temp_buffer[temp_size++] = wirelessPTT_nibbler_decoder_in_buffer[i];
      }
      ptr_to_wirelessPTT_nibbler_decoder_in_buffer->out_buffer_index = ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index;
  
      BT_SPP_ATPraser( &temp_buffer[0], temp_size);
    }
  }
  else  //AT Handshaking done for SPP device -Start XNL-XCMP
  {
    wirelessPTT_nibbler_decoder_in_buffer[ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index++] = datain;
    ptr_to_wirelessPTT_nibbler_decoder_in_buffer->in_buffer_index %= NIBBLER_BUFFER_MAX_SIZE_BYTES;
  }
}

/*===========================================================================
*  Function:       BT_HSP_ATPraser
*  Description:    search for match address
*  Returns:        btDevInfo
*===========================================================================*/
void BT_HSP_ATPraser(BT_U8 *datain, BT_U8 length)
{ 
  BT_U8* at_cmd_ptr = NULL;
  BT_U8  sizeof_at_cmd = 0;

  #ifdef BT_ENABLE_SW_TST_UART
  BT_RawLog("--->#### HS ATPraser receive = %s \n",datain);
  #endif

  if( strcmp( (const char*)datain, "AT+CONF=0\r") == 0 )
  {
    if( audiodev_atfail_TMO != NULL ) 
    {
      BT_TimeoutCancel(audiodev_atfail_TMO);
      audiodev_atfail_TMO = NULL;
    }

    at_cmd_ptr = (BT_U8*)&ok_at_cmd[0];
    sizeof_at_cmd = sizeof(ok_at_cmd) - 1;
  }
  else if( strcmp( (const char*)datain, "AT+XCMP=0\r" ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&ok_at_cmd[0];
    sizeof_at_cmd = sizeof(ok_at_cmd) - 1;
    headset_status.Is_AT_Handshaking_done = BT_TRUE; 
    headset_status.Is_comm_over_xnl_xcmp = BT_TRUE;
    
    //Start XNL timer to send Master Device Broadcast
    if (!tc_flags.simulator_enable)
    {
      xnl_timer_start_send_master_status_delay(device_1_id);
    }
  }  
  else if( strcmp( (const char*)datain, "AT+CONF=2\r" ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&ok_at_cmd[0];
    sizeof_at_cmd = sizeof(ok_at_cmd) - 1;
    headset_status.Is_AT_Handshaking_done = BT_TRUE;  
    headset_status.Is_comm_over_xnl_xcmp = BT_FALSE;
  }
  else if( strncmp( (const char*)datain, "AT+VGS=", 7 ) == 0 )
  {
    strcpy(broadcastVolInfo.volAtCmd,(const char*)datain);
    strcpy(broadcastVolInfo.volAtCmd,&(broadcastVolInfo.volAtCmd[2]));
    strcat(broadcastVolInfo.volAtCmd, "\r");
    
    if( wirelessPTT_status.Is_SPP_flow_enable == BT_TRUE
        && wirelessPTT_status.Is_AT_Handshaking_done == BT_TRUE
        && wirelessPTT_status.Is_comm_over_xnl_xcmp == BT_FALSE
        && (BT_SetwirelessPTTReverseNibblerDataOut( ((BT_U8*)&(broadcastVolInfo.volAtCmd))
               , 8) == BT_TRUE) )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->>>ATPraser reply to SPP  = %s \n",broadcastVolInfo.volAtCmd);
      #endif
      
      sendSppAtCmdRsp(SEND_R1_4_REVERSE_NIBBLER);
    }
 }
   else if( strcmp( (const char*)datain, "AT+LED=0\r" ) == 0 )
   {

     SEND_MESSAGE_TO_CONTROLS_MANAGER(BT_LED_DARK_MODE, NULL, 0);   

     if( wirelessPTT_status.Is_SPP_flow_enable == BT_TRUE
         && wirelessPTT_status.Is_AT_Handshaking_done == BT_TRUE
         && wirelessPTT_status.Is_comm_over_xnl_xcmp == BT_FALSE  
         && (BT_SetwirelessPTTReverseNibblerDataOut( (BT_U8*)&led_off_at_cmd_rpy[0], (sizeof(led_off_at_cmd_rpy) - 1) ) == BT_TRUE) )
     {
       #ifdef BT_ENABLE_SW_TST_UART
       BT_RawLog("--->>>ATPraser reply to SPP  = %s \n", &led_off_at_cmd_rpy[0]);
       #endif
       
       sendSppAtCmdRsp(SEND_R1_4_REVERSE_NIBBLER);
     }
  }

  else if( strcmp( (const char*)datain, "AT+LED=1\r" ) == 0 )
  {

    SEND_MESSAGE_TO_CONTROLS_MANAGER( BT_NORMAL_LED_MODE, NULL, 0);   

    if( wirelessPTT_status.Is_SPP_flow_enable == BT_TRUE
        && wirelessPTT_status.Is_AT_Handshaking_done == BT_TRUE
        && wirelessPTT_status.Is_comm_over_xnl_xcmp == BT_FALSE
        && (BT_SetwirelessPTTReverseNibblerDataOut( (BT_U8*)&led_on_at_cmd_rpy[0], (sizeof(led_on_at_cmd_rpy) - 1) ) == BT_TRUE) )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->>>ATPraser reply to SPP  = %s \n", &led_on_at_cmd_rpy[0]);
      #endif
      
      sendSppAtCmdRsp(SEND_R1_4_REVERSE_NIBBLER);
    }
  }
  else if( strcmp( (const char*)datain, "OK\r" ) == 0 )
  {
    if( headset_status.AT_cmd_state == AT_CMD_STATE_MPTT_DISCONNECTED 
      || headset_status.AT_cmd_state == AT_CMD_STATE_MPTT_CONNECTED )
    {
      headset_status.AT_cmd_state = AT_CMD_STATE_NON;
      headset_status.AT_cmd_retry_cnt = 0;
      if( mptt_reply_TMO != NULL )BT_TimeoutCancel(mptt_reply_TMO);
    }
  }
  else if( strncmp( (const char*)datain, "AT+CGMI=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }  
  else if( strncmp( (const char*)datain, "AT+CGMM=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+CGMR=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+CGSN=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strcmp( (const char*)datain, "ERROR\r" ) == 0 )
  {
    at_cmd_ptr = NULL;
    sizeof_at_cmd = 0;
  }
  /* extended AT command */  
  else if( strncmp( (const char*)datain, "AT+NIBBLER=", 11 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+RFCOMM=", 10 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+LRRP=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }

  if( at_cmd_ptr != NULL && sizeof_at_cmd != 0 )
  {
    if( (headset_status.Is_SPP_flow_enable == BT_TRUE) 
       && (nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE) 
       && (BT_SetheadsetReverseNibblerDataOut( at_cmd_ptr , sizeof_at_cmd) == BT_TRUE) )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->#### HS ATPraser reply = %s \n",at_cmd_ptr);
      #endif

      sendHspAgAtCmdRsp(REVERSE_NIBBLER);
    
      BT_reverse_nibbler_resend();
    }
  }

}

/*===========================================================================
*  Function:       BT_SPP_ATPraser
*  Description:    search for match address
*  Returns:        btDevInfo
*===========================================================================*/
void BT_SPP_ATPraser(BT_U8 *datain, BT_U8 length)
{ 
  BT_U8* at_cmd_ptr = NULL;
  BT_U8  sizeof_at_cmd = 0;

  #ifdef BT_ENABLE_SW_TST_UART
  BT_RawLog("--->#### SPP ATPraser receive = %s \n",datain);
  #endif

  if( strcmp( (const char*)datain, "AT+CONF=0\r" ) == 0 )
  {
    if( nonaudiodev_atfail_TMO != NULL ) 
    {
      BT_TimeoutCancel(nonaudiodev_atfail_TMO);
      nonaudiodev_atfail_TMO = NULL;
    }

    at_cmd_ptr = (BT_U8*)&ok_at_cmd[0];
    sizeof_at_cmd = sizeof(ok_at_cmd) - 1;
  }
  else if( strcmp( (const char*)datain, "AT+XCMP=0\r" ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&ok_at_cmd[0];
    sizeof_at_cmd = sizeof(ok_at_cmd) - 1;
    wirelessPTT_status.Is_AT_Handshaking_done = BT_TRUE;
    wirelessPTT_status.Is_comm_over_xnl_xcmp = BT_TRUE;
        //Start XNL timer to send MAster Device Broadcast
    xnl_timer_start_send_master_status_delay(device_2_id);
  }  
  else if( strcmp( (const char*)datain, "AT+CONF=2\r" ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&ok_at_cmd[0];
    sizeof_at_cmd = sizeof(ok_at_cmd) - 1;
    wirelessPTT_status.Is_AT_Handshaking_done = BT_TRUE;
    wirelessPTT_status.Is_comm_over_xnl_xcmp = BT_FALSE;
    wirelessPTT_status.AT_cmd_state = AT_CMD_STATE_INITIALIZE_VGS;
  }
  else if( strncmp( (const char*)datain, "AT+VGS=", 7 ) == 0 )
  {
    strcpy(broadcastVolInfo.volAtCmd,(const char*)datain);
    strcpy(broadcastVolInfo.volAtCmd,&(broadcastVolInfo.volAtCmd[2]));
    strcat(broadcastVolInfo.volAtCmd, "\r");
    
    if( (headset_status.Is_NIBBLER_enable == BT_TRUE)
      && (headset_status.Is_AT_Handshaking_done == BT_TRUE)
      && (headset_status.Is_comm_over_xnl_xcmp == BT_FALSE)
      && (BT_SetheadsetReverseNibblerDataOut( ((BT_U8*)&(broadcastVolInfo.volAtCmd)), 8) == BT_TRUE) )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->>> ATPraser reply to HS  = %s \n", &broadcastVolInfo.volAtCmd[0]);
      #endif

      sendHspAgAtCmdRsp(REVERSE_NIBBLER);

      BT_reverse_nibbler_resend();
    }
  }
  else if( strcmp( (const char*)datain, "AT+LED=0\r" ) == 0 )
  {  

    SEND_MESSAGE_TO_CONTROLS_MANAGER(BT_LED_DARK_MODE, NULL, 0);   

    if( (headset_status.Is_NIBBLER_enable == BT_TRUE)
      && (headset_status.Is_AT_Handshaking_done == BT_TRUE)
      && (headset_status.Is_comm_over_xnl_xcmp == BT_FALSE)
      && (BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&led_off_at_cmd_rpy[0], (sizeof(led_off_at_cmd_rpy) - 1) ) == BT_TRUE) )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->#### SPP ATPraser reply = %s \n",&led_off_at_cmd_rpy[0]);
      #endif

      sendHspAgAtCmdRsp(REVERSE_NIBBLER);

      BT_reverse_nibbler_resend();
    }
  }
  else if( strcmp( (const char*)datain, "AT+LED=1\r" ) == 0 )
  {  

    SEND_MESSAGE_TO_CONTROLS_MANAGER( BT_NORMAL_LED_MODE, NULL, 0);   

    if( (headset_status.Is_NIBBLER_enable == BT_TRUE)
      && (headset_status.Is_AT_Handshaking_done == BT_TRUE)
      && (headset_status.Is_comm_over_xnl_xcmp == BT_FALSE)
      && (BT_SetheadsetReverseNibblerDataOut( (BT_U8*)&led_on_at_cmd_rpy[0], (sizeof(led_on_at_cmd_rpy) - 1) ) == BT_TRUE) )
    {
      #ifdef BT_ENABLE_SW_TST_UART
      BT_RawLog("--->#### SPP ATPraser reply = %s \n",&led_on_at_cmd_rpy[0]);
      #endif

      sendHspAgAtCmdRsp(REVERSE_NIBBLER);

      BT_reverse_nibbler_resend();
    }
  }
  else if( strncmp( (const char*)datain, "AT+CGMI=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }  
  else if( strncmp( (const char*)datain, "AT+CGMM=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+CGMR=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+CGSN=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strcmp( (const char*)datain, "OK\r" ) == 0 )
  {
    at_cmd_ptr = NULL;
    sizeof_at_cmd = 0;
  }
  else if( strcmp( (const char*)datain, "ERROR\r" ) == 0 )
  {
    at_cmd_ptr = NULL;
    sizeof_at_cmd = 0;
  }
  /* extended AT command */  
  else if( strncmp( (const char*)datain, "AT+NIBBLER=", 11 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+RFCOMM=", 10 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }
  else if( strncmp( (const char*)datain, "AT+LRRP=", 8 ) == 0 )
  {
    at_cmd_ptr = (BT_U8*)&error_at_cmd[0];
    sizeof_at_cmd = sizeof(error_at_cmd) - 1;
  }


  
  if( at_cmd_ptr != NULL && sizeof_at_cmd != 0 )
  {
    if( (wirelessPTT_status.Is_SPP_flow_enable == BT_TRUE) 
        && (nibbler_get_enable_status(&wirelessPTT_nibbler) == NIBBLER_ENABLE) 
        && (BT_SetwirelessPTTReverseNibblerDataOut( at_cmd_ptr , sizeof_at_cmd) == BT_TRUE) )
    {
       #ifdef BT_ENABLE_SW_TST_UART
       BT_RawLog("--->#### SPP ATPraser reply = %s \n",at_cmd_ptr);
       #endif
       
       sendSppAtCmdRsp(SEND_R1_4_REVERSE_NIBBLER);

       if( (wirelessPTT_status.Is_AT_Handshaking_done == BT_TRUE)
          && (headset_status.Is_AT_Handshaking_done == BT_TRUE)
          && (headset_status.Is_comm_over_xnl_xcmp == BT_FALSE)
          && (wirelessPTT_status.Is_comm_over_xnl_xcmp == BT_FALSE)
          && (wirelessPTT_status.AT_cmd_state == AT_CMD_STATE_INITIALIZE_VGS)
          && (BT_SetwirelessPTTReverseNibblerDataOut( ((BT_U8*)&(broadcastVolInfo.volAtCmd)), 8) == BT_TRUE) )
        {
          #ifdef BT_ENABLE_SW_TST_UART
          BT_RawLog("--->#### SPP ATPraser reply = %s \n", &broadcastVolInfo.volAtCmd[0] );
          #endif

          /* send Volume level On connection of Wireless PTT 
            if Headset Connected first 
          */
          wirelessPTT_status.AT_cmd_state = AT_CMD_STATE_NON;
          sendSppAtCmdRsp(SEND_R1_4_REVERSE_NIBBLER);
          /* Volume level should be send only on new connection */
      }
    }
  }
}

/*===========================================================================
*  Function:       BT_MNG_Clear_Audiodev_NibblerBuffer
*  Description:    clear nibbler data buffer
*  Returns:        non
*===========================================================================*/
void BT_MNG_Clear_Audiodev_NibblerBuffer( void )
{
  memset( &headset_nibbler_decoder, 0x00, sizeof(headset_nibbler_decoder) );
  memset( &headset_nibbler_decoder_in_buffer, 0x00, sizeof(headset_nibbler_decoder_in_buffer) );
  
  headset_nibbler_decoder.buffer_size = NIBBLER_BUFFER_MAX_SIZE_BYTES;
  headset_nibbler_decoder.data_buffer_array_ptr = &headset_nibbler_decoder_in_buffer[0];
}

 
/*===========================================================================
*  Function:       BT_MNG_Clear_NonAudiodev_NibblerBuffer
*  Description:    clear nibbler data buffer
*  Returns:        non
*===========================================================================*/
void BT_MNG_Clear_NonAudiodev_NibblerBuffer( void )
{
 memset( &wirelessPTT_nibbler_decoder, 0x00, sizeof(wirelessPTT_nibbler_decoder) );
 memset( &wirelessPTT_nibbler_decoder_in_buffer, 0x00, sizeof(wirelessPTT_nibbler_decoder_in_buffer) );
 
 wirelessPTT_nibbler_decoder.buffer_size = NIBBLER_BUFFER_MAX_SIZE_BYTES;
 wirelessPTT_nibbler_decoder.data_buffer_array_ptr = &headset_nibbler_decoder_in_buffer[0];
}

/*===========================================================================
*  Function:       BT_HSSPKR_controller
*  Description:    mute and unmute function
*  Returns:        non
*===========================================================================*/
void BT_HSSPKR_controller( void )
{
  if(isDetAudmute != spkr_prev_state) 
  {
    spkr_prev_state = isDetAudmute; 
    if(isDetAudmute == true) /* mute */
    {
      reverse_nibbler_set_AUDIO_UNMUTE_flag(&headset_nibbler);
      reverse_nibbler_set_AUDIO_UNMUTE_flag(&wirelessPTT_nibbler);

      isAudioDetectMute = BT_TRUE;
      if(nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE 
          && headset_status.Is_SPP_flow_enable == BT_TRUE)
      {
        /* Send Mute to R1.3 Headset */
        sendHspAgAtCmdRsp(REVERSE_NIBBLER);
      }
    }
    else /* unmute */
    {
      reverse_nibbler_clear_AUDIO_UNMUTE_flag(&headset_nibbler);
      reverse_nibbler_clear_AUDIO_UNMUTE_flag(&wirelessPTT_nibbler);
      
      isAudioDetectMute = BT_FALSE;
      if(nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE 
          && headset_status.Is_SPP_flow_enable == BT_TRUE)
      {
        sendHspAgAtCmdRsp(REVERSE_NIBBLER);

        BT_reverse_nibbler_resend();
      }
    }
  }
}
/*===========================================================================
*  Function:       BT_echo_reverse_nibbler_null_byte
*  Description:    Null Nibble Sequence Number Echo
*  Returns:        non
*===========================================================================*/
void BT_echo_reverse_nibbler_null_byte( BT_U8 data_byte)
{
  //Only allow to send the Null Nibble if GW is mute
  if( isAudioDetectMute == TRUE )
  {
    echo_seq_no = data_byte;
    sendHspAgAtCmdRsp(NULL_NIBBLER);
  }
}
/*===========================================================================
*  Function:       BT_reverse_nibbler_resend
*  Description:    resend reverse nibbler if the audio is in unmute state
*  Returns:        none
*===========================================================================*/
void BT_reverse_nibbler_resend( void )
{
  if( isDetAudmute == true ) return; /* no need to resend if in mute state */
  
  if( ReverseNibblerSyncTimer != 0 )BT_TimeoutCancel(ReverseNibblerSyncTimer);
  ReverseNibblerSyncTimer = BT_TimeoutReq(appSenderId,
                                  TIMER_ID_RUN_DONGLE_PTT_PRESSED_STATE,  /* user timer id */
                                  0,                                      /* userTimerData */
                                  100);                                   /* msTimeout */

}
/*===========================================================================
*  Function:       send_spp_xnl_msg
*  Description:    Send XNL messages to the SPP data stream
*  Returns:        TRUE or FALSE
*===========================================================================*/
success_failure_t send_spp_xnl_msg(UINT8_T *data_tx_ptr, UINT16_T data_tx_length)
{
  if( (wirelessPTT_status.Is_SPP_flow_enable == BT_TRUE)
      && spp_atcommand_retry_TMO == NULL
      && (nibbler_get_enable_status(&wirelessPTT_nibbler) == NIBBLER_ENABLE)
      && (BT_SetwirelessPTTReverseNibblerDataOut( (BT_U8 *)data_tx_ptr , data_tx_length) == BT_TRUE) )
  {
     #ifdef BT_ENABLE_SW_TST_UART
     //U8 j;
     //BT_RawLog("SPP Sent\n");
     //for ( j = 0; j < data_tx_length; j++)  BT_RawLog(" %.2x", data_tx_ptr[j]);
     //BT_RawLog("\n");  
     #endif
     
    if( sendSppAtCmdRsp(SPP_XCMP_REVERSE_NIBBLER) == BT_CONGESTED )
    {
      return FAILURE;
    }
    else
    {
      return SUCC;
    }
  } 
  else
  {
    return FAILURE;
  }
}
/*===========================================================================
*  Function:       send_hsp_xnl_msg
*  Description:    Send XNL messages to the HSP data stream
*  Returns:        TRUE or FALSE
*===========================================================================*/
success_failure_t send_hsp_xnl_msg(UINT8_T *data_tx_ptr, UINT16_T data_tx_length)
{
  if((headset_status.Is_SPP_flow_enable == BT_TRUE)
     && (hsp_atcommand_retry_TMO == NULL)
     && (nibbler_get_enable_status(&headset_nibbler) == NIBBLER_ENABLE) 
     && (BT_SetheadsetReverseNibblerDataOut( (BT_U8 *)data_tx_ptr , data_tx_length) == BT_TRUE) )
  {
    #ifdef BT_ENABLE_SW_TST_UART
    //U8 j;
    //BT_RawLog("HS XNL Message Sent\n");
    //for ( j = 0; j < data_tx_length; j++)  BT_RawLog(" %.2x", data_tx_ptr[j]);
    //BT_RawLog("\n");  
    #endif
  
    if( sendHspAgAtCmdRsp(HSP_XCMP_REVERSE_NIBBLER) == BT_CONGESTED )
    {
      return FAILURE;
    }
    else
    {
      BT_reverse_nibbler_resend();   
      return SUCC;
    }
  }
  else
  {
    return FAILURE;
  }
}
