#ifndef BLUETOOTH_MANAGER_H
#define BLUETOOTH_MANAGER_H

/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <bluetooth_manager.h>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* Chia Weng Sun		08/06/2010   	CCMPD01379068		Initial Creation
* Niravkumar Rabara     09/08/2010      CCMPD01389372           Added typedef and Macro for Bluetooth Manager changed BTCOM to BT_MNGR
* Tan Seng Kai          09/22/2010      CCMPD01394890           Added configuration for BQB and RTTE test
* Niravkumar Rabara	09/23/2010	CCMPD01394958           Headset Profile Audio Gateway implementation. 
* YewFoong Lim          10/04/2010      CCMPD01398520           Added Pairing Status (NewPairing/ PreviousPaired)for Bluetooth Device Info 
* Niravkumar Rabara	10/04/2010	CCMPD01398596           AT Command Implementation for R1.3 Headset Test
* YewFoong Lim          10/06/2010      CCMPD01398520           Updated typedef for Pairing Info
* Tan Seng Kai      10/07/2010          CCMPD01397694           Implement Nibbler and Reverse Nibbler
* Niravkumar Rabara	10/08/2010	CCMPD01400432           Modified RING AT Command to 10 times as per MSC
* Niravkumar Rabara     10/15/2010      CCMPD01402008           Added Serial Port Profile
* Niravkumar Rabara		10/27/2010			CCMPD01405413           Added PTT timeout Timer for Nibbler
* Tan Seng Kai      10/27/2010      CCMPD01407568      Change maximum store SPP and HSP device into 40
* Tan Seng Kai      11/01/2010      CCMPD01408084     Added OS message for Mute and Unmute
* Tan Seng Kai      11/01/2010      CCMPD01408859     Added service name discovery name count for retry
* JJ Low            11/08/2010          CCMPD01410054           Compiler warning resolution for R2.1
* Tan Seng Kai      11/03/2010    CCMPD01409994       Add in typedef for discovery type
* Tan Seng Kai      11/04/2010    CCMPD01410165       Change define for PTT press, release to MUTE and UNMUTE
* Tan Seng Kai      11/12/2010    CCMPD01413546       Add macro for max timer allocation
* Niravkumar Rabara 11/14/2010    CCMPD01413929       Added Timers for SPP
* Niravkumar Rabara 11/19/2010    CCMPD01415880       Added macro for Bluetooth Qualification Mode.
* Chia Weng Sun     12/03/2013    CCMPD00000000       Support BT Spec R2.1 HCI Events
* Tan Seng Kai      12/06/2010    CCMPD01450321       Added Timer for SPP service search connection TMO
* Tan Seng Kai      12/08/2010    CCMPD01451448       Added in Linkey handler
* YewFoong          12/10/2010    CCMPD01452415       Added mcro for max device search cycle
* Tan Seng Kai      12/17/2010    CCMPD01455489       Qos Setup for 12 slot
* Mahes             Jan/06/2011   CCMPD01460340       Software catup to dongle R1.2 version R01.00.00
* Tan Seng Kai      01/17/2011    CCMPD01463409       Added in AT praser for Data over nibbler
* Tan Seng Kai      01/19/2011    CCMPD01464287       Implement bluetooth manager and connection manager interaction message for mpp pairing
* Tan Seng Kai        02/11/2011    CCMPD01471859     Implement align to new MSC diagram. SecureWireless_R2.1_R2.0_R2.3_data_connection.pdf
* Toh Pei See       08-12-2011    CCMPD01587273       Added the compiler switch definition to disable EDR packet type       
* Toh PeiSee        15/12/2011    CCMPD01592074        Added macro for low power reconnection mechanism
* wrn637            17/9/2013     CCMPD01815076       Remove Low power reconnection feature
* WRN637            20/12/2013    CCMPD01833277       WPTT state machine
* WRN637            27/01/2014    CCMPD01856259       Disable_EDR
* Abhishek Trivedi  03/10/2014	  CCMPD01870625       CSR DSP Audio Detect Integration Changes
* Aneeket Patkar    03/26/2014    CCMPD01876782       Initialization Sequence update - Create MPP State Machine after BT initialization
* Abhishek Trivedi  04/04/2014    CCMPD01882874       CSR Version Check
* Abhishek Trivedi  04/15/2014    CCMPD01883363       Interchip Ping part 2
* Abhishek Trivedi  10/22/2014    CCMPD01938895       Audio Switch
* Abhishek Trivedi  11/11/2014    CCMPD01945832       Edge of Range Support
* Abhishek Trivedi  11/29/2014    CCMPD01957210       WPTT Support for Audio Switch
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/


/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "bluetooth_int.h"
#include "bt_common.h"
#include "rfcomm.h"
#include "sdp.h"
#include "spp.h"  // CCMPD01410054 (JJ 8/11/2010)
#include "bt_log.h"
#include "bt_security_manager.h"
#include "padapt.h"
#include "hci_link_handler.h"
#include "bt_hci.h"
#include "bt_lp.h"
#include "hci_link_handler.h"
#include "l2cap.h"
#include "sdap.h"
#include "hsp_ag.h"
#include "test_commands_manager.h" 
#include "ConnectionManager.h" 


/*****************************************************************************/
/* Private macros                                                            */
/*****************************************************************************/

/*
 * Timer id used when requesting a delay before
 * processing the resend queue
 */
#define TIMER_ID_RUN_STATE_MACHINE                        2
#define TIMER_ID_RUN_CTRL_STATE_MACHINE                   3
#define TIMER_ID_RUN_HSP_STATE_MACHINE                    4
#define TIMER_ID_RUN_SPP_STATE_MACHINE                    5
#define TIMER_ID_RUN_HSP_AG_AT_CMD_STATE_MACHINE          6 
#define TIMER_ID_RUN_HCI_STATE_MACHINE                    7 
#define TIMER_ID_RUN_INITIALIZE_CHECK                     8
#define TIMER_ID_RUN_RING_CMD_STATE_MACHINE               9
#define TIMER_ID_RUN_HS_PAIRING_STATE_MACHINE            10
#define TIMER_ID_RUN_R1_4_PAIRING_STATE_MACHINE          11
#define TIMER_ID_RUN_HS_CONNECTING_STATE_MACHINE         12
#define TIMER_ID_RUN_R1_4_CONNECTING_STATE_MACHINE       13
#define TIMER_ID_RUN_R1_4_CONNECTING_DELAY               14
#define TIMER_ID_RUN_R1_3_NIBBLER_STATE_MACHINE	         15
#define TIMER_ID_RUN_DONGLE_PTT_PRESSED_STATE            16
#define TIMER_ID_RUN_R1_4_RFCOMM_ATCMD_RSP               17
#define TIMER_ID_RUN_R1_4_NIBBLER_STATE_MACHINE          18
#define TIMER_ID_RUN_REPEAT_R1_4_ATCMD                   19
#define TIMER_ID_RUN_SERVICE_NAME_CLOSE_CONN_TMO         20
#define TIMER_ID_RUN_AUDIODEV_AT_ESTABLISH_FAIL_TMO      21
#define TIMER_ID_RUN_NONAUDIODEV_AT_ESTABLISH_FAIL_TMO   22
#define TIMER_ID_RUN_MPTT_REPLY_FAIL_TMO                 23
#define TIMER_ID_BT_CHIP_HCIRESET_COMPLETE_FAIL_TMR      24
#define TIMER_ID_BT_CHIP_HCI_PING_RETRY_TMO              25
#define TIMER_ID_RUN_HSP_NULL_NIBBLE_RETRY               26

#define TIMER_ID_RUN_MAX                                 27   /* keep this as the last number */

/* Message Related to Control Manager */
#define HEADSET_SPKR_CONTROL                             40

/*
 *  These valuse are used for BTCOM_HspRequestPhase
 *	These phases can not be run in parallell
 */
#define BT_MNGR_HSP_CONNECT_OR_DISCONNECT	    1
#define BT_MNGR_HSP_SETUP_QOS           	    2


#define BT_MNGR_SPP_CONNECT_OR_DISCONNECT           1
#define BT_MNGR_SPP_SETUP_QOS                       2

/*
 * Delay in ms between each attempt to resend
 * entries from the resend queue
 */
#define RUN_STATE_MACHINE_DELAY			    200

/* Delay in ms for checking initialize process
 * This period of time is tested with BT_RAWLOG enale with no 
 * Log Filter.
 */
#define RUN_INITIALIZE_CHK_DELAY                10000

#define BT_STACK_TASK_INITIALIZATION_TIMEOUT_PERIOD     6000

/* These valuse are used for BT_MNGR_StartupPhase  */
#define BT_MNGR_PHASE_INITIATING		    1
#define BT_MNGR_PHASE_RESTARTING		    2

/* Maximum RING Indication on HS */
#define MAX_RING_INDICATION                         10
/*
 * These valuse are used for BT_MNGR_StartupState
 */
#define BT_MNGR_STATE_NOT_INITIATED                                     1
#define BT_MNGR_STATE_INITIATING                                        2
#define BT_MNGR_STATE_SEND_WRITE_CLASS_OF_DEVICE                        3
#define BT_MNGR_STATE_SEND_WRITE_CONNECTABLE                            4
#define BT_MNGR_STATE_SEND_WRITE_DISCOVERABLE                           5
#define BT_MNGR_STATE_SEND_WRITE_PAGE_TIMEOUT                           6
#define BT_MNGR_STATE_SEND_READ_LOCAL_BTADDR                            7
#define BT_MNGR_STATE_SEND_WRITE_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL  8
#define BT_MNGR_STATE_INITIATED                                         9

#define BT_MNGR_STATE_DEVICE_UNDER_TEST    99

/*
 *	These valuse are used for BT_MNGR_CtrlRequestPhase
 *	These phases can not be run in parallell
 */
#define BT_MNGR_CONTROL_PHASE_SET_DISCOVERABLE	  0
#define BT_MNGR_CONTROL_PHASE_IDEAL               1
#define BT_MNGR_CONTROL_PHASE_DISCOVERY           2
#define BT_MNGR_CONTROL_PHASE_PAIRING             3
#define BT_MNGR_CONTROL_PHASE_CONNECT             4
#define BT_MNGR_CONTROL_PHASE_READ_PAIRED         5
#define BT_MNGR_CONTROL_PHASE_CREATE_BOND_HS  	  6
#define BT_MNGR_CONTROL_PHASE_CREATE_BOND_SPP  	  7

/*
 *	These valuse are used for BT_MNGR_CtrlRequestState
 *	Current state for the current BT_MNGR_CtrlRequestPhase
 */
#define BT_MNGR_CONTROL_NONE			    0
#define BT_MNGR_CONTROL_SEND_RSSI_CFG		    1
#define BT_MNGR_CONTROL_SEND_SDAP_ENUM		    2
#define BT_MNGR_CONTROL_SEND_WRITE_DISCOVERABLE	    3
#define BT_MNGR_CONTROL_SEND_HS_CREATE_BOND	    4
#define BT_MNGR_CONTROL_SEND_R1_4_CREATE_BOND	    5
#define BT_MNGR_CONTROL_SEND_HS_PASSKEY_RSP         6
#define BT_MNGR_CONTROL_SEND_R1_4_PASSKEY_RSP       7
#define BT_MNGR_CONTROL_SEND_REJECT_PASSKEY_RSP     8
#define BT_MNGR_CONTROL_SEND_SDAP_TERMINATE	    9
#define BT_MNGR_CONTROL_SEND_SDAP_SERVICE_SEARCH    10
#define BT_MNGR_CONTROL_SEND_CREATE_BOND	    11
#define BT_MNGR_CONTROL_SEND_PASSKEY_RSP            12
#define BT_MNGR_CONTROL_SEND_LINKKEY_REQ            13
#define BT_MNGR_CONTROL_SEND_LINKKEY_RSP            14

/*
 * These valuse are used for BT_MNGR_HspState
 * Current state for the current BT_MNGR_HspRequestPhase
 */
#define BT_MNGR_HSP_NONE			  0
#define BT_MNGR_HSP_SEND_DISCONNECT_REQ	          1
#define BT_MNGR_HSP_SEND_CONNECT_REQ	          2
#define BT_MNGR_HSP_SEND_AUDIO_CONNECT_REQ        3
#define BT_MNGR_HSP_SEND_AUDIO_DISCONNECT_REQ     4
#define BT_MNGR_HSP_QOS_SETUP                     5 //cwc034: QoS Test

/*
 * These valuse are used for BT_MNGR_HspState
 * Current state for the current BT_MNGR_HspRequestPhase
 */
#define BT_MNGR_SPP_NONE			  0
#define BT_MNGR_SPP_SEND_DISCONNECT_REQ	          1
#define BT_MNGR_SPP_SEND_CONNECT_REQ	          2
#define BT_MNGR_SPP_QOS_SETUP                     3

/*
 * These valuse are used for Hciphase
 * wrn637: CCMPD01388039
 */
#define BT_MNGR_HCI_SETUSB_TRANSPORT              1
#define BT_MNGR_HCI_DEVICE_TEST		          2
#define BT_MNGR_HCI_SEND_BCCMD		          3


/*
 * These valuse use for internal task message
 */
#define BT_MNGR_START_PAIRING                   8
#define SWITCH_TRANSPORT_LAYER_REQUEST		9
#define DEVICE_UNDER_TEST_REQUEST		10
#define DEVICE_TEST_USING_CODEPLUG		11
#define DEVICE_SEND_NIBBLER_BYTE		12
#define DEVICE_SEND_VM_CMD                      15
#define CHECK_CSR_VERSION_REQ                   16
#define HCI_PING_GET_BT_CHIP_RESPONSE           17
/*
 * These valuse are used for BT_MNGR_HciState
 * wrn637: CCMPD01388039
 */
#define BT_MNGR_HCI_NONE		          0
#define BT_MNGR_HCI_SETUSBTL			  1
#define BT_MNGR_HCI_GETUSBTL			  2
#define BT_MNGR_HCI_SETWARMRESET		  3
#define	BT_MNGR_HCI_DEVTEST_1			  4
#define	BT_MNGR_HCI_DEVTEST_2	                  5
#define	BT_MNGR_HCI_CUSTOM_CMDSEND                6
#define BT_MNGR_HCI_VM_CMDSEND                    7
#define BT_MNGR_HCI_CSR_VER_CHECK                 8

#define MAX_NUMBER_LENGTH     40
#define MAX_R1_4_DEVICE       40
#define MAX_HSP_DEVICE        40
#define R1_4_SERVICE_NAME     "FastPTT+0x0001"  

#define BT_MNGR_MAX_INQUIRY_RESULTS 40
#define MAX_DEV_DATABASE            2
#define MAX_DEV_INQUIRY_FAIL_CYCLE  6  /* Max cycle of Device Inquiry Failure as a timeout for transitioning to Idle State*/


#define PACKET_TYPE   HCI_ACL_DM1 | HCI_ACL_DH1 | HCI_ACL_DM3 | HCI_ACL_DH3 | HCI_ACL_DM5 |HCI_ACL_DH5 | HCI_ACL_DISALLOW_2_DH1 | HCI_ACL_DISALLOW_3_DH1 | HCI_ACL_DISALLOW_2_DH3 | HCI_ACL_DISALLOW_3_DH3 | HCI_ACL_DISALLOW_2_DH5 | HCI_ACL_DISALLOW_3_DH5 

#define SPP_RFCOMM_CH 13
#define HSP_RFCOMM_CH 1

#define MPP_PROTOCOL_TO_ENABLE_EDRx

#define MINOR_DEVICE_CLASS_UNCATEGORIZED    0x00
#define MAJOR_DEVICE_CLASS_MISC             0x00
#define MAJOR_SERVICE_CLASS_AUDIO           0x20  /* The ping mechanism between CSR and Atmel relies on this value, so please keep it a non-zero number */
/*****************************************************************************/
/* Public types                                                              */
/*****************************************************************************/


/*****************************************************************************/
/* Private types                                                             */
/*****************************************************************************/

/*
 * Union of all messages that can be received by this
 * applications message handler
 */
typedef union
{
    BT_Header           header;
    CTRL_IndConf        ctrl;
    HCI_Event           hci;
    SDP_RemoteServerRsp sdp;
    PADAPT_IndConf      padapt;
    SDAP_Rsp            sdap;
    SEC_IndConf         sec;
    BT_TimeoutInd       tsrv;
    HSP_AG_IndConf      hspAg;
    SPP_DEV_IndConf	sppDev;
} BT_MNGR_InMsg;

typedef enum
{
  HS_OUTGOING_CONNECTION,
  HS_INCOMING_CONNECTION
}Hs_Connection_Type;

typedef enum
{
  R1_4_OUTGOING_CONNECTION,
  R1_4_INCOMING_CONNECTION
}R1_4_Connection_Type;

/* Type definitions to be used for phase and state variables */
typedef BT_U8 BT_MNGR_StartupState;
typedef BT_U8 BT_MNGR_StartupPhase;
typedef BT_U8 BT_MNGR_CtrlRequestState;
typedef BT_U8 BT_MNGR_CtrlRequestPhase;
typedef BT_U8 BT_MNGR_HspRequestState;
typedef BT_U8 BT_MNGR_HspRequestPhase;
typedef BT_U8 BT_MNGR_SppRequestState;
typedef BT_U8 BT_MNGR_SppRequestPhase;

typedef BT_U8 BT_MNGR_HciRequestState;
typedef BT_U8 BT_MNGR_HciRequestPhase;



//typedef struct {
//  btDevInfo     btDev;
//  UINT8		timeOut;
//}connectingDevInfo;

typedef enum
{
  PING_CMD,               
  LOAD_DSP_CMD,
  UNLOAD_DSP_CMD,         
  AUDIO_DETECT_ON_CMD,    
  AUDIO_DETECT_OFF_CMD,   
  SET_OUTPUT_GAIN_CMD,    
  SET_INPUT_GAIN_CMD,     
  SET_DELAY_CMD,          
  SET_THRESH_CMD
}vm_cmd_send_t;
/****************************************************************************
  Private function prototypes                                               
*****************************************************************************/
BT_Result MsgHandler (const BT_Msg *msg);
void RunStartupStateMachine();
void RunCtrlStateMachine();
void RunHspStateMachine();
void RunSppStateMachine();
void RunHciStateMachine(); 
BT_U16 BdAddrImg(char *imgBuffer,const BT_BdAddr addr);
void EndPhase (BT_U8 *phaseVar, BT_U8 phase);
void BTCOM_SetupLogFilter();
void SendRINGCommand();
BT_BOOL CompareBTAddress(BT_U8 *, BT_U8 * );
BT_BOOL ComparePairedBTAddress(BT_U8 *addr1, BT_U8 *addr2);
void SPPConnectCfm(SPP_DEV_ConnectCfm *cfm);  // CCMPD01410054 (JJ 8/11/2010)
void SPPDisconnectCfm(SPP_DEV_DisconnectCfm *cfm);  // CCMPD01410054 (JJ 8/11/2010)
void Cancel_HS_NibbleTimer(void);
void Cancel_WPTT_NibbleTimer(void);
void BT_echo_reverse_nibbler_null_byte( BT_U8 data_byte);
/*****************************************************************************/
/* Public macros                                                             */
/*****************************************************************************/

#ifndef BT_DEPRECATED_MSG_CONST
#define BT_DEPRECATED_MSG_CONST const
#endif


#endif /*BLUETOOTH_MANAGER_H*/
