/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <bluetooth_send.c>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* Chia Weng Sun		 	08/06/2010   	CCMPD01379068		    Initial Creation
* Niravkumar Rabara 08/20/2010    CCMPD01383800       Added Fuctions for Audio Routing
* Tan Seng Kai   	  08/30/2010	  CCMPD01388039       Added Functions for BCCMD
* Niravkumar Rabara 09/08/2010    CCMPD01389372       Modified Function Names
* Tan Seng Kai      09/22/2010    CCMPD01394890       Added configuration for BQB and RTTE test
* Niravkumar Rabara	09/23/2010	  CCMPD01394958       Headset Profile Audio Gateway implementation.
* Niravkumar Rabara	10/04/2010	  CCMPD01398596       AT Command Implementation for R1.3 Headset Test 
* Tan Seng Kai      10/07/2010    CCMPD01397694       Implement Nibbler and  Nibbler
* Niravkumar Rabara	10/08/2010	  CCMPD01400432       Modified RING AT Command to 10 times as per MSC
* Niravkumar Rabara	10/11/2010	  CCMPD01400996       Bug Fix related to 1.3 Remote PTT Nibble
* Niravkumar Rabara 10/06/2010    CCMPD014000437      Updated Device Discovery Timer to 20 Hex
* Niravkumar Rabara	10/18/2010	  CCMPD01402008       Added Serial Port Profile
* Tan Seng Kai      10/27/2010    CCMPD01407568       Added RSSI configuration to enable RSSI value
* Tan Seng Kai      10/29/2010    CCMPD01408084       Clean up test code that use for dubugging RSSI
* Tan Seng Kai      11/01/2010    CCMPD01408859       change Device discovery time into codeplug setting
* Tan Seng Kai      11/01/2010    CCMPD01409147       Write comment for changes to improve Pairing
* JJ Low            11/08/2010            CCMPD01410054           Compiler warning resolution for R2.1
* Tan Seng Kai      11/03/2010    CCMPD01409994       Add in function to send page time out message
* Niravkumar Rabara 11/14/2010    CCMPD01413929       Added function for SPP connection & AT cmd handling
* Tan Seng Kai      11/23/2010    CCMPD01418684       Add command send for "AT+MPTT=0\r"
* Tan Seng Kai      11/25/2010    CCMPD01421182       Implement AT+MPTT over Nibbler
* Chia Weng Sun     12/03/2010    CCMPD01450072       Added functions for Read & Write Inquiry Response Transmit Power HCI Command
* Tan Seng Kai      12/08/2010    CCMPD01451448       Added in BT_MNGR_SendSeclinkkeyreqrsp
* Maheswaran        12/20/2010    CCMPD01414087       Added BT_MNGR_Send_Read_BDADD & HCI_DELETE_STORED_LINK_KEY
* Tan Seng Kai      12/10/2010    CCMPD01452526       Nibbler data send for R1.4
* Tan Seng Kai      12/17/2010    CCMPD01455489       BT_MNGR_SendHciQosSetup function added in
* Mahes             Jan/06/2011   CCMPD01460340       Software catup to dongle R1.2 version R01.00.00
* Mahesh            07-Dec-2011   CCMPD01460638       Added  initial MPP inter task messages
* Tan Seng Kai      01/17/2011    CCMPD01463409       Added in AT praser for Data over nibbler
* Tan Seng Kai      29/04/2011    CCMPD01503017       Resolve connection manager and bluetooth manager syncronization issue.
* Toh Pei See       15/12/2011    CCMPD01592074       Added the new functions for low power reconnection mechanism
* wrn637            17/9/2013     CCMPD01815076       Remove Low power reconnection feature
* Abhishek Trivedi  09/02/2013    CCMPD01827271       XNL-XCMP host support
* WRN637            06/01/2014    CCMPD01849533       Resolve function descriptions comment
* Abhishek Trivedi  03/10/2014	  CCMPD01870625       CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi  04/04/2014    CCMPD01882874       CSR Version Check
* Abhishek Trivedi  04/15/2014    CCMPD01883363       Interchip Ping part 2
* Abhishek Trivedi  11/11/2014    CCMPD01945832       Edge of Range Support
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "bluetooth_int.h"
#include "hsp_ag.h" 
#include "spp.h"
/*****************************************************************************/
/* Private macros                                                            */
/*****************************************************************************/

/*****************************************************************************/
/* Private types                                                             */
/*****************************************************************************/

/*****************************************************************************/
/* Public constants & variables                                              */
/*****************************************************************************/
HSP_AG_Handle agHandler; //cwc034: AG specific
extern BT_U32 ag_supportedFeatures;
extern BT_U8 DeviceInquiryTimerValue;
extern BT_BOOL isBQBModeOn;
extern BT_U8  echo_seq_no;
/*****************************************************************************/
/* Private constants & variables                                             */
/*****************************************************************************/
#define REVERSE_NIBBLER_BUFFER      100
static BT_U8 HSPReverse_Nibbler_Buffer[REVERSE_NIBBLER_BUFFER];
static BT_U8 SPPReverse_Nibbler_Buffer[REVERSE_NIBBLER_BUFFER];

/*****************************************************************************/
/* Private function prototypes                                               */
/*****************************************************************************/


/*****************************************************************************/
/* Callback or Interrupt functions                                           */
/*****************************************************************************/


/*****************************************************************************/
/* Private functions                                                         */
/*****************************************************************************/

/*****************************************************************************/
/* Private tasks                                                             */
/*****************************************************************************/
	
/*****************************************************************************/
/* Public API functions                                                      */
/*****************************************************************************/
extern BT_Result SendSppConncedReq(SPP_DEV_ConnectReq *req); // CCMPD01410054 (JJ 8/11/2010)

 /* ===========================================================================
 * Function:    SendCreateBondReq
 * Description: Create and send a SEC_CREATE_BOND_REQ message
 * Returns: Result of operation
 * =========================================================================== */
BT_Result BT_MNGR_SendCreateBondReq(BT_BdAddr bdAddr, BT_BOOL createTrust)
{
    
    SEC_CreateBondReq secCreateBondReq;
    
    /*Init header data*/        
    secCreateBondReq.header.primitive   = SEC_CREATE_BOND_REQ;
    secCreateBondReq.header.sender      = appSenderId ;
    secCreateBondReq.header.receiver    = BT_SEC;

    memcpy(secCreateBondReq.bdAddr, bdAddr, 6);
    secCreateBondReq.createTrust        = createTrust;

    return BT_INVOKE(&secCreateBondReq);

}

/* ===========================================================================
 * Function:    SendSecPinRequestRsp
 * Description: Create and send a SEC_PIN_REQUEST_RSP message
 * Returns:     Result of operation 
 * =========================================================================== */
BT_Result BT_MNGR_SendSecPinRequestRsp(BT_BdAddr bdAddr,BT_BOOL acceptPairing)
{
    SEC_PinRequestRsp secPinReqRsp;
    BT_U8 passKey[20];
    const char *pin = "0000";
    BT_U8 pinLength = 4;

    secPinReqRsp.header.primitive   = SEC_PIN_REQUEST_RSP;
    secPinReqRsp.header.sender      = appSenderId ;
    secPinReqRsp.header.receiver    = BT_SEC;

    memcpy(secPinReqRsp.bdAddr, bdAddr, 6);
    
    secPinReqRsp.acceptPairing = acceptPairing;
    secPinReqRsp.pinLength = pinLength;
    memcpy(passKey, pin, pinLength);
    secPinReqRsp.pin = passKey;

    return BT_INVOKE(&secPinReqRsp);
}

/* ===========================================================================
 * Function: SendSecWriteConnectableReq
 * Description: Sets device connectable
 * =========================================================================== */
BT_Result BT_MNGR_SendSecWriteConnectableReq(BT_BOOL accept,BT_U16 scanInterval,
												   BT_U16 scanWindow)
{
	SEC_WriteConnectableReq		connectableReq;
	
	connectableReq.header.primitive		= SEC_WRITE_CONNECTABLE_REQ;
	connectableReq.header.sender			= appSenderId ;
	connectableReq.header.receiver 		= BT_SEC;
	connectableReq.mode					= accept?SEC_CONNECTABLE:SEC_NON_CONNECTABLE;
	connectableReq.scanInterval			= scanInterval;
	connectableReq.scanWindow			= scanWindow;

	return BT_INVOKE(&connectableReq);
}

/* ===========================================================================
 * Function: SendSecWriteDiscoverableReq
 * Description: Sets device discoverable
 * =========================================================================== */
BT_Result BT_MNGR_SendSecWriteDiscoverableReq(BT_BOOL accept,BT_U16 scanInterval, BT_U16 scanWindow)
{
	SEC_WriteDiscoverableReq	discoverableReq;
	
	discoverableReq.header.primitive		= SEC_WRITE_DISCOVERABLE_REQ;
	discoverableReq.header.sender			= appSenderId ;
	discoverableReq.header.receiver 		= BT_SEC;
	discoverableReq.mode					= accept?SEC_DISCOVERABLE_GIAC:SEC_NON_DISCOVERABLE;
	discoverableReq.scanInterval			= scanInterval;
	discoverableReq.scanWindow				= scanWindow;

	return BT_INVOKE(&discoverableReq);

}

/* ===========================================================================
 * Function:    BT_MNGR_RemoveLinkKeys
 * Description: Create and send a HCI_DELETE_STORED_LINK_KEY message
 * Returns: Result of operation
 * =========================================================================== */
BT_Result BT_MNGR_RemoveLinkKeys(void)
{
    HCI_DeleteStoredLinkKey cmd;

    cmd.header.primitive    = HCI_DELETE_STORED_LINK_KEY;
    cmd.header.sender       = appSenderId;
    cmd.header.receiver     = BT_HCI;

    cmd.deleteAllFlag       = 0x01;
    memset(cmd.bdAddr, 0, 6);
    
    return BT_INVOKE(&cmd);
}

/* ===========================================================================
 * Function:    BT_MNGR_SendHciWriteScanEnable
 * Description: Sends an HCI_WRITE_SCAN_ENABLE message.
 * Returns:     Result of operation
 * =========================================================================== */
BT_Result BT_MNGR_SendHciWriteScanEnable(HCI_ScanEnable scanEnable)
{
    HCI_WriteScanEnable writeScanEnable;

    writeScanEnable.header.primitive    = HCI_WRITE_SCAN_ENABLE;
    writeScanEnable.header.sender       = appSenderId;
    writeScanEnable.header.receiver     = BT_HCI;

    writeScanEnable.scanEnable = scanEnable;

    return BT_INVOKE(&writeScanEnable);
}

/* ===========================================================================
 * Function: SendHciWriteClassOfDevice
 * Description: Writes the classOfDevice defined in global variable 
 * =========================================================================== */
BT_Result BT_MNGR_SendHciWriteClassOfDevice(HCI_ClassOfDevice classOfDevice)
{
	HCI_WriteClassOfDevice msg;

	msg.header.primitive	= HCI_WRITE_CLASS_OF_DEVICE;
	msg.header.receiver 	= BT_HCI;
	msg.header.sender	= appSenderId;
	
	memcpy(msg.classOfDevice, classOfDevice, sizeof(classOfDevice));
	
	return BT_INVOKE(&msg);
}
/* ===========================================================================
 * Function: BT_MNGR_SendHciReadClassOfDevice
 * Description: Reads the classOfDevice defined in global variable 
 * =========================================================================== */
BT_Result BT_MNGR_SendHciReadClassOfDevice()
{
	HCI_ReadClassOfDevice msg;

	msg.header.primitive	= HCI_READ_CLASS_OF_DEVICE;
	msg.header.receiver 	= BT_HCI;
	msg.header.sender	= appSenderId;

	return BT_INVOKE(&msg);
}

/* ===========================================================================
 * Function: BT_MNGR_SendReadDeviceInfoReq
 * Description: Read stored devices
 * =========================================================================== */
BT_Result BT_MNGR_SendReadDeviceInfoReq(void)
{
    HCI_ReadStoredLinkKey        readLinkKeys;
    
    readLinkKeys.header.primitive   = HCI_READ_STORED_LINK_KEY;
    readLinkKeys.header.sender      = appSenderId;
    readLinkKeys.header.receiver    = BT_HCI;
    memset(readLinkKeys.bdAddr,0,sizeof(BT_BdAddr));

    readLinkKeys.readAllFlag        = BT_TRUE;

    return BT_INVOKE( &readLinkKeys );
}

/* ===========================================================================
 * Function:    BT_MNGR_SendHciControllerRestartedRsp
 * Description: Sends an HCI_CONTROLLER_RESTARTED_RSP message.
 * Returns:     -
 * =========================================================================== */
BT_Result BT_MNGR_SendHciControllerRestartedRsp(void)
{
    BT_Msg controllerRestartedRsp;

    controllerRestartedRsp.header.primitive = HCI_CONTROLLER_RESTARTED_RSP;
    controllerRestartedRsp.header.sender    = appSenderId;
    controllerRestartedRsp.header.receiver  = BT_HCI;

    return BT_INVOKE(&controllerRestartedRsp);
}

/* ===========================================================================
 * Function: BT_MNGR_SendSdapTerminatePrimReq
 * Description: Interrupts SDAP operation
 * =========================================================================== */
BT_Result BT_MNGR_SendSdapTerminatePrimReq(BT_Primitive primitive)
{
	SDAP_TerminatePrimReq		sdapTermReq;
	
	sdapTermReq.header.primitive	= SDAP_TERMINATE_PRIM_REQ;
	sdapTermReq.header.sender		= appSenderId ;
	sdapTermReq.header.receiver 	= BT_SDAP;

	sdapTermReq.primitive			= primitive;

	return BT_INVOKE( &sdapTermReq );
}

/* ===========================================================================
 * Function: BT_MNGR_SendSdapServiceSearchAttrReq
 * Description: Performs service search on a specific device
 * =========================================================================== */
BT_Result BT_MNGR_SendSdapServiceSearchAttrReq(BT_BdAddr addr)
{
	
  SDAP_ServiceSearchAttrReq	sdapSSReq;

  BT_U8 BT_ROM bqbAttributeIdList[] =
  {
    0x35, 0x03,           /* data element seq 6 bytes */
    0x09, 0x00, 0x01     /* 0x0001 - UINT16, ServiceClassIDList list */

  };

  BT_U8 BT_ROM bqbSearchPattern[] =
  {
    0x35, 0x03,         /* data element seq 6 bytes  */
    0x19, 0x11, 0x08    /* 0x0100 - UUID, Headset */    
  };

    BT_U8 BT_ROM attributeIdList[] =
  {
    0x35, 0x09,           /* data element seq 6 bytes */
    0x09, 0x00, 0x01,     /* 0x0001 - UINT16, ServiceClassIDList list */
    0x09, 0x00, 0x04,     /* 0x0004 - UINT16, Protocol descriptor list */
    0x09, 0x01, 0x00      /* 0x0100 - UINT16, Service name */


  };

  BT_U8 BT_ROM searchPattern[] =
  {
    0x35, 0x03,         /* data element seq 6 bytes  */
    0x19, 0x01, 0x00    /* 0x0100 - UUID, L2CAP */
    
  };
  sdapSSReq.header.primitive  = SDAP_SERVICE_SEARCH_ATTR_REQ;
  sdapSSReq.header.receiver   = BT_SDAP;
  sdapSSReq.header.sender     = appSenderId;

  sdapSSReq.bdAddr            = (BT_BdAddr*)addr;
  sdapSSReq.noOfBdAddr        = 1;

  sdapSSReq.getRemDevName     = BT_FALSE;
  sdapSSReq.maxNoOfBytes      = 672;
  sdapSSReq.maxSearchTime     = 10000;

  sdapSSReq.remDevRelation    = SDAP_NO_RELATION;

  if(isBQBModeOn)
  {
    sdapSSReq.attributeId       = bqbAttributeIdList;
    sdapSSReq.searchPattern     = bqbSearchPattern;
    
  }
  else
  {
    sdapSSReq.attributeId       = attributeIdList;
    sdapSSReq.searchPattern     = searchPattern;
  }
  return BT_INVOKE( &sdapSSReq );
}

/* ===========================================================================
 * Function: BT_MNGR_SendSdapEnumRemDevReq
 * Description: Starts SDAP device enumeration, will reply with SDAP_REMOTE_DEVICE_RSP
 * =========================================================================== */
BT_Result BT_MNGR_SendSdapEnumRemDevReq(void)
{
    SDAP_EnumerateRemDevReq      sdapEnumReq;

    SDAP_Lap            lap             = SDAP_GIAC;        /* GIAC */

    BT_U8               inquiryLength   = (BT_U8)DeviceInquiryTimerValue; /* 1 == 1.28 s*/
      
    BT_U8               noOfResponses   = 0;                              /* 0 == unlimited */
    HCI_ClassOfDevice   filter          = {0x00, 0x00, 0x00 };

    sdapEnumReq.header.primitive        = SDAP_ENUMERATE_REM_DEV_REQ;
    sdapEnumReq.header.sender           = appSenderId ;
    sdapEnumReq.header.receiver         = BT_SDAP;

    sdapEnumReq.lap                     = lap;
    sdapEnumReq.inquiryDuration         = inquiryLength;
    sdapEnumReq.noOfResponses           = noOfResponses;

    /* Get device name always set to false to reduce searching time */
    sdapEnumReq.getRemDevName           = BT_FALSE;

    memcpy(sdapEnumReq.filter, filter, 3);

    return BT_INVOKE( &sdapEnumReq );
}

/* ===========================================================================
 * Function: SendConnectReq (cwc034 Added: AG Specific)
 * Description: Sends a HSP_AG_CONNECT_REQ
 * =========================================================================== */

BT_Result BT_MNGR_SendHspAgConnectReq(BT_BdAddr addr)
{

    HSP_AG_ConnectReq req;
    req.header.primitive    = HSP_AG_CONNECT_REQ;
    req.header.receiver     = BT_LookupProfile(BT_HSP_AG);
    req.header.sender       = appSenderId;

    memcpy(req.bdAddr, addr, sizeof(BT_BdAddr));

    return BT_INVOKE( &req );
}

/* ===========================================================================
 * Function: BT_MNGR_SendHspAgDisconnectReq (cwc034: AG specific)
 * Description: Sends hsp Ag disconnect request
 * =========================================================================== */
BT_Result BT_MNGR_SendHspAgDisconnectReq(void)
{
    HSP_AG_DisconnectReq req;

    req.header.primitive    = HSP_AG_DISCONNECT_REQ;
    req.header.receiver     = BT_LookupProfile(BT_HSP_AG);
    req.header.sender       = appSenderId;
    req.handle				= agHandler;

    return BT_INVOKE( &req );
}
/* ===========================================================================
 * Function: BT_MNGR_SendHspAgConnectRsp (cwc034: AG Specific)
 * Description: Process the connecting phase.
 * =========================================================================== */
BT_Result BT_MNGR_SendHspAgConnectRsp(BT_BOOL accept)
{
    HSP_AG_ConnectRsp rsp;

	rsp.header.primitive    = HSP_AG_CONNECT_RSP;
    rsp.header.receiver     = BT_LookupProfile(BT_HSP_AG);
    rsp.header.sender       = appSenderId;
	rsp.handle				= agHandler;
    rsp.accept              = accept;

	return BT_INVOKE( &rsp );
}

/* ===========================================================================
 * Function: BT_MNGR_SendHsAgDataReq
 * Description: Sends a HSP_AG_DATA_REQ
 * =========================================================================== */\

BT_Result BT_MNGR_SendHsAgDataReq(BT_U8 data)
{
    HSP_AG_DataReq req;
    BT_U8 *dataPtr; 

    switch(data)
    {	
    case RING_CMD:
      dataPtr = "\r\nRING\r\n";
      req.length              = strlen((char const *)dataPtr);  // CCMPD01410054 (JJ 8/11/2010)
      req.dta                 = dataPtr;                        // CCMPD01410054 (JJ 8/11/2010)
      break;

    case OK_CKPD_CMD:
    case OK_NIBBLER_CMD:
      dataPtr = "\r\nOK\r\n";
      req.length              = strlen((char const *)dataPtr);  // CCMPD01410054 (JJ 8/11/2010)
      req.dta                 = dataPtr;                        // CCMPD01410054 (JJ 8/11/2010)
      break;

    case CGMM_CMD_RSP:
      dataPtr="CGMM:PLMN5712A+NIBBLER\r";
      req.length              = strlen((char const *)dataPtr);  // CCMPD01410054 (JJ 8/11/2010)
      req.dta                 = dataPtr;                        // CCMPD01410054 (JJ 8/11/2010)
      break;

    case REVERSE_NIBBLER_BYTE: // CCMPD01410054 (JJ 8/11/2010)
      req.length              = BT_GetHSPReverseNibbler(&HSPReverse_Nibbler_Buffer[0]);
      req.dta                 = &HSPReverse_Nibbler_Buffer[0];
      break;
    
    case ECHO_NULL_NIBBLER_BYTE:
      req.length              = 1;
      req.dta                 = &echo_seq_no;      
      break;
      
    default:
      req.length              = strlen((char const *)dataPtr);  // CCMPD01410054 (JJ 8/11/2010)
      req.dta                 = dataPtr;                        // CCMPD01410054 (JJ 8/11/2010)
      break;
    }	

    req.header.primitive    = HSP_AG_DATA_REQ;
    req.header.receiver     = BT_LookupProfile(BT_HSP_AG);
    req.header.sender       = appSenderId;

    return BT_INVOKE( &req );
}
/* ===========================================================================
 * Function: BT_MNGR_SendSppDataReq
 * Description: Sends a SPP_DEV_DATA_REQ;
 * =========================================================================== */

BT_Result BT_MNGR_SendSppDataReq(BT_U8 data)
{
      SPP_DEV_DataReq req;
      BT_U8 *dataPtr;
      //BT_U8 nibblerData;

      req.header.primitive    = SPP_DEV_DATA_REQ;
      req.header.receiver     = BT_LookupProfile(BT_SPP_DEV);
      req.header.sender       = appSenderId;

      switch(data)
      {	
          case RFCOMM_OK_RSP:
          case NIBBLER_OK_RSP:
               dataPtr = "\r\nOK\r\n";
                break;

          case CGMM_RSP:
                dataPtr="CGMM:PLMN5712A+NIBBLER\r";
                break;

          case RFCOMM_CHNL_RSP:
                dataPtr = "AT+RFCOMM=13\r";
                break;

          case SEND_REVERSE_NIBBLER_BYTE:
            req.length              = BT_GetSPPReverseNibbler(&SPPReverse_Nibbler_Buffer[0]);
            req.dta                 = &SPPReverse_Nibbler_Buffer[0];      
                return BT_INVOKE( &req );

          default:
                break;

      }
     req.length			  = strlen((const char*)dataPtr);
     req.dta				  = dataPtr;	
     return BT_INVOKE( &req );
}
/* ===========================================================================
 * Function: BT_MNGR_SendHsAgAudioConnectReq
 * Description: Sends a HSP_AG Audio Connect Req
 * =========================================================================== */
BT_Result BT_MNGR_SendHsAgAudioConnectReq(void)
{
    HSP_AG_AudioConnectReq req;
    
    req.header.primitive    = HSP_AG_AUDIO_CONNECT_REQ;
    req.header.receiver     = BT_LookupProfile(BT_HSP_AG);
    req.header.sender       = appSenderId;
    req.handle				= agHandler;
  
    return BT_INVOKE( &req );

}
/* ===========================================================================
 * Function: BT_MNGR_SendHsAgAudioConnectRsp
 * Description: Process the Audio Disconnecting phase.
 * =========================================================================== */
BT_Result BT_MNGR_SendHspAgAudioDisconnectReq(void)
{
      HSP_AG_AudioDisconnectReq req;

      req.header.primitive    = HSP_AG_AUDIO_DISCONNECT_REQ;
      req.header.receiver     = BT_LookupProfile(BT_HSP_AG);
      req.header.sender       = appSenderId;
      req.handle	      = agHandler;
	
      return BT_INVOKE( &req );
}
/* ===========================================================================
 * Function: BT_MNGR_SendHsAgAudioConnectRsp
 * Description: Process the Audio connecting phase.
 * =========================================================================== */
BT_Result BT_MNGR_SendHsAgAudioConnectRsp(BT_BOOL accept)
{
    HSP_AG_AudioConnectCfm rsp;
    
    rsp.header.primitive    = HSP_AG_AUDIO_CONNECT_RSP;
    rsp.header.receiver     = BT_LookupProfile(BT_HSP_AG);
    rsp.header.sender       = appSenderId;
    rsp.handle		= agHandler;
    rsp.success		= accept;
    
    return BT_INVOKE( &rsp );
}
/* ===========================================================================
 * Function: BT_MNGR_BCCMD_VER_CHECK
 * Description: Prepare Bluecore command to get CSR Version.
 * =========================================================================== */
BT_MNGR_HCI_BCCMD_USR_PSKEY BT_MNGR_BCCMD_VER_CHECK(BT_U16 GETSET, BT_U16 SEQNO)
{
  BT_MNGR_HCI_BCCMD_USR_PSKEY BCCMD;
  
  memset( (void*)&BCCMD, 0, sizeof(BCCMD) );
  
  BCCMD.type 			= GETSET;
  BCCMD.pdulen 			= sizeof(BT_MNGR_HCI_BCCMD_USR_PSKEY)/2;
  BCCMD.seqno 			= SEQNO;
  BCCMD.varid 			= BCCMD_VARID_PS;
  BCCMD.status 			= BCCMD_STATUS_OK;
  
  BCCMD.ps.pskey 		= PSKEY_USR38;
  BCCMD.ps.len 		        = 0x0004;
  BCCMD.ps.stores 		= PSKEY_STORE_DEFAULT;
  BCCMD.ps.data[0] 		= PSKEY_VALUE_DUMMY;
  BCCMD.ps.data[1] 		= PSKEY_VALUE_DUMMY;
  BCCMD.ps.data[2] 		= PSKEY_VALUE_DUMMY;
  BCCMD.ps.data[3] 		= PSKEY_VALUE_DUMMY;
  
  return BCCMD;  
}
/* ===========================================================================
 * Function: BT_MNGR_BCCMD_USBTL
 * Description: Prepare Bluecore command to set or get USB Transport Layer.
 * =========================================================================== */
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_USBTL(BT_U16 GETSET, BT_U16 SEQNO)
{
  BT_MNGR_HCI_BCCMD BCCMD;
  
  memset( (void*)&BCCMD, 0, sizeof(BCCMD) );
  
  BCCMD.type 			= GETSET;
  BCCMD.pdulen 			= sizeof(BT_MNGR_HCI_BCCMD)/2;
  BCCMD.seqno 			= SEQNO;
  BCCMD.varid 			= BCCMD_VARID_PS;
  BCCMD.status 			= BCCMD_STATUS_OK;
  
  BCCMD.d.ps.pskey 		= PSKEY_HOST_INTERFACE;
  BCCMD.d.ps.len 		= 0x0001;
  BCCMD.d.ps.stores 		= PSKEY_STORE_DEFAULT;
  BCCMD.d.ps.data 		= PSKEY_VALUE_USBLINK;
  
  return BCCMD;
}

/* ===========================================================================
 * Function: BT_MNGR_BCCMD_SETWARMRESET
 * Description: Prepare Bluecore command to warm reset CSR IC.
 * =========================================================================== */
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_SETWARMRESET(BT_U16 SEQNO)
{
  BT_MNGR_HCI_BCCMD BCCMD;
  
  BCCMD.type 		= BCCMD_TYPE_SETREQ;
  BCCMD.pdulen 		= sizeof(BT_MNGR_HCI_BCCMD)/2;
  BCCMD.seqno 		= SEQNO;
  BCCMD.varid 		= BCCMD_VARID_WARMRESET;
  BCCMD.status 		= BCCMD_STATUS_OK;
  
  BCCMD.d.data[0] 	= 0x0000;
  BCCMD.d.data[1] 	= 0x0000;
  BCCMD.d.data[2] 	= 0x0000;
  BCCMD.d.data[3] 	= 0x0000;
  
  return BCCMD;
}

#ifdef BT_ENABLE_DUT
/* ===========================================================================
 * Function: BT_MNGR_BCCMD_SETWARMRESET
 * Description: Prepare Bluecore command to enter BT test.
 * =========================================================================== */
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_TXRXTEST(BT_U16 SEQNO, BT_MNGR_HCI_BCCMDDATA* parameter)
{
  BT_MNGR_HCI_BCCMD BCCMD;

  BCCMD.type 		= BCCMD_TYPE_SETREQ;
  BCCMD.pdulen 		= sizeof(BT_MNGR_HCI_BCCMD)/2;
  BCCMD.seqno 		= SEQNO;
  BCCMD.varid 		= BCCMD_VARID_RADIOTEST;
  BCCMD.status 		= BCCMD_STATUS_OK;
  
	memcpy(BCCMD.d.data, parameter, sizeof(BT_MNGR_HCI_BCCMDDATA));
  
  return BCCMD;
}

/* ===========================================================================
 * Function: BT_MNGR_BCCMD_SETWARMRESET
 * Description: Prepare Bluecore command to enter DUT.
 * =========================================================================== */
BT_MNGR_HCI_BCCMD BT_MNGR_BCCMD_DUT(BT_U16 SEQNO, BT_U8 step)
{
  BT_MNGR_HCI_BCCMD BCCMD;

  memset( (void*)&BCCMD, 0, sizeof(BCCMD) );

  BCCMD.type 			= BCCMD_TYPE_SETREQ;
  BCCMD.pdulen 		= sizeof(BT_MNGR_HCI_BCCMD)/2;
  BCCMD.seqno 		= SEQNO;
  if( step == BT_MNGR_HCI_DEVTEST_1 )
  {
  	BCCMD.varid 		= BCCMD_VARID_DUT1;
  }
  else
  {
  	BCCMD.varid 		= BCCMD_VARID_DUT2;
  }
  BCCMD.status 		= BCCMD_STATUS_OK;
    
  return BCCMD;
}
#endif

/* ===========================================================================
 * Function: BT_MNGR_SendHci_BCCMD
 * Description: Wrap BCCMD with HCI, BCCMD and an input parameter. This function will
 *				Warp it with HCI header.
 * =========================================================================== */
BT_Result BT_MNGR_SendHci_BCCMD(BT_MNGR_HCI_BCCMD CMD)
{
  HCI_RawCmdReq req;
  BT_MNGR_HCI_BCCMDPKT extendpkt;
  BT_U8	i;
  BT_U16 temp	  = BT_MNGR_HCI_HEADER;
  BT_U8* ptrfrom  = (BT_U8*)&CMD;
  BT_U8* ptrto 	  = (BT_U8*)&extendpkt.BCCMDPDU;

  memset( (void*)&req, 0, sizeof(req));
  memset( (void*)&extendpkt, 0, sizeof(extendpkt));

  /* Preparing BCCMD */
  ASSIGN_VAR_LE16( &extendpkt.Header, &temp);
  extendpkt.Parameter_Total_Length = sizeof(BT_MNGR_HCI_BCCMDPKT) - 3;

  extendpkt.PayloadDescriptor.all = BT_MNGR_HCI_FIRSTFRAGMENT << 7 |
                                    BT_MNGR_HCI_LASTFRAGMENT << 6 |
                                    BT_MNGR_HCI_CHANNELID_BCCMD;

  for( i = 0; i < sizeof(BT_MNGR_HCI_BCCMD); i += 2)
  {
    ASSIGN_VAR_LE16( &ptrto[i], &ptrfrom[i] );
  }
  
  /* preparing HCI RAW */
  req.header.primitive      = HCI_RAW_CMD_REQ;
  req.header.receiver       = BT_HCI;
  req.header.sender         = appSenderId;
  req.hciCmdPacket          = (BT_U8*) &extendpkt;
  req.cmdFlowCtrlHandling   = HCI_BYPASS_CMD_FLOW_CTRL;
  
  /* Send out */	
  return BT_INVOKE( &req );
}
/* ===========================================================================
 * Function: BT_MNGR_SendHci_UsrPskey_BCCMD
 * Description: Wrap BCCMD with HCI, BCCMD and an input parameter. This function 
              will Wrap it with HCI header.
 * =========================================================================== */
BT_Result BT_MNGR_SendHci_UsrPskey_BCCMD(BT_MNGR_HCI_BCCMD_USR_PSKEY CMD)
{
  HCI_RawCmdReq req;
  BT_MNGR_HCI_BCCMD_USR_PSKEYPKT extendpkt;
  BT_U8	i;
  BT_U16 temp	  = BT_MNGR_HCI_HEADER;
  BT_U8* ptrfrom  = (BT_U8*)&CMD;
  BT_U8* ptrto 	  = (BT_U8*)&extendpkt.BCCMDUSRPSKEYPDU;

  memset( (void*)&req, 0, sizeof(req));
  memset( (void*)&extendpkt, 0, sizeof(extendpkt));

  /* Preparing BCCMD */
  ASSIGN_VAR_LE16( &extendpkt.Header, &temp);
  extendpkt.Parameter_Total_Length = sizeof(BT_MNGR_HCI_BCCMD_USR_PSKEY) - 3;

  extendpkt.PayloadDescriptor.all = BT_MNGR_HCI_FIRSTFRAGMENT << 7 |
                                    BT_MNGR_HCI_LASTFRAGMENT << 6 |
                                    BT_MNGR_HCI_CHANNELID_BCCMD;

  for( i = 0; i < sizeof(BT_MNGR_HCI_BCCMD_USR_PSKEY); i += 2)
  {
    ASSIGN_VAR_LE16( &ptrto[i], &ptrfrom[i] );
  }
  
  /* preparing HCI RAW */
  req.header.primitive      = HCI_RAW_CMD_REQ;
  req.header.receiver       = BT_HCI;
  req.header.sender         = appSenderId;
  req.hciCmdPacket          = (BT_U8*) &extendpkt;
  req.cmdFlowCtrlHandling   = HCI_BYPASS_CMD_FLOW_CTRL;
  
  /* Send out */	
  return BT_INVOKE( &req );
}
/* ===========================================================================
 * Function: BT_MNGR_Send_hci_raw_cmd
 * Description: Wrap VM commands with HCI, Command string is input parameter. 
                This function will wrap it with HCI header.
 * =========================================================================== */
BT_Result BT_MNGR_Send_hci_raw_cmd( const BT_U8 *hcivmCmd, BT_U8 size )
{
  HCI_RawCmdReq req;
  static BT_MNGR_HCI_RAWPKT vmpkt;
  BT_U16 temp	  = BT_MNGR_HCI_HEADER;
 
  ASSIGN_VAR_LE16( &vmpkt.Header, &temp); //Flip the data to make it little endian
  // Total length of the HCI RAW packet
  vmpkt.Parameter_Total_Length =  BT_MNGR_HCI_RAWPKT_SIZE_WO_PAYLOAD + size - 3; // Always 3 less as defined in document CSR HCI Extensions
  // VM Channel ID and single frame of data
  vmpkt.PayloadDescriptor.all = BT_MNGR_HCI_FIRSTFRAGMENT << 7 |
                                    BT_MNGR_HCI_LASTFRAGMENT << 6 |
                                    BT_MNGR_HCI_CHANNELID_VM;
  // Copy the Payload
  memcpy(vmpkt.payload, hcivmCmd, size);
  
  /* preparing HCI RAW */
  req.header.primitive      = HCI_RAW_CMD_REQ;
  req.header.receiver       = BT_HCI;
  req.header.sender         = appSenderId;
  req.hciCmdPacket          = (BT_U8*) &vmpkt;
  req.cmdFlowCtrlHandling   = HCI_BYPASS_CMD_FLOW_CTRL;
  
    /* Send out */	
  return BT_INVOKE( &req );
}  
/* ===========================================================================
 * Function: BT_MNGR_SendHciDeviceUnderTest
 * Description: Go to device under test mode.
 * =========================================================================== */
BT_Result BT_MNGR_SendHciDeviceUnderTest(void)
{
    HCI_EnableDeviceUnderTestMode req;
    
    req.header.primitive    = HCI_ENABLE_DEVICE_UNDER_TEST_MODE;
    req.header.receiver     = BT_HCI;
    req.header.sender       = appSenderId;
    
    return BT_INVOKE( &req );
}

/******************************************************************************
* SPP related send Functions
*******************************************************************************/

/* ===========================================================================
 * Function: BT_MNGR_SendSppDevConnectReq
 * Description: Go to device under test mode.
 * =========================================================================== */
BT_Result BT_MNGR_SendSppDevConnectReq(BT_BdAddr addr)
{
    SPP_DEV_ConnectReq req;
    req.header.primitive    = SPP_DEV_CONNECT_REQ;
    req.header.receiver     = BT_LookupProfile(BT_SPP_DEV);
    req.header.sender       = appSenderId;

    memcpy(req.bdAddr, addr, sizeof(BT_BdAddr));

    return BT_INVOKE( &req );
	
}

/*
BT_Result BT_MNGR_SendSppDevConnectReq(BT_BdAddr addr)
{
    
    SPP_DEV_ConnectReq req;
    BT_Result BT_RAM res = BT_OK;
        
    req.header.primitive    = SPP_DEV_CONNECT_REQ;
    req.header.receiver     = BT_LookupProfile(BT_SPP_DEV);
    req.header.sender       = appSenderId;

    memcpy(req.bdAddr, addr, sizeof(BT_BdAddr));
    res = SendSppConncedReq(&req);

    return res;
}
*/
/* ===========================================================================
 * Function: BT_MNGR_SendSppConnectRsp
 * Description: Process the connecting phase.
 * =========================================================================== */
BT_Result BT_MNGR_SendSppConnectRsp(BT_BOOL accept)
{
    SPP_DEV_ConnectRsp rsp;

    rsp.header.primitive    = SPP_DEV_CONNECT_RSP;
    rsp.header.receiver     = BT_LookupProfile(BT_SPP_DEV);
    rsp.header.sender       = appSenderId;
    rsp.accept              = accept;

    return BT_INVOKE( &rsp );
	
}

/* ===========================================================================
 * Function: BT_MNGR_SendSppDevDisconnectReq
 * Description: Disconnect R1.4 Device
 * =========================================================================== */
BT_Result BT_MNGR_SendSppDevDisconnectReq(void)
{
    SPP_DEV_DisconnectReq req;
    req.header.primitive    = SPP_DEV_DISCONNECT_REQ;
    req.header.receiver     = BT_LookupProfile(BT_SPP_DEV);
    req.header.sender       = appSenderId;

    return BT_INVOKE( &req );
	
}

/* ===========================================================================
 * Function: BT_MNGR_SendRssiInqCfg
 * Description: To enable RSSI 
 * =========================================================================== */
BT_Result BT_MNGR_SendRssiInqCfg(void)
{
  HCI_WriteInquiryMode      req;

  req.header.primitive     = HCI_WRITE_INQUIRY_MODE;
  req.header.sender        = appSenderId;
  req.header.receiver      = BT_HCI;
  req.inquiryMode          = (HCI_InquiryMode)HCI_INQUIRY_RESULT_FORMAT_WITH_RSSI;

  return BT_INVOKE( &req );
}

/* ===========================================================================
 * Function: BT_MNGR_SendRssiInqCfg
 * Description: To enable RSSI 
 * =========================================================================== */
BT_Result BT_MNGR_SendHciwritepagetimeout(void)
{
    HCI_WritePageTimeout req;

    req.header.primitive  = HCI_WRITE_PAGE_TIMEOUT;
    req.header.sender     = appSenderId;
    req.header.receiver   = BT_HCI;
    

    req.pageTimeout       = BT_HCI_PAGE_TIMEOUT;

    return BT_INVOKE( &req );
}

/* ===========================================================================
 * Function: BT_MNGR_SendHciReadInquiryResponseTransmitPowerLevel
 * Description: This command will read the inquiry Transmit Power level used to transmit the
 *              FHS and EIR data packets. This can be used directly in the Tx Power Level
 *              EIR data type
 * =========================================================================== */
BT_Result BT_MNGR_SendHciReadInquiryResponseTransmitPowerLevel(void)
{
    HCI_ReadInquiryResponseTransmitPowerLevel pwrlevel;

    pwrlevel.header.primitive  = HCI_READ_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL;
    pwrlevel.header.sender     = appSenderId;
    pwrlevel.header.receiver   = BT_HCI;

    return BT_INVOKE( &pwrlevel );
}

/* ===========================================================================
 * Function: BT_MNGR_SendHciWriteInquiryResponseTransmitPowerLevel
 * Description: This command is used to write the inquiry transmit power level used to transmit
 *              the inquiry (ID) data packets. The Controller should use the supported TX
 *              power level closest to the Tx_Power parameter.
 * =========================================================================== */
BT_Result BT_MNGR_SendHciWriteInquiryResponseTransmitPowerLevel(BT_S8 ReqPwr)
{
    HCI_WriteInquiryResponseTransmitPowerLevel pwrreq;

    pwrreq.header.primitive  = HCI_WRITE_INQUIRY_RESPONSE_TRANSMIT_POWER_LEVEL;
    pwrreq.header.sender     = appSenderId;
    pwrreq.header.receiver   = BT_HCI;
    pwrreq.txPower           = ReqPwr;
    
    return BT_INVOKE( &pwrreq );
}

/* =========================================================================== */
 /* ===========================================================================
 * Function:    BT_MNGR_SendSeclinkkeyreqrsp
 * Description: Respond on the link key, host have the link key or not
 * Returns:     
 * =========================================================================== */
BT_Result BT_MNGR_SendSeclinkkeyreqrsp( btDevInfo* device, BT_BOOL accept)
{    
    SEC_LinkKeyRequestRsp req;
    
    memset( &req, 0x00, sizeof(SEC_LinkKeyRequestRsp));

    /*Init header data*/        
    req.header.primitive   = SEC_LINK_KEY_REQUEST_RSP;
    req.header.sender      = appSenderId;
    req.header.receiver    = BT_SEC;

    memcpy(req.bdAddr, device->addr, sizeof(HCI_BdAddr));
    req.accept = accept;

    if( accept == BT_TRUE )
    {
      memcpy( &req.linkKey,     &device->linkkey,      sizeof(HCI_LinkKey));
      memcpy( &req.keyType,     &device->keyType,      sizeof(HCI_KeyType));
      memcpy( &req.pairingType, &device->pairingType,  sizeof(SEC_PairingType));
    }
    
    return BT_INVOKE(&req);
}

//cwc034: QoS test
/* ===========================================================================
 * Function: BT_MNGR_SendHciQosSetup
 * Description: Only for Access Latency
 * =========================================================================== */
BT_Result BT_MNGR_SendHciQosSetup(BT_U16 connectionHandle, BT_U32 pollrate)
{
	HCI_QosSetup qos;
	
	qos.header.primitive = HCI_QOS_SETUP;
	qos.header.sender = appSenderId;
	qos.header.receiver = BT_HCI;

  //#define HCI_QOS_NO_TRAFFIC_AVAILABLE	0x0
  //#define HCI_QOS_BEST_EFFORT_AVAILABLE	0x1
  //#define HCI_QOS_GUARANTEED_AVAILABLE	0x2
  qos.serviceType = HCI_QOS_GUARANTEED_AVAILABLE;
    
	qos.connectionHandle = connectionHandle;
	qos.latency = pollrate;
	
	return BT_INVOKE( &qos );
} 

 /* ===========================================================================
 * Function:    BT_MNGR_Send_Read_BDADD
 * Description: Request to local bluetooth Address
 * Returns:
 * =========================================================================== */
BT_Result BT_MNGR_Send_Read_BDADD(void)
{
  HCI_ReadBdAddr readBDAdd;

    readBDAdd.header.primitive   = HCI_READ_BD_ADDR;
    readBDAdd.header.sender      = appSenderId;
    readBDAdd.header.receiver    = BT_HCI;

        return BT_INVOKE( &readBDAdd );
}

/* =========================================================================== */

