/*##############################################################################
#
# 	                      FILE SPECIFICATION
# 		COPYRIGHT 2011,2013-2015 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#			MOTOROLA CONFIDENTIAL RESTRICTED
#
################################################################################
#
# FILE NAME: codeplug_ui.h
#
# --------------------------- General Description -----------------------------
#   This file describes the user application programming interface that enables 
# the application to interface with the Codeplug Manager. This file contains the
# prototypes and structure definitions of the API.
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified  CR Tracking Number  Description
* Jonathan James    05/12/2010     CCMPD01346766       Initial Creation
* YewFoong Lim      09/08/2010     CCMPD01389483       Added 4 bytes of new codeplug fields
*                                                      for storing the BT addresses of the paired 
*                                                      HSP and SPP BT devices
* PeiSee Toh        09/21/2010    CCMPD01393922        Added new codeplug fields to support hardware RTTE & BQB Test
* PeiSee Toh        10/06/2010    CCMPD01399521        Cleanup the unwanted codeplug fields and add in the new codeplug fields for engineering testing
* PeiSee Toh        09/20/2010    CCMPD01393923        Catchup from 2.0 latest version WIRELESS_HEADSET_SW_I08.00.00
* PeiSee Toh        10/29/2010    CCMPD01408759        Added new codeplug field for pairing timer
* YewFoong          11/18/2010    CCMPD01411683        Added new parameters "BT_QUALIFICATION_TEST_MODE", "BQB_HSP_ADDR_1",
*                                                      "BQB_HSP_ADDR_2" for BT Qualification Test Mode usage
* PeiSee Toh        11/24/2010    CCMPD01419110        Added new parameter of "MAX_CODEPLUG_ITEMS" as a marker for number of codeplug item.
* Tan Seng Kai      12/08/2010    CCMPD01451448        Linkey handle and store in codeplug
* Mahes             Jan/06/2011   CCMPD01460340        Software catch-up to dongle R1.2 version R01.00.00
* PeiSee Toh        01/17/2011    CCMPD01463473        Define new codeplug fields for R2.1 Dongle
* PeiSee Toh        01/25/2011    CCMPD01466788        Added new codeplug field to store the NFC pairing info
* PeiSee Toh        02/10/2011    CCMPD01471881        Added new codeplug field of "TIME_CONNECTION" and "POLL_RATE", changed the parameter of "TIME_RECONNECT"
* wrn637            10/16/2013    CCMPD01826478        Audio detection handling
* WRN637            01/27/2014    CCMPD01856321        OneDot TwoDot disconnection
* Abhishek Trivedi  03/10/2014	  CCMPD01870625        CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi  04/04/2014    CCMPD01880219        Allow EDR for std_pairing
* Abhishek Trivedi  05/22/2014    CCMPD01896550        Add Nibbler PTT timeout to codeplug
* Abhishek Trivedi  10/22/2014    CCMPD01938895        Audio Switch
* Abhishek Trivedi  01/14/2015    CCMPD01958122        GW supports infinte pairing
*--------------------------- End of History Template----------------------------
*******************************************************************************/
//------------------------------------------------------------------------------
//      Preprocessor Definitions
//------------------------------------------------------------------------------
#ifndef CODEPLUG_UI_H
#define CODEPLUG_UI_H

/* Codeplug General Definitions */
#define CODEPLUG_TOTAL_SIZE                 0x400
#define CODEPLUG_PARTITION_SIZE             0x200
#define CODEPLUG_PARAMETER_SIZE             sizeof(long)
#define CODEPLUG_PARAMETER_MAX_COUNT        CODEPLUG_PARTITION_SIZE / sizeof(long)

/* Codeplug Function Return Status Codes */
#define CODEPLUG_FAIL                       0x0
#define CODEPLUG_OK                         0x1
#define CODEPLUG_NVRAM_NSYNC                0x2
#define CODEPLUG_NVRAM_SYNC                 0x4

/* Codeplug Header Information Definitions */
#define CODEPLUG_HEADER_MAGIC_NUMBER        0x0FA3
#define CODEPLUG_ACTIVE_MARKER              0x86C5

//------------------------------------------------------------------------------
//      Type Definitions
//------------------------------------------------------------------------------

/* codeplug<Get|Set>Parameter options */
#define CPLG_NONE                       0

/* codeplugGetParameter options */
#define CPLG_CHK_SYNC                   1 

/* codeplugSetParameter options */
#define CPLG_FLUSH                      1

//////////// CODEPLUG PARAMETERS ///////////////////////////////////////////////

/* Codeplug Parameter List */
/*    This list contains all valid parameters that can be accessed by the 
      implementation in terms of read/write operations. If a parameter is
      not on the list or an index is not within range, do not use it. */


enum {
  
  RE_PAIRING_CYCLE = 2,
  PAIRING_METHOD,
  TIME_PAIRING_MODE,
  TIME_RECONNECT,
  TIME_LINK_ESTABLISH,
  TIME_DEVICE_INQUIRY,
  PAIRING_BT_AUDIO_ADDR_1,
  PAIRING_BT_AUDIO_ADDR_2,
  PAIRING_BT_PTT_ADDR_1,
  PAIRING_BT_PTT_ADDR_2,
  RF_TEST_CONFIGURATION_1,
  RF_TEST_CONFIGURATION_2,
  PAIRING_REC_RFCOMM_NUM_CH,
  PAIRING_REC_RFCOMM_BT_AUDIO,
  PAIRING_REC_RFCOMM_BT_PTT,
  DONGLE_DISCOVERABLE,
  BT_QUALIFICATION_TEST_MODE,
  BQB_BT_AUDIO_ADDR_1,
  BQB_BT_AUDIO_ADDR_2,
  PAIRING_BT_AUDIO_LINKKEY_1,
  PAIRING_BT_AUDIO_LINKKEY_2,
  PAIRING_BT_AUDIO_LINKKEY_3,
  PAIRING_BT_AUDIO_LINKKEY_4,
  PAIRING_BT_AUDIO_KEYTYPE,
  PAIRING_BT_AUDIO_PAIRTYPE,
  PAIRING_BT_PTT_LINKKEY_1,
  PAIRING_BT_PTT_LINKKEY_2,
  PAIRING_BT_PTT_LINKKEY_3,
  PAIRING_BT_PTT_LINKKEY_4,
  PAIRING_BT_PTT_KEYTYPE,
  PAIRING_BT_PTT_PAIRTYPE,
  PAIRING_BQB_BT_AUDIO_LINKKEY_1,
  PAIRING_BQB_BT_AUDIO_LINKKEY_2,
  PAIRING_BQB_BT_AUDIO_LINKKEY_3,
  PAIRING_BQB_BT_AUDIO_LINKKEY_4,
  PAIRING_BQB_BT_AUDIO_KEYTYPE,
  PAIRING_BQB_BT_AUDIO_PAIRTYPE,
  PAIRING_BT_AUDIO_TRANSACTION_TYPE,
  PAIRING_BT_AUDIO_DEVICE_TYPE,
  PAIRING_BT_AUDIO_FAST_PTT,
  PAIRING_BT_PTT_TRANSACTION_TYPE,
  PAIRING_BT_PTT_DEVICE_TYPE,
  PAIRING_BT_PTT_FAST_PTT,
  TIME_CONNECTION,
  POLL_RATE_SETTING,
  MUTE_DELAY_TIME,
  ENABLE_ONEDOT_TWODOT_DISCONNECTION,
  CSR_DSP_SPEAKER_GAIN,
  CSR_DSP_MIC_GAIN,
  CSR_DSP_AUDIO_LINE_DELAY,
  CSR_DSP_AUDIO_DETECT_THRESHOLD,
  ENABLE_EDR_STD_PAIRING,
  ENABLE_HW_AUDIO_DETECT,
  NIBBLER_PTT_TIMEOUT,
  GW_LEGACY_BEHAVIOR,
  GW_NEVER_REPAIR,
  DISABLE_GW_USB_HID,
  /* Marks the number of codeplug items */
  MAX_CODEPLUG_ITEMS,
  
  /* Marks the out-of-bounds range start location */
  INVALID_PARAMETER = CODEPLUG_PARAMETER_MAX_COUNT - 1 
  /* Do not use any parameter index starting with the INVALID_PARAMETER index */
};


////////////////////////////////////////////////////////////////////////////////

/* Definition of the Codeplug parameter data type. */
typedef long int cplg_param_t;

//------------------------------------------------------------------------------
//      Codeplug Function Prototype Declaration
//------------------------------------------------------------------------------

int codeplugInit(); 

bool codeplugCompareParameter(int index);

int codeplugWriteback();

int codeplugGetParameter(int index, cplg_param_t *value, int options);
int codeplugSetParameter(int index, cplg_param_t value, int options);

void codeplug_restore_from_default();


#endif
