#ifndef CONFIG_H // Insert File name here like "INCLUDE_FILE_NAME_H"
#define CONFIG_H // Insert File name here like "INCLUDE_FILE_NAME_H"

/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2015 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: initialization.h
#
# --------------------------- General Description -----------------------------
# This file contains the 'defines' which are specific to configuring the Wireless
# headset product code.
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR             Date Modified	CR Tracking Number 	  Description
* Aneeket Patkar     02/03/2010         CCMPD01310299_Atmel_Init  Initial Creation
* Aneeket Patkar     05/25/2010         CCMPD01347254             XCMP Implementation
* Sevuhan Ramanathan 06/29/2010                                   Included RADIO_PTT_GPIO_PIN and ONHOOK_READ_GPIO_PIN for R1.2     
* Tan Seng Kai	     09/09/2010		CCMPD01390555	          Change pin assigment for ONHOOK_READ_GPIO_PIN.
* WRN637	     10/20/2010   	CCMPD01394399	          Added in define for BT reset pin
* JJ Low             11/15/2010         CCMPD01412613             R2.1 removing debug UART
*Sevuhan Ramanathan  11/03/2010         CCMPD01409605             added definition for AUDIO_DETECT_GPIO_PIN,AUDIO_DETECT_IRQ,AUDIO_DETECT_IRQ_LEVEL    
* YK - JWPM67          Nov/11/2010      CCMPD01413200           Catch-up to NON_SECURE_R1.2A_ITR05_I05.00.09  
* YK - JWPM67          Nov/15/2010      CCMPD01413200           Defined AUDIO_ROUTE_SWITCH_GPIO_PIN, AUDIO_ROUTE_SWITCH_IRQ, and AUDIO_ROUTE_SWITCH_IRQ_LEVEL
* Mahes                Jan/06/2011      CCMPD01460340           Software catch-up to dongle R1.2 version R01.00.00
* Sevuhan Ramanathan   01/13/2011       CCMPD01462651           Added SW_TEST_UP_PIN   
* Sevuhan Ramanathan   04/20/2011       CCMPD01498417           Define LED_PIN & BTLINK_PIN 
* Sevuhan Ramanathan   12/21/2011       CCMPD01594785          defn for PROGRAM_BTN_1 and PROGRAM_BTN_2
*
* Sevuhan Ramanathan   01/04/2012       CCMPD01600891           Added pin defines for 2.17, added ENABLE_2_17_CB to select 2.17 pin map
* WRN637               9/11/2013        CCMPD01808031           REMOVE USB HID Support
* WRN637               09/17/2013       CCMPD01815073           Add Button handling for R2.17 Wireless Gateway P0B board
* Abhishek Trivedi     09/02/2013       CCMPD01827271           XNL-XCMP Host support
* Abhishek Trivedi     03/10/2014       CCMPD01870625           CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi     03/18/2014       CCMPD01873731           Resolve 2 device connection issue
* Abhishek Trivedi     02/20/2015       CCMPD01970147           Increase TC maximum buffer read size
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/
#include "gpio.h"

/*********************************************************************************/
/*--------------------------- DATA TYPES - DEFINITIONS -----------------------*/
/* Basic data types */
/* Integer Types */ /* EWAVR32_CompilerReference.pdf - C/C++ Compiler Reference
                        Guide for Atmel AVR32 - Page 163-168 */

/* Size = 8-bits    Range = -128 to 127       Alignment = 1 */
typedef signed char             INT8_T;
/* Size = 8-bits    Range = 0 to 255          Alignment = 1 */
typedef unsigned char           UINT8_T;
/* Size = 16-bits   Range = -32768 to 32767   Alignment = 2 */
typedef short                   INT16_T;
/* Size = 16-bits   Range = 0 to 65535        Alignment = 2 */
typedef unsigned short          UINT16_T;
/* Size = 32-bits   Range = -2^31 to 2^31-1   Alignment = 4 */
typedef signed int              INT32_T;
/* Size = 32-bits   Range = 0 to 2^32-1       Alignment = 4 */
typedef unsigned int            UINT32_T;
/* Size = 32-bits   Range = -2^31 to 2^31-1   Alignment = 4 */
typedef signed long             LONG32_T;
/* Size = 32-bits   Range = 0 to 2^32-1       Alignment = 4 */
typedef unsigned long           ULONG32_T;
/* Size = 64-bits   Range = -2^63 to 2^63-1   Alignment = 4 */
typedef signed long long int    LONG64_T;  //!< 64-bit signed integer.
/* Size = 64-bits   Range = 0 to 2^64-1       Alignment = 4 */
typedef unsigned long long int  ULONG64_T;  //!< 64-bit unsigned integer.
/* Floating-Point Types */ 
/* Size = 32-bits    Range = +-1.18E-38 to +-3.39E+38 */
/* Decimals = 7   Exponent = 8-bits     Mantissa = 23     */
typedef float                   FLOAT32_T;  //!< 32-bit floating-point number.
/* Size = 64-bits    Range = +-2.23E-308 to +-1.79E+308 */
/* Decimals = 7   Exponent = 8-bits     Mantissa = 52     */
typedef double                  FLOAT64_T;  //!< 64-bit floating-point number.

typedef unsigned char           BOOL_T; //!< Boolean.

/*********************************************************************************/

//------------------------------------------------------------------------------
//-------------------------------Enable R2.17 pin map---------------------------

#define PCB_BOARD_VERSION   R2_17_GATEWAY_P0B

#define R2_17_GATEWAY_P0A   0
#define R2_17_GATEWAY_P0B   1


//------------------------------------------------------------------------------

#define RADIO_SERIAL_PORT                              ((avr32_usart_t*)AVR32_USART1_ADDRESS)  // CCMPD01412613 (JJ 22/11/2010)

/*======================================================================*/
/*                          CLOCK DEFINES                               */
/*======================================================================*/
// Clock defines. 
#define DONGLE_FOSC0_CLK                                16000000    // Osc0 crystal freq
#define DONGLE_OSC0_CLK_STARTUP                         0x00000003  //startup time of 18 ms

// PBA config. Used to drive UART.
#define config_DONGLE_PBA_CLOCK_HZ                      DONGLE_FOSC0_CLK //(DONGLE_FOSC0_CLK/pow(2,(PBA_SEL+1)))

// Clock Configuration defines
#define PBA_DIV                                          0            // Enable clk divide.                    
#define PBA_SEL                                          0            // Divide main clock by 4.                                   
#define PBB_DIV                                          0            // Enable clk divide.                 
#define PBB_SEL                                          0            // Divide main clock by 4.                   
#define CLK_HSB_DIV                                      0            // Enable clk divide.                
#define CLK_HSB_SEL                                      0            // Divide main clock by 4.  

/*======================================================================*/
/*                          USB CLOCK DEFINES                           */
/*======================================================================*/
#define DONGLE_USB_PLL_SELECT                           1             // Select PLL 1 as source for USB
#define DONGLE_USB_PLL_PLLOSC                           0             // Set Osc0 as source for PLL
#define DONGLE_USB_PLL_PLLMUL                           5             // 96 MHz = 16 MHz(the FOSC)*(5+1)
#define DONGLE_USB_PLL_PLLDIV                           1             // Divide by 1
#define DONGLE_USB_PLL_PLLCOUNT                         16            // Set to same as EVK1101
#define DONGLE_USB_PLL_PLLOPT_BIT0                      1             // VCO freq : 80MHz<fvco<180MHz
#define DONGLE_USB_PLL_PLLOPT_BIT1                      1             // fpll = fvco/2 = 48MHz 
#define DONGLE_USB_PLL_PLLOPT_BIT2                      0             // Wide BW mode disabled

#define DONGLE_USB_PLL_GCCTRL_OSCSEL                    1             // Select PLL1 as source
#define DONGLE_USB_PLL_GCCTRL_PLLSEL                    1             // Select PLL1 as source
#define DONGLE_USB_PLL_GCCTRL_DIVEN                     0             // Disable Divide
#define DONGLE_USB_PLL_GCCTRL_DIV                       0             // Divide =0 

/*======================================================================*/
/*                           UART DEFINES                               */
/*======================================================================*/


/*======================================================================*/
/*                           INTERRUPT DEFINES                         */
/*======================================================================*/

/* PTT_MFB_GPIO_PIN PA06*/
#define PTT_MFB_GPIO_PIN_IRQ                  AVR32_GPIO_IRQ_0
#define PTT_MFB_GPIO_PIN_IRQ_LEVEL            AVR32_INTC_INT0

/* AUDIO_DETECT_GPIO_PIN PA07*/
#define AUDIO_DETECT_GPIO_PIN_IRQ                AVR32_GPIO_IRQ_0
#define AUDIO_DETECT_GPIO_PIN_IRQ_LEVEL          AVR32_INTC_INT0

#define CSR_DSP_AUDIO_DETECT_GPIO_PIN_IRQ         AVR32_GPIO_IRQ_4
#define CSR_DSP_AUDIO_DETECT_GPIO_PIN_IRQ_LEVEL   AVR32_INTC_INT0

/* ONE_DOT_DETECT_GPIO_PIN - PA04 */
#define ONE_DOT_DETECT_GPIO_PIN_IRQ              AVR32_GPIO_IRQ_0
#define ONE_DOT_DETECT_GPIO_PIN_IRQ_LEVEL        AVR32_INTC_INT0

/* TWO_DOT_DETECT_GPIO_PIN - PA05 */
#define TWO_DOT_DETECT_GPIO_PIN_IRQ              AVR32_GPIO_IRQ_0
#define TWO_DOT_DETECT_GPIO_PIN_IRQ_LEVEL        AVR32_INTC_INT0

/* PHYSICAL_HOOK_DETECT_GPIO_PIN */
#define PHYSICAL_HOOK_DETECT_GPIO_PIN_IRQ        AVR32_GPIO_IRQ_1
#define PHYSICAL_HOOK_DETECT_GPIO_PIN_IRQ_LEVEL  AVR32_INTC_INT1   

/* BOARD_FAIL_DETECT_PIN - PB02 */
#define BOARD_FAIL_DETECT_PIN_IRQ                AVR32_GPIO_IRQ_4
#define BOARD_FAIL_DETECT_PIN_IRQ_LEVEL          AVR32_INTC_INT3

/* BOARD_ID_DETECT_PIN - PB03*/
#define BOARD_ID_DETECT_PIN_IRQ                  AVR32_GPIO_IRQ_4
#define BOARD_ID_DETECT_PIN_IRQ_LEVEL            AVR32_INTC_INT3

/* UPGRADE_DETECT_GPIO_PIN - PB09 */
#define UPGRADE_DETECT_GPIO_PIN_IRQ              AVR32_GPIO_IRQ_5
#define UPGRADE_DETECT_GPIO_PIN_IRQ_LEVEL        AVR32_INTC_INT3





#define PTT_BUTTON_IRQ                                   PTT_MFB_GPIO_PIN_IRQ
#define PTT_BUTTON_IRQ_LEVEL                             PTT_MFB_GPIO_PIN_IRQ_LEVEL

#define AUDIO_DETECT_IRQ                                 AUDIO_DETECT_GPIO_PIN_IRQ
#define AUDIO_DETECT_IRQ_LEVEL                           AUDIO_DETECT_GPIO_PIN_IRQ_LEVEL

#define BC05_UART_IRQ                                    AVR32_USART2_IRQ   // 224 IRQ_Group#7
#define BC05_UART_PORT                                   ((avr32_usart_t*)AVR32_USART2_ADDRESS)

/*======================================================================*/
/*                           GPIO DEFINES                               */
/*======================================================================*/
#define DONGLE_GPIO                                     AVR32_GPIO
//  Function Selection defines for GPIO
#define PIN_FUNCTION_A                                   0
#define PIN_FUNCTION_B                                   1
#define PIN_FUNCTION_C                                   2
#define PIN_FUNCTION_D                                   3     // need to check implementation in gpio_enable_module_pin()
#define PIN_GPIO_FUNCTION                                10


// ATMEL PIN CONFIGUARTION & FUNCTIONALITY defines GPIO pins PA03-PA31 and PB00-PB11

/* MMP output */
#define RADIO_MMP_PTT_GPIO_PIN                               PA20   /* output, L:Assert H:deassert */
#define RADIO_MMP_ONE_DOT_GPIO_PIN                           PA23   /* output, L:Assert H:deassert */
#define RADIO_MMP_TWO_DOT_GPIO_PIN                           PA24   /* output, L:Assert H:deassert */
#define RADIO_MMP_VIRTUAL_HOOK_GPIO_PIN                      PB08   /* output, L:RAD_SPKR H:HS_SPKR */

/* Input */
#define PTT_MFB_GPIO_PIN                                     PA06   /* input, L:ENABLE H:DISABLE */
#define AUDIO_DETECT_GPIO_PIN                                PA07   /* input, L:NO_AUD H:AUD_DET */
#define CSR_DSP_AUDIO_DETECT_GPIO_PIN                        PB06   /* input, L:NO_AUD H:AUD_DET */
#define PHYSICAL_HOOK_DETECT_GPIO_PIN                        PA08   /* input, L:ON_HOOK H:OFF_HOOK */
#define BOARD_FAIL_DETECT_PIN                                PB02   /* input, H:PASSED L:FAILED */
#define BOARD_ID_DETECT_PIN                                  PB03   /* input, L:P0A_BOARD H:UNDEFINED */
#define UPGRADE_DETECT_GPIO_PIN                              PB09   /* input, L:GPIO_FUNC H:USB_FUNC */
#define UPGRADE_DETECT_GPIO_PIN2                             PA31   /* input, L:GPIO_FUNC H:USB_FUNC */

/* Only applicable for P0B */
#define ONE_DOT_DETECT_GPIO_PIN                              PA04   /* input, L:PRESSED H:RELEASED */
#define TWO_DOT_DETECT_GPIO_PIN                              PA05   /* input, L:PRESSED H:RELEASED */

/* Output */
#define ATMEL_CSR_UPGRADE_SELECT_GPIO_PIN                    PA15   /* output, L:ATMEL H:CSR */
#define LED_PIN                                              PA28   /* output, L:ENABLE H:DISABLE */
#define DEBUG_GPIO_PIN                                       PA29   /* output, NA */
#define MIC_SELECT_GPIO_PIN                                  PB04   /* output, L:BT_SPKR H:Local_mic */   
#define USB_SELECT_GPIO_PIN                                  PB05   /* output,  L:GPIO_FUNC H:USB_FUNC */
#define UP_RST_BT_GPIO_PIN                                   PA22   /* output, L:Release reset H:Reset */


#define PA03      3
#define PA03_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA03_ADC_FUNCTION          PIN_FUNCTION_A
#define PA03_PM_FUNCTION           PIN_FUNCTION_B
#define PA03_USBB_FUNCTION         PIN_FUNCTION_C

#define PA04      4
#define PA04_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA04_ADC_FUNCTION          PIN_FUNCTION_A
#define PA04_PM_FUNCTION           PIN_FUNCTION_B
#define PA04_USBB_FUNCTION         PIN_FUNCTION_C

#define PA05      5
#define PA05_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA05_EIC_FUNCTION          PIN_FUNCTION_A
#define PA05_ADC_FUNCTION          PIN_FUNCTION_B
#define PA05_USART1_FUNCTION       PIN_FUNCTION_C

#define PA06      6
#define PA06_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA06_EIC_FUNCTION          PIN_FUNCTION_A
#define PA06_ADC_FUNCTION          PIN_FUNCTION_B
#define PA06_USART1_FUNCTION       PIN_FUNCTION_C

#define PA07      7
#define PA07_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA07_PWM_FUNCTION          PIN_FUNCTION_A
#define PA07_ADC_FUNCTION          PIN_FUNCTION_B
#define PA07_USART1_FUNCTION       PIN_FUNCTION_C

#define PA08      8
#define PA08_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA08_PWM_FUNCTION          PIN_FUNCTION_A
#define PA08_ADC_FUNCTION          PIN_FUNCTION_B
#define PA08_USART1_FUNCTION       PIN_FUNCTION_C

#define PA09      9
#define PA09_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA09_TWI_FUNCTION          PIN_FUNCTION_A
#define PA09_SPI_FUNCTION          PIN_FUNCTION_B       
#define PA09_USART1_FUNCTION       PIN_FUNCTION_C

#define PA10     10
#define PA10_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA10_TWI_FUNCTION          PIN_FUNCTION_A
#define PA10_SPI_FUNCTION          PIN_FUNCTION_B
#define PA10_USART1_FUNCTION       PIN_FUNCTION_C

#define PA11     11
#define PA11_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA11_USART0_FUNCTION       PIN_FUNCTION_A
#define PA11_TC_FUNCTION           PIN_FUNCTION_B
#define PA11_PWM_FUNCTION          PIN_FUNCTION_C

#define PA12     12
#define PA12_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA12_USART0_FUNCTION       PIN_FUNCTION_A
#define PA12_TC_FUNCTION           PIN_FUNCTION_B
#define PA12_PWM_FUNCTION          PIN_FUNCTION_C

#define PA13     13
#define PA13_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA13_NMI_FUNCTION          PIN_FUNCTION_A
#define PA13_PWM_FUNCTION          PIN_FUNCTION_B
#define PA13_USART0_FUNCTION       PIN_FUNCTION_C

#define PA14     14
#define PA14_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA14_SPI_FUNCTION          PIN_FUNCTION_A
#define PA14_PWM_FUNCTION          PIN_FUNCTION_B
#define PA14_EIC_FUNCTION          PIN_FUNCTION_C

#define PA15     15
#define PA15_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA15_SPI_FUNCTION          PIN_FUNCTION_A
#define PA15_PWM_FUNCTION          PIN_FUNCTION_B
#define PA15_USART2_FUNCTION       PIN_FUNCTION_C

#define PA16     16
#define PA16_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA16_SPI_FUNCTION          PIN_FUNCTION_A
#define PA16_TC_FUNCTION           PIN_FUNCTION_B

#define PA17     17
#define PA17_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA17_SPI_NPCS_FUNCTION     PIN_FUNCTION_A
#define PA17_TC_FUNCTION           PIN_FUNCTION_B
#define PA17_SPI_SCK_FUNCTION      PIN_FUNCTION_C

#define PA18     18
#define PA18_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA18_USART0_FUNCTION       PIN_FUNCTION_A
#define PA18_PWM_FUNCTION          PIN_FUNCTION_B
#define PA18_SPI_FUNCTION          PIN_FUNCTION_C

#define PA19     19
#define PA19_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA19_USART0_FUNCTION       PIN_FUNCTION_A
#define PA19_PWM_FUNCTION          PIN_FUNCTION_B
#define PA19_SPI_FUNCTION          PIN_FUNCTION_C

#define PA20     20
#define PA20_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA20_USART1_FUNCTION       PIN_FUNCTION_A
#define PA20_TC_FUNCTION           PIN_FUNCTION_B
#define PA20_USART2_FUNCTION       PIN_FUNCTION_C

#define PA21     21
#define PA21_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA21_PWM_FUNCTION          PIN_FUNCTION_A
#define PA21_TC_FUNCTION           PIN_FUNCTION_B
#define PA21_USART2_FUNCTION       PIN_FUNCTION_C

#define PA22     22
#define PA22_GPIO_FUNCTION         PIN_GPIO_FUNCTION
#define PA22_PWM_FUNCTION          PIN_FUNCTION_A
#define PA22_TC_FUNCTION           PIN_FUNCTION_B
#define PA22_ADC_FUNCTION          PIN_FUNCTION_C

#define PA23     23
#define PA23_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA23_USART1_FUNCTION        PIN_FUNCTION_A
#define PA23_SPI_FUNCTION           PIN_FUNCTION_B
#define PA23_EIC_FUNCTION           PIN_FUNCTION_C

#define PA24     24
#define PA24_GPIO_FUNCTION
#define PA24_USART1_FUNCTION        PIN_FUNCTION_A
#define PA24_SPI_FUNCTION           PIN_FUNCTION_B
#define PA24_EIC_FUNCTION           PIN_FUNCTION_C

#define PA25     25
#define PA25_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA25_SPI_FUNCTION           PIN_FUNCTION_A
#define PA25_PWM_FUNCTION           PIN_FUNCTION_B
#define PA25_EIC_FUNCTION           PIN_FUNCTION_C

#define PA26     26
#define PA26_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA26_USB_FUNCTION           PIN_FUNCTION_A
#define PA26_USART2_FUNCTION        PIN_FUNCTION_B
#define PA26_TC_FUNCTION            PIN_FUNCTION_C

#define PA27     27
#define PA27_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA27_USB_FUNCTION           PIN_FUNCTION_A
#define PA27_USART2_FUNCTION        PIN_FUNCTION_B
#define PA27_TC_FUNCTION            PIN_FUNCTION_C

#define PA28     28
#define PA28_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA28_USART0_FUNCTION        PIN_FUNCTION_A
#define PA28_PWM_FUNCTION           PIN_FUNCTION_B
#define PA28_SPI_FUNCTION           PIN_FUNCTION_C

#define PA29     29
#define PA29_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA29_TC_CLK0_FUNCTION       PIN_FUNCTION_A
#define PA29_TC_CLK1_FUNCTION       PIN_FUNCTION_B
#define PA29_SPI_FUNCTION           PIN_FUNCTION_C

#define PA30     30
#define PA30_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA30_ADC_FUNCTION           PIN_FUNCTION_A
#define PA30_EIC_FUNCTION           PIN_FUNCTION_B
#define PA30_PM_FUNCTION            PIN_FUNCTION_C

#define PA31     31
#define PA31_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PA31_ADC_FUNCTION           PIN_FUNCTION_A
#define PA31_EIC_FUNCTION           PIN_FUNCTION_B

#define PB00     32
#define PB00_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB00_TC_FUNCTION            PIN_FUNCTION_A
#define PB00_EIC_FUNCTION           PIN_FUNCTION_B
#define PB00_USART2_FUNCTION        PIN_FUNCTION_C

#define PB01     33
#define PB01_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB01_TC_FUNCTION            PIN_FUNCTION_A
#define PB01_EIC_FUNCTION           PIN_FUNCTION_B
#define PB01_USART2_FUNCTION        PIN_FUNCTION_C

#define PB02     34
#define PB02_GPIO_FUNCTION          PIN_GPIO_FUNCTION 
#define PB02_EIC_FUNCTION           PIN_FUNCTION_A
#define PB02_TC_FUNCTION            PIN_FUNCTION_B
#define PB02_USART1_FUNCTION        PIN_FUNCTION_C

#define PB03     35
#define PB03_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB03_EIC_FUNCTION           PIN_FUNCTION_A
#define PB03_TC_FUNCTION            PIN_FUNCTION_B
#define PB03_USART1_FUNCTION        PIN_FUNCTION_C

#define PB04     36
#define PB04_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB04_USART1_FUNCTION        PIN_FUNCTION_A
#define PB04_SPI_FUNCTION           PIN_FUNCTION_B
#define PB04_TC_FUNCTION            PIN_FUNCTION_C

#define PB05     37
#define PB05_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB05_USART1_FUNCTION        PIN_FUNCTION_A
#define PB05_SPI_FUNCTION           PIN_FUNCTION_B
#define PB05_PWM_FUNCTION           PIN_FUNCTION_C

#define PB06     38
#define PB06_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB06_SSC_FUNCTION           PIN_FUNCTION_A
#define PB06_USART1_FUNCTION        PIN_FUNCTION_B
#define PB06_EIC_FUNCTION           PIN_FUNCTION_C

#define PB07     39
#define PB07_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB07_SSC_FUNCTION           PIN_FUNCTION_A
#define PB07_USART1_FUNCTION        PIN_FUNCTION_B
#define PB07_EIC_FUNCTION           PIN_FUNCTION_C

#define PB08     40
#define PB08_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB08_SSC_FUNCTION           PIN_FUNCTION_A
#define PB08_USART1_FUNCTION        PIN_FUNCTION_B
#define PB08_EIC_FUNCTION           PIN_FUNCTION_C

#define PB09     41
#define PB09_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB09_SSC_FUNCTION           PIN_FUNCTION_A
#define PB09_USART1_FUNCTION        PIN_FUNCTION_B
#define PB09_EIC_FUNCTION           PIN_FUNCTION_C

#define PB10     42
#define PB10_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB10_SSC_FUNCTION           PIN_FUNCTION_A
#define PB10_TC_FUNCTION            PIN_FUNCTION_B
#define PB10_USART0_FUNCTION        PIN_FUNCTION_C

#define PB11     43
#define PB11_GPIO_FUNCTION          PIN_GPIO_FUNCTION
#define PB11_SSC_FUNCTION           PIN_FUNCTION_A
#define PB11_TC_FUNCTION            PIN_FUNCTION_B
#define PB11_USART0_FUNCTION        PIN_FUNCTION_C

// GPIO map for SPI

#define OS_ENTER_SWITCHING_ISR          portENTER_SWITCHING_ISR()
#define OS_EXIT_SWITCHING_ISR           portEXIT_SWITCHING_ISR()

/*======================================================================*/
/*                DEBUG/FACTORY TEST COMMANDS MANAGER DEFINES           */
/*======================================================================*/

#define DEBUG_QUEUE_DELAY               0
#define DEBUG_QUEUE_LENGTH              300
#define DEBUG_SEMPHR_MAXCOUNT           900
#define DEBUG_SEMPHR_INITCOUNT          900

#define TC_QUEUE_DELAY                  0
#define TC_RX_BUFFER_LENGTH             500
#define TC_DATA_QUEUE_LENGTH            200
#define TC_SEMPHR_MAXCOUNT              200
#define TC_SEMPHR_INITCOUNT             200
#define TC_MAX_SIZE                     450
#define TC_TASK_DELAY                   10

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
typedef enum success_failure
{
  FAILURE = 0,
  SUCC    = 1
} success_failure_t;
//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
void vTaskSwitchContext( void );

#endif
