#ifndef CONTROLS_H
#define CONTROLS_H

/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: controls.h
#
# --------------------------- General Description -----------------------------
# This file contains the function prototypes, variables, includes and extern
# function prototypes for the controls.
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	 CR Tracking Number      Description
* Abhishek Trivedi  04/14/2010           CCMPD01331626           Initial Creation
* Rhee Zhang        05/07/2010           CCMPD01345347           Cleanup IAR Compiler Warnings
* Aneeket Patkar    05/14/2010           CCMPD01347254           Porting to Secure Wireless
* Aneeket Patkar    06/15/2010           CCMPD01361228           USART "putchar" function fix
* Aneeket Patkar    05/14/2010           CCMPD01347254           Porting to Secure Wireless
* Abhishek Trivedi  05/14/2010           CCMPD01346767           XNL Initialization
* Abhishek Trivedi  05/18/2010           CCMPD01349944           PTT_RESEND
* PeiSee Toh        07/07/2010                                   Wireless R1.2 Initial Draft
* Sevuhan Ramanathan09/03/2010           CCMPD01388942           Added PTT_LONG_PRESS_TIME,DONGLE_OFF_STATE
* Sevuhan Ramanathan09/03/2010           CCMPD01386213           Added LED_PWR_FAILED
* Sevuhan Ramanathan10/06/2010           CCMPD01397694           added wireless_ptt_handler prototype
* Sevuhan Ramanathan10/27/2010           CCMPD01407547           Added ONE_MINUTE definition and removed LED_PWR_FAILED definition 
* Sevuhan Ramanathan10/30/2010           CCMPD01408045           added  wirelessR1_3ptt_handler and  wirelessR1_4ptt_handler
* YK - JWPM67       Nov/15/2010          CCMPD01413200           Added Constant definition for Audio Route Switch (Dongle R2.1).
* SevuhanRamanathan 02/12/2010           CCMPD01472726           Added definition for AUDIO_ROUTE_SWITCH_DEBOUNCE
* Sevuhan Ramanathan04/01/2012           CCMPD01600891           added defn for HOOK_PIN_DEBOUNCE_TIME
* WRN637            09/17/2013           CCMPD01815073           Add Button handling for R2.17 Wireless Gateway P0B board
* wrn637            10/16/2013           CCMPD01826478           Audio detection handling
* Abhishek Trivedi  03/10/2014           CCMPD01870625           CSR DSP Audio Detect Integration Changes
* Abhishek Trivedi  10/22/2014           CCMPD01938895           Audio Switch
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

#include "config.h"
//#include "nibbler.h"

/*==============================================================================
                                TYPE DEFINITIONS
==============================================================================*/



/*==============================================================================
                                CONSTANTS
==============================================================================*/
// This is the priority level of the buttons

// Timer for Debounce
#define PTT_DEBOUNCE_TC_CHANNEL     0     //Channel 0 also used by configTICK_TC_CHANNEL(disabled), RTCTask.h (disabled)
#define DEBOUNCE_TC_HANDLE          ((avr32_tc_t*)AVR32_TC_ADDRESS)
#define DEBOUNCE_TC_IRQ             AVR32_TC_IRQ0
#define DEBOUNCE_MS_COUNT           500
#define PTT_RESEND_100MS_COUNT      50000
#define PTT_LONG_PRESS_TIME         3000 

#define PTT_RESEND_TIME_MS          100
#define PTT_BUTTON_DEBOUNCE         7
#define AUDIO_ROUTE_SWITCH_DEBOUNCE 3
#define HOOK_PIN_DEBOUNCE_TIME      3

/*********** Audio Route Switch in R2.1 *****CCMPD01413200******/
#define AUDIO_ROUTE_SWITCH_HAS_SELECTED_RADIO   HIGH       /* Switch level High: audio source is radio's */
#define AUDIO_ROUTE_SWITCH_HAS_SELECTED_DONGLE  LOW        /* Switch level Low: audio source is accessory's */
  
#define AUDIO_ROUTE_SWITCH_MAX_VERIFY_COUNT   3  /*  Verification counts for Audio Route switch level */
#define AUDIO_ROUTE_SWITCH_RESET_VERIFY_COUNT   0  



// UART SPEED
#define UART_CONFIGURE_9600_BPS     9600
#define UART_CONFIGURE_19200_BPS    19200
#define UART_CONFIGURE_38400_BPS    38400
#define UART_CONFIGURE_57600_BPS    57600
#define UART_CONFIGURE_115200_BPS   115200
/* Message IDs */

#define ONE_MINUTE                    60000  
#define DONGLE_OFF_STATE              12

#define ENTER_CRITICAL              enter_critical2()
#define EXIT_CRITICAL               exit_critical2(x)

#define PTT_BTN_DEBOUNCE_COUNTER        3
#define AUDIO_DET_DEBOUNCE_COUNTER      3
#define BTN_DEBOUNCE_COUNTER            3

#define LOCAL_MIC_SPKR true
#define REMOTE_MIC_SPKR false
/*==============================================================================
                                ENUMS / STRUCTS
==============================================================================*/
// States for buttons
typedef enum 
{
  PRESSED   =   0,
  RELEASED  =   1,
  DEBOUNCED =   2
} controls_button_state_t;


#define  AUDIO_NOTDETECTED     PRESSED
#define  AUDIO_DETECTED        RELEASED



// The list of the buttons available
typedef enum controls_button_list
{
  
  NUMBER_OF_BUTTONS =  4
} controls_button_list_t;

typedef enum headset_button_id_state
{

  DEFAULT_BUTTON                     =4
} headset_button_id_state_t;
/*
typedef enum button_timers_id_list
{
  POWER_BUTTON_TIMER  =   0,
  PTT_BUTTON_TIMER    =   1,
  VOLUME_UP_TIMER     =   2,
  VOLUME_DOWN_TIMER   =   3,
  MAX_BUTTON_TIMERS   =   4
} button_timers_id_list_t;

// The button control structure
typedef struct
{
  controls_button_list_t      button_type;
  button_timers_id_list_t     button_id;
  UINT                        gpio_button_offset;
  controls_button_state_t     button_state;
  UCHAR                       button_debounce;
} controls_t;
*/


typedef controls_button_state_t controls_button_state;

typedef enum {
       PTT_BUTTON  = 0,
       AUDIO_DET,
       ONE_DOT,
       TWO_DOT,
       CSR_DSP_AUD_DET,
       MAX_NUM_BTN
} GatewayButtonIds;

typedef enum 
{
  INTERRUPT_BASE,
  POLLING_BASE
}button_detection_t;

/*button structure*/
typedef struct
{
  UINT8_T                 button_pin_no;        //atmel pin number
  controls_button_state_t Button_Detect_State;
  controls_button_state_t Prev_Button_State;
  UINT8_T                 Debounce_Counter;     // debounce counter for each button 
  UINT8_T                 Active_Msg;           // Intertask message for Button Active
  UINT8_T                 Inactive_Msg;         // Intertask message for Button InActive
  button_detection_t      button_detection;     // to indicate handling for the button
}buttons_pin_t;



//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: controls_init

	DESCRIPTION: Initialize the buttons and audio path 
                     
	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE:
==============================================================================*/
void controls_init(void);

/*=============================================================================
	FUNCTION: gpio_group0_controls_isr

	DESCRIPTION: Initialize the buttons and audio path ISR

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE:
==============================================================================*/
void gpio_group0_controls_isr( void );


/*=============================================================================
	FUNCTION: BT_usart_putchar

	DESCRIPTION: This function will put the specified byte on BC05_UART_PORT
                     
	ARGUMENTS PASSED: byte to be tx.

	REFERENCE ARGUMENTS PASSED: none.

	RETURN VALUE: TRUE - none
==============================================================================*/
void BT_usart_putchar(unsigned char c);


/*=============================================================================
	FUNCTION: wirelessR1_3ptt_handler(bool R1_3PttPressed)

	DESCRIPTION:This function is for nibbler decoder task to call for notifying radio 
                    on wireless R1.3 ptt press/release
                     
	ARGUMENTS PASSED:bool R1_3PttPressed
                         
	REFERENCE ARGUMENTS PASSED: 

	RETURN VALUE: 
==============================================================================*/
void wirelessR1_3ptt_handler(bool R1_3PttPressed);


/*=============================================================================
	FUNCTION: wirelessR1_4ptt_handler(bool R1_4PttPressed)

	DESCRIPTION:This function is for nibbler decoder task to call for notifying radio 
                    on wireless R1.4 ptt press/release
                     
	ARGUMENTS PASSED:bool R1_4PttPressed
                         
	REFERENCE ARGUMENTS PASSED: 

	RETURN VALUE: 
==============================================================================*/
void wirelessR1_4ptt_handler(bool R1_4PttPressed);

void select_mic_spkr(bool local);
#endif

