#ifndef _DEBUG_MANAGER_H_
#define _DEBUG_MANAGER_H_

/*################################################################################
#

#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: debug_manager.h
#
# --------------------------- General Description -----------------------------
# This file contains the declarations of the Debug Manager.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/


/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR      Date Modified Tracking Number     Description
* Phong Tran  03/18/2010    CCMPD01316656       Initial Creation
* Phong Tran  06/14/2010    CCMPD01355429       Added send_mpp_str and send_mpp_byte
* Tan Seng Kai10/06/2010    CCMPD01399559       RADIO_INTERFACE_MANAGER_TASK,MPP_TASK,NIBBLER_TASK Compile sw 
*                                               added to remove Radio interface and mpp task
* WRN637      20/12/2013    CCMPD01833277       WPTT state machine
*
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/*===============================================================================================
                                      DEFINES
================================================================================================*/
#define INTEGRATION_TESTx

#ifdef INTEGRATION_TEST
#define DISPLAY_STATE_TRANSITION_DEBUG
#define DISPLAY_DATABASE_HANDLING_DEBUG
#endif

/*====================================================================================================
                                    ENUMS & STRUCTURES
==================================================================================================*/

typedef enum priority_level
{
    PRIORITY_LOW = 0,
    PRIORITY_MEDIUM = 1,
    PRIORITY_HIGH = 2
} priority_level_t;

/*=====================================================================================
                                      FUNCTION PROTOYPES
======================================================================================*/
/*=============================================================================
	FUNCTION: send_debug_info

	DESCRIPTION: This function is provided to send any debug message from
                     any component.

	ARGUMENTS PASSED: function_name - the name of the function
                          debug_str - the debug string
                          timestamp - the time stamp
                          priority - the priority level

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void send_debug_info(char *function_name, INT8_T *debug_str, INT8_T *timestamp, priority_level_t priority);


#ifdef MPP_TASK
/*=============================================================================
	FUNCTION: send_mpp_str

	DESCRIPTION: This function is provided to send any debug message from
                     mpp component.

	ARGUMENTS PASSED: function_name - the name of the function
                          debug_str - the debug string
                          timestamp - the time stamp
                          priority - the priority level

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void send_mpp_str(char *function_name, INT8_T *debug_str, INT8_T *timestamp, priority_level_t priority);

/*=============================================================================
	FUNCTION: send_mpp_byte

	DESCRIPTION: This function is provided to send any debug byte to the PC.

	ARGUMENTS PASSED: debug_byte - the byte to send
                          priority - the priority level

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void send_mpp_byte(UINT8_T debug_byte, priority_level_t priority);
#endif

/*=============================================================================
	FUNCTION: get_time_stamp

	DESCRIPTION: This function returns the timestamp when the debug message
                     is sent.
	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: timestamp - the global variable in this module
==============================================================================*/
INT8_T * get_time_stamp();

/*=============================================================================
       FUNCTION: send_button_broadcast
       
       DESCRIPTION: Send to broadcast to the PC to report the button state.
       
       ARGUMENTS PASSED:  button_id - the button id
                          state - Pressed or Released
       
       REFERENCE ARGUMENTS PASSED: none
       
       RETURN VALUE: none 
==============================================================================*/  
void send_button_broadcast(UINT8_T chipset, UINT8_T button_id, UINT8_T state);

#endif  // _DEBUG_MANAGER_H_
