#ifndef INIT_H // Insert File name here like "INCLUDE_FILE_NAME_H"
#define INIT_H // Insert File name here like "INCLUDE_FILE_NAME_H"

/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: initialization.h
#
# --------------------------- General Description -----------------------------
# This file contains the function prototypes and 'define' to be used in the Initialization 
# of the  Headset Code .
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	  Description
* Aneeket Patkar    02/03/2010          CCMPD01310299_Atmel_Init  Initial Creation
* JJ Low ckpd36     12/08/2010          CCMPD01440674             To enable/disable USB module
* Sevuhan Ramanathan 04/20/2011         CCMPD01498417             Removed function nitialize_dongle_usb_features
*                                                                 from R2.1 code to suit R2.19   
* Abhishek Trivedi   04/04/2014         CCMPD01880139             Reset on DSP Command failure
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

#include "TypeDef.h"

/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++   */
/*  This Section is to be moved to a file similar to Utilities.h. This section
    contains enum and other defines which need not be product specific. In short,
    the contents of this file can be genric to the Wireless project */


/*  UTILITIES.H SECTION ENDS HERE.                                            */
/*  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++   */


//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
typedef enum
{
	WATCHDOG_RESET = 1,
	BROWNOUT_RESET,
	EXTERNAL_RESET,
	POWERON_RESET,
	SLEEP_RESET,
	CPU_ERR_RESET
}reset_causes;
//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------

/*=============================================================================
	FUNCTION: initialize_system

	DESCRIPTION: This function will be called from "main". The task is to 
                    initialize all components.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void initialize_system(void);

/*=============================================================================
	FUNCTION: configure_atmel_clock

	DESCRIPTION: This function will configure UC3B clock.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void configure_atmel_clock(void);

/*=============================================================================
	FUNCTION: watchdog_enable

	DESCRIPTION: This function will enable Watchdog Timer.

	ARGUMENTS PASSED: time ( in milliseconds )

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void watchdog_enable(int watchdog_period);

/*=============================================================================
	FUNCTION: watchdog_disable

	DESCRIPTION: This function will disable Watchdog Timer.

	ARGUMENTS PASSED: none.

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void watchdog_disable(void);

/*=============================================================================
	FUNCTION: watchdog_reset

	DESCRIPTION: This function will reset Watchdog Timer. This function needs
                     to be called before the Wathdog Timer period to prevent the
                     Watchdog from resetting the device.

	ARGUMENTS PASSED: none.

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void watchdog_reset(void);

/*=============================================================================
	FUNCTION: get_reset_cause

	DESCRIPTION: This function is a wrapper to provide the reason for reset.
                     For UC3B, the reset status can be directly accessed from 
                     the RCAUSE register.
	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: int. Reason for RESET.
==============================================================================*/
int get_reset_cause(void);


/*=============================================================================
	FUNCTION: initialize_dongle_features

	DESCRIPTION: Initialization related to functionality of the headset,
                     rather than to functionality of the processor or the
                     system.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void initialize_dongle_features(void);
/*=============================================================================
	FUNCTION: 

	DESCRIPTION: 

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
//void (void);




#endif