#ifndef _MPP_INIT_H_
#define _MPP_INIT_H_
/*################################################################################
#

#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: mpp_init.h
#
# --------------------------- General Description -----------------------------
# This file contains the declarations realted to mpp module initialization
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/


/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified Tracking Number Description
* Jaspreet Bajwa    01/08/2010    CCMPD           Initial Creation
* JJ Low            11/12/2010    CMPD01412613    R2.1 MPP state machine
* Mahesh.guru       05/01/2011    CCMPD01459957   Change "MPP_TC_MODULE_RA_VALUE" & "MPP_TC_MODULE_RC_VALUE" values for secure wireless
* Mahes             Jan/10/2011   CCMPD01460340   To solve linker issue: Undefined external "send_inter_task_msg"
* Mahesh            30-Dec-2010   CCMPD01414087   use "SEND_MESSAGE_TO_CONNECTION_MNGR()" to replase "MPP_OS_send_inter_task_msg()"
* Mahesh            07-Dec-2011   CCMPD01460638   Added  initial MPP inter task messages
* Tan Seng Kai      07-Jan-2011   CCMPD01460652   Make use of BT_RawLog for debugging
* Mahesh            19-Jan-2011   CCMPD01462971   enable the AMS RX path damper in TX mode and disable on RX mode.
* Tan Seng Kai      02/17/2011    CCMPD01474548   comment out MPP_DEBUG_CRC_TIMEOUT_MSG
* WRN637            11/13/2013    CCMPD01835515   NFC oscillator trim 
* Abhishek Trivedi	03/18/2014	  CCMPD01873731	  Resolve 2 device connection issue
*--------------------------- End of History Template-----------------------------
* *****************************************************************************/

/*==============================================================================
                                      DEFINES
==============================================================================*/
#define ATMEL_AVR32                     // To include AVR specifric files
#define OPEN_RTOS                       // To include OPEN_RTOS implementation files
#define OSAL_USED                       // To inlclude OSAL implementation files

/* to compile code for device*/
//#define MPP_DEVICE
/* to comple code for host*/
#define MPP_HOST


/* just used to include some header file, plan was to make code working directly on OPENRTOS and OSAL*/

/*these defines are to enable board specific ports*/
//#define MPP_EVK1101
//#define MPP_P0_BOARD
//#define MPP_OPTION_BOARD
#define MPP_SECURE_DONGLE

/* free the DB mutex on power down if testing, else its responsibility of the host side product code*/
#define DEL_DB_MUTEX_ON_POWER_DOWN
/* RTOS_TASK_LOOP is defined to enable OPENRTOS specific for(;;) in task it should be undefine is tasks are being used in non OS or some other OS enviornment*/
#define RTOS_TASK_LOOP

/* AMS_RX_PATH_DAMPER can be define to enable the AMS RX path damper in TX mode and disable on RX mode it will increase the range*/
#define AMS_RX_PATH_DAMPER

// AVR specific File Includes
#ifdef ATMEL_AVR32
    #include "board.h"
    #include "gpio.h"
    #include "usart.h"
    #include "pm.h"
    #include "tc.h"
    #include "spi.h"
    #include "eic.h"
#endif

// OPEN RTOS Framework files
#ifdef FREERTOS_USED
    #include "FreeRTOS.h"
    #include "task.h"
    #include "queue.h"
    #include "semphr.h"
/* enable ATMEL driver level semaphores*/

  #define TIMER_RESOLUTION portTICK_RATE_MS

  extern xQueueHandle xRxedChars;
  extern xQueueHandle xCharsForTx;
#else
  #define TIMER_RESOLUTION 1
#endif

// OSAL Implementation files
#ifdef OSAL_USED
#include "TaskConfig.h" // CCMPD01410054 (JJ 8/11/2010)
#include "TypeDef.h"
#include "osal.h"
#endif

#define ZERO_DELAY                          0
#define MAX_DELAY                           0xffffffff
/* debug UART baud rate*/
#define mainCOM_TEST_BAUD_RATE                ( ( unsigned portLONG ) 57600 )

#define comBUFFER_LEN                         40
/* debug queues*/

#define MPP_DEBUG_TX_QUEUE  xCharsForTx
#define MPP_DEBUG_RX_QUEUE  xRxedChars

extern UNSIGNED_8BIT mpp_debug_enable;
extern SIGNED_8BIT mpp_time_to_pair;
extern  xSemaphoreHandle sems[];


#define MPP_PASS 1
#define MPP_FAIL 0
#define MPP_TIME_OUT 2

#define WHITENING_BYTE        0x55
#define NO_WHITENING          0x00
#define MPP_ACK_TO_HOST_BYTE  0x7D

#ifndef MPP_SECURE_DONGLE
/* debug fucntion abstraction any platform can use its own fucntions*/
#define MPP_PUT_DEBUG_BYTE(data)              mpp_put_debug_byte((data))
#define MPP_PUT_DEBUG_STRING(string)          mpp_put_debug_string((string))
#else
extern void BT_RawLog(const char *format, ... );

#define MPP_PUT_DEBUG_BYTE(data)              BT_RawLog("%.2x", data)
#define MPP_PUT_DEBUG_STRING(string)          BT_RawLog(string)
#endif

/* For Debug messages on Bad CRC and Timeouts */
//#define MPP_DEBUG_CRC_TIMEOUT_MSG

typedef enum{
SPI_MODE_16_BIT,
SPI_MODE_8_BIT,
SPI_MODE_AMS_TRIM_OSC,
SPI_MODE_POWER_DOWN,
MPP_SPI_MODES
}spi_mode;

#define SHIFT_BY_EIGHT 8


/* AMS HAL */
#define HAL_MPP_READ_BYTE_SERIAL_PORT(data,delay, whitening)       mpp_read_byte_from_serialport((data), (delay), (whitening))
#define HAL_MPP_WRITE_BYTE_SERIAL_PORT(dataout, whitening)         mpp_write_byte_to_serialport((dataout), (whitening))
#define HAL_MPP_SPI_INIT_MODE_16_BIT                    mpp_spi_16bit_mode()  //mpp_spi_init(SPI_FOR_AMS_CHIP, SPI_MODE_16_BIT)
#define HAL_MPP_SPI_INIT_MODE_8_BIT                     mpp_spi_8bit_mode()   //mpp_spi_init(SPI_FOR_AMS_CHIP, SPI_MODE_8_BIT)
#define HAL_MPP_SPI_INIT_MODE_TRIM_OSC                  mpp_spi_init(SPI_FOR_AMS_CHIP, SPI_MODE_AMS_TRIM_OSC)
#define HAL_MPP_SPI_INIT_MODE_POWER_DWN                 mpp_spi_init(SPI_FOR_AMS_CHIP, SPI_MODE_POWER_DOWN)
#define HAL_MPP_SPI_SELECT_CHIP                         spi_selectChip(SPI_FOR_AMS_CHIP, MPP_SPI_CHANNEL)
#define HAL_MPP_SPI_UNSELECT_CHIP                       spi_unselectChip(SPI_FOR_AMS_CHIP, MPP_SPI_CHANNEL)
#define HAL_MPP_TX_CLK_START                            tc_start(MPP_TC_HANDLE, MPP_TC_CHANNEL);
#define HAL_MPP_TX_CLK_STOP                             tc_stop(MPP_TC_HANDLE, MPP_TC_CHANNEL);
#define HAL_SPI_WRITE(data)                             spi_write(SPI_FOR_AMS_CHIP, (data))
#define HAL_SPI_READ(data)                              spi_read(SPI_FOR_AMS_CHIP, (data))
#define HAL_MPP_SPI_SET_LAST_TX                         {SPI_FOR_AMS_CHIP->cr = AVR32_SPI_CR_LASTXFER_MASK;}
#define HAL_MPP_UART_RX_DIS                                                       {MPP_UART_PORT->cr |= AVR32_USART_CR_RXDIS_MASK;}
#define HAL_MPP_UART_RX_RESET                                                     {MPP_UART_PORT->cr |= AVR32_USART_CR_RSTRX_MASK;}
#define HAL_MPP_UART_TX_DIS                                                       {MPP_UART_PORT->cr |= AVR32_USART_CR_TXDIS_MASK;}
#define HAL_MPP_UART_RX_INT_EN                                                    {MPP_UART_PORT->ier = AVR32_USART_IER_RXRDY_MASK;}
#define HAL_MPP_UART_TX_EN                                                        {MPP_UART_PORT->cr |= AVR32_USART_CR_TXEN_MASK;}

/*OS fucntions not used in core code*/
#define MPP_OS_QueueReceive(handle,data,delay)                                    xQueueReceive((handle), (data), (delay))
#define MPP_OS_QueueSend(handle,data,delay)                                       xQueueSend((handle), (data), (delay))
#define MPP_OS_QueueCreate(handle,size)                                           xQueueCreate((handle), (size))



/* extension functions not supported by OSAL directly taken from OPENRTOS */
#define MPP_OS_SemaphoreGiveFromISR(sem_num, HigherPriorityTaskWoken)             xSemaphoreGiveFromISR((sem_num), (HigherPriorityTaskWoken))
#define MPP_OS_QueueDelete(handle)                                                vQueueDelete((handle))
#define MPP_OS_ENTER_SWITCHING_ISR                                                portENTER_SWITCHING_ISR()
#define MPP_OS_EXIT_SWITCHING_ISR                                                 portEXIT_SWITCHING_ISR()

/* OSAL implemented inside those functions*/

#ifndef MPP_SECURE_DONGLE   /* use "SEND_MESSAGE_TO_CONNECTION_MNGR()" to replase "MPP_OS_send_inter_task_msg()"*/ //CCMPD01460340(GM_Jan/10/2011)
#define MPP_OS_send_inter_task_msg(taskId, msgid, ptr2message, message_size, op_code)      send_inter_task_msg((taskId),(msgid),(ptr2message), (message_size), (op_code))
#endif
#define MPP_OS_get_inter_task_msg(msgid, ptr2message, message_size, delay)                 get_inter_task_msg((msgid),(ptr2message), (message_size),(delay))
extern UNSIGNED_8BIT get_inter_task_msg(UNSIGNED_8BIT *msgid, void **ptr2message, UNSIGNED_16BIT *message_size, UNSIGNED_32BIT_LONG delay ); //CCMPD01414087 (GM_30Dec2010)

/* replace with osal calls*/
#define MPP_SEM_TAKEN                                                             SEM_RET_SUCCESS
#define MPP_SYSTEM_DELAY                                                          Delay
#define MPP_ENTER_CRITICAL                                                        enter_critical2()
#define MPP_EXIT_CRITICAL                                                         exit_critical2(0) // as this value is not being used so made it zero
#define MPP_OS_Get_Task_Id(task)                                                  Get_Task_Id((task))
#define MPP_OS_SemaphoreTake(sem_num,delay)                                       capture_time_semaphore((sem_num), (delay)) //xSemaphoreTake((handle), (delay))
#define MPP_OS_SemaphoreGive(sem_num)                                             release_semaphore((sem_num)) //xSemaphoreGive((handle))

#define MPP_OS_free_mem(ptr)                                                      Free_Buf((ptr))
#define MPP_OS_SemaphoreCreateMutex(sem_num)                                      semaphore_init((sem_num), MUTEX, NULL) //xSemaphoreCreateMutex()
#define MPP_OS_SemaphoreCreateBinary(sem_num)                                     semaphore_init((sem_num), BINARY, NULL) //vSemaphoreCreateBinary((handle))
#define MPP_CONNECTION_DB_MUTEX                                                   SEM_SHARE_DB
#define MPP_CONNECTION_DB_MUTEX_HANDLE                                            sems[MPP_CONNECTION_DB_MUTEX]
#define MPP_SERIAL_PORT_EVENT_HANDLE                                              sems[mpp_sem_serial_port_event]

//#############################################################################




#define MPP_SPI_RUN_TIME_BAUD_RATE                  960000
#define MPP_SPI_AMS_OSC_TRIM_BAUD_RATE              32768
#define MPP_GPIO  AVR32_GPIO

#define PIN_FUNCTION_A                              0
#define PIN_FUNCTION_B                              1
#define PIN_FUNCTION_C                              2

#define MPP_SYS_PM                                      &AVR32_PM

/* BEGIN defines specific to Project */
/****************************** MPP_SECURE_DONGLE *****************************/
#if defined(MPP_SECURE_DONGLE)

//#define MPP_DEBUG
#define MPP_CONNECTION_MGR                          CONNECTION_MANAGER
#define MPP_FOSC0                                   DONGLE_FOSC0_CLK    // CCMPD01412613 (JJ 12/11/2010)
#define PBA_enable                                  1
#define PBA_divisor                                 2
#define PBB_enable                                  1
#define PBB_divisor                                 2
#define HSB_enable                                  1
#define HSB_divisor                                 2

#define PBA_disable                                 0
#define PBB_disable                                 0
#define HSB_disable                                 0
#define MPP_AVR32_PM                                (*((volatile avr32_pm_t*)AVR32_PM_ADDRESS))
#define HAL_PM_CKSEL_DIV                            {}
#define HAL_PM_CKSEL_ORI                            {}
#define SPI_FOR_AMS_CHIP                            ((avr32_spi_t*)AVR32_SPI_ADDRESS)

//GPIO MAPPING
#define MPP_SPI_NPCS_GPIO_PIN                       16              //PA16
#define MPP_SPI_NPCS_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_SPI_MISO_GPIO_PIN                       25              //PA25
#define MPP_SPI_MISO_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_SPI_SCK_GPIO_PIN                        17              //PA17
#define MPP_SPI_SCK_GPIO_PIN_FUNCTION               PIN_FUNCTION_C
#define MPP_SPI_MOSI_GPIO_PIN                       14              //PA14
#define MPP_SPI_MOSI_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_USART_RXD_GPIO_PIN                      PB10
#define MPP_USART_RXD_GPIO_PIN_FUNCTION             PIN_FUNCTION_C
#define MPP_USART_TXD_GPIO_PIN                      PB11
#define MPP_USART_TXD_GPIO_PIN_FUNCTION             PIN_FUNCTION_C
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN               21              //PA21
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN_FUNCTION      PIN_FUNCTION_B
#define MPP_WAKEUP_IRQ                              AVR32_GPIO_IRQ_1
#define MPP_WAKEUP_IRQ_LEVEL                        AVR32_INTC_INT1
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN               12                  //PA12
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN_FUNCTION      PIN_GPIO_FUNCTION
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN_MASK          0x1000
#define MPP_PORT_USART_IRQ                          AVR32_USART0_IRQ    //192 IRQ GP# 6
#define MPP_PBA_CLOCK_HZ                            config_DONGLE_PBA_CLOCK_HZ

#ifdef MPP_DEBUG
#define MPP_DEBUG_USART_RXD_GPIO_PIN                42              //PB10
#define MPP_DEBUG_USART_RXD_GPIO_PIN_FUNCTION       PIN_FUNCTION_C
#define MPP_DEBUG_USART_TXD_GPIO_PIN                43              //PB11
#define MPP_DEBUG_USART_TXD_GPIO_PIN_FUNCTION       PIN_FUNCTION_C
#define MPP_DEBUG_PORT_USART_IRQ                    AVR32_USART0_IRQ    //192 IRQ GP# 6
#endif

#define MPP_SPI_CHANNEL                             0

// UART Port Address Mapping
#define MPP_UART_PORT                               ((avr32_usart_t*)AVR32_USART0_ADDRESS)
//#define MPP_DEBUG_UART_PORT                         ((avr32_usart_t*)AVR32_USART0_ADDRESS)

// Timer Counter Module
//#define MPP_TC_MODULE_RA_VALUE                      48          //( (System_clk/2) /RC value in waveform mode)
//#define MPP_TC_MODULE_RC_VALUE                      96          // ((24 MHz /2 )/192) = 125 KHz
#define MPP_TC_MODULE_RA_VALUE                      32          //( (System_clk/2) /RC value in waveform mode) - MAHESH - CCMPD01459957
#define MPP_TC_MODULE_RC_VALUE                      64          // ((4 MHz /2 )/16) = 125 KHz  ( follow R1.2 )
#define HAL_MPP_ENABLE_WAKEUP_INT                   gpio_enable_pin_interrupt(MPP_WAKEUP_INTERRUPT_GPIO_PIN, GPIO_RISING_EDGE)
#define HAL_MPP_DISABLE_WAKEUP_INT                  gpio_disable_pin_interrupt(MPP_WAKEUP_INTERRUPT_GPIO_PIN)
#define MPP_TC_CHANNEL                              1
#define MPP_TC_HANDLE                               ((avr32_tc_t*)AVR32_TC_ADDRESS)

/****************************** MPP_OPTION_BOARD *****************************/
#elif defined(MPP_OPTION_BOARD)

#define MPP_CONNECTION_MGR                          GENERIC_CONNECTION_MANAGER_ID
#define MPP_FOSC0                                   12000000
#define PBA_enable                                  1
#define PBA_divisor                                 2
#define PBB_enable                                  1
#define PBB_divisor                                 2
#define HSB_enable                                  1
#define HSB_divisor                                 2

#define PBA_disable                                 0
#define PBB_disable                                 0
#define HSB_disable                                 0
#define MPP_AVR32_PM                           (*((volatile avr32_pm_t*)0xFFFF0C00))
#define HAL_PM_CKSEL_DIV                      pm_cksel(&MPP_AVR32_PM, PBA_enable, PBA_divisor,PBB_enable, PBB_divisor, HSB_enable, HSB_divisor)
#define HAL_PM_CKSEL_ORI                      pm_cksel(&MPP_AVR32_PM, PBA_disable, PBA_disable,PBB_disable, PBB_disable, HSB_disable, HSB_disable)
#define SPI_FOR_AMS_CHIP                      ((avr32_spi_t*)0xFFFF2400)

//GPIO MAPPING
#define MPP_SPI_NPCS_GPIO_PIN                       10   //PA10
#define MPP_SPI_NPCS_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_SPI_MISO_GPIO_PIN                       11   //PA11
#define MPP_SPI_MISO_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_SPI_SCK_GPIO_PIN                        13   //PA13
#define MPP_SPI_SCK_GPIO_PIN_FUNCTION               PIN_FUNCTION_A
#define MPP_SPI_MOSI_GPIO_PIN                       12   //PA12
#define MPP_SPI_MOSI_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_USART_RXD_GPIO_PIN                      5   //PA05
#define MPP_USART_RXD_GPIO_PIN_FUNCTION             PIN_FUNCTION_A
#define MPP_USART_TXD_GPIO_PIN                      6   //PA06
#define MPP_USART_TXD_GPIO_PIN_FUNCTION             PIN_FUNCTION_A
#define MPP_DEBUG_USART_RXD_GPIO_PIN                61   //PB29
#define MPP_DEBUG_USART_RXD_GPIO_PIN_FUNCTION       PIN_FUNCTION_A
#define MPP_DEBUG_USART_TXD_GPIO_PIN                62   //PB30
#define MPP_DEBUG_USART_TXD_GPIO_PIN_FUNCTION       PIN_FUNCTION_A
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN               57   //PB25
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN_FUNCTION      PIN_FUNCTION_A

#define MPP_WAKEUP_IRQ                              66 //AVR32_GPIO_IRQ_2
#define MPP_WAKEUP_IRQ_LEVEL                        0x00000002
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN               22 //AVR32_EIC_EXTINT_1_PIN
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN_MASK          0x400000

#define MPP_PORT_USART_IRQ                          192 // AVR32_USART1_IRQ    //192 IRQ GP# 7
#define MPP_DEBUG_PORT_USART_IRQ                    160 //  AVR32_USART0_IRQ    //160 IRQ GP# 5
#define MPP_PBA_CLOCK_HZ                            24000000           // 48 MHz

#define MPP_SPI_CHANNEL                             2

// UART Port Address Mapping
#define MPP_UART_PORT                               ((avr32_usart_t*)0xFFFF1800)
#define MPP_DEBUG_UART_PORT                         ((avr32_usart_t*)0xFFFF1400)

// Timer Counter Module
#define MPP_TC_MODULE_RA_VALUE                      48          //( (System_clk/2) /RC value in waveform mode)
#define MPP_TC_MODULE_RC_VALUE                      96          // ((24 MHz /2 )/192) = 125 KHz
#define HAL_MPP_ENABLE_WAKEUP_INT                   gpio_enable_pin_interrupt(MPP_WAKEUP_INTERRUPT_GPIO_PIN, GPIO_RISING_EDGE)
#define HAL_MPP_DISABLE_WAKEUP_INT                  gpio_disable_pin_interrupt(MPP_WAKEUP_INTERRUPT_GPIO_PIN)
#define MPP_TC_CHANNEL                              1
#define MPP_TC_HANDLE                               ((avr32_tc_t*)0xFFFF3800)

/******************************** MPP_EVK1101 *********************************/
#elif defined(MPP_EVK1101)

/* enable debug message printing*/
#define MPP_DEBUG
#define MPP_CONNECTION_MGR                          MPP_EXAMPLE_CONNECTION_MGR
#define MPP_FOSC0           12000000
#define PBA_enable                                  1
#define PBA_divisor                                 0
#define PBB_enable                                  1
#define PBB_divisor                                 0
#define HSB_enable                                  1
#define HSB_divisor                                 0
#define PBA_disable                                 0
#define PBB_disable                                 0
#define HSB_disable                                 0
#define HAL_PM_CKSEL_DIV                      pm_cksel(&AVR32_PM, PBA_enable, PBA_divisor,PBB_enable, PBB_divisor, HSB_enable, HSB_divisor)
#define HAL_PM_CKSEL_ORI                      pm_cksel(&AVR32_PM, PBA_disable, PBA_divisor,PBB_disable, PBB_divisor, HSB_disable, HSB_divisor)
#define SPI_FOR_AMS_CHIP                      ((avr32_spi_t*)AVR32_SPI_ADDRESS)
//GPIO MAPPING
#define MPP_SPI_NPCS_GPIO_PIN                       AVR32_SPI_NPCS_2_0_PIN
#define MPP_SPI_NPCS_GPIO_PIN_FUNCTION              AVR32_SPI_NPCS_2_0_FUNCTION
//#define MPP_SPI_MISO_GPIO_PIN                       AVR32_SPI_MISO_0_0_PIN
//#define MPP_SPI_MISO_GPIO_PIN_FUNCTION              AVR32_SPI_MISO_0_0_FUNCTION
//#define MPP_SPI_SCK_GPIO_PIN                        AVR32_SPI_SCK_0_0_PIN
//#define MPP_SPI_SCK_GPIO_PIN_FUNCTION               AVR32_SPI_SCK_0_0_FUNCTION
//#define MPP_SPI_MOSI_GPIO_PIN                       AVR32_SPI_MOSI_0_0_PIN
//#define MPP_SPI_MOSI_GPIO_PIN_FUNCTION              AVR32_SPI_MOSI_0_0_FUNCTION

#define MPP_USART_RXD_GPIO_PIN                      AVR32_USART0_RXD_0_1_PIN
#define MPP_USART_RXD_GPIO_PIN_FUNCTION             AVR32_USART0_RXD_0_1_FUNCTION
#define MPP_USART_TXD_GPIO_PIN                      AVR32_USART0_TXD_0_1_PIN
#define MPP_USART_TXD_GPIO_PIN_FUNCTION             AVR32_USART0_TXD_0_1_FUNCTION

//#define MPP_DEBUG_USART_RXD_GPIO_PIN                AVR32_USART1_RXD_0_0_PIN
//#define MPP_DEBUG_USART_RXD_GPIO_PIN_FUNCTION       AVR32_USART1_RXD_0_0_FUNCTION
//#define MPP_DEBUG_USART_TXD_GPIO_PIN                AVR32_USART1_TXD_0_0_PIN
//#define MPP_DEBUG_USART_TXD_GPIO_PIN_FUNCTION       AVR32_USART1_TXD_0_0_FUNCTION

#define MPP_125KHz_CLOCK_OUT_GPIO_PIN               AVR32_TC_B1_0_1_PIN
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN_FUNCTION      AVR32_TC_B1_0_1_FUNCTION

//#define MPP_WAKEUP_IRQ                              AVR32_GPIO_IRQ_1
#define MPP_WAKEUP_IRQ_LEVEL                        AVR32_INTC_INT2
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN               AVR32_PIN_PA10


//#define MPP_PORT_USART_IRQ                          AVR32_USART0_IRQ    //160 IRQ GP# 5
//#define MPP_DEBUG_PORT_USART_IRQ                    AVR32_USART1_IRQ    //192 IRQ GP# 6
#define MPP_PBA_CLOCK_HZ                            12000000           // 12 MHz

//#define MPP_SPI_CHANNEL                             2

// UART Port Address Mapping
//#define MPP_UART_PORT                               ((avr32_usart_t*)AVR32_USART0_ADDRESS)
//#define MPP_DEBUG_UART_PORT                         ((avr32_usart_t*)AVR32_USART1_ADDRESS)

// Timer Counter Module
#define MPP_TC_MODULE_RB_VALUE                      24          //( (System_clk/2) /RC value in waveform mode)
#define MPP_TC_MODULE_RC_VALUE                      48          // ((12 MHz /2 )/48) = 125 KHz
#define HAL_MPP_ENABLE_WAKEUP_INT                                                 gpio_enable_pin_interrupt(AVR32_PIN_PA10, GPIO_RISING_EDGE)
#define HAL_MPP_DISABLE_WAKEUP_INT                                                gpio_disable_pin_interrupt(AVR32_PIN_PA10)

#define MPP_TC_CHANNEL                          1
#define MPP_TC_HANDLE                           ((avr32_tc_t*)AVR32_TC_ADDRESS)

/******************************** MPP_PO_BOARD ********************************/
#elif defined(MPP_P0_BOARD)

/* enable debug message printing*/
#define MPP_DEBUG
#define MPP_CONNECTION_MGR                      MPP_EXAMPLE_CONNECTION_MGR
#define MPP_FOSC0 16000000 //!< Osc0 frequency: Hz.

// Clock Configuration defines . 'Ported' from ams3930_driver.h. With authorized permission from Jaspreet.
#define PBA_DIV     1 // Enable clk divide.
#define PBA_SEL     1 // Divide main clock by 4.
#define PBB_DIV     1 // Enable clk divide.
#define PBB_SEL     1 // Divide main clock by 4.
#define CLK_HSB_DIV 1 // Enable clk divide.
#define CLK_HSB_SEL 1 // Divide main clock by 4.
// PBA config. Used by MPP UART.

//  Function Selection defines for GPIO
#define HAL_PM_CKSEL_DIV                      {}
#define HAL_PM_CKSEL_ORI                      {}
#define SPI_FOR_AMS_CHIP                      ((avr32_spi_t*)AVR32_SPI_ADDRESS)

//GPIO MAPPING
#define MPP_SPI_NPCS_GPIO_PIN                       16   //PA16
#define MPP_SPI_NPCS_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_SPI_MISO_GPIO_PIN                       25   //PA25
#define MPP_SPI_MISO_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_SPI_SCK_GPIO_PIN                        17   //PA17
#define MPP_SPI_SCK_GPIO_PIN_FUNCTION               PIN_FUNCTION_C
#define MPP_SPI_MOSI_GPIO_PIN                       14   //PA14
#define MPP_SPI_MOSI_GPIO_PIN_FUNCTION              PIN_FUNCTION_A
#define MPP_USART_RXD_GPIO_PIN                      24   //PA24
#define MPP_USART_RXD_GPIO_PIN_FUNCTION             PIN_FUNCTION_A
#define MPP_USART_TXD_GPIO_PIN                      23   //PA23
#define MPP_USART_TXD_GPIO_PIN_FUNCTION             PIN_FUNCTION_A
#define MPP_DEBUG_USART_RXD_GPIO_PIN                42   //PB10
#define MPP_DEBUG_USART_RXD_GPIO_PIN_FUNCTION       PIN_FUNCTION_C
#define MPP_DEBUG_USART_TXD_GPIO_PIN                43   //PB11
#define MPP_DEBUG_USART_TXD_GPIO_PIN_FUNCTION       PIN_FUNCTION_C
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN               21   //PA21
#define MPP_125KHz_CLOCK_OUT_GPIO_PIN_FUNCTION      PIN_FUNCTION_B

#define MPP_WAKEUP_IRQ                              AVR32_GPIO_IRQ_4
#define MPP_WAKEUP_IRQ_LEVEL                        AVR32_INTC_INT2
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN               36                  //PB04
#define MPP_WAKEUP_INTERRUPT_GPIO_PIN_MASK          16


#define MPP_PORT_USART_IRQ                          AVR32_USART1_IRQ    //224 IRQ GP# 7
#define MPP_DEBUG_PORT_USART_IRQ                    AVR32_USART0_IRQ    //160 IRQ GP# 5

#define MPP_SPI_CHANNEL                             0

#define MPP_PBA_CLOCK_HZ                            4000000           // 4 MHz

// UART Port Address Mapping
#define MPP_UART_PORT                               ((avr32_usart_t*)AVR32_USART1_ADDRESS)
#define MPP_DEBUG_UART_PORT                         ((avr32_usart_t*)AVR32_USART0_ADDRESS)

// Timer Counter Module
#define MPP_TC_MODULE_RA_VALUE                      8           //( (System_clk/2) /RC value in waveform mode)
#define MPP_TC_MODULE_RC_VALUE                      16          // ((4 MHz /2 )/16) = 125 KHz
#define HAL_MPP_ENABLE_WAKEUP_INT                                                 gpio_enable_pin_interrupt(MPP_WAKEUP_INTERRUPT_GPIO_PIN, GPIO_RISING_EDGE)
#define HAL_MPP_DISABLE_WAKEUP_INT                                                gpio_disable_pin_interrupt(MPP_WAKEUP_INTERRUPT_GPIO_PIN)
#define MPP_TC_CHANNEL                          1
#define MPP_TC_HANDLE                           ((avr32_tc_t*)AVR32_TC_ADDRESS)

/* END defines specific to Project */
#endif

/* debug queues are varied based on if debug printing is used or not*/
#ifdef  MPP_DEBUG
#define MPP_DEBUG_QUEUE_TX_LENGTH              200
#define MPP_DEBUG_QUEUE_RX_LENGTH              5
#else
#define MPP_DEBUG_QUEUE_TX_LENGTH              20
#define MPP_DEBUG_QUEUE_RX_LENGTH              5
#endif
/* AMS HAL */
/*==============================================================================
                                    ENUMS & STRUCTURES
==============================================================================*/


/*==============================================================================
                                      FUNCTION PROTOTYPES
==============================================================================*/
/*=============================================================================
	FUNCTION: mpp_hw_tx_clk_init

	DESCRIPTION: Init125 MHZ clock

	ARGUMENTS PASSED:

	REFERENCE ARGUMENTS PASSED:

	RETURN VALUE: none
==============================================================================*/
void mpp_hw_tx_clk_init();
/*=============================================================================
	FUNCTION: HAL_MPP_READ_BYTE_SERIAL_PORT

	DESCRIPTION: Read a byte from Serial port.

	ARGUMENTS PASSED: UNSIGNED_32BIT_LONG

	REFERENCE ARGUMENTS PASSED: UNSIGNED_8BIT *

	RETURN VALUE: none
==============================================================================*/

UNSIGNED_8BIT mpp_read_byte_from_serialport(volatile UNSIGNED_8BIT *data, UNSIGNED_32BIT_LONG delay, UNSIGNED_8BIT whitening);

/*=============================================================================
	FUNCTION: mpp_write_byte_to_serialport

	DESCRIPTION: Write a byte to serial port.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: UNSIGNED_8BIT *

	RETURN VALUE: none
==============================================================================*/
UNSIGNED_8BIT mpp_write_byte_to_serialport(volatile UNSIGNED_8BIT *data, UNSIGNED_8BIT whitening);

/*=============================================================================
	FUNCTION: mpp_wait_tx_complete

	DESCRIPTION: This non-blocking function will implement wait till the
                      entire MPP packet has been transmitted.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_wait_tx_complete();

/*=============================================================================
	FUNCTION: debug_port_isr

	DESCRIPTION:  isr

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: SIGNED_32BIT_LONG
==============================================================================*/
static SIGNED_32BIT_LONG debug_port_isr( void );

/*=============================================================================
	FUNCTION: mpp_serial_port_isr

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: SIGNED_32BIT_LONG
==============================================================================*/
static SIGNED_32BIT_LONG mpp_serial_port_isr( void );

/*=============================================================================
	FUNCTION: debug_uart_isr

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
static void debug_uart_isr( void );

/*=============================================================================
	FUNCTION: mpp_uart_isr

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
static void mpp_uart_isr( void );



/*=============================================================================
	FUNCTION: mpp_debug_comm_create

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_debug_comm_create();

/*=============================================================================
	FUNCTION: mpp_hw_comm_create

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/

void mpp_hw_comm_create();

/*=============================================================================
	FUNCTION: mpp_spi_init

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_spi_init(avr32_spi_t  *spi, spi_mode spi_mode);

/*=============================================================================
	FUNCTION: SPISlaveInit

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void SPISlaveInit( void );

/*=============================================================================
	FUNCTION: mpp_sw_init

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_sw_init(void);

/*=============================================================================
	FUNCTION: mpp_serialport_init

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/

void mpp_serialport_init();

/*=============================================================================
	FUNCTION: mpp_debug_port_init

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/

void mpp_debug_port_init();
/*=============================================================================
	FUNCTION: mpp_wakeup_setup

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/

void mpp_wakeup_setup();

/*=============================================================================
	FUNCTION: mpp_hw_peripherals_init

	DESCRIPTION:

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_hw_peripherals_init(void);

/*=============================================================================
	FUNCTION: mpp_gpio_init

	DESCRIPTION: This function will intialize all the GPIO necessary for the MPP module.
                     GPIO are SPI (4), USART(2), DEBUG_USART(2) and 125KHz Clk(1).
                     Initialization is based on the "gpio_enable_module()" function
                     implementation of AVR framework 1.5.0

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_gpio_init(void);


/*=============================================================================
	FUNCTION: mpp_hw_setup_rx_mode

	DESCRIPTION: Configure MPP hardware for receiving NFC data.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_hw_setup_rx_mode();

/*=============================================================================
	FUNCTION: mpp_hw_setup_tx_mode

	DESCRIPTION: Configure MPP hardware for transmitting NFC data.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_hw_setup_tx_mode();


/*=============================================================================
	FUNCTION: mpp_trigger_tx

	DESCRIPTION: will enable tx init or dma or tx empty int based on implementation

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_trigger_tx();

/*=============================================================================
	FUNCTION: mpp_wait_tx_complete

	DESCRIPTION: This non-blocking function will implement wait till the
                      entire MPP packet has been transmitted.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_wait_tx_complete();

/*=============================================================================
	FUNCTION: mpp_hw_setup_idle_mode

	DESCRIPTION: Configure MPP hardware for idle state.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_hw_setup_idle_mode();

/*=============================================================================
	FUNCTION: mpp_spi_16bit_mode

	DESCRIPTION: Configure MPP 16 bit SPI mode

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_spi_16bit_mode();

/*=============================================================================
	FUNCTION: mpp_spi_8bit_mode

	DESCRIPTION: Configure MPP 8 bit SPI mode

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_spi_8bit_mode();

extern void mpp_wakeup_isr( void );


/*===============================================================================================
                                      DEFINES
================================================================================================*/


#define MILLI_SEC_1                             1/TIMER_RESOLUTION
#define MILLI_SEC_8                             8/TIMER_RESOLUTION
#define MILLI_SEC_10                            10/TIMER_RESOLUTION
#define MILLI_SEC_50                            50/TIMER_RESOLUTION
#define MILLI_SEC_100                           100/TIMER_RESOLUTION
#define MILLI_SEC_500                           500/TIMER_RESOLUTION
#define MILLI_SEC_1000                          1000/TIMER_RESOLUTION
#define MILLI_SEC_2000                          2000/TIMER_RESOLUTION

#define DELAY_AFTER_PATTERN                     0
#define DB_MUTEX_WAIT_TIME                      MILLI_SEC_50

/*
#define MPP_T1_TIME
#define MPP_T2_TIME
#define MPP_T3_TIME
#define MPP_T4_TIME
*/
/* MPP T1 T2 T3 T4 times will be derived from formula e.g T4 = MPP_WAIT_FOR_FIRST_BYTE + (MPP_UART_INTER_BYTE_DELAY x NUMBER OF BYTES EXPECTED IN PACKET)*/
#define MPP_WAIT_FOR_FIRST_BYTE             60/TIMER_RESOLUTION
#define MPP_WAIT_FOR_BEACON_BYTE            150/TIMER_RESOLUTION
#define MPP_UART_INTER_BYTE_DELAY           20/TIMER_RESOLUTION

#include "mpp_msg.h"

#ifdef MPP_HOST
extern connection_database             *ptr2connection_database;
extern host_succ_mpp                   host_paired_succ;
extern connection_database             host_connection_db;
extern init_host_mpp_pkt               *ptr2init_host_mpp_pkt;
extern init_host_mpp_pkt               host_pkt;
extern host_reject_mpp                 host_pairing_reject;
extern mpp_beacon                      beacon_brdcast;
extern UNSIGNED_8BIT                   rfcomm_taken[NUM_MAX_MPP_RFCOMM_CH];
extern host_mpp_config                 run_time_config;
#endif

#ifdef MPP_DEVICE
extern init_device_mpp_pkt            device_pkt;
extern device_succ_mpp                device_succ_msg;
extern device_reject_mpp              device_pairing_reject;
extern init_device_mpp_pkt            *ptr2init_device_mpp_pkt;
#endif
/*====================================================================================================
                                    ENUMS & STRUCTURES
==================================================================================================*/

#endif
