#ifndef MPP_MSG_H
#define MPP_MSG_H
/*################################################################################
#

#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: mpp_msg.h
#
# --------------------------- General Description -----------------------------
# This file contains the declarations of mpp message structures
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "mpp_init.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified Tracking Number Description
* Jaspreet Bajwa    01/08/2010    CCMPD           Initial Creation
* WRN637            07/11/2013    CCMPD01825398   MPP Class 1 RFPA handling
*
* Abhishek Trivedi  10/24/2014    CCMPD01941655   Audio Switch Redesign
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/*===============================================================================================
                                      DEFINES
================================================================================================*/

#define MPP_MAX_BT_SERVICE_TYPES 7
#define MPP_BT_MAC_BYTES         6
#define MPP_MAX_RFCOMM_USED      7 /*it makes upto total of eight entries and It should always be even to keep things consistant with code written in mpp_msg.c*/
#define MPP_ENC_LINK_KEY_SIZE   16
#define NUM_MAX_MPP_RFCOMM_CH   15

#define RFCOMM_AVAIL                          0
#define RFCOMM_NOT_AVAIL                      1
#define RFCOMM_TAKEN                          0xF0
#define MAX_ALLOWED_CONNECTIONS               7

#define AUDIO_DEVICE                          1
#define NON_AUDIO_DEVICE                      0

#ifdef MPP_HOST

#define PTR_TO_CONNECTION_DB                                  ptr2connection_database
#define BT_HOST_DB                                            host_connection_db
#define BT_HOST_PAIRED_SUCC                                   host_paired_succ
#define PTR_TO_HOST_MPP_PKT                                   ptr2init_host_mpp_pkt
#define HOST_PKT_INIT                                         host_pkt
#define BT_HOST_PAIRING_REJECT                                host_pairing_reject

#define BT_HOST_PAIRING_REJECT_CODE                           BT_HOST_PAIRING_REJECT.reject.reject_code
#define BT_HOST_PAIRING_REJECT_TIME_MS                        BT_HOST_PAIRING_REJECT.reject_pairing_stat.pairing_time_in_msec
#define BT_HOST_PAIRING_TIME_OUT                              BT_HOST_PAIRING_REJECT.reject.reject_for_msg
#define BT_HOST_PAIRING_REJECT_TRANS_TYPE                     BT_HOST_PAIRING_REJECT.tt_type.transaction_type 
#define BT_HOST_PAIRING_REJECT_DEVICE_TYPE                    BT_HOST_PAIRING_REJECT.device_type.device
#define BT_HOST_PAIRING_REJECT_DEVICE_MAC(count)              BT_HOST_PAIRING_REJECT.mac_address.bt_mac_byte[(count)]
#define BT_HOST_PAIRING_REJECT_SERVICES_REQUESTED             BT_HOST_PAIRING_REJECT.service_type.num_of_entries
#define BT_HOST_PAIRING_REJECT_SERVICE_TYPE_NIBBLER(count)    BT_HOST_PAIRING_REJECT.service_type.bt_service_type[(count)].nibbler
#define BT_HOST_PAIRING_REJECT_SERVICE_TYPE_PROFILE(count)    BT_HOST_PAIRING_REJECT.service_type.bt_service_type[(count)].bt_service_profile_protocol
#define BT_HOST_PAIRING_REJECT_CUMULATIVE_PAIRING_TIME          BT_HOST_PAIRING_REJECT.reject_pairing_stat.cumulative_pairing_time_in_msec
#define BT_HOST_PAIRING_REJECT_CUMULATIVE_VALID_BEACON_PROC     BT_HOST_PAIRING_REJECT.reject_pairing_stat.cumulative_valid_beacon_proc
#define BT_HOST_PAIRING_REJECT_CUMULATIVE_VALID_DATA_MSG_PROC   BT_HOST_PAIRING_REJECT.reject_pairing_stat.cumulative_valid_data_msg_proc

#define BT_HOST_PAIRING_SERVICES_REQUESTED                    BT_HOST_PAIRING_REJECT_SERVICES_REQUESTED  
#define BT_HOST_PAIRING_SERVICE_TYPE_NIBBLER(count)           BT_HOST_PAIRING_REJECT_SERVICE_TYPE_NIBBLER(count)  
#define BT_HOST_PAIRING_SERVICE_TYPE_PROFILE(count)           BT_HOST_PAIRING_REJECT_SERVICE_TYPE_PROFILE(count) 


#define BT_HOST_INIT_DB_SYSTEM_STATUS                               BT_HOST_DB.system_status
#define BT_HOST_INIT_DB_AUDIO_CONN_AVAIL                            BT_HOST_DB.audio_conn_avail
#define BT_HOST_INIT_DB_DATA_CONN_AVAIL                             BT_HOST_DB.data_conn_avail
#define BT_HOST_INIT_DB_RFCOMM_ALLOC                                BT_HOST_DB.num_rfcomm_chan
#define BT_HOST_INIT_DB_LINK_KEY_COPY_FROM(count)                   BT_HOST_DB.link_key.link_key_byte[(count)]
#define BT_HOST_INIT_DB_RFCOMM_LOOKUP_CH_NUM(count)                 BT_HOST_DB.rfcomm_in_system[(count)].channel_no
#define BT_HOST_INIT_DB_RFCOMM_LOOKUP_RFCOMM_STATUS(count)          BT_HOST_DB.rfcomm_in_system[(count)].rfcomm_status
#define BT_HOST_INIT_DB_RFCOMM_LOOKUP_DEVICE_TYPE(count)            BT_HOST_DB.rfcomm_in_system[(count)].device_type.device
#define BT_HOST_INIT_DB_RFCOMM_LOOKUP_BT_SERVICE_NIBBLER(count)     BT_HOST_DB.rfcomm_in_system[(count)].profile_type.nibbler
#define BT_HOST_INIT_DB_RFCOMM_LOOKUP_BT_SERVICE_PROFILE(count)     BT_HOST_DB.rfcomm_in_system[(count)].profile_type.bt_service_profile_protocol
#define BT_HOST_INIT_DB_PTR_TO_MAC_LIST_HEAD                        BT_HOST_DB.ptr2_mac_addr_list_head



#define BT_HOST_DB_SYSTEM_STATUS                              PTR_TO_CONNECTION_DB->system_status
#define BT_HOST_DB_AUDIO_CONN_AVAIL                           PTR_TO_CONNECTION_DB->audio_conn_avail
#define BT_HOST_DB_DATA_CONN_AVAIL                            PTR_TO_CONNECTION_DB->data_conn_avail
#define BT_HOST_DB_RFCOMM_ALLOC                               PTR_TO_CONNECTION_DB->num_rfcomm_chan
#define BT_HOST_DB_LINK_KEY_COPY_FROM(count)                  PTR_TO_CONNECTION_DB->link_key.link_key_byte[(count)]
#define BT_HOST_DB_RFCOMM_LOOKUP_CH_NUM(count)                PTR_TO_CONNECTION_DB->rfcomm_in_system[(count)].channel_no
#define BT_HOST_DB_RFCOMM_LOOKUP_RFCOMM_STATUS(count)         PTR_TO_CONNECTION_DB->rfcomm_in_system[(count)].rfcomm_status
#define BT_HOST_DB_RFCOMM_LOOKUP_DEVICE_TYPE(count)           PTR_TO_CONNECTION_DB->rfcomm_in_system[(count)].device_type.device
#define BT_HOST_DB_RFCOMM_LOOKUP_BT_SERVICE_NIBBLER(count)    PTR_TO_CONNECTION_DB->rfcomm_in_system[(count)].profile_type.nibbler
#define BT_HOST_DB_RFCOMM_LOOKUP_BT_SERVICE_PROFILE(count)    PTR_TO_CONNECTION_DB->rfcomm_in_system[(count)].profile_type.bt_service_profile_protocol
#define BT_HOST_DB_PTR_TO_MAC_LIST_HEAD                       PTR_TO_CONNECTION_DB->ptr2_mac_addr_list_head

#define BT_HOST_SUCC_TRANS_TYPE                               BT_HOST_PAIRED_SUCC.tt_type.transaction_type 
#define BT_HOST_SUCC_DEVICE_TYPE                              BT_HOST_PAIRED_SUCC.device_type.device
#define BT_HOST_SUCC_DEVICE_RFPA                              BT_HOST_PAIRED_SUCC.rfpa_flag.rfpa
#define BT_HOST_SUCC_DEVICE_MAC_STRUCT                        BT_HOST_PAIRED_SUCC.mac_address
#define BT_HOST_SUCC_DEVICE_MAC(count)                        BT_HOST_PAIRED_SUCC.mac_address.bt_mac_byte[(count)]

#define BT_HOST_SUCC_LINK_KEY(count)                          BT_HOST_PAIRED_SUCC.link_key.link_key_byte[(count)]
#define BT_HOST_SUCC_RFCOMM_INDEX_ENTRIES                     BT_HOST_PAIRED_SUCC.rfcomm_index.num_of_entries
#define BT_HOST_SUCC_RFCOMM_INDEX_TO_CONN_DB(count)           BT_HOST_PAIRED_SUCC.rfcomm_index.rfcomm_channels[(count)].rf_comm_channel_mapped
#define BT_HOST_SUCC_PAIRING_TIME                             BT_HOST_PAIRED_SUCC.succ_pairing_stat.pairing_time_in_msec
#define BT_HOST_SUCC_CUMULATIVE_PAIRING_TIME                  BT_HOST_PAIRED_SUCC.succ_pairing_stat.cumulative_pairing_time_in_msec
#define BT_HOST_SUCC_CUMULATIVE_VALID_BEACON_PROC             BT_HOST_PAIRED_SUCC.succ_pairing_stat.cumulative_valid_beacon_proc
#define BT_HOST_SUCC_CUMULATIVE_VALID_DATA_MSG_PROC           BT_HOST_PAIRED_SUCC.succ_pairing_stat.cumulative_valid_data_msg_proc

#define BT_HOST_MPP_CONFIG_TYPE                               PTR_TO_HOST_MPP_PKT->mpp_config_type
#define BT_HOST_CONTINOUS_PAIRING                             PTR_TO_HOST_MPP_PKT->continous_pairing
#define BT_HOST_SSP_OOB                                       PTR_TO_HOST_MPP_PKT->link_key_exc.bt_ssp_oob
#define BT_HOST_128_KEY_PUSH                                  PTR_TO_HOST_MPP_PKT->link_key_exc.lf_bt_128_key_push
#define BT_HOST_LINK_KEY_EXT_BIT                              PTR_TO_HOST_MPP_PKT->link_key_exc.bt_link_key_exchange_method_ext_bit
#define BT_HOST_LINK_KEY_EXT_BYTE                             PTR_TO_HOST_MPP_PKT->link_key_exc.extension_byte


#define BT_HOST_LINK_ENC_TYPE_128_56                          PTR_TO_HOST_MPP_PKT->link_enc.e0_enc_type_128_56
#define BT_HOST_LINK_ENC_EXT_BIT                              PTR_TO_HOST_MPP_PKT->link_enc.bt_link_enc_ext_bit
#define BT_HOST_LINK_ENC_EXT_BYTE                             PTR_TO_HOST_MPP_PKT->link_enc.extension_byte


#define BT_HOST_AUDIO_MODIFIED                                PTR_TO_HOST_MPP_PKT->audio_modified.status
#define BT_HOST_MAC_ADDRESS(count)                            PTR_TO_HOST_MPP_PKT->mac_address.bt_mac_byte[(count)]

#define BT_HOST_TIERING_CODE                                  PTR_TO_HOST_MPP_PKT->beacon_conf.tiering_code
#define BT_HOST_LF_BASLINE_OPER                               PTR_TO_HOST_MPP_PKT->beacon_conf.lf_baseline_operation
#define BT_HOST_LF_SEC_CAP_EXT_BIT_0                          PTR_TO_HOST_MPP_PKT->beacon_conf.lf_security_capability.security_extensions_bit_0
#define BT_HOST_LF_SEC_CAP_EXT_BIT_1                          PTR_TO_HOST_MPP_PKT->beacon_conf.lf_security_capability.security_extensions_bit_1
#define BT_HOST_LF_SEC_CAP_EXT_BIT                            PTR_TO_HOST_MPP_PKT->beacon_conf.lf_security_capability.extension_bit
#define BT_HOST_LF_SEC_CAP_EXT_BYTE                           PTR_TO_HOST_MPP_PKT->beacon_conf.extension_byte

#endif


#ifdef MPP_DEVICE

#define PTR_TO_DEVICE_MPP_PKT                                 ptr2init_device_mpp_pkt
#define BT_DEV_SUCC_MSG                                       device_succ_msg
#define DEVICE_PKT_INIT                                       device_pkt
#define BT_DEVICE_PAIRING_REJECT                              device_pairing_reject
#define BT_DEVICE_PAIRING_REJECT_CODE                         BT_DEVICE_PAIRING_REJECT.reject.reject_code
#define BT_DEVICE_PAIRING_REJECT_TIME_MS                      BT_DEVICE_PAIRING_REJECT.reject.pairing_time_in_msec
#define BT_DEVICE_PAIRING_TIME_OUT                            BT_DEVICE_PAIRING_REJECT.reject.reject_for_msg

#define BT_DEV_SUCC_TIERING_CODE                              BT_DEV_SUCC_MSG.beacon_conf.tiering_code
#define BT_DEV_SUCC_LF_BASLINE_OPER                           BT_DEV_SUCC_MSG.beacon_conf.lf_baseline_operation
#define BT_DEV_SUCC_LF_SEC_CAP_EXT_BIT_0                      BT_DEV_SUCC_MSG.beacon_conf.lf_security_capability.security_extensions_bit_0
#define BT_DEV_SUCC_LF_SEC_CAP_EXT_BIT_1                      BT_DEV_SUCC_MSG.beacon_conf.lf_security_capability.security_extensions_bit_1
#define BT_DEV_SUCC_LF_SEC_CAP_EXT_BIT                        BT_DEV_SUCC_MSG.beacon_conf.lf_security_capability.extension_bit
#define BT_DEV_SUCC_LF_SEC_CAP_EXT_BYTE                       BT_DEV_SUCC_MSG.beacon_conf.extension_byte

#define BT_DEV_SUCC_SSP_OOB                                   BT_DEV_SUCC_MSG.link_key_exc.bt_ssp_oob
#define BT_DEV_SUCC_128_KEY_PUSH                              BT_DEV_SUCC_MSG.link_key_exc.lf_bt_128_key_push
#define BT_DEV_SUCC_LINK_KEY_EXT_BIT                          BT_DEV_SUCC_MSG.link_key_exc.bt_link_key_exchange_method_ext_bit
#define BT_DEV_SUCC_LINK_KEY_EXT_BYTE                         BT_DEV_SUCC_MSG.link_key_exc.extension_byte

#define BT_DEV_SUCC_LINK_ENC_TYPE_128_56                      BT_DEV_SUCC_MSG.link_enc.e0_enc_type_128_56
#define BT_DEV_SUCC_LINK_ENC_EXT_BIT                          BT_DEV_SUCC_MSG.link_enc.bt_link_enc_ext_bit
#define BT_DEV_SUCC_LINK_ENC_EXT_BYTE                         BT_DEV_SUCC_MSG.link_enc.extension_byte

#define BT_DEV_SUCC_RFCOMM_ENTRIES                            BT_DEV_SUCC_MSG.rfcomm_chnl_num.num_of_entries
#define BT_DEV_SUCC_RFCOMM(count)                             BT_DEV_SUCC_MSG.rfcomm_chnl_num.rfcomm_channels[(count)].rf_comm_channel_mapped
#define BT_DEV_SUCC_HOST_MAC_ADDRESS(count)                   BT_DEV_SUCC_MSG.mac_address.bt_mac_byte[(count)]
#define BT_DEV_SUCC_LINK_KEY(count)                           BT_DEV_SUCC_MSG.link_key.link_key_byte[(count)]
#define BT_DEV_SUCC_AUDIO_MODIFIED                            BT_DEV_SUCC_MSG.audio_modified.status
#define BT_DEV_SUCC_PAIRING_TIME                              BT_DEV_SUCC_MSG.pairing_time_in_msec

#define BT_DEVICE_TIERING_CODE                                PTR_TO_DEVICE_MPP_PKT->beacon_brdcast.tiering_code
#define BT_DEVICE_LF_BASLINE_OPER                             PTR_TO_DEVICE_MPP_PKT->beacon_brdcast.lf_baseline_operation
#define BT_DEVICE_LF_SEC_CAP_EXT_BIT_0                        PTR_TO_DEVICE_MPP_PKT->beacon_brdcast.lf_security_capability.security_extensions_bit_0
#define BT_DEVICE_LF_SEC_CAP_EXT_BIT_1                        PTR_TO_DEVICE_MPP_PKT->beacon_brdcast.lf_security_capability.security_extensions_bit_1
#define BT_DEVICE_LF_SEC_CAP_EXT_BIT                          PTR_TO_DEVICE_MPP_PKT->beacon_brdcast.lf_security_capability.extension_bit
#define BT_DEVICE_LF_SEC_CAP_EXT_BYTE                         PTR_TO_DEVICE_MPP_PKT->beacon_brdcast.extension_byte


#define BT_DEVICE_TRANSACT_TYPE                               PTR_TO_DEVICE_MPP_PKT->tt_type.transaction_type

#define BT_DEVICE_SSP_OOB                                     PTR_TO_DEVICE_MPP_PKT->link_key_exc.bt_ssp_oob
#define BT_DEVICE_128_KEY_PUSH                                PTR_TO_DEVICE_MPP_PKT->link_key_exc.lf_bt_128_key_push
#define BT_DEVICE_LINK_KEY_EXT_BIT                            PTR_TO_DEVICE_MPP_PKT->link_key_exc.bt_link_key_exchange_method_ext_bit
#define BT_DEVICE_LINK_KEY_EXT_BYTE                           PTR_TO_DEVICE_MPP_PKT->link_key_exc.extension_byte

#define BT_DEVICE_LINK_ENC_TYPE_128_56                        PTR_TO_DEVICE_MPP_PKT->link_enc.e0_enc_type_128_56
#define BT_DEVICE_LINK_ENC_EXT_BIT                            PTR_TO_DEVICE_MPP_PKT->link_enc.bt_link_enc_ext_bit
#define BT_DEVICE_LINK_ENC_EXT_BYTE                           PTR_TO_DEVICE_MPP_PKT->link_enc.extension_byte


#define BT_DEVICE_MAC_ADDRESS(count)                          PTR_TO_DEVICE_MPP_PKT->mac_address.bt_mac_byte[(count)]
#define BT_DEVICE_DEVICE_TYPE                                 PTR_TO_DEVICE_MPP_PKT->device_type.device
#define BT_DEVICE_RFPA_FLAG                                   PTR_TO_DEVICE_MPP_PKT->rfpa_flag.rfpa
#define BT_DEVICE_SERVICES_TO_REQUEST                         PTR_TO_DEVICE_MPP_PKT->service_type.num_of_entries
#define BT_DEVICE_SERVICE_TYPE_NIBBLER(count)                 PTR_TO_DEVICE_MPP_PKT->service_type.bt_service_type[(count)].nibbler
#define BT_DEVICE_SERVICE_TYPE_PROFILE(count)                 PTR_TO_DEVICE_MPP_PKT->service_type.bt_service_type[(count)].bt_service_profile_protocol

#endif

#define MASK_BIT_POS_0                      0x01
#define MASK_BIT_POS_1                      0x02
#define MASK_BIT_POS_2                      0x04
#define MASK_BIT_POS_3                      0x08
#define MASK_BIT_POS_4                      0x10
#define MASK_BIT_POS_5                      0x20
#define MASK_BIT_POS_6                      0x40
#define MASK_BIT_POS_7                      0x80


#define MIN_BYTES_IN_DEV_CPB_BRDCAST        9
#define MIN_BYTES_IN_DEV_CPB_REP            24

#define BLUETOOTH_STANDARD                  0x0

/*
1) AMS decodes incoming data as msb first and for the wakeup sequence it always looks for Manchester coded data ( we are not using Manchester coding except for wakeup sequence)
2) It follows OOK which is like 0 - for no carrier and 1 - for carrier (which is 125khz) and Manchester coding is 01 for 0 and 10 for 1 so there cant be any 00 or 11 in any single bit Manchester period.
3) As you are aware AMS needs carrier burst followed by preamble which is no carrier -> carrier and no carrier -> carrier and this can be shared/ overlapped with the pattern.
4) In the NFC hardware design it was decided to send carrier for 0 and no carrier for 1 as UART idle is 1 and it doesn't make any sense to keep on sending the carrier frequency all the time.
Pattern bytes are 0x4a and 0x53 (its not as per MPP ICD as pattern mentioned there doesn't work as it does follow the Manchester coding rules)
0x4a in binary is 01001010 and 0x53 is 01010011
which translates into this on line with most significant bit transmitted first
start bit                      stop bit     start bit                     stop bit
0            0101 0010    1                0        1100    1010    1
we are sending 0 as carrier and 1 as no carrier as per NFC hardware
so AMS chip will interpret it as
carrier     preamble
burst       with two bits shared with pattern
                  0x6        a                         0x6        a
11            0101 10 1    0                1        0 011   0 101    0
*/

#define MPP_PATTER_BYTE_1                   0x35 
#define MPP_PATTER_BYTE_2                   0xF3 

#define INIT_CRC_CCITT                      0xFFFF

/*====================================================================================================
                                    ENUMS & STRUCTURES
==================================================================================================*/

/* MPP payload encoding*/
enum{
PAYLOAD_1B_OR_LESS_VALUE_1 = 1,
PAYLOAD_15B_OR_LESS_VALUE_2,        
PAYLOAD_22B_OR_LESS_VALUE_3,     
PAYLOAD_31B_OR_LESS_VALUE_4,      
PAYLOAD_41B_OR_LESS_VALUE_5       
};

/* MPP packet fields*/
typedef enum{
BYTE_2_FOR_TT_TYPE_BLUETOOTH = 0x00,
/*** reserved from 0x00 to 0x1f *********/
BC_BYTE1 = 0x20,       
BC_EXT_BYTE,                       
BB_BYTE1,                          
BB_EXT_BYTE,                       
BYTE_1_PL_TT,                     
BT_ENC_TYPE,                                      
BT_ENC_TYPE_BYTE2,                               
BT_ENC_TYPE_BYTE3,                    
BT_SERVICE_TYPE_STRUCT_BYTES,     
BT_DEV_TYPE_AND_SERVICE_TYPE,      
BT_MAC_ADDRESS,                    
BT_LINK_KEY,                       
BYTE_CRC                          
}mpp_pkt_byte;

/* MPP failure codes*/
enum{
MPP_ERR_FAILURE_GEN = 0x00,
MPP_ERR_BAD_MESSAGE,          
MPP_ERR_NO_DATA_LINK,        
MPP_ERR_NO_AUDIO_LINK,        
MPP_ERR_NO_RADIO_SERVICE,      
MPP_ERR_NO_OTA_COMM_TECH_SUPPORT,   
MPP_ERR_CRC_FAIL,
/* 0x07 to 0x10 TBD*/
BT_LINK_SEC_FAIL = 0x11,
BT_SERVICE_FAIL,                     
BT_SSP_OOB_NOT_SUPPORT,  
BT_DEVICE_RECORD_EXISTS
};

/* inter task message types*/
enum{
STOP_PAIR = 1,
START_PAIR,                                         
REJECT_PAIR ,                                  
READY_PAIR,                                  
SUCC_PAIR ,                           
INIT_DEVICE_MPP_PKT_REQ,                  
INIT_HOST_MPP_PKT_REQ,               
HOST_CONN_ALLOC_RES_DB_REQ,            
HOST_SYSTEM_STATUS_REQ,           
HOST_MPP_CONFIG,             
HOST_CONN_ALLOC_RES_DB_RPLY,        
INIT_HOST_MPP_PKT_RPLY,      
INIT_DEVICE_MPP_PKT_RPLY,      
MPP_RE_INIT,
MPP_ERROR,
IN_RANGE,
SUSPEND_MPP,
RESUME_MPP
};

/* MPP profile type*/
enum{
SPP_no_porotocol =    0,		
SPP_Device_Dervice_1,
SPP_from2TBD,         
SPP_to19TBD =  19,
HID,                  
DUN,	           		              
PAN,	            	             
L2CAP_BNEP                        
};  

/* MPP protocol messages as per ICD*/
typedef struct
{
  UNSIGNED_8BIT        transaction_type:5;
}mpp_transaction_type;

typedef struct
{
  UNSIGNED_16BIT        bt_ssp_oob:1;
  UNSIGNED_16BIT        lf_bt_128_key_push:1;
  UNSIGNED_16BIT        bt_link_key_exchange_method_ext_bit:1;
  UNSIGNED_16BIT        extension_byte:8;  
}bt_link_key_exchange_method;

typedef struct
{
  UNSIGNED_16BIT        e0_enc_type_128_56:1;
  UNSIGNED_16BIT        bt_link_enc_ext_bit:1;
  UNSIGNED_16BIT        extension_byte:8;
}bt_link_enc;

typedef struct
{
  UNSIGNED_16BIT        device:2;
}bt_device_type;

typedef struct
{
  UNSIGNED_16BIT        rfpa:1;
}bt_rfpa_flag;

typedef struct
{  
    UNSIGNED_16BIT       nibbler:1;
    UNSIGNED_16BIT       bt_service_profile_protocol:6;     
  }bt_service;

typedef struct
{  
  UNSIGNED_16BIT         num_of_entries:3;  
  bt_service                 bt_service_type[MPP_MAX_BT_SERVICE_TYPES];
}bt_service_type_struct;

typedef struct
{
UNSIGNED_8BIT             bt_mac_byte[MPP_BT_MAC_BYTES];
}bt_mac_address;

typedef struct
{
  UNSIGNED_16BIT          tiering_code:4;
  UNSIGNED_16BIT          lf_baseline_operation:1;
  struct{  
    UNSIGNED_16BIT        security_extensions_bit_0:1;
    UNSIGNED_16BIT        security_extensions_bit_1:1;
    UNSIGNED_16BIT        extension_bit:1; 
  }lf_security_capability;
    UNSIGNED_16BIT        extension_byte:8;
}mpp_beacon;

typedef struct
{
  UNSIGNED_16BIT          status:1;
}digital_audio_modifed;

typedef struct
{  
UNSIGNED_16BIT            rf_comm_channel_mapped:4;    
}rf_comm;

typedef struct
{  
  UNSIGNED_16BIT          num_of_entries:3;  
  rf_comm                     rfcomm_channels[MPP_MAX_RFCOMM_USED];
}bt_rfcomm_struct;

typedef struct
{
  UNSIGNED_8BIT           link_key_byte[MPP_ENC_LINK_KEY_SIZE];
}bt_link_key;

/* MPP implementation specific data structures to be shared with connection manager*/
typedef struct
{
    UNSIGNED_8BIT         reject_code;
#ifdef MPP_DEVICE    
    UNSIGNED_32BIT_LONG   pairing_time_in_msec;
#endif    
    UNSIGNED_8BIT	  reject_for_msg;
}reject_mpp;

typedef struct
{
    UNSIGNED_32BIT_LONG   pairing_time_in_msec;
    UNSIGNED_32BIT_LONG   cumulative_pairing_time_in_msec; // max value is 4294967296
    UNSIGNED_16BIT        cumulative_valid_beacon_proc;    //max value is 65536
    UNSIGNED_8BIT         cumulative_valid_data_msg_proc;  //max value is  256
}pairing_stat;


typedef struct
{
    reject_mpp reject;
}device_reject_mpp;

typedef struct{
    reject_mpp                  reject;
    pairing_stat                reject_pairing_stat;
    mpp_transaction_type        tt_type;
    bt_device_type              device_type;
    bt_mac_address              mac_address;
    bt_service_type_struct 	service_type;
}host_reject_mpp;

typedef struct
{
  mpp_beacon                  beacon_brdcast;
  mpp_transaction_type        tt_type;  
  bt_link_key_exchange_method link_key_exc;
  bt_link_enc                 link_enc ;
  bt_device_type              device_type;
  bt_rfpa_flag                rfpa_flag;
  bt_service_type_struct      service_type;  
  bt_mac_address              mac_address;
  /* product tiering to be added as part of release 2 MPP ICD release*/
}init_device_mpp_pkt;

typedef struct
{
  UNSIGNED_8BIT               mpp_config_type; /* 0= one time config , 1= any time config*/
  UNSIGNED_8BIT               continous_pairing; /* 0= one time pair, 1= continous pair*/
  mpp_beacon                      beacon_conf;
  bt_link_key_exchange_method     link_key_exc;
  bt_link_enc                     link_enc ;
  digital_audio_modifed           audio_modified;
  bt_mac_address                  mac_address;
  /* product tiering to be added as part of release 2 MPP ICD release*/
}init_host_mpp_pkt;

typedef struct
{
    	bt_device_type            device_type;/* 0 = NON_AUDIO_DEVICE, 1 = AUDIO_DEVICE*/
    	bt_service                profile_type; 
    	UNSIGNED_8BIT         channel_no;
        UNSIGNED_8BIT         rfcomm_status;	/*0 =  AVAIL, 1= NOT_AVAIL  -This is for MPP Block  to keep track of which RFCOMM channel is in use and which is not in use.*/
}rfcomm_lookup;

typedef struct bt_mac_addr_lookup bt_mac_addr_lookup_node;

struct bt_mac_addr_lookup
{ 
        bt_mac_address                  device_mac;
        bt_mac_addr_lookup_node         *next;
};

typedef struct
{
        UNSIGNED_8BIT                 system_status;  /*0 = HOST_RES_AVAIL; 1 = HOST_RES_UNAVAIL - this field will be checkedin the middle of the pairing to ensure resources are avail*/
        
        UNSIGNED_8BIT	          audio_conn_avail;  /*number of available audio connections*/
        UNSIGNED_8BIT	          data_conn_avail;   /*number of available data connections*/
        
        UNSIGNED_8BIT                 num_rfcomm_chan;  /*this is the number of rfcomm channels that are in use*/
        rfcomm_lookup                     rfcomm_in_system[NUM_MAX_MPP_RFCOMM_CH+1]; /*where NUM_MAX_MPP_RFCOMM_CH is 15 to follow the MPP ICD spec, +1 is added just to make sure array overflow never happens*/
        
        bt_mac_addr_lookup_node           *ptr2_mac_addr_list_head; /* Refer to Section 2.9.7.1.3.2 - this is a list of BT address that the Host does not want the MPP block to further the pairing with either because host already has a BT connection with it or it already has MPP_paired with it OR this is a Motorola BLOCKED out list of BT Addrs THIS IS A LINK LIST*/
       
        bt_link_key                       link_key; /* link key for the next pairing */

}connection_database;

typedef struct
{
  mpp_beacon                   beacon_conf;  
  bt_link_key_exchange_method  link_key_exc;
  bt_link_enc                  link_enc; 
  bt_rfcomm_struct             rfcomm_chnl_num;  
  bt_mac_address               mac_address;
  bt_link_key                  link_key;
  digital_audio_modifed        audio_modified;
  UNSIGNED_32BIT_LONG          pairing_time_in_msec;
}device_succ_mpp;

typedef struct
{  
  mpp_transaction_type        tt_type;
  bt_device_type              device_type;
  bt_rfpa_flag                rfpa_flag;
  bt_mac_address              mac_address;
  bt_link_key                 link_key;
  bt_rfcomm_struct	      rfcomm_index;
  pairing_stat		      succ_pairing_stat;
}host_succ_mpp;

typedef struct
{
  UNSIGNED_8BIT 		continous_pairing; /* 0 = ONE_TIME_PAIR; 1 = CONTINOUS_PAIR */
}host_mpp_config;

/*=====================================================================================
                                      FUNCTION PROTOYPES
======================================================================================*/

 /*=============================================================================
	FUNCTION: mpp_send_crc

	DESCRIPTION: Check the CRC on message
	ARGUMENTS PASSED: crc calculated so far

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_send_crc(UNSIGNED_16BIT crcCalValue);

/*=============================================================================
	FUNCTION: mpp_check_crc

	DESCRIPTION: Check the CRC on message
	ARGUMENTS PASSED: crc calculated so far

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: PASS, FAIl, TIMEOUT
==============================================================================*/
UNSIGNED_8BIT mpp_check_crc(UNSIGNED_16BIT crcCalValue);

/*=============================================================================
	FUNCTION: mpp_send_host_cpb_rep

	DESCRIPTION: Send reply to the MPP Capability Broadcast message received from Host.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_send_host_cpb_rep();

/*=============================================================================
	FUNCTION: mpp_process_host_cpb_rep

	DESCRIPTION: Process the MPP Capability Reply message recevived from Host.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_process_host_cpb_rep();

/*=============================================================================
	FUNCTION: mpp_send_dev_cpb_brdcst

	DESCRIPTION: Send the MPP Capability Broadcast message (Device side).

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_send_dev_cpb_brdcst();

/*=============================================================================
	FUNCTION: mpp_send_host_reject_msg

	DESCRIPTION: 

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_send_host_reject_msg();

/*=============================================================================
	FUNCTION: get_free_connection_index

	DESCRIPTION: 

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
UNSIGNED_8BIT get_free_connection_index();

/*=============================================================================
	FUNCTION: mpp_process_dev_cpb_brdcst

	DESCRIPTION: Process the MPP Capability Broadcast message (Host side).

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_process_dev_cpb_brdcst();

/*=============================================================================
	FUNCTION: mpp_send_beacon_brdcst

	DESCRIPTION: Send the MPP beacon Broadcast message (Host side).

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/

void mpp_send_beacon_brdcst();

/*=============================================================================
	FUNCTION: mpp_send_beacon_conf

	DESCRIPTION: Send the MPP beacon confirmation message (Device side).

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_send_beacon_conf();

/*=============================================================================
	FUNCTION: mpp_process_beacon_brdcst

	DESCRIPTION: Process the MPP beacon Broadcast message (Host side).

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_process_beacon_brdcst();

/*=============================================================================
	FUNCTION: mpp_process_beacon_conf

	DESCRIPTION: Process the MPP beacon confirmation message (Device side).

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_process_beacon_conf();

/*=============================================================================
	FUNCTION: mpp_send_wakeup_sequence

	DESCRIPTION: Send the wakeup pattern

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void mpp_send_wakeup_sequence();

#endif