/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <spp.h>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR                Date Modified	CR Tracking Number 	Description
* Niravkumar Rabara	10/18/2010	CCMPD01402008           Intial Creation       
* Niravkumar Rabara	10/19/2010	CCMPD01404218           Added AT Command for R1.4 
* Niravkumar Rabara	10/22/2010	CCMPD01405968           Modify AT Command handling for R1.4 & added Nibbler byte handling
* Niravkumar Rabara 11/14/2010  CCMPD01413929           Added SPP_DEV_NIBBLER_IND 
* Tan Seng Kai      12/10/2010  CCMPD01452526           define for reverse nibbler sending
* Tan Seng Kai      12/20/2010  CCMPD01455949           structure change for SPP_DEV_NibblerInd
* Mahes             Jan/06/2011 CCMPD01460340           Software catch-up to dongle R1.2 version R01.00.00
* Tan Seng Kai      01/17/2011  CCMPD01463409           remove unuse macro
* WRN637            01/22/2014  CCMPD01854392           Improve ACL message sending      
*
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/


#ifndef _SPP_H
#define _SPP_H

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "bt_common.h"
#include "sdap.h"
#include "bt_security_manager.h"
#include "padapt.h"
#include "rfcomm.h"
#include "hci_link_handler.h"

/*****************************************************************************/
/* Public macros                                                             */
/*****************************************************************************/

/* FIRST_PROFILE_ID is same as in btcommon.h 
 * (qbdx84) Note:- If Mecel Source change FIRST_PROFILE_ID also Subject to change
*/
#define BT_SPP_DEV		((BT_U16) (FIRST_PROFILE_ID + 0x25) )
#ifndef BT_DEPRECATED_MSG_CONST
#define BT_DEPRECATED_MSG_CONST const
#endif

/*
 * Values for SPP_DEV_AclStatus.
 * The various possbile states of the service level connection
 * to the HS.
 */
#define SPP_DEV_NOT_CONNECTED			0
#define SPP_DEV_CONNECTED			1


/*
 * Values for type SPP_DEV_Result
 */
#define	SPP_DEV_OK						0
#define	SPP_DEV_SERVICE_SEARCH_FAILED	1
#define	SPP_DEV_RFCOMM_CONNECT_FAILED	2
#define	SPP_DEV_NO_ACL_LINK				3
#define	SPP_DEV_HOST_CONTROLLER_RESTART	4


/*
 * SDP UUID's for SPP from Bluetooth Assigned Numbers
 */

#define SPP_DEV_UUID_MSB		0x11
#define SPP_DEV_UUID_LSB		0x01

/* i.e HSP Supported Features */
#define SPP_DEV_ATTR_ID_FEATURES_MSB	0x03
#define SPP_DEV_ATTR_ID_FEATURES_LSB	0x11

/*
 * Values for type SPP_DEV_ProfileVersion
 */
 /* Headsep profile version 1.1 or 1.2 */
//#define	SPP_DEV_VERSION_1_1				1
//#define	SPP_DEV_VERSION_1_2				2


/*
 * Macros used to bitwise OR the field validAttributes 
 * in the structs SPP_DEV_HsServiceRecord and 
 * SPP_DEV_ServiceRecord
 */
#define SPP_DEV_VALID_SERVICE_NAME				0x01
#define SPP_DEV_VALID_PROFILE_DESCRIPTOR_LIST	0x04 
#define SPP_DEV_VALID_SERVICE_CLASS_ID_LIST		0x08



/*
 * Size needed to create a HS service record with all optional
 * values. Note, add length of service name (up to 255).
 */
#define SPP_DEV_SERVICE_RECORD_SIZE		51 


/*
 * Enough room for all attribute values requested by 
 * SPP_DEV during connection. Assumes that no vendor uses more that 
 * two size bytes for a data element sequence.(There may be 5 
 * sequences in the response)
 *
 * This value is the requirement of SPP_DEV on the SDK config parameter
 * SDAP_MAX_RECEIVE_BUFFER_SIZE
 */
#define	SPP_DEV_SDAP_RECEIVE_BUFFER_SIZE			85


/*
 *	Min size of config parameter SDAP_MAX_SEARCH_PATTERN_SIZE
 */
#define SPP_DEV_SDAP_SEARCH_PATTERN_SIZE		5


/*
 * Min size of config parameter SDAP_MAX_ATTR_ID_LIST_SIZE
 *
 * Note that this value is for the automatic searches performed
 * during connection setup. If manual searches are performed by
 * application using SPP_DEV_attributeIdList, the corresponding value 
 * would be 14
 */
#define SPP_DEV_SDAP_ATTR_ID_LIST_SIZE		11


/*
 * Value to add to config parameter SEC_MAX_NO_OF_SERVICES when using 
 * this profile. SPP_DEV acts both as initiator and acceptor of connections
 * so it registers both outgoing and incoming services with SEC.
 */
#define SPP_DEV_NO_OF_SEC_SERVICES				2

/*
 * Configuration parameters 
 */
#define SPP_DEV_CFG_CLASS					BT_MAKE_CFG_CLASS(BT_SPP_DEV)

#define SPP_DEV_SECURITY_LEVEL				(SPP_DEV_CFG_CLASS |  0x01 )
#define SPP_DEV_FRAME_SIZE					(SPP_DEV_CFG_CLASS |  0x02 )
#define SPP_DEV_MIN_FRAME_SIZE				(SPP_DEV_CFG_CLASS |  0x03 )
#define SPP_DEV_MAX_FRAME_SIZE				(SPP_DEV_CFG_CLASS |  0x04 )
#define SPP_DEV_INITIAL_CREDITS				(SPP_DEV_CFG_CLASS |  0x05 )
#define SPP_DEV_CREDITS_TO_SEND				(SPP_DEV_CFG_CLASS |  0x06 )
#define SPP_DEV_MIN_CREDITS					(SPP_DEV_CFG_CLASS |  0x07 )
#define SPP_DEV_RESEND_TIME					(SPP_DEV_CFG_CLASS |  0x08 )
#define SPP_DEV_AT_COMMAND_MAX_SIZE			(SPP_DEV_CFG_CLASS |  0x09 )
#define SPP_DEV_LINK_HANDLER_SETTINGS		(SPP_DEV_CFG_CLASS |  0x0a )
#define SPP_DEV_MAX_NO_OF_HS_CONNECTIONS		(SPP_DEV_CFG_CLASS |  0x0b )
#define SPP_DEV_DISCONNECT_ACL_AFTER_DM_TIME	(SPP_DEV_CFG_CLASS |  0x0c )
#define SPP_DEV_BEHAVIOUR					(SPP_DEV_CFG_CLASS |  0x0d )

/* 
 * Fatal Error Codes
 */
#define SPP_DEV_ERR_CLASS						BT_MAKE_ERR_CLASS(BT_SPP_DEV)

#define SPP_DEV_ERR_SECURITY_LEVEL				(SPP_DEV_ERR_CLASS | 0x00)
#define SPP_DEV_ERR_MAX_FRAME_SIZE				(SPP_DEV_ERR_CLASS | 0x01)
#define SPP_DEV_ERR_INITIAL_CREDITS				(SPP_DEV_ERR_CLASS | 0x02)
#define SPP_DEV_ERR_CREDITS_TO_SEND				(SPP_DEV_ERR_CLASS | 0x03)
#define SPP_DEV_ERR_MIN_CREDITS					(SPP_DEV_ERR_CLASS | 0x04)
#define SPP_DEV_ERR_RESEND_TIME					(SPP_DEV_ERR_CLASS | 0x05)
#define SPP_DEV_ERR_REGISTER_PROFILE				(SPP_DEV_ERR_CLASS | 0x06)
#define SPP_DEV_ERR_AT_COMMAND_MAX_SIZE			(SPP_DEV_ERR_CLASS | 0x07)
#define SPP_DEV_ERR_MIN_FRAME_SIZE				(SPP_DEV_ERR_CLASS | 0x08)
#define SPP_DEV_ERR_FRAME_SIZE					(SPP_DEV_ERR_CLASS | 0x09)
#define SPP_DEV_ERR_LINK_HANDLER_SETTINGS		(SPP_DEV_CFG_CLASS | 0x0a)
#define SPP_DEV_ERR_MAX_NO_OF_WLPTT_CONNECTIONS		(SPP_DEV_CFG_CLASS | 0x0b)
#define SPP_DEV_ERR_DISCONNECT_ACL_AFTER_DM_TIME (SPP_DEV_CFG_CLASS | 0x0c)
#define	SPP_DEV_ERR_HCI_LH_MISSING				(SPP_DEV_ERR_CLASS | 0x0d)
#define	SPP_DEV_ERR_BEHAVIOUR					(SPP_DEV_ERR_CLASS | 0x0e)



/* 
 * SPP_DEV message API
 */
#define SPP_DEV_MSG_CLASS						BT_MAKE_MSG_CLASS(BT_SPP_DEV)

#define SPP_DEV_CONNECT_REQ						(SPP_DEV_MSG_CLASS | 0x00)
#define SPP_DEV_CONNECT_RSP						(SPP_DEV_MSG_CLASS | 0x01)
#define SPP_DEV_DISCONNECT_REQ					(SPP_DEV_MSG_CLASS | 0x02)

#define SPP_DEV_DATA_REQ							(SPP_DEV_MSG_CLASS | 0x03)

#define SPP_DEV_CONNECT_IND						(SPP_DEV_MSG_CLASS | 0x04)
#define SPP_DEV_CONNECT_CFM						(SPP_DEV_MSG_CLASS | 0x05)

#define SPP_DEV_LINK_STATUS_IND					(SPP_DEV_MSG_CLASS | 0x06)

#define SPP_DEV_AT_IND							(SPP_DEV_MSG_CLASS | 0x07)
#define SPP_DEV_FLOW_IND							(SPP_DEV_MSG_CLASS | 0x08) 
#define SPP_DEV_CONFIG_IND						(SPP_DEV_MSG_CLASS | 0x09)
#define SPP_DEV_NOT_CONGESTED_IND				(SPP_DEV_MSG_CLASS | 0x0a)
#define SPP_DEV_NIBBLER_IND						(SPP_DEV_MSG_CLASS | 0x0b)

#define SPP_DEV_LAST_MSG							SPP_DEV_NOT_CONGESTED_IND

/*****************************************************************************/
/* Public types                                                              */
/*****************************************************************************/

typedef BT_U8 SPP_DEV_Result;
typedef BT_U8 SPP_DEV_NetworkType;
typedef void* SPP_DEV_Handle;
typedef BT_U8 SPP_DEV_AclStatus;
typedef BT_U8 SPP_DEV_Behaviour;
typedef BT_U8 SPP_DEV_ProfileVersion;

typedef enum 
{
  RFCOMM_IND,
  RFCOMM_CHNL_IND,
  CGMM_IND,
  NIBBLER_IND,
  SEND_R1_4_REVERSE_NIBBLER,
  SPP_XCMP_REVERSE_NIBBLER
}SPP_AT_CMD_IND;

typedef enum
{
    RFCOMM_OK_RSP,
    RFCOMM_CHNL_RSP,
    CGMM_RSP,
    NIBBLER_OK_RSP,
    SEND_REVERSE_NIBBLER_BYTE,
}SPP_AT_CMD_RSP;
/*
 * Type for HS side SDP service record, used when implementomg
 * some external service browsing application using 
 * SPP_DEV_StartInterpretSearchResult, SPP_DEV_InterpretSearchResult
 */
typedef struct
{
	RFCOMM_ServerChannel		serverChannel;
	BT_U16						serviceClassIdList[2];
	BT_U8						*serviceName;		/* Not 0 terminated ! */
	BT_U16						serviceNameLength; 
	BT_U8						validAttributes;
} SPP_DEV_ServiceRecord;


/*
 * Iterator type used with functions SPP_DEV_StartInterpretSearchResult
 * and SPP_DEV_InterpretSearchResult
 */
typedef BT_U8	SPP_DEV_Position;

/*
 * Struct used for sending SPP_DEV_CONNECT_REQ message
 */
typedef struct
{
	BT_Header				header;
	BT_BdAddr				bdAddr;
} SPP_DEV_ConnectReq;

/*
 * Struct used for sending SPP_DEV_DISCONNECT_REQ message
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
} SPP_DEV_DisconnectReq;




/*
 * Struct used for sending SPP_DEV_CONNECT_RSP message
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	BT_BOOL					accept;
} SPP_DEV_ConnectRsp;

/*
 * Struct used for sending SPP_DEV_DISCONNECT_CFM message
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			      handle;
        BT_BdAddr				bdAddr;
	BT_BOOL					success;
} SPP_DEV_DisconnectCfm;

/*
 * Struct used for sending SPP_DEV_DATA_REQ message
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	const BT_U8				*dta;
	BT_U16					length;
} SPP_DEV_DataReq;

/*
 * The union of all requests and responses that can be sent
 * to the SPP_DEV module
 */
typedef union
{
	BT_Header							header;

	SPP_DEV_ConnectReq					connectReq;
	SPP_DEV_ConnectRsp					connectRsp;
	SPP_DEV_DisconnectReq				disconnectReq;
	SPP_DEV_DataReq						dataReq;
} SPP_DEV_ReqResp;


/*
 * Struct used for sending SPP_DEV_CONNECT_CFM message
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	BT_BdAddr				bdAddr;
	SPP_DEV_Result			result;
	RFCOMM_DlcFrameSize		framesize;
} SPP_DEV_ConnectCfm;


/*
 *	Struct used for sending SPP_DEV_CONNECT_IND
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	BT_BdAddr				bdAddr;
	RFCOMM_DlcFrameSize		framesize;
} SPP_DEV_ConnectInd;


/*
 *	Struct used for sending SPP_DEV_LINK_STATUS_IND
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	SPP_DEV_AclStatus		aclStatus;
        BT_BdAddr				bdAddr;
} SPP_DEV_LinkStatusInd;


/*
 *	Primitive	: SPP_DEV_AT_IND
 *	Description : See the Bluetooth SDK Profile Reference Manual
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	char					*details;
} SPP_DEV_AtInd;

/*
 *	Primitive	: SPP_DEV_NIBBLER_IND
 *	Description : Send Nibbler Byte
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	BT_U8					*nibbler;
	BT_U8					size;
} SPP_DEV_NibblerInd;

/*
 *	Primitive	: SPP_DEV_ConfigInd
 *	Description : See the Bluetooth SDK Profile Reference Manual
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
	RFCOMM_DlcFrameSize		framesize;
} SPP_DEV_ConfigInd;


/*
 *	Primitive	: SPP_DEV_FlowInd
 *	Description : See the Bluetooth SDK Profile Reference Manual
 */
typedef struct
{
	BT_Header				header;
	SPP_DEV_Handle			handle;
        BT_BdAddr				bdAddr;
	BT_BOOL					remoteReadyToReceive;
} SPP_DEV_FlowInd;


/*
 * Primitive:	SPP_DEV_NOT_CONGESTED_IND
 */
typedef struct
{
	BT_Header			header;
} SPP_DEV_NotCongestedInd;




/*
 * The union of all indications and confirms that can be received
 * from the SPP_DEV module.
 */
typedef union
{
	BT_Header							header;

	SPP_DEV_ConnectInd					connectInd;	
	SPP_DEV_ConnectCfm					connectCfm;
	SPP_DEV_ConfigInd					configInd;
	SPP_DEV_FlowInd						flowInd;

	SPP_DEV_LinkStatusInd				linkStatusInd;
	SPP_DEV_AtInd						atInd;
	SPP_DEV_NotCongestedInd				notCongestedInd;
        SPP_DEV_NibblerInd                                       nibblerInd;
} SPP_DEV_IndConf;


/*****************************************************************************/
/* Public constant & variable prototypes                     	             */
/*****************************************************************************/

extern const BT_U8 BT_ROM SPP_DEV_serviceSearchPattern[];
extern const BT_U8 BT_ROM SPP_DEV_attributeIdList[];

/*****************************************************************************/
/* Public API function prototypes                                            */
/* Description: See the Bluetooth SDK Profile Reference Manual               */
/*****************************************************************************/

BT_Result SPP_DEV_ChangeSecurityLevel(SEC_SecurityLevel securityLevel) BT_LARGE;


SPP_DEV_Position SPP_DEV_StartInterpretSearchResult(SDP_DePtr attributeBuffer) BT_LARGE;

BT_Result SPP_DEV_InterpretSearchResult(SDP_DePtr searchResult,
									BT_U16				lengthOfSearchResult,
									SPP_DEV_ServiceRecord *serviceRecord, 
									SPP_DEV_Position *position) BT_LARGE;

BT_Result SPP_DEV_Control(BT_ControlCommand cmd) BT_LARGE;

BT_U8 SPP_DEV_HandleOrdinalNo(SPP_DEV_Handle handle) BT_LARGE;

/*
 * Only special integrations may need to use these message handlers
 * directly
 */

BT_Result SPP_DEV_MsgHandler(BT_DEPRECATED_MSG_CONST BT_Msg *m) BT_LARGE;
BT_Result SPP_DEV_RequestMsgHandler(BT_DEPRECATED_MSG_CONST BT_Msg *m) BT_LARGE;
BT_Result SPP_DEV_IndicationMsgHandler(BT_DEPRECATED_MSG_CONST BT_Msg *m) BT_LARGE;

#ifdef BT_NO_TRACE_SPP_DEV
	#define SPP_DEV_Image 0
#else
	BT_U16 SPP_DEV_Image (const BT_Msg  *msg, MsgImageType imgType,
							char *imgBuffer, BT_U16 bufSize) BT_LARGE;
#endif 

#endif
