#ifndef _TEST_COMMANDS_MANAGER_H_
#define _TEST_COMMANDS_MANAGER_H_

/*################################################################################
#

#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: test_commands_manager.h
#
# --------------------------- General Description -----------------------------
# This file contains the declarations of the Test Commands Manager.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/


/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR      Date Modified Tracking Number     Description
* Phong Tran  03/18/2010    CCMPD01316656       Initial Creation
* Phong Tran  06/04/2010    CCMPD01355429       BT Addr, LED
* PeiSee Toh  09/08/2010    CCMPD01390094       Initial draft for Wireless 1.2 DOngle
* PeiSee Toh  09/29/2010    CCMPD01397210       Catchup from 2.0 latest framework, I08.00.00
* PeiSee Toh  10/14/2010    CCMPD01400426       Change the opcode of MSG_ATMEL_TEST_MODE from ED to F0
* JJ Low      11/30/2010    CCMPD01446399       Add Test Commander Pairing Mode command
* Phong Tran  12/06/2013    CCMPD01837173       Added support for XNL/XCMP simulator.
* Phong Tran  05/12/2014    CCMPD01885130       Modified to support XXT device
*
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/*===============================================================================================
                                      DEFINES
================================================================================================*/

/* ACMP Opcodes */
#define ACMP_REQUEST              0xF000
#define ACMP_REPLY                0xF800
#define ACMP_BROADCAST            0xFB00

/* Debug Message ID */
#define MSG_DEBUG_GENERIC         0x80
#define MSG_ENABLE_ACCESS         0x81
#define MSG_DEBUG_ON              0x82
#define	MSG_DEBUG_OFF             0x83                    
#define MSG_CP_READ               0x84
#define MSG_CP_WRITE              0x85
#define MSG_FLASH_READ            0x86
#define MSG_FLASH_WRITE           0x87
#define MSG_RAM_READ              0x88
#define MSG_RAM_WRITE             0x89
#define MSG_MEMORY_INFO           0x8A
#define MSG_MPP_DEBUG             0x8F  // CCMPD01446399 (JJ 30/11/2010)
#define MSG_SIMULATOR_CTRL        0x91
#define MSG_EMBEDDED_XCMP         0x92

/* Factory Test Message IDs */
#define MSG_ENTER_BOOTMODE        0xC1
#define MSG_VERSION_NUMBER        0xC2
#define MSG_GPIO                  0xC3
#define MSG_LED                   0xC5                     
#define MSG_BUTTON                0xCD
#define MSG_BUTTON_TEST_MODE      0xCE
#define MSG_PAIRING               0xCF  // CCMPD01446399 (JJ 30/11/2010)
#define MSG_BUTTON_STATE          0xD2
#define MSG_ATMEL_TEST_MODE       0xF0

/* Chipset */
#define TC_ATMEL                  0x00
#define TC_CSR                    0x01


/* Component */
#define TC_COMPONENT_NONE         0x00

/* Peripheral ID */
#define TC_UART1                  0x01 
#define TC_UART2                  0x02 
#define TC_UART3                  0x03 
#define TC_SPI                    0x04 
#define TC_TWI                    0x05 
#define TC_I2C                    0x06 
#define TC_PSKEY                  0x07 

/* Buttons */

#define TC_PTT_BUTTON             0x01

/* Pairing */ // CCMPD01446399 (JJ 30/11/2010)
#define TC_PAIRING_STANDARD       0x00
#define TC_PAIRING_MPP            0x01

#define TC_GET                          0x00
#define TC_SET                          0x01

#define TC_OFF                          0x00
#define TC_ON                           0x01

#define TEST_OFF                        0x00
#define TEST_ON                         0x01

#define TC_VOLTAGE                      0x00
#define TC_CURRENT                      0x01

#define TC_RELEASED                     0x00
#define TC_PRESSED                      0x01


#define INIT_CRC_CCITT                  0xFFFF

/* DFU */
#define FUSE_BIT_GP31                   31

/* Access Levels */
#define TC_NO_ACCESS                    0
#define TC_FACTORY_ACCESS               1
#define TC_DEVELOPER_ACCESS             2

/* CSR Communication */
#define CSR_SEND_MSG_TIMEOUT              5000
#define DFU_MODE_RSP_RECEIVED_FROM_CSR    1

/* MPP Debug Commands */  // CCMPD01446399 (JJ 30/11/2010)
enum 
{
  TC_MPP_DEBUG_MSG_ENABLE = 0,
  TC_MPP_START_PAIRING,
  TC_MPP_STOP_PAIRING,
  TC_MPP_SEND_AMS_DIR_CMDS,
  TC_MPP_PROG_AMS_REG,
  TC_MPP_AMS_CHIP_REINIT,
  TC_MPP_AMS_CHIP_READ_REG,
  TC_MPP_AMS_TRIM_OSC,
  TC_MPP_AMS_PWR_DWN,
  TC_MPP_INIT_DEV_MPP_PKT_TC
};

/* Button Test Modes */
enum 
{
  TC_BUTTON_TEST_OFF = 0,
  TC_BUTTON_TEST_ATMEL,
  TC_BUTTON_TEST_CSR,
  TC_BUTTON_TEST_ALL
};

/* Button Test Modes */
enum 
{
  TC_SIM_HOST = 0,
  TC_SIM_DEVICE,
};
/*====================================================================================================
                                    ENUMS & STRUCTURES
==================================================================================================*/

typedef enum test_command_result_t
{
    TC_SUCCESS = 0,
    TC_FAILURE,
    TC_INVALID_OPCODE, 
    TC_INVALID_CHIPSET,
    TC_MAX_SIZE_EXCEEDED,
    TC_ZERO_SIZE,
    TC_INVALID_MSG_ID, 
    TC_INVALID_COMPONENT,
    TC_INVALID_PARAMS,
    TC_INVALID_CRC,
    TC_INVALID_OPERATION,
    TC_INVALID_VALUE,
    TC_INVALID_PASSWORD,
    TC_INVALID_ACCESS,
    TC_INVALID_MODE,
    TC_VERSION_MISMATCH,
    TC_CSR_TX_ERROR,
    TC_CSR_RX_ERROR, 
    TC_CODEPLUG_ERROR,
    TC_EEPROM_READ_ERROR,
    TC_EEPROM_WRITE_ERROR,
    TC_INVALID_HEX_CHECKSUM,
    TC_INVALID_HEX_MSG_SIZE,
    TC_SIMULATOR_DISABLED,
    TC_BT_XNL_XCMP_INIT_NOT_COMPLETED
} test_command_result_t;

typedef struct
{
    BOOL_T debug_enable : 1;
    BOOL_T version_match : 1;
    UINT8_T button_test_mode : 1;
    UINT8_T access_level : 2;
    UINT8_T atmel_test_mode;
    BOOL_T simulator_enable;
    UINT8_T simulator_type;
} tc_flags_t;


typedef struct
{
    UINT8_T atmel;
    UINT8_T csr;
} tc_button_source_t;


typedef struct
{
    tc_button_source_t ptt;
    
} tc_button_states_t;

/*=====================================================================================
                                      FUNCTION PROTOYPES
======================================================================================*/
success_failure_t send_data_to_pc(UINT8_T *data, UINT16_T len);

#endif  /* _TEST_COMMANDS_MANAGER_H_ */
