/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: timers.c
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* Phong Tran        06/18/2010          CCMPD01331569           Added (new_timer != this_timer)
* YewFoong          01/13/2011          CCMPD01462474           Catched up the latest code change from 'WIRELESS_HEADSET_SW_R01.00.02'
* Abhishek Trivedi  09/02/2013          CCMPD01827271           Catch up to latest code change from INC RSM A
* Abhishek Trivedi  03/18/2014	        CCMPD01873731	        Catch up to latest code change from INC RSM A
* Abhishek Trivedi  05/28/2014          CCMPD01897875           Fix Klocwork Issues
*--------------------------- End of History Template-----------------------------
* ******************************************************************************/
#include "TaskConfig.h"
#include "osal.h"
#include "timers.h"

#define ENTER_CRITICAL              Disable_global_interrupt()
#define EXIT_CRITICAL               Enable_global_interrupt()

TimerDescriptorType * next_timer_to_process = NULL;

void TimerHandler(void)
{ 

  TimerDescriptorType * new_timer;
  TimerDescriptorType * this_timer;
  TimerDescriptorType * previous_timer;
  unsigned int current_time;
  ms_task_msg_t *msg;
  unsigned int timeout = SUSPEND_INDEFFINATELY;
  

  for(;;)
  {      
      msg = (ms_task_msg_t *)Get_Msg_w_Time_Out(timeout);
      
ENTER_CRITICAL;
      
      current_time = SYSTEM_TIME;  /* 16 bit free running counter is assuemed ! */  
      
      if((NULL != msg) && (TIMER_SCHEUDLE == msg->ros_msg.radio_if_msg.sub_opcode))  /* received request for a new timer in the quesue */
      {  
          
         new_timer = (TimerDescriptorType *)msg->ros_msg.radio_if_msg.data; /* get pointer to data*/
         
         previous_timer = next_timer_to_process;
         this_timer = next_timer_to_process;

         while ((NULL != this_timer) 
                && (new_timer != this_timer)
                && (!(new_timer->TimerMatchValue - current_time  > MAX_TIMEOUT)) /* if the new timer to be scheduled is already in the past, then schedule immediately*/
                /* if new timer is older than the closest scheduled timer or if the scheduled timer is already in the past */   
                && (((new_timer->TimerMatchValue - current_time) > (this_timer->TimerMatchValue - current_time)) || ((this_timer->TimerMatchValue - current_time) > MAX_TIMEOUT))
                && (this_timer != this_timer->Next))     /* looking for the closest in time 
                                                               timeout. Will sort timers upon entry
                                                               for the next in line. */       
          {
             previous_timer = this_timer; 
             this_timer = this_timer->Next;
          }
          
          if(new_timer->Next != NULL)
          {
            /* do nothing - False condition - Timer already scheduled*/
          }
          else if ((previous_timer == this_timer) && (new_timer != this_timer))  /* no timers were scheduled 
                                                              or new timer timeout is sooner than 
                                                               the closest timout that is 
                                                               scheduled */                           
          {
              next_timer_to_process = new_timer;
              new_timer->Next = this_timer;
          }
          else if (new_timer != this_timer)
          {
              previous_timer->Next = new_timer;
              new_timer->Next = this_timer;
          }
        
      }
      else if (NULL == msg) 
      {
        if(NULL != next_timer_to_process)  /* We are  here because 
                                                 the latest timer expired */
        {
           this_timer = next_timer_to_process;
           
           send_msg_to_task(this_timer->TaskToNotify, 
                            this_timer->MessageID, 
                            this_timer->Message, 
                            sizeof(void *));
           
           next_timer_to_process = this_timer->Next;
           this_timer->Next = NULL; /* clear pointer to next 
                                        from an expired timer */
        }
          
      }
      
      timeout = SUSPEND_INDEFFINATELY; /* reset timeout, in case if 
                                          there is no other timeout
                                          scheduled */
      if (NULL != next_timer_to_process) /* check again for the "new" timer */
      {
         timeout = next_timer_to_process->TimerMatchValue - current_time;
         if (timeout > MAX_TIMEOUT) /* to prevent codition where 
                                    due to the request processing time
                                    the timeout is already in the past */
         {
             timeout = 0;
         }
      }
      
      if (NULL != msg)
      {
        OS_free(msg);
      }
      
EXIT_CRITICAL;     
        
  }
}

void ScheduleTimer(TimerDescriptorType * timer)
{
    TimerDescriptorType * this_timer;
    TimerDescriptorType * previous_timer;
    unsigned char search_again = TRUE;      
      
ENTER_CRITICAL;  
    /* Search the same timer and cancel it if found */
    this_timer = next_timer_to_process;
    previous_timer = this_timer;
    if (timer == next_timer_to_process)
    {
         next_timer_to_process = this_timer->Next;
         this_timer->Next = NULL;
    }
    else
    {
         while ((NULL != this_timer) && (search_again))    
         {    
             if (this_timer == timer)
             {
                 previous_timer->Next = this_timer->Next;
                 this_timer->Next = NULL;
                 search_again = FALSE;
             }
             previous_timer = this_timer;
             this_timer = previous_timer->Next;
         }
    }
    /* End of Search/cancel the timer */

    send_msg_to_task(TIMER_HANDLER, TIMER_SCHEUDLE, timer, sizeof(void *));

EXIT_CRITICAL;    
}
void TaskCancelTimer(TimerDescriptorType * timer)
{
      TimerDescriptorType * this_timer;
      TimerDescriptorType * previous_timer;
      unsigned char search_again = TRUE;
      
ENTER_CRITICAL;   
     
      this_timer = next_timer_to_process;
      previous_timer = this_timer;
      if (timer == next_timer_to_process)
      {
           next_timer_to_process = this_timer->Next;
           this_timer->Next = NULL;
      }
      else
      {
         while ((NULL != this_timer) && (search_again))    
         {
             if (this_timer == timer)
             {
                 previous_timer->Next = this_timer->Next;
                 this_timer->Next = NULL;
                 search_again = FALSE;
             }
             previous_timer = this_timer;
             this_timer = previous_timer->Next;
          }
      }
      send_msg_to_task(TIMER_HANDLER, TIMER_CANCEL, NULL, 0);
EXIT_CRITICAL;        
}