/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: <Twu_transport_avr32.c>
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* WRN637	 		10/20/2010   	  CCMPD01394399		Initial Creation
* WRN637        11/02/2010      CCMPD01409504                   Add in InitSuccess, flag for indicate success initilize.
* WRN637        11/12/2010      CCMPD01413546                   Increase buffer size to increase stability in heavy load
* Mahes         Jan/06/2011      CCMPD01460340           Software catch-up to dongle R1.2 version R01.00.00
* Abhishek Trivedi    04/04/2014    CCMPD01882874       Interchip Ping 
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/


/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/

#include "uart_transport_avr32.h"
#include "bt_transport.h"
#include "bt_log.h"
#include "uart_transport_opt.h"
#include "uart_transport_int.h"

//#ifdef ATMEL_AVR32
    #include <stdio.h>
    #include <stdlib.h>
    #include <string.h>
    #include <avr32/io.h>
    #include "usart.h"
    #include "board.h"
    #include "gpio.h"
    #include "intc.h"
    #include "pdca.h"

    // Environment header files. 
    #include "pm.h"
    #include "tc.h"
//#endif

#if 0
/*****************************************************************************/
/* Private macros                                                            */
/*****************************************************************************/
/* 
 * Device buffer = TIMESPACKETSIZE*maxRxPacketSize. NT requires even buffer
 * size.
 */ 
#define		TIMESPACKETSIZE		4			

/* Ericsson OGF code for changing baudrate */		
#define		ERICSSON_BAUD_RATE_OGF		0xfc		

/* likewise for OCF code */ 
#define		ERICSSON_BAUD_RATE_OCF		0x09		

/* Command indication byte */
#define		HCI_COMMAND			0x01	

#endif
/*****************************************************************************/
/* Private types                                                             */
/*****************************************************************************/


typedef enum
{
	READING_FIRST,				    /* Waiting to get packet-type byte */
  READING_HCI_OPCODE,
  READING_DATA_OPCODE,      /* Waiting on the data length field */
  READING_SCO_DATA_OPCODE,
  READING_EVENT_OPCODE,     /* Waiting on the event length field */
  READING_HCI_LENGTH,
	READING_DATA_LENGTH,		  /* Waiting on the data length field */
  READING_SCO_DATA_LENGTH,
	READING_EVENT_LENGTH,		  /* Waiting on the event length field */
  READING_HCI_DATA,
	READING_ACL_DATA,			    /* Waiting on the data */
  READING_SCO_DATA,
	READING_EVENT_PARAMETERS,	/* Waiting on the event */
} ReadState;

typedef enum
{
  SUB_STATE1,    
  SUB_STATE2,    
  SUB_STATE3,
}ReadSubState;

BT_U16 recordDMAreadlength = 0;
BT_U32 recordINTstatus = 0;
BT_U16 acl_packet = 0;
BT_U16 TCRRcheck = 0;
BT_U16 TCRcheck = 0;



/* Command indication byte */
#define		HCI_COMMAND	  0x01	

/* Indication byte: Data to/from HCI */ 
#define		HCI_ACL				0x02	

/* Indication byte: Event from controller */	
#define		HCI_EVENT			0x04			 

/* Indication byte: Event from controller */	
#define		HCI_SCO				0x03

/* Hardware error event from controller */
#define		HW_ERROR			0x10	




#if 0
/*Union of messages sent to and from module*/
typedef union
{
	BT_Header			header;
	BTTL_UartPcReqResp	reqResp;
	BTTL_UartPcIndConf	indConf;
} BTTL_PcMsg;


extern BT_U16 TI_BTS_ActivateUartTransportPcSupport(void);

/*****************************************************************************/
/* Private constants & variables                                             */
/*****************************************************************************/
#endif
/*
 *	 For 115200baud rate, 1sec it will receive 14,400 byte.
 * 	 In 1ms it will receive 14.4 byte. by assuming this function might
 *	 Latency and access every 50ms. 720byte needed to keep it receive
 * 	 Buffer healthy.
 */
#define RX_BUFFSIZE   2000
#define TX_BUFFSIZE   2000                
#define RX_PACKETQUE  20


/* Transmit buffer */
static BT_U8 TX_buffer[TX_BUFFSIZE]; 
static buffer_ptr  tx_Aptr;

/* Receive buffer use as a ring buffer */
static BT_U8 RX_buffer[RX_BUFFSIZE];
static buffer_ptr  rx_Aptr;

/* Receive buffer use as a ring buffer */
static BT_U8 RX_buffer1[RX_BUFFSIZE];
static buffer_ptr  rx_Aptr1;

static BT_U16 requested_size = 1;
static BT_U8 * requested_loc = NULL;
static BT_U8 * DMAbuffer_ptr = RX_buffer;
static BT_U8 * DMACurrentbuffer_ptr = RX_buffer;



/* Receive location to record down location on ring buffer */
BT_U16      RX_packetlocation[RX_PACKETQUE];
buffer_ptr  packetque_ptr;

/* Mutex variable to protect shared variables */
static xSemaphoreHandle mutexSharedVar = NULL;
static xSemaphoreHandle xUARTAccess = NULL;

/* PBA clock macro for different board */
#define MECEL_PBA_CLOCKHZ					    (configPBA_CLOCK_HZ)

/* MACRO for UART port */
#define EXAMPLE_USART                 (&AVR32_USART2)
#define EXAMPLE_USART_IRQ				      AVR32_USART2_IRQ

/* PDCA PID for UART */
#define AVR32_PDCA_PID_USART_TX       AVR32_PDCA_PID_USART2_TX
#define AVR32_PDCA_PID_USART_RX       AVR32_PDCA_PID_USART2_RX

/* PDCA channel 0 (highest priority) */
#define PDCA_CHANNEL_RXUSART 0
#define PDCA_CHANNEL_TXUSART 1

/* Table for GPIO initialize */
static const gpio_map_t USART_GPIO_MAP =
{
	{AVR32_USART2_TXD_0_0_PIN, AVR32_USART2_TXD_0_0_FUNCTION},	 /* CSR UART TX  */
	{AVR32_USART2_RXD_0_0_PIN, AVR32_USART2_RXD_0_0_FUNCTION},	 /* CSR UART RX  */
  {AVR32_USART2_CTS_0_PIN,   AVR32_USART2_CTS_0_FUNCTION  },   /* CSR UART CTS */
  {AVR32_USART2_RTS_0_PIN,   AVR32_USART2_RTS_0_FUNCTION  },   /* CSR UART RTS */
};

// USART options.
static usart_options_t USART_OPTIONS =
{
	.baudrate     = 115200,
	.charlength   = 8,
	.paritytype   = USART_NO_PARITY,
	.stopbits     = USART_1_STOPBIT,
	.channelmode  = USART_NORMAL_CHMODE
};

// PDCA channel options
static const pdca_channel_options_t PDCA_TXOPTIONS =
{
  .addr           = (void *)TX_buffer,                  // memory address
  .pid            = AVR32_PDCA_PID_USART_TX,            // select peripheral - data are transmit on USART TX line.
  .size           = sizeof(TX_buffer),                  // transfer counter
  .r_addr         = NULL,                               // next memory address
  .r_size         = 0,                                  // next transfer counter
  .transfer_size  = PDCA_TRANSFER_SIZE_BYTE             // select size of the transfer
};

// PDCA channel options
static const pdca_channel_options_t PDCA_RXOPTIONS =
{
  .addr           = (void *)RX_buffer,                  // memory address
  .pid            = AVR32_PDCA_PID_USART_RX,            // select peripheral - data are transmit on USART TX line.
  .size           = sizeof(RX_buffer),                  // transfer counter
  .r_addr         = (void *)RX_buffer1,                 // next memory address
  .r_size         = sizeof(RX_buffer1),                 // next transfer counter
  .transfer_size  = PDCA_TRANSFER_SIZE_BYTE             // select size of the transfer
};



static BT_BOOL InitSuccess = BT_FALSE;
#if 0



/* Used to take care of reads that are completed immediately */
static HANDLE			handleInputSema;

/* Handle to port */	
static HANDLE			comPortHandle;

/* Variable used to write asynchronously to the port */	
static OVERLAPPED		overlappedTxD;

/* Variable used to read asynchronously to the port */	
static OVERLAPPED		overlappedRxD;

/* Communication event */
static OVERLAPPED		serialStatus;

/* Device Control Block, settings for the port */	
static DCB              portDCB;

/* 
 * Indicates whether a control signal event are pending or not 
 */
static BT_BOOL			waitingOnStat = BT_FALSE;
																					  	
/*
 * Information used when changing baudrate on Ericsson chips
 */
static BT_U32		newBaudRate;
static BT_ModuleId	senderOfBrPrimitive;
static BT_BOOL		changeBaudRateOnTxComplete = BT_FALSE;


/*
 * If an application has it's own addition to the event rx hook,
 * using BTTL_UartSetApplicationSpecificEventRxHook, a pointer to it is stored here
 */
static BTTL_UartPcHookFunc applicationEventRxHook = 0;
static BTTL_UartPcHookFunc applicationWriteHook = 0;
static BT_MsgHandlerFunc applicationUartMsgHandler = 0;

/*****************************************************************************/
/* Public constants & variables                                             */
/*****************************************************************************/

/*****************************************************************************/
/* Private function prototypes                                               */
/*****************************************************************************/
static void HandleEvErr(void);

static BT_Result ModifyDCB(DCB *port, BT_U32 baudrate, DWORD rtsControl);
static BT_U16 StartEventHandlerThread(void);
static BT_Result EricssonChangeBaudRate(BT_U32 baudRate);
#endif

/* private function for DMA interrupt handler */
static void pdca_Txint_handler( void );
static void pdca_Rxint_handler( void );
static void uart_interrupt_handler( void );

static void pdca_Txinterrupt(void);
static void pdca_Rxinterrupt(void);
static void uart_interrupt( void );



#if 0

/*****************************************************************************/
/* Public API functions                                                      */
/*****************************************************************************/

/* ===========================================================================
 * Function: 	BTTL_UartPcSetEventRxHook
 * Description: 
 * =========================================================================== */
BTTL_UartPcHookFunc BTTL_UartPcSetEventRxHook( BTTL_UartPcHookFunc func)
{
	BTTL_UartPcHookFunc previousHook = applicationEventRxHook;

	applicationEventRxHook = func;

	return previousHook;
}

/* ===========================================================================
 * Function: 	BTTL_UartPcSetWriteHook
 * Description: 
 * =========================================================================== */
BTTL_UartPcHookFunc  BTTL_UartPcSetWriteHook(BTTL_UartPcHookFunc func)
{
	BTTL_UartPcHookFunc previousHook = applicationWriteHook ;

	applicationWriteHook = func;

	return previousHook;
}


/* ===========================================================================
 * Function: 	BTTL_UartPcSetMsgHandlerHook
 * Description: 
 * =========================================================================== */
BT_MsgHandlerFunc BTTL_UartPcSetMsgHandlerHook( BT_MsgHandlerFunc func )
{
	BT_MsgHandlerFunc previousHook = applicationUartMsgHandler;

	applicationUartMsgHandler = func;

	return previousHook;

}

#endif
/*===========================================================================
*	Function:	BTTL_UartPlatformSleep
*	Description:
*	Returns:	
*===========================================================================*/
void BTTL_UartPlatformSleep(BT_U16 delay)
{
  vTaskDelay( (portTickType)delay );
}

/*===========================================================================
*	Function:	
*	Description:
*	Returns:	
*===========================================================================*/
BT_U16 BTTL_UartPlatformInitialise(void)
{
  //COMMTIMEOUTS	commtimeouts;
  BT_U16			fatalError = 0;

  // init variable
  memset( &tx_Aptr,               0, sizeof(tx_Aptr)            );
  memset( &rx_Aptr,              0, sizeof(rx_Aptr)           );
  memset( &packetque_ptr,         0, sizeof(packetque_ptr)      );
  memset( &TX_buffer[0],          0, sizeof(TX_buffer)          );
  memset( &RX_buffer[0],         0, sizeof(RX_buffer)         );	
  memset( &RX_packetlocation[0],  0, sizeof(RX_packetlocation)  );	

  /* Create Mutex */
  vSemaphoreCreateBinary( mutexSharedVar );
  vSemaphoreCreateBinary( xUARTAccess );

  if( mutexSharedVar == NULL )
  {
    fatalError = BTTL_UART_ERR_OS_RESOURCE;
  }
  else if( xUARTAccess == NULL )
  {
    fatalError = BTTL_UART_ERR_OS_RESOURCE;
  }
  // Assign GPIO to USART.
  else if ( gpio_enable_module(USART_GPIO_MAP, sizeof(USART_GPIO_MAP) / sizeof(USART_GPIO_MAP[0])) != 0 )
  {
    fatalError = BTTL_UART_ERR_COM_PORT;
  }
  // Init PDCA channel with the pdca_options.
  else if ( pdca_init_channel(PDCA_CHANNEL_TXUSART, &PDCA_TXOPTIONS) )
  {
    fatalError = BTTL_UART_ERR_COM_PORT;
  }
  // Init PDCA channel with the pdca_options.
  else if ( pdca_init_channel(PDCA_CHANNEL_RXUSART, &PDCA_RXOPTIONS) )
  {
    fatalError = BTTL_UART_ERR_COM_PORT;
  }
  // Initialize USART in RS232 mode.
  // Note: 12000000 to be replace by define
  //else if ( usart_init_rs232(EXAMPLE_USART, &USART_OPTIONS, MECEL_PBA_CLOCKHZ) != 0 )
  else if ( usart_init_hw_handshaking(EXAMPLE_USART, &USART_OPTIONS, MECEL_PBA_CLOCKHZ) != 0 )
  {
    fatalError = BTTL_UART_ERR_COM_PORT;
  }

  // Disable all interrupts.
  Disable_global_interrupt();

	// Enable USART Rx interrupt.
	EXAMPLE_USART->ier   |= AVR32_USART_IER_FRAME_MASK    //Frame error
	                      | AVR32_USART_IER_OVRE_MASK     //Overflow error
	                      | AVR32_USART_IER_PARE_MASK     //Parity error
	                      | AVR32_USART_IER_RXBRK_MASK;    //Receive break
  
  // Clear framing error  
  EXAMPLE_USART->cr |= AVR32_USART_CR_RSTSTA_MASK;        //Status 

  // Set interrupt handler
	INTC_register_interrupt((__int_handler)&uart_interrupt_handler, EXAMPLE_USART_IRQ, AVR32_INTC_INT3);
  INTC_register_interrupt( (__int_handler) &pdca_Txint_handler, AVR32_PDCA_IRQ_1, AVR32_INTC_INT2);
  INTC_register_interrupt( (__int_handler) &pdca_Rxint_handler, AVR32_PDCA_IRQ_0, AVR32_INTC_INT3);


  // Enable all interrupts.
  Enable_global_interrupt();

  pdca_enable_interrupt_reload_counter_zero(PDCA_CHANNEL_RXUSART);

  pdca_enable(PDCA_CHANNEL_RXUSART);

  InitSuccess = BT_TRUE;

	return fatalError;
}


/*===========================================================================
*	Function:	
*	Description:
*	Returns:	
*===========================================================================*/
void BTTL_UartPlatformGetSharedVarAccess(void)
{
	/*
	 * Get access to shared variables
	 */
  if( xSemaphoreTake( mutexSharedVar, ( portTickType ) portMAX_DELAY ) != pdTRUE )
  {
    /*
     * Did not get access to variables
     */
    BT_FatalError(BTTL_UART_ERR_OS_CALL);
  }

  
}

/*===========================================================================
*	Function:	
*	Description:
*	Returns:	
*===========================================================================*/
void BTTL_UartPlatformReleaseSharedVarAccess(void)
{
		/*
		 * Release access to shared variables
		 */
    xSemaphoreGive( mutexSharedVar );

}

/*===========================================================================
*	Function:	BTTL_UartPlatformIssueWrite
*	Description:Transfers data to port				
*	Returns:	Returns BT_OK if write was successful, otherwise BT_CONGESTED	
*===========================================================================*/
TxStatus BTTL_UartPlatformIssueWrite(const BT_U8 *content, BT_U16 bytesToWrite)
{
  BT_U8 i = 0;

  if( xSemaphoreTake( xUARTAccess, ( portTickType ) portMAX_DELAY ) == pdTRUE )
  {   
    if( bytesToWrite != 0 )
    {

      for( i = 0; i < bytesToWrite; i++ )
      {
        TX_buffer[i] = *(content + i);
      }

      pdca_load_channel(PDCA_CHANNEL_TXUSART
         , (void *)&TX_buffer[0]
         , bytesToWrite);

      pdca_enable_interrupt_transfer_complete(PDCA_CHANNEL_TXUSART);

      pdca_enable(PDCA_CHANNEL_TXUSART);
    }
  }
  return TX_COMPLETE;
}


/*===========================================================================
*	Function:	BTTL_UartPlatformIssueRead
*	Description:Issues a read from port. Activated once at startup
*				and after every incoming message from Host Controller.
*	Returns:	-										
*===========================================================================*/
RxStatus BTTL_UartPlatformIssueRead(BT_U16 length, BT_U8* buffer)
{
  BT_U16 first_buffsize,second_buffsize;

  first_buffsize = rx_Aptr.end_ptr - rx_Aptr.start_ptr;
  second_buffsize = rx_Aptr1.end_ptr - rx_Aptr1.start_ptr;

  if( DMAbuffer_ptr == &RX_buffer[0] )
  {
    if( first_buffsize >= length  )
    { 
      memcpy( buffer, &RX_buffer[rx_Aptr.start_ptr], length );
      rx_Aptr.start_ptr += length;

      /* to fix pointer overlap issue */
      if( rx_Aptr.start_ptr >= RX_BUFFSIZE )
      {
        memset( &rx_Aptr, 0, sizeof(rx_Aptr));
        DMAbuffer_ptr = &RX_buffer1[0];
      }

      return RX_COMPLETE;
    }
    else if( rx_Aptr.end_ptr == RX_BUFFSIZE )
    {  
      if( (first_buffsize + second_buffsize) >= length )
      {
        memcpy( buffer
          , &RX_buffer[rx_Aptr.start_ptr]
          , first_buffsize);
        memset( &rx_Aptr, 0, sizeof(rx_Aptr));

        memcpy( (buffer + first_buffsize )
          , &RX_buffer1[rx_Aptr1.start_ptr]
          , length - first_buffsize);
        rx_Aptr1.start_ptr += (length - first_buffsize);

        DMAbuffer_ptr = &RX_buffer1[0];        
        return RX_COMPLETE;
      }
    }
  }
  else if( DMAbuffer_ptr == &RX_buffer1[0] )
  {
    if( second_buffsize >= length  )
    { 
      memcpy( buffer, &RX_buffer1[rx_Aptr1.start_ptr], length );
      rx_Aptr1.start_ptr += length;

      /* to fix pointer overlap issue */
      if( rx_Aptr1.start_ptr >= RX_BUFFSIZE )
      {
        memset( &rx_Aptr1, 0, sizeof(rx_Aptr1));
        DMAbuffer_ptr = &RX_buffer[0];
      }

      return RX_COMPLETE;
    }
    else if( rx_Aptr1.end_ptr == RX_BUFFSIZE )
    {  
      if( (first_buffsize + second_buffsize) >= length )
      {
        memcpy( buffer
          , &RX_buffer1[rx_Aptr1.start_ptr]
          , second_buffsize);
        memset( &rx_Aptr1, 0, sizeof(rx_Aptr1));

        memcpy( (buffer + second_buffsize)
          , &RX_buffer[rx_Aptr.start_ptr]
          , length - second_buffsize);
        rx_Aptr.start_ptr += (length - second_buffsize); 

        
        DMAbuffer_ptr = &RX_buffer[0];        

        return RX_COMPLETE;
      }
    }
  }

  requested_loc = buffer;
  requested_size = length;
  return RX_IN_PROGRESS;
 
}
/*===========================================================================
*	Function:	BTTL_UartPlatformMsgHandler									
*	Description:Message handler for extensions made in pc version
*				of UART transport
*	Returns:	BT_OK if successful, otherwise BT_CONGESTED.			
*===========================================================================*/
BT_Result BTTL_UartPlatformMsgHandler(BT_DEPRECATED_MSG_CONST BT_Msg *msg)
{
#if 0
	BTTL_UartPcReqResp	*m = (BTTL_UartPcReqResp*)msg;
	BT_Result			result = BT_OK;
		
	switch ( m->header.primitive )
	{
	case BTTL_ERICSSON_BR_REQ:
		senderOfBrPrimitive = m->header.sender;
		result = EricssonChangeBaudRate( m->changeBrReq.command );
		break;

	default:
		if ( applicationUartMsgHandler	!= 0 )
		{
			result = applicationUartMsgHandler(msg);
		}
		else
		{
			result = BT_CALL_ERROR;
		}
		break;
	}
	
	return result;
#endif
  return BT_OK;
}
/*===========================================================================
*	Function:	BTTL_UartPlatformTxCompleteHook
*	Description:
*===========================================================================*/
void BTTL_UartPlatformTxCompleteHook(void)
{
#if 0
	/*
	 * One packet was sent. If it was change baudrate
	 * change baudrate of driver
	 */
	if ( changeBaudRateOnTxComplete )
	{
		changeBaudRateOnTxComplete = BT_FALSE;
		BTTL_UartPlatformSleep(50);
		BTTL_UartPlatformChangeDriverBaudrate(newBaudRate);
	}
#endif
}

/*===========================================================================
*	Function:	BTTL_UartPlatformEventRxHook
*	Description:
*===========================================================================*/
BT_BOOL	BTTL_UartPlatformEventRxHook(BT_U8 *event)
{
#if 0
	BTTL_UartPcIndConf	m;
	BT_BOOL handledEvent = BT_FALSE;

	
	/*
	 * Call the application specific event rx hook if any.
	 * Always continue with the platform specific hook if 
	 * the application specific return BT_FALSE
	 */
	if ( applicationEventRxHook )
	{
		handledEvent = applicationEventRxHook(event);
	}

	/*
	 * If this is the HCI_ERICSSON_SET_UART_BAUD_RATE_COMPLETE_EVENT
	 * event, replace it with the custom message BTTL_ERICSSON_BR_IND
	 */
	if (	!handledEvent
		 && event[0] == 0x04		/* event packet type */
		 && event[1] == 0x0e		/* command complete */
		 && event[4] == ERICSSON_BAUD_RATE_OCF 
		 && event[5] == ERICSSON_BAUD_RATE_OGF )
	{
		/* Response for Ericsson_Set_Uart_Baud_Rate command */
		m.changeBrInd.header.sender = BT_TL;
		m.changeBrInd.header.receiver = senderOfBrPrimitive;
		m.changeBrInd.header.primitive = BTTL_ERICSSON_BR_IND;

	   /*
		* The change of baudrate was successful since Host and
		* Host Controller are still synchronised. Send notification
		* to the sender of BTTL_ERICSSON_BR_REQ
		*/
		BTTL_UartBlockingInvoke( (BT_Msg*)&m );
		
		handledEvent = BT_TRUE;
	}

	return handledEvent;
#endif
   /* uart sniffer need to implement here */


   /* event was not handle by uart */
  return BT_FALSE;
}
#if 0

/*===========================================================================
*	Function:	BTTL_UartPlatformChangeDriverBaudrate
*	Description:
*	Returns:	-										
*===========================================================================*/
void BTTL_UartPlatformChangeDriverBaudrate(BT_U32 baudRate)
{
	GetCommState( comPortHandle, &portDCB );	
	portDCB.BaudRate = (unsigned long) baudRate;	
	
	if ( !SetCommState( comPortHandle, &portDCB ) )
	{
		DWORD error = GetLastError();
		LOG_INFO((BT_TL,
				"Different baudrates on controller and port!\n" ));
		BT_FatalError( BTTL_UART_ERR_OS_CALL );
	}
}
#endif

#ifdef BT_ENABLE_TRACE
/*===========================================================================
*	Function:		BTTL_UartPlatformMsgImage
*	Description:	Image function for extensions made for this
*					platform only
*===========================================================================*/
BT_U16 BTTL_UartPlatformMsgImage(const BT_Msg *msg, MsgImageType imgType, 
						char *imgBuffer, BT_U16 bufSize)
{
#if 0
	int			size = 0;
	BTTL_PcMsg	*m = (BTTL_PcMsg*)msg;

	switch (msg->header.primitive )
	{
	case BTTL_ERICSSON_BR_REQ:
		if (imgType == MSGIMG_PRIMITIVE)
		{
			size += sprintf(imgBuffer + size, "BTTL_ERICSSON_BR_REQ" );
		}
		else
		{
			size += sprintf(imgBuffer+size,"baudrate: %d\n",
							m->reqResp.commandReq.command);
		}
		break;

	case BTTL_ERICSSON_BR_IND:
		if ( imgType == MSGIMG_PRIMITIVE )
		{
			size = sprintf(imgBuffer, "BTTL_ERICSSON_BR_IND" );
		}
		else
		{
			size = 0;
		}
		break;
	}
	
	return (BT_U16)size;
#endif
}

#endif

#if 0
/*****************************************************************************/
/* Private tasks                                                             */
/*****************************************************************************/
/*===========================================================================
*	Function:	EventHandlerThread
*	Description:Entry point for the EventHandlerThread. Waits for completed read 
*				transfer and/or completed write transfer from/to port.
*	Returns:	The thread is never exited.
*===========================================================================*/
static BT_U32 EventHandlerThread(void)
{
	BT_U32		waitFor;
	BT_U32		noOfObjects = 0;
	BT_U32		bytesRead;
	BT_U32		error = 0;
	BT_U32		bytesWritten;	
	int			res;
	HANDLE		waitObjects[4];
	DWORD		commEvents;
	BT_U32		osResult;
	COMSTAT		comStat;
	DWORD		serialError;
	BT_Result	result = BT_OK;

	/* 
	 * There will always be a Rx, Tx event and semaphore in waitObject 
	 */
	waitObjects[0] = handleInputSema;
	waitObjects[1] = overlappedRxD.hEvent;
	waitObjects[2] = overlappedTxD.hEvent;

	/* 
	 * Start reading events/data
	 */
	if ( BTTL_UartPlatformIssueRead( 1, &BTTL_uartReadBuffer[0] )
		== RX_COMPLETE)
	{
		BTTL_UartReadComplete();
	}


	/* 
	 * overlappedRxD/TxD is signaled when the read/write transfer is
	 * completed. WaitForMultipleObjects is then signaled and the data
	 * on the port is dealt with/the variable writeInProgress is updated.
	 * If an issued read from the port succeeded immediately, the semaphore
	 * handleInputSema is signaled and the data on the port is taken care 
	 * of.
	 */
	
	for ( ;; )
	{
		/* 
		 * Issue a status event check if not already done 
		 */
		if ( !waitingOnStat )
		{
			if ( !WaitCommEvent( comPortHandle, &commEvents, &serialStatus ) )
			{
				if ( ( error = GetLastError() ) == ERROR_IO_PENDING )
				{
					waitObjects[3] = serialStatus.hEvent;
					waitingOnStat = BT_TRUE;
				}
				else
				{
					LOG_INFO(( BT_TL,
						"Could not add CommEvent as waitObject, error: %d\n",
						 error )); 
				}
			}
			else if ( commEvents & EV_ERR )
			{
				HandleEvErr();
			}
		}
		
		if ( waitingOnStat )
		{
			noOfObjects = 4;
		}
		else
		{
			noOfObjects = 3;
		}


		/* 
		 * Wait for Rx, Tx or CommError 
		 */
		waitFor = WaitForMultipleObjects( noOfObjects, waitObjects, 
										BT_FALSE, INFINITE ); 
		error = 0;

		switch ( waitFor )
		{
		case WAIT_OBJECT_0:
			/* 
			 * handleInputSema was released, the issued read was
			 * completed immediately and is dealt with here.
			 */
			BTTL_UartReadComplete();
			break;

		case WAIT_OBJECT_0 + 1:
			/* 
			 * Got Rx event, an async read has completed
			 */

			if ( (res = GetOverlappedResult( comPortHandle, &overlappedRxD, 
									   &bytesRead, FALSE )) == 0 )
			{
				error = GetLastError();
			}
			ResetEvent( overlappedRxD.hEvent );

			if ( res == 0 )
			{
				LOG_INFO(( BT_TL,
					"Rx event error in WAIT_OBJECT_0+1: %d\n", error ));

				if( error > 0 
					&& !ClearCommError( comPortHandle, &serialError, &comStat ) )
				{
					BT_FatalError( BTTL_ERR_RX_EVENT );
				}
			}
			else if ( bytesRead > 0 )
			{
				BTTL_UartReadComplete();
			}
			break;

		case WAIT_OBJECT_0 + 2:
			/* 
			 * Got Tx event, an async tx has completed
			 */

			if ( (res = GetOverlappedResult( comPortHandle, &overlappedTxD, 
									 &bytesWritten, FALSE )) == 0 )
			{
				error = GetLastError();
			}
			ResetEvent( overlappedTxD.hEvent ); 

			if ( res == 0 )
			{
				LOG_INFO(( BT_TL,"Tx event error in WAIT_OBJECT_0+2: %d\n", 
							error ));

				if ( error > 0 
					&& !ClearCommError( comPortHandle, &serialError, &comStat ) )
				{
						BT_FatalError( BTTL_ERR_TX_EVENT );
				}
			}
			else
			{
				BTTL_UartWriteComplete();
			}

			break;

		case WAIT_OBJECT_0 + 3:
			/* 
			 * COM port error event 
			 */
			
			if ( (res = GetOverlappedResult( comPortHandle, &serialStatus, 
									 &osResult, FALSE )) == 0 )
			{
				/* error in GetOverlappedResult */
				error = GetLastError();
			}
			ResetEvent( serialStatus.hEvent );

			if ( res == 0 )
			{
				LOG_INFO(( BT_TL, 
					"GetOverlappedResult error in WAIT_OBJECT_0+3  %d\n",
					 error ));
			}
			else
			{
				HandleEvErr();
			}
			break;

		default:
			error = GetLastError();
			LOG_INFO(( BT_TL,"WaitForMultipleObjects error %d\n",error ));
			break;

		}/* switch */
	}/* for ( ;; ) */
}

/*****************************************************************************/
/* Private functions                                                         */
/*****************************************************************************/

/*===========================================================================
*	Function:	HandleEvErr
*	Description:Handles a line status error event.				
*	Returns:	-	
*===========================================================================*/
static void HandleEvErr(void)
{
	DWORD		serialError;
	COMSTAT		comStat;
	BT_BOOL		fFrame, fRxOver, fOverRun, fIoe, fTxFull, fBreak;
	
	if ( !ClearCommError( comPortHandle, &serialError, &comStat ) )
	{
		BT_FatalError( BTTL_ERR_COMM_EVENT );
	}
	fRxOver		= (serialError & CE_RXOVER)		!= 0;
	fOverRun	= (serialError & CE_OVERRUN)	!= 0;
	fIoe		= (serialError & CE_IOE)		!= 0;
	fTxFull		= (serialError & CE_TXFULL)		!= 0;
	fFrame		= (serialError & CE_FRAME)		!= 0;
	fBreak		= (serialError & CE_BREAK)		!= 0;

	LOG_INFO(( BT_TL,"Comm error event: 0x%02x\n"
			"  CE_BREAK:   %d\n"
			"  CE_RXOVER:  %d\n"
			"  CE_OVERRUN: %d\n"
			"  CE_FRAME:   %d\n"
			"  CE_IOE:     %d \n"
			"  CE_TXFULL:  %d\n",

			serialError,
			fBreak, fRxOver, fOverRun, fFrame, fIoe, fTxFull ));
	
	if ( fRxOver || fOverRun || fFrame || fIoe || fTxFull )
	{
		LOG_INFO(( BT_TL,
			"For more information on windows comm port problems, see MSDN documents Q131016 and Q79988 \n" ));
	}

	waitingOnStat = BT_FALSE;

	//BTTL_UartSendReset();
        /* Change to this interface as we need to do a soft reset 
            instead of Mecel Reset */
        BT_FatalError( BTTL_ERR_HARDWARE );        

}


/*===========================================================================
*	Function:	StartEventHandlerThread
*	Description:Start the module. Executes the thread. 
*	Returns:	BT_OK if successful, otherwise BT_FAILED.	
*===========================================================================*/
static BT_U16 StartEventHandlerThread(void)
{
	HANDLE			threadHandle;
	BT_U32			threadId;
	BT_U8			threadStackSize = 0;
	BT_U16			fatalError = 0;

	/* Create thread */
	if ( (threadHandle = CreateThread( 0, threadStackSize,
									(LPTHREAD_START_ROUTINE) EventHandlerThread, 0,
									CREATE_SUSPENDED, &threadId )) == 0 )
	{
		fatalError = BTTL_UART_ERR_OS_RESOURCE;
	}

	/* Set thread priority */
	else if ( SetThreadPriority( threadHandle, 
								THREAD_PRIORITY_NORMAL ) == 0 )
	{
		fatalError = BTTL_UART_ERR_OS_CALL;
	}

	/* Execute thread */
	else if ( ResumeThread( threadHandle ) == -1 )
	{
		fatalError = BTTL_UART_ERR_OS_CALL;
	}

	return fatalError;
}


/*===========================================================================	
*	Function:	ModifyDCB
*	Description:Configures the Device Control Block				
*	Returns:	BT_OK if configuration succeded, otherwise BT_FAILED.	
*===========================================================================*/
static BT_Result ModifyDCB(DCB *port, BT_U32 baudrate, DWORD rtsControl)
{
	
	ZeroMemory( port, sizeof(DCB) );

	/* Initialize the DCBlength member. */
	port->DCBlength = sizeof (DCB); 

	/* Get the default port setting information. */
	GetCommState ( comPortHandle, port );

	/* Change the DCB structure settings. */
	port->BaudRate = baudrate;				/* Current baud */ 
	port->fBinary = BT_TRUE;					/* Binary mode; no EOF check */ 
	port->fParity = BT_FALSE;					/* Disable parity checking */ 
	port->fOutxCtsFlow = BT_TRUE;				/* CTS output flow control */ 
	port->fOutxDsrFlow = BT_FALSE;				/* No DSR output flow control */ 
	port->fDtrControl = DTR_CONTROL_DISABLE; 
											/* DTR flow control type */ 
	port->fDsrSensitivity = BT_FALSE;			/* DSR sensitivity */ 
	port->fTXContinueOnXoff = BT_FALSE;		/* XOFF continues Tx */ 
	port->fOutX = BT_FALSE;					/* No XON/XOFF out flow control */ 
	port->fInX = BT_FALSE;						/* No XON/XOFF in flow control */ 

	port->fErrorChar = BT_FALSE;				/* Disable error replacement */ 
	port->fNull = BT_FALSE;					/* Disable null stripping */ 

											/* 
											 * CTS low when when number
											 * of free bytes in device
											 * buffer is less than XoffLim
											 */
	port->XoffLim = BTTL_uartMaxRxPacketSize*(TIMESPACKETSIZE - 1);
									
											/*
											 * CTS set when # of bytes in 
											 * buffer less than XonLim
											 */
	port->XonLim = BTTL_uartMaxRxPacketSize*(TIMESPACKETSIZE - 1); 
	 										
	port->fRtsControl = rtsControl; 		/* RTS flow control */ 
	port->fAbortOnError = BT_FALSE;;				/* Do not abort reads/writes on 
											 * error
											 */
	port->ByteSize = 8;						/* Number of bits/byte, 4-8 */ 
	port->Parity = NOPARITY;				/* 0-4=no,odd,even,mark,space */ 
	port->StopBits = ONESTOPBIT;				/* 0,1,2 = 1, 1->5, 2 */ 
	
	/*
	 * Configure the port according to the specifications of the DCB 
	 * structure.
	 */
	if ( SetCommState ( comPortHandle, port ) == 0 )
	{
		return BT_FAILED;
	}
	else
	{
		return BT_OK;
	}

}

/*===========================================================================
*	Function:	EricssonChangeBaudRate										
*	Description:Changes the baudrate of controller and host
*	Returns:	BT_OK if successful, otherwise BT_FAILED.				 																			 
*===========================================================================*/
static BT_Result EricssonChangeBaudRate(BT_U32 baudRate)
{
	BT_Result		result = BT_OK;
	BT_U8			buffer[4] = {0x09, 0xfc, 0x01, 0x00};

	/* 
	 * Encode the specified baud rate 
	 */
	switch ( baudRate )
	{
	case 300:
		buffer[3] = 0x19;
		break;

	case 600:
		buffer[3] = 0x18;
		break;

	case 900:
		buffer[3] = 0x09;
		break;

	case 1200:
		buffer[3] = 0x17;
		break;

	case 1800:
		buffer[3] = 0x08;
		break;

	case 2400:
		buffer[3] = 0x16;
		break;

	case 3600:
		buffer[3] = 0x07;
		break;

	case 4800:
		buffer[3] = 0x15;
		break;

	case 7200:
		buffer[3] = 0x06;
		break;

	case 9600:
		buffer[3] = 0x14;
		break;

	case 14400:
		buffer[3] = 0x05;
		break;

	case 19200:
		buffer[3] = 0x13;
		break;

	case 28800:
		buffer[3] = 0x04;
		break;

	case 38400:
		buffer[3] = 0x12;
		break;

	case 57600:
		buffer[3] = 0x03;
		break;

	case 76800:
		buffer[3] = 0x11;
		break;

	case 115200:
		buffer[3] = 0x02;
		break;

	case 153600:
		buffer[3] = 0x10;
		break;

	case 230400:
		buffer[3] = 0x01;
		break;

	case 460800:
		buffer[3] = 0x00;
		break;

	default:
		result = BT_CALL_ERROR;
		break;
	}

	if ( result == BT_OK )
	{
		BTTL_UartTxQueueFlush();

		/* 
		 * Setup flag to change device baudrate
		 * on tx complete.
		 * Send HCI Reset command to Controller 
		 */
		newBaudRate					= baudRate;
		changeBaudRateOnTxComplete	= BT_TRUE;
		
		(void)BTTL_UartTxQueueAddTail( buffer, HCI_COMMAND, 5 );
	}

	return result;
}
#endif

/*===========================================================================
*	Function:	    pdca_Rxinterrupt										
*	Description:  Incoming and outgoing uart interrupt will come here
*	Returns:	    non			 																			 
*===========================================================================*/
#if __GNUC__
	__attribute__((__naked__))
#elif __ICCAVR32__
	#pragma shadow_registers = full   // Naked.
#endif
static void pdca_Rxint_handler( void )
{
  /* This ISR can cause a context switch, so the first statement must be a
  call to the MPP_OS_ENTER_SWITCHING_ISR macro.  This must be BEFORE any
  variable declarations. */
  portENTER_SWITCHING_ISR();
  
  pdca_Rxinterrupt();
  
  /* Exit the ISR.  If a task was woken by either a character being received
  or transmitted then a context switch will occur. */
  portEXIT_SWITCHING_ISR()
}

/*===========================================================================
*	Function:	    pdca_Rxinterrupt										
*	Description:  Incoming and outgoing uart interrupt will come here
*	Returns:	    non			 																			 
*===========================================================================*/
#if __GNUC__
	__attribute__((__naked__))
#elif __ICCAVR32__
	#pragma shadow_registers = full   // Naked.
#endif
static void pdca_Txint_handler( void )
{
  /* This ISR can cause a context switch, so the first statement must be a
  call to the MPP_OS_ENTER_SWITCHING_ISR macro.  This must be BEFORE any
  variable declarations. */
  portENTER_SWITCHING_ISR();
  
  pdca_Txinterrupt();
  
  /* Exit the ISR.  If a task was woken by either a character being received
  or transmitted then a context switch will occur. */
  portEXIT_SWITCHING_ISR()
}

/*===========================================================================
*	Function:	    pdca_Rxinterrupt										
*	Description:  Send and Receive incoming and outgoing message
*	Returns:	    non			 																			 
*===========================================================================*/
static void pdca_Rxinterrupt(void)
{
  volatile avr32_pdca_channel_t *pdca_channel = pdca_get_handler(PDCA_CHANNEL_RXUSART);

  if((unsigned long)&RX_buffer[0] <= pdca_channel->mar
    && pdca_channel->mar <= (unsigned long)&RX_buffer[RX_BUFFSIZE - 1] )
  {
    pdca_reload_channel(PDCA_CHANNEL_RXUSART
      , (void *)RX_buffer1
      , sizeof(RX_buffer1) );
    DMACurrentbuffer_ptr = &RX_buffer[0];
  }
  else if((unsigned long)&RX_buffer1[0] <= pdca_channel->mar
    && pdca_channel->mar <= (unsigned long)&RX_buffer1[RX_BUFFSIZE - 1] )
  {
    pdca_reload_channel(PDCA_CHANNEL_RXUSART
      , (void *)RX_buffer
      , sizeof(RX_buffer) );
    DMACurrentbuffer_ptr = &RX_buffer1[0];
  }
}

/*===========================================================================
*	Function:	    pdca_Txinterrupt										
*	Description:  Send and Receive incoming and outgoing message
*	Returns:	    non			 																			 
*===========================================================================*/
static void pdca_Txinterrupt(void)
{
  portBASE_TYPE xHigherPriorityTaskWoken = pdFALSE;

  pdca_disable_interrupt_transfer_complete(PDCA_CHANNEL_TXUSART);
  xSemaphoreGiveFromISR(xUARTAccess, (&xHigherPriorityTaskWoken));
}


/*===========================================================================
*	Function:	    uart_interrupt_handler										
*	Description:  uart interrupt handler
*	Returns:	    non			 																			 
*===========================================================================*/
#if __GNUC__
	__attribute__((__naked__))
#elif __ICCAVR32__
	#pragma shadow_registers = full   // Naked.
#endif
static void uart_interrupt_handler( void )
{
  /* This ISR can cause a context switch, so the first statement must be a
  call to the MPP_OS_ENTER_SWITCHING_ISR macro.  This must be BEFORE any
  variable declarations. */
  portENTER_SWITCHING_ISR();
  
  uart_interrupt();
  
  /* Exit the ISR.  If a task was woken by either a character being received
  or transmitted then a context switch will occur. */
  portEXIT_SWITCHING_ISR()
}

/*===========================================================================
*	Function:	    uart_interrupt										
*	Description:  uart interrupt
*	Returns:	    non			 																			 
*===========================================================================*/
static void uart_interrupt(void)
{
  volatile avr32_usart_t *usart = EXAMPLE_USART;

  enter_critical2();

  /* Check for Error */
  if (usart->csr & (AVR32_USART_CSR_OVRE_MASK 
                    | AVR32_USART_CSR_FRAME_MASK 
                    | AVR32_USART_CSR_PARE_MASK
                    | AVR32_USART_CSR_RXBRK_MASK ))
  {
    /* Reset Error */
    EXAMPLE_USART->cr = AVR32_USART_RSTSTA_MASK;
  }

  exit_critical2(0);
}

/*===========================================================================
*	Function:	    BTTL_uartPlatform1ms										
*	Description:  Pooling method to get complete message into mecel stack
*	Returns:	    non			 																			 
*===========================================================================*/
void BTTL_uartPlatform1ms(void)
{
  BT_U16 first_buffsize,second_buffsize;
  BT_U32 buffer_address;

  if( InitSuccess != BT_TRUE ) return;

  enter_critical2();

  if( DMACurrentbuffer_ptr == &RX_buffer[0] )
  {
    buffer_address = (BT_U32)&RX_buffer[0];
    rx_Aptr.end_ptr = RX_BUFFSIZE - pdca_get_load_size(PDCA_CHANNEL_RXUSART);

    /* This condition happen when DMA swapping buffer half way */
    if( rx_Aptr.end_ptr == 0 && rx_Aptr.start_ptr != 0 )
    {
      rx_Aptr.end_ptr = RX_BUFFSIZE;
    }
  }
  else
  {
    buffer_address = (BT_U32)&RX_buffer1[0];
    rx_Aptr1.end_ptr = RX_BUFFSIZE - pdca_get_load_size(PDCA_CHANNEL_RXUSART);

    /* This condition happen when DMA swapping buffer half way */
    if( rx_Aptr1.end_ptr == 0 && rx_Aptr1.start_ptr != 0 )
    {
      rx_Aptr1.end_ptr = RX_BUFFSIZE;
    }
  }
  exit_critical2();

  if( DMAbuffer_ptr == &RX_buffer[0] && buffer_address != (BT_U32)&RX_buffer[0])
  {
    rx_Aptr.end_ptr = RX_BUFFSIZE;
  }
  else if( DMAbuffer_ptr == &RX_buffer1[0] && buffer_address != (BT_U32)&RX_buffer1[0])
  {
     rx_Aptr1.end_ptr = RX_BUFFSIZE;
  }
    
  first_buffsize = rx_Aptr.end_ptr - rx_Aptr.start_ptr;    
  second_buffsize = rx_Aptr1.end_ptr - rx_Aptr1.start_ptr;
  
  if( DMAbuffer_ptr == &RX_buffer[0] )
  {  
    if( first_buffsize >= requested_size  )
    { 
      if( requested_loc == NULL ) requested_loc = &BTTL_uartReadBuffer[0];

      memcpy( requested_loc, &RX_buffer[rx_Aptr.start_ptr], requested_size );
      rx_Aptr.start_ptr += requested_size;

      /* to fix pointer overlap issue */
      if( rx_Aptr.start_ptr >= RX_BUFFSIZE )
      {
        memset( &rx_Aptr, 0, sizeof(rx_Aptr));
        DMAbuffer_ptr = &RX_buffer1[0];
      }
      
      BTTL_UartReadComplete();
    }
    else if( buffer_address == (BT_U32)&RX_buffer1[0] )
    {
      if( (first_buffsize + second_buffsize) >= requested_size )
      {
        memcpy( requested_loc
          , &RX_buffer[rx_Aptr.start_ptr]
          , first_buffsize);
        memset( &rx_Aptr, 0, sizeof(rx_Aptr));

        memcpy( (requested_loc + first_buffsize)
          , &RX_buffer1[rx_Aptr1.start_ptr]
          , requested_size - first_buffsize);
        rx_Aptr1.start_ptr += (requested_size - first_buffsize);


        DMAbuffer_ptr = &RX_buffer1[0];
        BTTL_UartReadComplete();
      }
    }
  }
  else if ( DMAbuffer_ptr == &RX_buffer1[0] )
  {
    if( second_buffsize >= requested_size  )
    { 
      if( requested_loc == NULL ) requested_loc = &BTTL_uartReadBuffer[0];

      memcpy( requested_loc, &RX_buffer1[rx_Aptr1.start_ptr], requested_size );
      rx_Aptr1.start_ptr += requested_size;

      /* to fix pointer overlap issue */
      if( rx_Aptr1.start_ptr >= RX_BUFFSIZE )
      {
        memset( &rx_Aptr1, 0, sizeof(rx_Aptr1));
        DMAbuffer_ptr = &RX_buffer[0];
      }

      BTTL_UartReadComplete();
    }
    else if( buffer_address == (BT_U32)&RX_buffer[0] )
    {
      if( (first_buffsize + second_buffsize) >= requested_size )
      {
        memcpy( requested_loc
          , &RX_buffer1[rx_Aptr1.start_ptr]
          , second_buffsize);
        memset( &rx_Aptr1, 0, sizeof(rx_Aptr1));

        memcpy( (requested_loc + second_buffsize)
          , &RX_buffer[rx_Aptr.start_ptr]
          , requested_size - second_buffsize);
        rx_Aptr.start_ptr += (requested_size - second_buffsize);        

        DMAbuffer_ptr = &RX_buffer[0];
        BTTL_UartReadComplete();
      }
    }
  }
}

/*****************************************************************************/
/* Callback or Interrupt functions                                           */
/*****************************************************************************/
   
