/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: usb_main.c
#
# --------------------------- General Description -----------------------------
# This file contains the definitions of the USB CDC task.
#
# --------------------------- HEADER FILE INCLUDES ---------------------------*/

#include "usb_drv.h"

/*******************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR             Date Modified    Tracking Number     Description
* Phong Tran         03/18/2010       CCMPD01316656       Initial Creation
* Sevuhan Ramanathan 1/3/2011         CCMPD01594785       changed the name of the function usb_cdc_init to 
*                                                         usb_dev_mode_init,added loadDescriptors(),loadUsbConfigValues()
* WRN637		     9/11/2013        CCMPD01808031       REMOVE USB HID Support
*
*--------------------------- End of History Template----------------------------
* *****************************************************************************/

/*==============================================================================
                                      EXTERNAL DEFINITIONS
==============================================================================*/

/*==============================================================================
                                    GLOBAL VARIABLES
==============================================================================*/

/*==============================================================================
                                      EXTERNAL FUNCTIONS
==============================================================================*/
extern void usb_task_init(void);
extern void usb_init(void);

/*==============================================================================
                                      FUNCTION PROTOTYPES
==============================================================================*/

/*==============================================================================
                                      FUNCTION DEFINITIONS
==============================================================================*/

/*=============================================================================
	FUNCTION: usb_cdc_init

	DESCRIPTION: Inititize the task for the USB CDC.
	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/

void usb_cdc_init(void)
{
  // Initialize USB task
  usb_task_init();

  usb_init();

  Usb_enable_sof_interrupt();
}
