/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2013-2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: utilities.c
#
# --------------------------- General Description -----------------------------
#
#
#
#
********************************************************************************
* Abhishek Trivedi  09/03/2013                     XNL Host
* Abhishek Trivedi  04/04/2014    CCMPD01882874    Error Recovery 
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/
/* ***************************************************************************
                                HEADER INCLUDE FILES
   ************************************************************************** */
#include "utilities.h"
extern void fatal_error_reset(void);
/*=============================================================================
	FUNCTION: buffer_compare_indices

	DESCRIPTION: Compare Circular Buffer indices to see if there is any data 
                     present

	ARGUMENTS PASSED: Pointer to Source Buffer 

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: 
         
==============================================================================*/
success_failure_t buffer_compare_indices(data_buffer_struct_t * buffer_source_ptr)
{
  return ((buffer_source_ptr->in_buffer_index) != (buffer_source_ptr->out_buffer_index)) ? SUCC : FAILURE;
}

/*=============================================================================
	FUNCTION: buffer_write_and_increment_in_index

	DESCRIPTION: Add a byte to the data buffer and increment the
                     in index value.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: success_failure_t
==============================================================================*/
void buffer_write_and_increment_in_index(data_buffer_struct_t * buffer_to_write_ptr, UINT8_T byte_to_write)
{  
  buffer_to_write_ptr->data_buffer_array_ptr[(buffer_to_write_ptr->in_buffer_index)++] = byte_to_write;

  if (buffer_to_write_ptr->in_buffer_index >= buffer_to_write_ptr->buffer_size)
  {
          buffer_to_write_ptr->in_buffer_index = 0;
  }
}
/*=============================================================================
	FUNCTION: buffer_read_and_increment_out_index

	DESCRIPTION: Read a byte to the data buffer and increment the
                     out index value.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: return read_byte
==============================================================================*/
UINT8_T buffer_read_and_increment_out_index(data_buffer_struct_t * buffer_to_read_ptr)
{
  UINT8_T return_byte_read = 0x00;

  if (!buffer_compare_indices(buffer_to_read_ptr))
  {
    fatal_error_reset(); //FAILURE
  }  

  // Read Byte and Increment Out Index   
  return_byte_read = buffer_to_read_ptr->data_buffer_array_ptr[(buffer_to_read_ptr->out_buffer_index)++];

  // Check increment out index and reset if necessary 
  if(buffer_to_read_ptr->out_buffer_index >= buffer_to_read_ptr->buffer_size)
  {
    // Read all the bytes in buffer. Reset the index.
    buffer_to_read_ptr->out_buffer_index = 0;
  }
  return return_byte_read;
}

/*=============================================================================
	FUNCTION: buffer_read_byte_no_increment

	DESCRIPTION: Reads a byte from a buffer but does not increment the out
        pointer permanently. It uses an offset parameter to specify which byte
        to read.

	ARGUMENTS PASSED: none

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: return read_byte
==============================================================================*/
UINT8_T buffer_read_byte_no_increment(data_buffer_struct_t * buffer_to_read_ptr, UINT16_T offset)
{
  UINT16_T index = buffer_to_read_ptr->out_buffer_index + offset;

  // Make sure index is less than buffer's size, or else need to wrap around   
  if(index >= buffer_to_read_ptr->buffer_size)
  {
    index = index % buffer_to_read_ptr->buffer_size;
  }

  return buffer_to_read_ptr->data_buffer_array_ptr[index];
}
/*=============================================================================
	FUNCTION: buffer_increment_out_index

	DESCRIPTION: increment the out index value and discard the data.

	ARGUMENTS PASSED: pointer to the buffer, increment step value

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
void buffer_increment_out_index(data_buffer_struct_t * buffer_to_read_ptr, UINT16_T inc_value)
{
  UINT16_T i;
  for(i=0; i < inc_value; i++)
  {
    if(!buffer_compare_indices(buffer_to_read_ptr))
    {
      return; //FAILURE    
    }  
    (buffer_to_read_ptr->out_buffer_index)++;
    if(buffer_to_read_ptr->out_buffer_index >= buffer_to_read_ptr->buffer_size)
    {
      // Read all the bytes in buffer. Reset the index.
      buffer_to_read_ptr->out_buffer_index = 0;
    }
  }
}

/*=============================================================================
	FUNCTION: buffer_get_size_of_new_data

	DESCRIPTION: returns how many new bytes are in the buffer

	ARGUMENTS PASSED: pointer to the buffer

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
==============================================================================*/
UINT8_T buffer_get_size_of_new_data (data_buffer_struct_t * buffer_to_read_ptr)
{
  if (buffer_to_read_ptr->in_buffer_index >= buffer_to_read_ptr->out_buffer_index)
  {
    return buffer_to_read_ptr->in_buffer_index - buffer_to_read_ptr->out_buffer_index;
  }
  else
  {
    return buffer_to_read_ptr->buffer_size - buffer_to_read_ptr->out_buffer_index + buffer_to_read_ptr->in_buffer_index;
  }
}