#ifndef VERSION_STRING_H
#define VERSION_STRING_H

/*################################################################################
#
# 						FILE SPECIFICATION
# 					COPYRIGHT 2011,2014-2015 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#						MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: version_string.h
#
# --------------------------- General Description -----------------------------
# This file is to be included by Atmel and CSR firmware builds to ensure
# that each firmware check the version string for a match before allowing
# execution.
#*/
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified	CR Tracking Number 	Description
* NAME		    MM/DD/YYYY   	CCMPD##########		Initial Creation
*
* JJ Low   	    11/04/2010		CCMPD01410055   	Initial Creation
* JJ Low   	    11/09/2010		N/A
* JJ Low   	    11/26/2010		N/A
* JJ Low   	    12/03/2010		N/A
*--------------------------- End of History Template-----------------------------
* *********************************************************************************/


/********************************************************************
D (development - internal to Motorola, external to software development team)
I (iteration - internal to software development team)
A (alpha - external to software, internal to Motorola)
B (beta - external to Motorola, for field testing &
          release to Software Box Test, for Software Box Testing)
R (release - final release to customer)
S (special - special release to customer)
U (undetermined - other special releases not necessarily
                  needing a branch)
********************************************************************/


typedef struct{
  unsigned char VersionType;
  unsigned char Iteration;
  unsigned char MajorVersion;
  unsigned char MinorVersion;
} versionType;


#define CURRENT_VERSION_IDENTIFIER       'R'
#define CURRENT_VERSION_PHASE 0x1
#define CURRENT_VERSION_MAJOR 0x15
#define CURRENT_VERSION_MINOR 0x0

#endif
