#ifndef XCMP_H
#define XCMP_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp.h
#
# --------------------------- General Description -----------------------------
# This is the xcmp_main header file.  This file contains basic type definitions, macros
# and constants to be used to implement xcmp. 
#
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/

#include "config.h"
#include "utilities.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
*   AUTHOR              Date Modified         Tracking Number         Description
* Abhishek Trivedi      09/02/2013            CCMPD01827271       XCMP Interfaces
* Abhishek Trivedi      03/18/2014	      CCMPD01873731	  Resolve 2 device connection issue
* Abhishek Trivedi      06/05/2014            CCMPD01900617       Version Request Support
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/
//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
#define XCMP_MSG_UNSUPPORT_REPLY_MIN_SIZE	3

/* Defines of Handle unsupported request from Radio */
#define XCMP_MSG_OPCODE_REPLY                 0x8000
#define UNSUPPORTED_MSG_REPLY_XCMP_PAYLOAD    0x03
#define XCMP_MSG_REQUEST_OPCODE_MASK          0xF000
#define UNSUPPORTED_MSG_REPLY_RESULT_CODE     0x03
#define INVALID_MSG_REPLY_RESULT_CODE         0x04
#define INVALID_MSG_REPLY_XCMP_PAYLOAD        0x04
#define MIN_INVALID_MSG_REPLY_XCMP_PAYLOAD    0x03
//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
typedef enum
{
  XCMP_FAILURE			= 0,  
  XCMP_SUCCESS			= 1,
  XCMP_INSUFFICIENT_DATA	= 2,
  XCMP_UNSUPPORTED_REQ		= 3
}xcmp_return_value_t;

typedef enum
{
  XCMP_MSG_RESULT_SUCCESS		= 0x00,
  XCMP_MSG_RESULT_FAILURE		= 0x01,
  XCMP_MSG_OPCODE_NOT_SUPPORTED		= 0x03,
  XCMP_MSG_RESULT_INVALID_PARAMETER	= 0x04,
  XCMP_MSG_FUNC_NOT_AVAILABLE		= 0x07,
  XCMP_MSG_RESULT_METHOD_NOT_SUPPORTED	= 0x10
}xcmp_reply_result_t;

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
xcmp_return_value_t xcmp_process_init(UINT8_T index, UINT16_T xnl_devid, data_buffer_struct_t *payload_data_ptr, UINT8_T payload_length);
xcmp_return_value_t xcmp_process_message(UINT16_T xnl_devid, data_buffer_struct_t *payload_data_ptr, UINT16_T payload_length);
UINT16_T xcmp_get_2bytes(void);

//Unsupported messages
success_failure_t xcmp_msg_tx_unsupported_xcmp_msg_reply(UINT16_T xnl_devid, UINT16_T unsupported_xcmp_opcode);
success_failure_t xcmp_msg_send_invalid_xcmp_msg_reply(UINT16_T xnl_devid, UINT16_T invalid_xcmp_parameter, UINT8_T echo_function, UINT8_T echo_reqd);

void xcmp_msg_rx_unsupported_xcmp_msg_request(UINT16_T xnl_devid, UINT16_T unsupported_xcmp_opcode);
void received_invalid_xcmp_msg(UINT16_T xnl_devid, UINT16_T xcmp_opcode);
#endif // XCMP_MAIN_H
