#ifndef XCMP_MSG_BATT_LVL_H_
#define XCMP_MSG_BATT_LVL_H_

/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_batt_lvl.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Battery Level message.  It contains
# all the definitions for this specific message.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"

/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
*   AUTHOR              Date Modified			Tracking Number         Description
* Abhishek Trivedi       09/06/2013             CCMPD01827271          XNL-XCMP Host
*
*
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
/* Opcodes */
#define XCMP_MSG_OPCODE_BROADCAST_BATT_LVL              0xB410

#define XCMP_MSG_BATT_LVL_MSG_SIZE                      6

#define XCMP_BATTERY_OKAY				0x00
#define XCMP_BATTERY_LOW				0x01
#define XCMP_BATTERY_BLOCK_TX				0x02
#define XCMP_BATTERY_ABORT_TX				0x03
//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;
  UINT8_T   batt_state;
  UINT8_T   batt_charge;
  UINT16_T  batt_voltage;
} xcmp_msg_batt_lvl_broadcast_t;
#if __ICCAVR32__
#pragma pack()
#endif

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
   /*=============================================================================
	FUNCTION: xcmp_msg_rx_batt_lvl_broadcast()

	DESCRIPTION: Process a Battery Level Broadcast XCMP message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_batt_lvl_broadcast(UINT16_T xnl_devid, UINT8_T payload_length);

void received_xcmp_batt_lvl_msg_bdst(UINT16_T xnl_devid, xcmp_msg_batt_lvl_broadcast_t batt_lvl_bcast);
#endif // XCMP_MSG_BATT_LVL_H_