/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_bt_config.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Device Initialization messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR             Date Modified     Tracking Number         Description
* Abhishek Trivedi      09/06/2013       CCMPD01827271     XNL-XCMP Host
* Abhishek Trivedi      11/8/2013        CCMPD01834482     Updates for XNL-XCMP 
* Abhishek Trivedi      11/19/2013       CCMPD01836292     Fix the BT Config Broadcast message 
* Abhishek Trivedi      03/18/2014	 CCMPD01873731	   Resolve 2 device connection issue
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
  FUNCTION: xcmp_msg_tx_bt_config_reply()

  DESCRIPTION: This function sends the BlueTooth Config reply message. 
      Currently only supports the audio_accy_power_up_t structure optional data
==============================================================================*/
success_failure_t xcmp_msg_tx_bt_config_reply(UINT16_T xnl_devid, xcmp_reply_result_t result, UINT8_T function, 
											UINT8_T accy_type, UINT8_T pairing_timeout,
                                                                                        UINT8_T out_of_range_timeout, 
											UINT8_T bt_state, UINT8_T pairing_type)
{
    xcmp_msg_bt_cfg_reply_t outgoing_msg;
    UINT8_T message_size = BT_CONFIG_REPLY_AUDIO_PARAMS_MSG_SIZE;
  
    // Stuff the message
    outgoing_msg.opcode		= XCMP_MSG_OPCODE_REPLY_BT_CONFIG;
    outgoing_msg.result		= result;
    outgoing_msg.function	= function;
    if(function == XCMP_MSG_BT_POWER_UP_CONFIG)
    {
      //only supporting the audio_accy_power_up_t structure
      outgoing_msg.data[0]	= accy_type;
      outgoing_msg.data[1]	= pairing_timeout;
      outgoing_msg.data[2]	= out_of_range_timeout;
      outgoing_msg.data[3]      = 0x00;				// Audio gain - No data
      outgoing_msg.data[4]	= bt_state;			// 00:OFF/CPS OFF, 01:ON/CPS OFF, 02:OFF/CPS ON, 03:ON/CPS ON
      outgoing_msg.data[5]	= pairing_type;		// 01:Standard, 02:LF-MPP
      outgoing_msg.data[6]	= 0x00;                 // 2 bytes- power off delta                  
      outgoing_msg.data[7]	= 0x00;			// No data
      outgoing_msg.data[8]	= 0x00;				// BER Threshold - No data
      outgoing_msg.data[9]	= 0x00;				// Inquiry timeout - No data
      outgoing_msg.data[10]	= 0x00;				// Inquiry scan timeout -No data
      
      // XNL to send data
      return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REPLY);
    }
    else
    {
      return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, BT_CONFIG_REPLY_NO_DATA_MSG_SIZE, XNL_DATA_MSG_REPLY);  //Only message with the function, no optional data
    }
}
/*=============================================================================
  FUNCTION: xcmp_msg_tx_bt_config_bcast()

  DESCRIPTION: This function sends the BlueTooth Config Broadcast message. 
      Currently only supports the audio_accy_power_up_t structure optional data
==============================================================================*/
success_failure_t xcmp_msg_tx_bt_config_bcast(UINT16_T xnl_devid, UINT8_T function, 
                                                                  UINT8_T accy_type, UINT8_T pairing_timeout,
                                                                  UINT8_T out_of_range_timeout, 
                                                                  UINT8_T bt_state, UINT8_T pairing_type)
{
    xcmp_msg_bt_cfg_bcast_t outgoing_msg;
    UINT8_T message_size = BT_CONFIG_BCAST_AUDIO_PARAMS_MSG_SIZE;
  
    // Stuff the message
    outgoing_msg.opcode		= XCMP_MSG_OPCODE_BROADCAST_BT_CONFIG;
    outgoing_msg.function	= function;
    if(function == XCMP_MSG_BT_POWER_UP_CONFIG)
    {
      //only supporting the audio_accy_power_up_t structure
      outgoing_msg.data[0]	= accy_type;
      outgoing_msg.data[1]	= pairing_timeout;
      outgoing_msg.data[2]	= out_of_range_timeout;
      outgoing_msg.data[3]      = 0x00;				// Audio gain - No data
      outgoing_msg.data[4]	= bt_state;			// 00:OFF/CPS OFF, 01:ON/CPS OFF, 02:OFF/CPS ON, 03:ON/CPS ON
      outgoing_msg.data[5]	= pairing_type;		// 01:Standard, 02:LF-MPP
      outgoing_msg.data[6]	= 0x00;                 // 2 bytes- power off delta                  
      outgoing_msg.data[7]	= 0x00;			// No data
      outgoing_msg.data[8]	= 0x00;				// BER Threshold - No data
      outgoing_msg.data[9]	= 0x00;				// Inquiry timeout - No data
      outgoing_msg.data[10]	= 0x00;				// Inquiry scan timeout -No data
      
      // XNL to send data
      return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_BRDCST);
    }
    else
    {
      return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, BT_CONFIG_BCAST_NO_DATA_MSG_SIZE, XNL_DATA_MSG_BRDCST);  //Only message with the function, no optional data
    }
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_bt_config_request()

	DESCRIPTION: This function processes the BlueTooth Config request message.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_bt_config_request(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_bt_cfg_request_t incoming_msg;
  UINT8_T i, remaining_payload = 0;
  
  if (payload_length >= MIN_BT_CONFIG_REQUEST_SIZE)  
  {
    incoming_msg.opcode		= XCMP_MSG_OPCODE_REQUEST_BT_CONFIG;
    incoming_msg.function	= xcmp_get_1byte();
    // Calculate the remaining bytes for the optional data field
    remaining_payload = payload_length - 3; //Read the opcode and function bytes
    if(payload_length > MIN_BT_CONFIG_REQUEST_SIZE)
    {
      //Protect the data array and get the remaining data
      for(i=0; (i < remaining_payload) && (i < MAX_BT_CONFIG_DATA_BUFFER); i++)
      {
        incoming_msg.data[i]	= xcmp_get_1byte();  
      }
    }      
    //Pass decoded message to user application
    received_xcmp_bt_config_msg_rqst(xnl_devid, incoming_msg, remaining_payload);
            
    return XCMP_SUCCESS;
  }
  else
  {
    return XCMP_INSUFFICIENT_DATA;
  }
} 

