#ifndef XCMP_MSG_BT_CONFIG_H_
#define XCMP_MSG_BT_CONFIG_H_
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_bt_config.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for BlueTooth Config XCMP messages.
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            	Date Modified   Tracking Number		Description
* Abhishek Trivedi       09/06/2013      CCMPD01827271        XNL-XCMP Host
* Abhishek Trivedi      11/8/2013        CCMPD01834482       Updates for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
/* Opcode */
#define XCMP_MSG_OPCODE_REQUEST_BT_CONFIG				0x043D
#define XCMP_MSG_OPCODE_REPLY_BT_CONFIG					0x843D
#define XCMP_MSG_OPCODE_BROADCAST_BT_CONFIG				0xB43D

/* function */
#define XCMP_MSG_BT_POWER_UP_CONFIG					0x04

/* Accessory type */
#define XCMP_MSG_BT_AUDIO_ACCESSORY_TYPE				0x01
#define XCMP_MSG_BT_PTT_ACCESSORY_TYPE                                  0x03
#define XCMP_MSG_BT_NON_AUDIO_ACCESSORY_TYPE                            0x06

/* Pairing Type */
#define XCMP_MSG_BT_STD_PAIRING_TYPE				        0x01
#define XCMP_MSG_BT_MPP_PAIRING_TYPE                                    0x02
#define XCMP_MSG_BT_REPLACE_PAIRING_TYPE                                0x04

/* Pairing Timeout */
#define XCMP_MSG_BT_IMMEDIATE_PAIRING                                   0x00
#define XCMP_MSG_BT_INFINITE_PAIRING                                    0x01

/* Out of Range Timeout */
#define XCMP_MSG_BT_0_TIMEOUT                                           0x00
#define XCMP_MSG_BT_8_HR_TIMEOUT                                        0x80

/* BT state */
#define XCMP_MSG_BT_STATE_OFF                                           0x00
#define XCMP_MSG_BT_STATE_ON                                            0x01

/* Message sizes */
#define MIN_BT_CONFIG_REQUEST_SIZE					0x03
#define MAX_BT_CONFIG_DATA_BUFFER                                       20
#define BT_CONFIG_REPLY_AUDIO_PARAMS_MSG_SIZE                           15
#define BT_CONFIG_REPLY_NO_DATA_MSG_SIZE                                4
#define BT_CONFIG_BCAST_NO_DATA_MSG_SIZE                                3
#define BT_CONFIG_BCAST_AUDIO_PARAMS_MSG_SIZE                           14
//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct  
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT8_T		accy_type;
	UINT8_T		pairing_timeout;
	UINT8_T		out_of_range_timeout;
	UINT8_T		audio_gain_info;
	UINT8_T		bt_state;
	UINT8_T		pairing_type;
	UINT16_T	poweroff_delta;
	UINT8_T	        ber_threshold;
        UINT8_T         inquiry_timeout;
        UINT8_T         inquiry_scan_timeout;
}audio_accy_power_up_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT16_T	opcode;
	UINT8_T		function;
	UINT8_T		data[MAX_BT_CONFIG_DATA_BUFFER];
} xcmp_msg_bt_cfg_request_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT16_T	opcode;
	UINT8_T		result;
	UINT8_T		function;
	UINT8_T		data[MAX_BT_CONFIG_DATA_BUFFER];
} xcmp_msg_bt_cfg_reply_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT16_T	opcode;
	UINT8_T		function;
	UINT8_T		data[MAX_BT_CONFIG_DATA_BUFFER];
} xcmp_msg_bt_cfg_bcast_t;
#if __ICCAVR32__
#pragma pack()
#endif

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_bt_config_reply()

	DESCRIPTION: This function sends the BlueTooth Config reply message. 
==============================================================================*/
success_failure_t xcmp_msg_tx_bt_config_reply(UINT16_T xnl_devid, xcmp_reply_result_t result, UINT8_T function, 
											UINT8_T accy_type, UINT8_T pairing_timeout, 
                                                                                        UINT8_T out_of_range_timeout, 
											UINT8_T bt_state, UINT8_T pairing_type);
/*=============================================================================
  FUNCTION: xcmp_msg_tx_bt_config_bcast()

  DESCRIPTION: This function sends the BlueTooth Config Broadcast message. 
      Currently only supports the audio_accy_power_up_t structure optional data
==============================================================================*/
success_failure_t xcmp_msg_tx_bt_config_bcast(UINT16_T xnl_devid, UINT8_T function, 
                                                                  UINT8_T accy_type, UINT8_T pairing_timeout,
                                                                  UINT8_T out_of_range_timeout, 
                                                                  UINT8_T bt_state, UINT8_T pairing_type);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_bt_config_request()

	DESCRIPTION: This function processes the BlueTooth Config request message.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_bt_config_request(UINT16_T device_id, UINT8_T payload_length);

/* Description: This function receives a BlueTooth Config request message.
 * Parameters:
 *		function: Functions to perform. Power Up Config: 0x04
 *		accy_type: Types of accessory. OPTION BOARD: 0x00, AUDIO ACCESSORY: 0x01,
 *					DATA ACCESSORY: 0x02, GENERIC / NON-AUDIO: 0x03			
*/
void received_xcmp_bt_config_msg_rqst(UINT16_T xnl_devid, xcmp_msg_bt_cfg_request_t bt_cfg_rqst, UINT8_T optional_data_length);

#endif /* XCMP_MSG_BT_CONFIG_H_ */