/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_dev_init.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Device Initialization messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013            CCMPD01827271         XNL-XCMP Host
* Abhishek Trivedi      11/8/2013             CCMPD01834482       Updates for XNL-XCMP 
* Abhishek Trivedi    03/18/2014	        CCMPD01873731	  Rework for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */
// Extern Device Initialization Status Info configured by User
extern xcmp_msg_device_init_status_broadcast_t dev_init_status_info;
/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_rx_wait_device_init()

	DESCRIPTION: Processes incoming device init status message
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_wait_device_init(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_device_init_status_broadcast_t dev_init_msg;
  UINT8_T index = xnl_get_device_index_from_id(xnl_devid);
  UINT8_T i, remaining_payload = 0;
  
  //Check message payload size
  if(payload_length >= XCMP_DEVINIT_MSG_MIN_SIZE_CHK)
  {
    dev_init_msg.opcode = XCMP_MSG_OPCODE_BROADCAST_DEVICE_INITIALIZATION_STATUS;
    dev_init_msg.version = xcmp_get_2bytes();
    dev_init_msg.version <<= 16;    //32 bit value, shift the 16 bit value to MSB
    dev_init_msg.version |= xcmp_get_2bytes();
    dev_init_msg.init_type = xcmp_get_1byte();
    dev_init_msg.device_type = xcmp_get_1byte();	//Status =0 , Complete =1, Update =2 
    dev_init_msg.device_status = xcmp_get_2bytes();
    dev_init_msg.device_descriptor_size = xcmp_get_1byte();
    
    //11 bytes read
    remaining_payload = payload_length - XCMP_DEVINIT_MSG_MIN_SIZE_CHK;
    
    //Check if there is descriptor data remaining
    if(remaining_payload > 0 && (remaining_payload >= dev_init_msg.device_descriptor_size))
    {	
      //Fill in the descriptor data
      for(i=0; (i*ATTR_AND_VALUE) < dev_init_msg.device_descriptor_size; i++)
      {
        dev_init_msg.st_descriptor[i].attribute_id = xcmp_get_1byte();
        dev_init_msg.st_descriptor[i].attribute_value = xcmp_get_1byte();
      }	
      
      //Pass data to user application
      receive_xcmp_device_init_msg_bdst(xnl_devid, dev_init_msg);	
      
      //Check device status and device type to be simiilar to the xnl device type
      if(( dev_init_msg.init_type == XCMP_MSG_DEVICE_INIT_STATUS_TYPE_STATUS ) && dev_init_msg.device_type == xnl_device[index]->device_type)
      {
        return XCMP_SUCCESS;
      }
      else
      {
        return XCMP_FAILURE;
      }
    }
    else
    {
      return XCMP_INSUFFICIENT_DATA;
    }
  }
  else
  {
    //XCMP message size too short
    return XCMP_INSUFFICIENT_DATA;		
  }
}

/*=============================================================================
	FUNCTION: xcmp_msg_tx_device_init_status()

	DESCRIPTION: This function fills-in/stuffs and sends DEVICE INIT XCMP
                 message.
=============================================================================*/
success_failure_t xcmp_msg_tx_device_init_status(UINT16_T xnl_devid)
{
  UINT8_T message_size = XCMP_MSG_DEVICE_INIT_STATUS_MSG_HEADER_SIZE + 
							dev_init_status_info.device_descriptor_size;

  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&dev_init_status_info, message_size, XNL_DATA_MSG_BRDCST);
}

/*=============================================================================
	FUNCTION: xcmp_msg_tx_device_init_done()

	DESCRIPTION: This function fills-in/stuffs and sends DEVICE INIT DONE XCMP
                     message to XNL layer.
=============================================================================*/
success_failure_t xcmp_msg_tx_device_init_done(UINT16_T xnl_devid)
{
  UINT8_T message_size = XCMP_DEVINIT_MSG_COMPLETE_SIZE;
  xcmp_msg_device_init_status_broadcast_t outgoing_msg;
  
  outgoing_msg.opcode = XCMP_MSG_OPCODE_BROADCAST_DEVICE_INITIALIZATION_STATUS;
  outgoing_msg.version = dev_init_status_info.version;
  outgoing_msg.init_type = XCMP_MSG_DEVICE_INIT_STATUS_TYPE_COMPLETE;
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_BRDCST);
}
/*=============================================================================
	FUNCTION: xcmp_msg_tx_device_init_update()

	DESCRIPTION: This function fills-in/stuffs and sends DEVICE INIT DONE XCMP
                     message to XNL layer.
=============================================================================*/
success_failure_t xcmp_msg_tx_device_init_update(UINT16_T xnl_devid)
{
  UINT8_T message_size = XCMP_DEVINIT_MSG_COMPLETE_SIZE;
  xcmp_msg_device_init_status_broadcast_t outgoing_msg;
  
  outgoing_msg.opcode = XCMP_MSG_OPCODE_BROADCAST_DEVICE_INITIALIZATION_STATUS;
  outgoing_msg.version = dev_init_status_info.version;
  outgoing_msg.init_type = XCMP_MSG_DEVICE_INIT_STATUS_TYPE_UPDATE;
  
  //Copy the device descriptor of old device connected and also the new connection
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_BRDCST);  
}