#ifndef XCMP_MSG_DEV_INIT_STATUS_H
#define XCMP_MSG_DEV_INIT_STATUS_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_dev_init_status.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Device Initialization Status message.  It contains
# all the definitions for this specific message.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
*   AUTHOR              Date Modified         Tracking Number         Description
* Abhishek Trivedi      09/02/2013            CCMPD01827271            XNL Host
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/
//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
// Opcode */
#define XCMP_MSG_OPCODE_BROADCAST_DEVICE_INITIALIZATION_STATUS              0xB400

/* Current XCMP Version */
#define XCMP_MSG_DEVICE_INIT_STATUS_VERSION_NUMBER                          0x00000001

/* 'Type' field define(s) */
#define XCMP_MSG_DEVICE_INIT_STATUS_TYPE_STATUS                             0x00
#define XCMP_MSG_DEVICE_INIT_STATUS_TYPE_COMPLETE                           0x01
#define XCMP_MSG_DEVICE_INIT_STATUS_TYPE_UPDATE                             0x02

/* 'Device Type' field define(s) */
#define XCMP_MSG_DEVICE_INIT_STATUS_DEVICE_TYPE_RF_TRANSCEIVER              0x01
#define XCMP_MSG_DEVICE_INIT_STATUS_DEVICE_TYPE_OPTION_BOARD                0x07
#define XCMP_MSG_DEVICE_INIT_STATUS_DEVICE_TYPE_EXTERNAL_MIC                0x09

/* 'Device Status' field define(s) */
#define XCMP_MSG_DEVICE_INIT_STATUS_DEVICE_STATUS_NO_ERRORS                 0x0000

/* 'Device Descriptor Size' field Define(s) */
#define XCMP_MSG_DEVICE_INIT_STATUS_NO_DESCRIPTOR                           0
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_SIZE		            10
#define XCMP_MSG_DEVICE_INIT_STATUS_MSG_HEADER_SIZE                         11
#define XCMP_DEVINIT_MSG_MIN_SIZE_CHK                                       11
#define XCMP_DEVINIT_MSG_COMPLETE_SIZE                                      7

/* Device Descriptor Attribute Define(s) */
typedef enum
{
	XCMP_DEVICE_FAMILY			= 0,
	XCMP_DEVICE_PWR_LVL,
	XCMP_DEVICE_DISPLAY,
	XCMP_DEVICE_SPEAKER,
	XCMP_DEVICE_RF_BAND,
	XCMP_DEVICE_GPIO_CTRL,
	XCMP_DEVICE_SELECTED,
	XCMP_DEVICE_RADIO_TYPE,
	XCMP_DEVICE_SECURE_MODULE,
	XCMP_DEVICE_KEYPAD,
	XCMP_DEVICE_POWERUP_TYPE		= 10,
	XCMP_DEVICE_IDENTIFIER,
	XCMP_DEVICE_POWEROFF_TYPE,
	XCMP_DEVICE_CHANNEL_KNOB,
	XCMP_DEVICE_VIRTUAL_PERSONALITY_SUPPORTED,
	XCMP_DEVICE_PRODUCT_ID,
	XCMP_DEVICE_MIC_TYPE,
	XCMP_DEVICE_BLUETOOTH_TYPE,
	XCMP_DEVICE_PHYSICAL_CONTROL_ID1,
	XCMP_DEVICE_ACCELEROMETER_TYPE,
	XCMP_DEVICE_GPS_TYPE                    = 20,
}xcmp_device_descriptor_attr_id_t;

/* Device Descriptor Values Define(s) */
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_VALUE_NO_DISPLAY   0x00
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_VALUE_NO_KEYPAD    0x00
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_POWER_LEVEL        0x01
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_ATTRIB_DISPLAY     0x02
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_SPEAKER            0x03
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_RF_BAND            0x04
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_RADIO_TYPE                0x07
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_SECURE_MODULE      0x08
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_ATTRIB_KEYPAD      0x09
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_IDENTIFIER         0x0B
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_PRODUCT_ID         0x0F
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_MIC_TYPE           0x10
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_BLUETOOTH_TYPE     0x11
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_ATTRIB_CONTROL_ID  0x12
#define XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_DEVICE_ACCELEROMETER_TYPE 0x13



//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
/* Device Descriptor Definition */
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT8_T attribute_id;
  UINT8_T attribute_value;
} device_descriptor_t;

/* DEVice INITialization STatuS Broadcast Message: DEVINITSTS */
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T            opcode;
  UINT32_T            version;
  UINT8_T             init_type;
  UINT8_T             device_type;
  UINT16_T            device_status;
  UINT8_T             device_descriptor_size;
  device_descriptor_t  st_descriptor[XCMP_MSG_DEVICE_INIT_STATUS_DESCRIPTOR_SIZE];
} xcmp_msg_device_init_status_broadcast_t;
#if __ICCAVR32__
#pragma pack()
#endif
//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_rx_wait_device_init()

	DESCRIPTION: Processes incoming device init status message
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_wait_device_init(UINT16_T device_id, UINT8_T payload_length);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_device_init_status()

	DESCRIPTION: This function fills-in/stuffs and sends DEVICE INIT XCMP
                 message.
=============================================================================*/
success_failure_t xcmp_msg_tx_device_init_status(UINT16_T device_id);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_device_init_done()

	DESCRIPTION: This function fills-in/stuffs and sends DEVICE INIT DONE XCMP
                     message to XNL layer.
=============================================================================*/
success_failure_t xcmp_msg_tx_device_init_done(UINT16_T device_id);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_device_init_update()

	DESCRIPTION: This function fills-in/stuffs and sends DEVICE INIT DONE XCMP
                     message to XNL layer.
=============================================================================*/
success_failure_t xcmp_msg_tx_device_init_update(UINT16_T device_id);
/*=============================================================================
	FUNCTION: receive_xcmp_device_init_msg_bdst()

	DESCRIPTION: Glue code for the application .
=============================================================================*/
void receive_xcmp_device_init_msg_bdst(UINT16_T xnl_devid, xcmp_msg_device_init_status_broadcast_t dev_init_msg);
#endif // XCMP_MSG_DEV_INIT_STATUS_H

