#ifndef XCMP_MSG_EMERG_CONTROL_H
#define XCMP_MSG_EMERG_CONTROL_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_emerg_control.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Emergency Control XCMP message. 
# It contains all the definitions for this specific message.
# Message Format 
#     Offset    Size        Description
#     ------    -----   ------------------------------------
#       0         2     Opcode = 0x
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified   Tracking Number   Description
* Abhishek Trivedi  08/25/2013       CCMPD01827271     XNL-XCMP host
*
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
// Opcodes
#define XCMP_MSG_OPCODE_REQUEST_EMERG_CONTROL                      0x0413
#define XCMP_MSG_OPCODE_REPLY_EMERG_CONTROL                        0x8413 
#define XCMP_MSG_OPCODE_BROADCAST_EMERG_CONTROL                    0xB413 

// Message sizes
#define MIN_EMERG_CONTROL_REQUEST_MSG_SIZE			   5
#define MIN_EMERG_CONTROL_BROADCAST_MSG_SIZE                       5
#define MIN_EMERG_CONTROL_REPLY_MSG_SIZE                           7

// Options
#define EMERGENCY_INITIATED_BY_APPLICATION                         0x0000
#define EMERGENCY_INITIATED_BY_USER                                0x0020

// Emergency Control function
#define EMERG_CONTROL_FUNC_STATUS                                  0x80

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
// Make sure that data is byte aligned
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;       // 0x0413 
  UINT8_T   function;     // Function that needs to be performed: status-0x80
  UINT16_T  option; 
} xcmp_msg_emerg_control_request_t;

typedef struct 
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;			// 0x0413 
  UINT8_T   status;			// 0x00 : exit, 0x01 : alarm, 0x02 : call
  //UINT16_T  remote_address; 
  UINT16_T  option;         // Bitfield 5: 0 = application, 1 = user
}xcmp_msg_emerg_control_broadcast_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;       // 0x8413
  UINT8_T   result;       // Result code from audio filter request
  UINT8_T   function;     // Function that needs to be performed
  UINT16_T  option; 
  UINT8_T	status;
} xcmp_msg_emerg_control_reply_t;
#if __ICCAVR32__
#pragma pack(1)
#endif

// Emergency Control status
typedef enum
{
	EMERG_CONTROL_STATUS_EXIT	= 0x00,
	EMERG_CONTROL_STATUS_ALARM	= 0x01,
	EMERG_CONTROL_STATUS_CALL	= 0x02
}emerg_ctrl_status_t;

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------

/*=============================================================================
	FUNCTION: xcmp_msg_tx_emerg_control_broadcast()

	DESCRIPTION: Send Emergency Control broadcast message 
=============================================================================*/
success_failure_t xcmp_msg_tx_emerg_control_broadcast(UINT16_T device_id, emerg_ctrl_status_t status, UINT16_T option);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_emerg_control_reply()

	DESCRIPTION: Send Emergency Control reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_emerg_control_reply(UINT16_T device_id, xcmp_reply_result_t result, UINT8_T function, emerg_ctrl_status_t status);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_emerg_control_request()

	DESCRIPTION: Process incoming Emergency Control request message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_emerg_control_request(UINT16_T device_id, UINT8_T payload_length);

/* Description: This function receives an Emergency Control request message.
 * Parameters:
 *		xnl_devid: ID of target device.
 *		structure data for the request
*/
void received_xcmp_emerg_control_msg_rqst(UINT16_T xnl_devid, xcmp_msg_emerg_control_request_t rxd_msg);

#endif // XCMP_MSG_EMERG_CONTROL_H
