/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_emergency_control.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Emergency Control messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013           CCMPD01827271         XNL-XCMP Host
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_emerg_control_broadcast()

	DESCRIPTION: Send Emergency Control broadcast message 
=============================================================================*/
success_failure_t xcmp_msg_tx_emerg_control_broadcast(UINT16_T xnl_devid, emerg_ctrl_status_t status, UINT16_T option)
{
  xcmp_msg_emerg_control_broadcast_t outgoing_msg;
  outgoing_msg.opcode				= XCMP_MSG_OPCODE_BROADCAST_EMERG_CONTROL;
  outgoing_msg.status				= status;
  outgoing_msg.option             = option;
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, (UINT8_T)MIN_EMERG_CONTROL_BROADCAST_MSG_SIZE);
}

/*=============================================================================
	FUNCTION: xcmp_msg_tx_emerg_control_reply()

	DESCRIPTION: Send Emergency Control reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_emerg_control_reply(UINT16_T xnl_devid, xcmp_reply_result_t result, UINT8_T function, emerg_ctrl_status_t status)
{
  xcmp_msg_emerg_control_reply_t outgoing_msg;
  outgoing_msg.opcode     = XCMP_MSG_OPCODE_REPLY_EMERG_CONTROL;
  outgoing_msg.result	  = result;
  outgoing_msg.function   = function;
  outgoing_msg.option     = 0x0000; // default	
  outgoing_msg.status	  = status;
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, (UINT8_T)MIN_EMERG_CONTROL_REPLY_MSG_SIZE);
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_emerg_control_request()

	DESCRIPTION: Process incoming Emergency Control request message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_emerg_control_request(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_emerg_control_request_t incoming_msg;
  
  // Check message payload size
  if(payload_length >= MIN_EMERG_CONTROL_REQUEST_MSG_SIZE)
  {
    // Fill decoded message structure
    incoming_msg.opcode		= XCMP_MSG_OPCODE_REQUEST_EMERG_CONTROL;
    incoming_msg.function	= xcmp_get_1byte();
    incoming_msg.option		= xcmp_get_2bytes();
    
    // Pass decoded message to user application
    received_xcmp_emerg_control_msg_rqst(xnl_devid, incoming_msg);
    
    return XCMP_SUCCESS;
  }
  else
  {
    // XCMP message size too short
    return XCMP_INSUFFICIENT_DATA;
  }
}

