/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_ind_update.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Indicator Update messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013            CCMPD01827271         XNL-XCMP Host
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_indicator_update_request()

	DESCRIPTION: Send indicator update request
=============================================================================*/
success_failure_t xcmp_msg_tx_indicator_update_request(UINT16_T xnl_devid, UINT8_T function, UINT16_T indicator_id)
{
  xcmp_msg_ind_update_request_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_ind_update_request_t);
  outgoing_msg.opcode      = XCMP_MSG_OPCODE_REQUEST_INDICATOR_UPDATE;
  outgoing_msg.function    = function;
  outgoing_msg.num_ind     = 0x01;	//ACCY only supports one indicator
  outgoing_msg.struct_size = XCMP_INDICATOR_UPDATE_MSG_IND_STRUCT_SIZE;	//0x02
  outgoing_msg.colors_size = XCMP_INDICATOR_UPDATE_MSG_IND_NUM_COLORS;	//0x00
  outgoing_msg.struct_data = indicator_id; //0x0041 strobe or 0x0042 remote command

  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size);
}

/*=============================================================================
	FUNCTION: xcmp_msg_tx_indicator_update_reply()

	DESCRIPTION: Send indicator update reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_indicator_update_reply(UINT16_T xnl_devid, xcmp_reply_result_t result, UINT8_T function, UINT16_T indicator_id)
{
  xcmp_msg_ind_update_reply_t outgoing_msg;
  UINT8_T message_size = MIN_IND_UPDATE_REPLY_SIZE; //sizeof(xcmp_msg_ind_update_reply_t); 

  // Compose Indicator Update reply message
  outgoing_msg.opcode      = XCMP_MSG_OPCODE_REPLY_INDICATOR_UPDATE;
  outgoing_msg.result      = result; 
  outgoing_msg.function    = function;
  outgoing_msg.num_ind     = 0x01; 
  outgoing_msg.struct_size = XCMP_INDICATOR_UPDATE_MSG_IND_STRUCT_SIZE;	//0x02
  outgoing_msg.colors_size = XCMP_INDICATOR_UPDATE_MSG_IND_NUM_COLORS;	//0x00
  outgoing_msg.struct_data = indicator_id; //0x0041 strobe or 0x0042 remote command

  switch (outgoing_msg.function)
  {
    case 0x00: // 7 bytes additional data for update
    {
            message_size += 7;
            break;
    }

    case 0x02: // enable
    case 0x03: // disable
            break;

    default: 
    {
            outgoing_msg.result = 0x01;  // fail
            break;
    }
  }

  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size);

}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_indicator_update_request()

	DESCRIPTION: Process incoming indicator update request message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_indicator_update_request(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_ind_update_request_t incoming_msg;

  if ( payload_length >= MIN_IND_UPDATE_MSG_SIZE)  
  {
    incoming_msg.function    = xcmp_get_1byte();
    incoming_msg.num_ind     = xcmp_get_1byte();
    incoming_msg.struct_size = xcmp_get_1byte();
    incoming_msg.colors_size = xcmp_get_1byte();
    incoming_msg.struct_data = xcmp_get_2bytes();
              
    //Pass decoded message to user application
    received_xcmp_indicator_update_msg_rqst(xnl_devid, incoming_msg);
    
    return XCMP_SUCCESS;
  }
  else
  {
      return XCMP_INSUFFICIENT_DATA;
  } 
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_indicator_update_reply()

	DESCRIPTION: Process incoming indicator update reply message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_indicator_update_reply(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_ind_update_reply_t rx_msg;
      
  if ( payload_length >= MIN_IND_UPDATE_REPLY_SIZE )  
  {
    rx_msg.result      = xcmp_get_1byte();
    rx_msg.function    = xcmp_get_1byte();
    rx_msg.num_ind     = xcmp_get_1byte();
    rx_msg.struct_size = xcmp_get_1byte();
    rx_msg.colors_size = xcmp_get_1byte();
    rx_msg.struct_data = xcmp_get_2bytes(); // Indicator ID
            
    //Pass decoded message to user application
    received_xcmp_indicator_update_msg_rply(xnl_devid, rx_msg);
    
    return XCMP_SUCCESS;
  }
  // Probably this is a reply for an unsupported request message the Host sent.
  else if ( payload_length >= XCMP_MSG_UNSUPPORT_REPLY_MIN_SIZE )
  {
    rx_msg.result	= xcmp_get_1byte();
    //Pass result to user application, set other fields to be 0 or null
    //receive_xcmp_indicator_update_msg_rply(xnl_devid, rx_msg.result, 0x0000);
    
    return XCMP_SUCCESS;
  }
  else
  {
      return XCMP_INSUFFICIENT_DATA;
  } 
}
