#ifndef XCMP_MSG_IND_UPDATE_H
#define XCMP_MSG_IND_UPDATE_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_ind_update.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Indicator Update XCMP message.  It contains
# all the definitions for this specific message.
# Message Format 
#     Offset    Size        Description
#     ------    -----   ------------------------------------
#       0         2     Opcode = 0x
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified   	Tracking Number 	  Description
* Abhishek Trivedi       09/06/2013      CCMPD01827271       XNL-XCMP Host
*
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
#define ALL_LEDS                                                0x00FE  
#define ALL_INDICATORS                                          0x00FF
#define STROBE_LED                                              0x0041
#define REMOTE_COMMAND                                          0x0042

#define MIN_IND_UPDATE_MSG_SIZE                                 8
#define MIN_IND_UPDATE_REPLY_SIZE				9
#define XCMP_INDICATOR_UPDATE_MSG_IND_STRUCT_SIZE               2
#define XCMP_INDICATOR_UPDATE_MSG_IND_NUM_COLORS                0

#define XCMP_INDICATOR_UPDATE_MSG_FUNC_UPDATE					0x00
#define XCMP_INDICATOR_UPDATE_MSG_FUNC_QUERY					0x01
#define XCMP_INDICATOR_UPDATE_MSG_FUNC_ENABLE					0x02
#define XCMP_INDICATOR_UPDATE_MSG_FUNC_DISABLE					0x03
#define XCMP_INDICATOR_UPDATE_MSG_FUNC_QUERY_DSPY_1				0x04
#define XCMP_INDICATOR_UPDATE_MSG_FUNC_QUERY_DSPY_2				0x05
#define XCMP_INDICATOR_UPDATE_MSG_FUNC_REFRESH					0x06

#define XCMP_MSG_OPCODE_REQUEST_INDICATOR_UPDATE                0x0402
#define XCMP_MSG_OPCODE_REPLY_INDICATOR_UPDATE                  0x8402
//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------

#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;       // 0x0402 
  UINT8_T   function;     // Function that needs to be performed: 0x02 enable
  UINT8_T   num_ind;      // Number of indicators 
  UINT8_T   struct_size;  // Size of indicator update in IndData 
  UINT8_T   colors_size;  // Number of colors in the IndColor 
  UINT16_T  struct_data;  // IndData: 0x0041 strobe, 0x0042 remote command
} xcmp_msg_ind_update_request_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;       // 0x8402
  UINT8_T   result;       // Result code from indicator update request
  UINT8_T   function;     // Function that needs to be performed
  UINT8_T   num_ind;      // Number of indicators being updated or queried
  UINT8_T   struct_size;  // Size of indicator update in IndData array
  UINT8_T   colors_size;  // number of colors in the IndColor array
  UINT16_T  struct_data;  // refer the SECT. 0x00FE = ALL LED
  UINT8_T   more_data[7]; // Additional data
} xcmp_msg_ind_update_reply_t;
#if __ICCAVR32__
#pragma pack()
#endif
//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_indicator_update_request()

	DESCRIPTION: Send indicator update request
=============================================================================*/
success_failure_t xcmp_msg_tx_indicator_update_request(UINT16_T xnl_devid, UINT8_T function, UINT16_T indicator_id);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_indicator_update_reply()

	DESCRIPTION: Send indicator update reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_indicator_update_reply(UINT16_T xnl_devid, xcmp_reply_result_t result, UINT8_T function, UINT16_T indicator_id);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_indicator_update_request()

	DESCRIPTION: Process incoming indicator update request message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_indicator_update_request(UINT16_T xnl_devid, UINT8_T payload_length);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_indicator_update_reply()

	DESCRIPTION: Process incoming indicator update reply message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_indicator_update_reply(UINT16_T xnl_devid, UINT8_T payload_length);

/* Description: This function receives the Indicator Update reply message
 * Parameters:
 *		result: XCMP reply result code. See xcmp_reply_result_t.
 *				If result code is not XCMP_MSG_RESULT_SUCCESS, all other
 *				params should be 0 or NULL.
 *		indicator_id:same as above. 
*/	
void received_xcmp_indicator_update_msg_rply(UINT16_T xnl_devid, xcmp_msg_ind_update_reply_t ind_upd_rply);
/* Description: The function receives the Indicator Update request message
 * Parameters:
 *		function: same as above.
 *		indicator_id: same as above.
*/
void received_xcmp_indicator_update_msg_rqst(UINT16_T xnl_devid, xcmp_msg_ind_update_request_t ind_upd_rqst);
#endif // XCMP_MSG_IND_UPDATE_H
