/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_ping.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Ping messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013           CCMPD01827271           XNL-XCMP Host
* Abhishek Trivedi       03/18/2014	      CCMPD01873731	  Rework for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ping_request()

	DESCRIPTION: This function sends the Ping request message.
==============================================================================*/
success_failure_t xcmp_msg_tx_ping_request(UINT16_T xnl_devid)
{
  xcmp_msg_ping_request_t  outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_ping_request_t);

  // Stuff the message
  outgoing_msg.opcode   = XCMP_MSG_OPCODE_REQUEST_PING;

  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REQUEST);
}
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ping_reply()

	DESCRIPTION: This function sends the Ping reply message.
==============================================================================*/
success_failure_t xcmp_msg_tx_ping_reply(UINT16_T xnl_devid, UINT8_T result)
{
  xcmp_msg_ping_reply_t  outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_ping_reply_t);

  // Stuff the message
  outgoing_msg.opcode   = XCMP_MSG_OPCODE_REPLY_PING;
  outgoing_msg.result   = result;

  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REPLY);
}
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ping_reply()

	DESCRIPTION: This function processes the Ping reply message.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ping_reply(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_ping_reply_t incoming_msg;
  
  if ( payload_length >= MIN_PING_REPLY_MESSAGE_SIZE)  
  {
      incoming_msg.opcode		= XCMP_MSG_OPCODE_REPLY_PING;
      incoming_msg.result		= xcmp_get_1byte();
              
      //Pass decoded message to user application
      received_xcmp_ping_msg_rply(xnl_devid, incoming_msg);
              
      return XCMP_SUCCESS;
  }
  else
  {
      return XCMP_INSUFFICIENT_DATA;
  }
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_ping_request()

	DESCRIPTION: This function processes the Ping request message.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ping_request(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_ping_request_t incoming_msg;

  incoming_msg.opcode		= XCMP_MSG_OPCODE_REQUEST_PING;
         
  //Pass decoded message to user application
  received_xcmp_ping_msg_rqst(xnl_devid, incoming_msg);
          
  return XCMP_SUCCESS;
}