#ifndef XCMP_MSG_PING_H_
#define XCMP_MSG_PING_H_

/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_ping.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Ping message.  It contains
# all the definitions for this specific message.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"

/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
*   AUTHOR              Date Modified			Tracking Number         Description
* Abhishek Trivedi       09/06/2013             CCMPD01827271          XNL-XCMP Host
*
*
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
/* Opcodes */
#define XCMP_MSG_OPCODE_REQUEST_PING                    0x0431
#define XCMP_MSG_OPCODE_REPLY_PING			0x8431
#define XCMP_MSG_OPCODE_BROADCAST_PING			0xB431

/* Sizes */
#define MIN_PING_REPLY_MESSAGE_SIZE			3

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
/* PING REQuest Message: PINGREQ */
typedef struct
{
	UINT16_T opcode;
} xcmp_msg_ping_request_t;

// Make sure that data is byte aligned
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif
{
	UINT16_T opcode;
	UINT8_T  result;
} xcmp_msg_ping_reply_t;
#if __ICCAVR32__
#pragma pack()
#endif

typedef struct
{
	UINT16_T opcode;
} xcmp_msg_ping_broadcast_t;


//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ping_request()

	DESCRIPTION: This function sends the Ping request message.
==============================================================================*/
success_failure_t xcmp_msg_tx_ping_request(UINT16_T xnl_devid);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ping_reply()

	DESCRIPTION: This function sends the Ping reply message.
==============================================================================*/
success_failure_t xcmp_msg_tx_ping_reply(UINT16_T xnl_devid, UINT8_T result);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ping_reply()

	DESCRIPTION: This function processes the Ping reply message.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ping_reply(UINT16_T xnl_devid, UINT8_T payload_length);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ping_request()

	DESCRIPTION: This function processes the Ping request message.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ping_request(UINT16_T xnl_devid, UINT8_T payload_length);

/* Description: This function receives a Ping reply message.
 * Parameters:
 *		result: XCMP reply result code. Success: 0x00, Failure: 0x01
*/
void received_xcmp_ping_msg_rply(UINT16_T xnl_devid, xcmp_msg_ping_reply_t ping_rply);

void received_xcmp_ping_msg_rqst(UINT16_T xnl_devid, xcmp_msg_ping_request_t ping_rqst);

#endif /* XCMP_MSG_PING_H_ */