/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_pui_input.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP PUI Broadcast messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013           CCMPD01827271          XNL-XCMP Host
* Abhishek Trivedi      11/8/2013             CCMPD01834482       Updates for XNL-XCMP 
* Abhishek Trivedi      03/18/2014	      CCMPD01873731	  Rework for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_pui_broadcast()

	DESCRIPTION: Send Physical User Input message 
=============================================================================*/
success_failure_t xcmp_msg_tx_pui_broadcast(UINT16_T xnl_devid, UINT8_T source, UINT8_T type, UINT16_T id, UINT8_T state, UINT8_T state_max)
{
  xcmp_msg_pui_broadcast_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_pui_broadcast_t);
  outgoing_msg.opcode				= XCMP_MSG_OPCODE_BROADCAST_PU_INPUT;
  outgoing_msg.source				= source;
  outgoing_msg.type				= type;
  outgoing_msg.id				= id;
  outgoing_msg.state				= state;
  outgoing_msg.state_min			= XCMP_MSG_PUI_BUTTON_STATE_MIN;	// default value -  not supporting negative value
  outgoing_msg.state_max			= state_max;		// value can range from 1 - 255
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_BRDCST);
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_pui_broadcast()

	DESCRIPTION: Process a Physical User Input Broadcast XCMP message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_pui_broadcast(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_pui_broadcast_t incoming_msg; 

  if(payload_length >= XCMP_MSG_PUI_MSG_SIZE)
  {
    incoming_msg.opcode			= XCMP_MSG_OPCODE_BROADCAST_PU_INPUT;
    incoming_msg.source			= xcmp_get_1byte();
    incoming_msg.type			= xcmp_get_1byte();
    incoming_msg.id			= xcmp_get_2bytes();	// Vol_up: 0x0050, Vol_down: 0x0051
                                                                                                            // ACCY 1-dot: 0x0091, ACCY 2-dot: 0x0092, 
                                                                                                            // Accy orange: 0x0097
    incoming_msg.state			= xcmp_get_1byte();
    incoming_msg.state_min		= xcmp_get_1byte();	
    incoming_msg.state_max		= xcmp_get_1byte();	

    received_xcmp_puinput_msg_bdst(xnl_devid, incoming_msg);
    
    return XCMP_SUCCESS;
  }
  else
  {
    //XCMP message size too short
    return XCMP_INSUFFICIENT_DATA;
  }			
                
}
