#ifndef XCMP_MSG_PU_INPUT_H
#define XCMP_MSG_PU_INPUT_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_pu_input.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Physical user Input XCMP message.  It contains
# all the definitions for this specific message.
# Physical user Input Broadcast Message Format 
#     Offset   Field            Size        Description
#     ------   -----            -----   ------------------------------------
#       0      Opcode             2     Opcode = 0xB4 05 . 
#       2      PUI_source         1     origin of physical input.  = 0x00
#       3      PUI_Type           1     Type of physical Input being reported.
#       4      PUI_Id             2     PUI ID definition.
#                                       Vol Up = 0x 0050 ; Vol Dn = 0x 0051
#       6      PUI_State          1     State of inout being reported.
#       7      PUI_State_Min      1     Minimum state value for button. 
#                                       = 0x00 for non-channel knob.
#       8      PUI_State_Max      1     Maximum state value for button.
#                                       = 0x01 for non-channel knob.
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified   	Tracking Number		Description
* Abhishek Trivedi   09/06/2013         CCMPD01827271        XNL-XCMP Host
* Abhishek Trivedi   11/8/2013          CCMPD01834482       Updates for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
/* Opcode */
#define XCMP_MSG_OPCODE_REQUEST_PU_INPUT		0x0405
#define XCMP_MSG_OPCODE_REPLY_PU_INPUT			0x8405
#define XCMP_MSG_OPCODE_BROADCAST_PU_INPUT		0xB405

/* Input Sources */
#define PUI_SOURCE_CONTROL_HEAD                0x00
#define PUI_SOURCE_AT_KEYBOARD                 0x01
#define PUI_SOURCE_HANDSET                     0x03
#define PUI_SOURCE_BLUETOOTH                   0x04

/* Input Types */
#define XCMP_MSG_PUI_TYPE_MOMENTARY_BUTTON              0x00
#define XCMP_MSG_PUI_TYPE_EXTERNAL_SWITCH               0x01
#define XCMP_MSG_PUI_TYPE_RELATIVE_STATIC_SWITCH        0x02
#define XCMP_MSG_PUI_TYPE_ABSOLUTE_STATIC_SWITCH        0x03

/* Input IDs: Identifies which type of physical user input is being reported */ 
#define PUI_ID_PTT_BUTTON                               0x0001
#define PUI_ID_ROTATORY_VOLUME                          0x0002
#define PUI_ID_ROTARY_CHANNEL	                        0x0004
#define PUI_ID_VOL_UP                                   0x0050  
#define PUI_ID_VOL_DOWN                                 0x0051
#define PUI_ID_PORTABLE_SIDE_TOP                        0x0060
#define PUI_ID_PORTABLE_SIDE_MIDDLE	                0x0061
#define PUI_ID_PORTABLE_SIDE_BUTTON	                0x0062
#define PUI_ID_ACCY_NO_DOT	                        0x0090
#define PUI_ID_ACCY_1_DOT				0x0091
#define PUI_ID_ACCY_2_DOT	          		0x0092
#define PUI_ID_TOP_FRONT_ORANGE	                        0x0097
#define PUI_ID_SAI_RX_CAPABILITY                        0x00DA
#define PUI_ID_SAI_TX_CAPABILITY                        0x00DB


/* Input State Minimum and Maximums */
#define XCMP_MSG_PUI_BUTTON_STATE_MAX                   0x01
#define XCMP_MSG_PUI_BUTTON_STATE_MIN                   0x00
#define XCMP_MSG_PUI_ABS_STATIC_SWITCH_STATE_MIN        0x00
#define XCMP_MSG_PUI_ABS_STATIC_SWITCH_STATE_MAX        0xFF

/* Input State */
#define XCMP_MSG_PUI_STATE_MOMENTARY_BUTTON_RELEASE     0x00
#define XCMP_MSG_PUI_STATE_MOMENTARY_BUTTON_PRESS       0x01

/* Physical User Input Message Size */
#define XCMP_MSG_PUI_MSG_SIZE                           9

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT16_T  opcode;
	UINT8_T   source;
	UINT8_T   type;
	UINT16_T  id;
	UINT8_T   state;
	UINT8_T   state_min;
	UINT8_T   state_max;
} xcmp_msg_pui_broadcast_t;
#if __ICCAVR32__
#pragma pack()
#endif

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_pui_broadcast()

	DESCRIPTION: Send Physical User Input message 
=============================================================================*/
success_failure_t xcmp_msg_tx_pui_broadcast(UINT16_T xnl_devid, UINT8_T source, UINT8_T type, UINT16_T id, UINT8_T state, UINT8_T state_max);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_pui_broadcast()

	DESCRIPTION: Process a Physical User Input Broadcast XCMP message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_pui_broadcast(UINT16_T xnl_devid, UINT8_T payload_length);

/* Description: This function receives Physical User Input broadcast message.
 * Parameters:
 *		source: Designates the origin of the physical input.
 *		type: Identifies the type of physical input being reported.
 *		id: Identifies which physical input is being reported.
 *			E.g. ACCY 1-dot: 0x0091, ACCY 2-dot: 0x0092, ACCY orange: 0x0097
 *		state: Identifies the state of the physical input being reported.
 *		state_min: minimum state value 
 *		state_max: maximum state value 
*/
void received_xcmp_puinput_msg_bdst(UINT16_T xnl_devid, xcmp_msg_pui_broadcast_t pui_bcast);
#endif // XCMP_MSG_PU_INPUT_H

	
	

