/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_radio_status.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Radio Status messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013           CCMPD01827271         XNL-XCMP Host
* Abhishek Trivedi      11/8/2013             CCMPD01834482       Updates for XNL-XCMP 
* Abhishek Trivedi      03/18/2014	        CCMPD01873731	  Rework for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_radio_status_reply()

	DESCRIPTION: Send Radio Status reply message. Not supporting string values
=============================================================================*/
success_failure_t xcmp_msg_tx_radio_status_reply(UINT16_T xnl_devid, UINT8_T result, UINT8_T condition, UINT8_T status)
{
  xcmp_msg_radio_status_reply_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_radio_status_reply_t);
  
  outgoing_msg.opcode				= XCMP_MSG_OPCODE_REPLY_RADIO_STATUS;
  outgoing_msg.result				= result;
  outgoing_msg.condition			= condition;
  outgoing_msg.status				= status;
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REPLY);
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_radio_status_request()

	DESCRIPTION: Process incoming Radio Status request message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_radio_status_request(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_radio_status_request_t incoming_msg;
  
  //Check message payload size
  if(payload_length >= MIN_RADIO_STATUS_REQUEST_MSG_SIZE)
  {
    //Fill decoded message structure
    incoming_msg.opcode		= XCMP_MSG_OPCODE_REQUEST_RADIO_STATUS;
    incoming_msg.condition	= xcmp_get_1byte();
    
    //Pass decoded message to user application
    received_xcmp_radio_status_msg_rqst(xnl_devid, incoming_msg);
    
    return XCMP_SUCCESS;
  }
  else
  {
    //XCMP message size too short
    return XCMP_INSUFFICIENT_DATA;
  }
}

