#ifndef XCMP_MSG_RADIO_STATUS_H
#define XCMP_MSG_RADIO_STATUS_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_radio_status.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Radio Status XCMP message. 
# It contains all the definitions for this specific message.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR	    Date Modified		Tracking Number		Description
* Abhishek Trivedi  10/16/2013			CCMPD01827271      Initial creation
*
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
#define XCMP_MSG_OPCODE_REQUEST_RADIO_STATUS                    0x000E
#define XCMP_MSG_OPCODE_REPLY_RADIO_STATUS			0x800E

#define MIN_RADIO_STATUS_REQUEST_MSG_SIZE			0x03

#define RAD_STAT_BATT_VAL               0x03
#define RAD_STAT_LOW_BATT               0x04
#define RAD_STAT_POWER_UP_STATUS        0x05
#define RAD_STAT_BT_ADDR                0x18
#define RAD_STAT_BT_ACT_CONN            0x23
#define RAD_STAT_BT_STATUS              0x24
//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
// Make sure that data is byte aligned
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct 
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;			// 0x000E 
  UINT8_T   condition;		// Which parameter of the radio to read the status of.
} xcmp_msg_radio_status_request_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T  opcode;			// 0x800E
  UINT8_T   result;			// Success/Invalid_Parameter
  UINT8_T   condition;		// Which parameter of the radio to read the status of.
  UINT8_T   status;			// Radio status
} xcmp_msg_radio_status_reply_t;
#if __ICCAVR32__
#pragma pack()
#endif

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_radio_status_reply()

	DESCRIPTION: Send Radio Status reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_radio_status_reply(UINT16_T xnl_devid, UINT8_T result, UINT8_T condition, UINT8_T status);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_radio_status_request()

	DESCRIPTION: Process incoming Radio Status request message 
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_radio_status_request(UINT16_T xnl_devid, UINT8_T payload_length);

#endif /* XCMP_MSG_RADIO_STATUS_H */