/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_shutdown.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Shutdown messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013           CCMPD01827271         XNL-XCMP Host
* Abhishek Trivedi      11/8/2013             CCMPD01834482       Updates for XNL-XCMP 
* Abhishek Trivedi      03/18/2014	      CCMPD01873731	  Rework for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_shutdown_broadcast()

	DESCRIPTION: This function sends the Shutdown broadcast message. 
==============================================================================*/
success_failure_t xcmp_msg_tx_shutdown_broadcast(UINT16_T xnl_devid, shutdown_operation_t op, shutdown_reason_t reason, UINT8_T send_reason)
{
  xcmp_msg_shutdown_broadcast_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_shutdown_broadcast_t);

  // Stuff the message
  outgoing_msg.opcode			= XCMP_MSG_OPCODE_BROADCAST_RADIO_SHUTDOWN;
  outgoing_msg.operation		= op;
  if(send_reason != 0)
  {
    outgoing_msg.reason			= reason;
   // XNL to send data
   return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_BRDCST);
  }
  else
  {
    return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, (message_size - 1), XNL_DATA_MSG_BRDCST);
  }
}