#ifndef XCMP_MSG_SHUTDOWN_H_
#define XCMP_MSG_SHUTDOWN_H_
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_shutdown.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Shutdown XCMP message. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            Date Modified   	Tracking Number   Description
* Abhishek Trivedi       09/06/2013     CCMPD01827271    XNL-XCMP Host
* Abhishek Trivedi      11/8/2013       CCMPD01834482    Updates for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
#define XCMP_MSG_OPCODE_BROADCAST_RADIO_SHUTDOWN               0xB40A

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
typedef enum 
{
	NO_OPERATION		= 0x00,
	SHUTDOWN_DEVICE		= 0x01,
	RESET_DEVICE		= 0x02
}shutdown_operation_t;

typedef enum
{
	REASON_NOT_SPECIFIED		= 0x00,
	POWER_BTN_PRESSED		= 0x01,
	IGNITION_TRANS_TO_INACTIVE	= 0x02,
	REMOTE_COM_RECEIVED		= 0x03
}shutdown_reason_t;

#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT16_T		opcode;
	UINT8_T			operation;
	UINT8_T			reason;
}xcmp_msg_shutdown_broadcast_t;
#if __ICCAVR32__
#pragma pack()
#endif
//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
success_failure_t xcmp_msg_tx_shutdown_broadcast(UINT16_T device_id, shutdown_operation_t op, shutdown_reason_t reason, UINT8_T send_reason);

#endif /* XCMP_MSG_SHUTDOWN_H_ */