#ifndef XCMP_MSG_TONE_CNTRL 
#define XCMP_MSG_TONE_CNTRL
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_tone_cntrl.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Tone Control XCMP message.  It contains
# all the definitions for this specific message.
# Message Format 
#     Offset    Size        Description
#     ------    -----   ------------------------------------
#       0         2     Opcode = 0x
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/********************************************************************************
*
*--------------------------- Revision History ----------------------------------
*
* AUTHOR            	Date Modified   Tracking Number   Description
* Abhishek Trivedi      09/06/2013      CCMPD01827271     XNL-XCMP Host
* Abhishek Trivedi      11/8/2013       CCMPD01834482     Updates for XNL-XCMP 
* Abhishek Trivedi      01/16/2014      CCMPD01853480     Tone requests for WPTT
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
/* Opcode */
#define XCMP_MSG_OPCODE_REQUEST_TONE_CNTRL			0x0409
#define XCMP_MSG_OPCODE_REPLY_TONE_CNTRL			0x8409
#define XCMP_MSG_OPCODE_BROADCAST_TONE_CNTRL			0xB409

/* Message sizes */
#define XCMP_MSG_TONE_CTRL_REPLY_EXPECTED_MSG_SIZE              5
#define XCMP_MSG_TONE_REQUEST_SIZE                              6
#define XCMP_MSG_TONE_CTRL_REQUEST_MIN_MSG_SIZE			6
#define XCMP_MSG_TONE_CTRL_REPLY_MIN_MSG_SIZE			7
#define XCMP_MSG_TONE_CTRL_REPLY_SIZE				7
#define XCMP_MSG_TONE_CTRL_BROADCAST_SIZE			14
#define XCMP_MSG_TONE_SPECIFICS_SIZE				8
#define SPECIFIC_TONE_MAX_FREQS_ALLOWED                         3
#define SPECIFIC_TONE_FREQ_AND_PATTERN_SIZE                     4
#define XCMP_MSG_TONE_CTRL_MAX_FRQ_NUMBER			((SPECIFIC_TONE_MAX_FREQS_ALLOWED)*(SPECIFIC_TONE_FREQ_AND_PATTERN_SIZE))

/* 'ToneIdentifier' field */
#define XCMP_MSG_SPECIFIC_TONE                                  0
#define XCMP_MSG_TONE_CTRL_ID_ALL_TONES				0xFFFF
#define ALERT_TONE_LOW_BATTERY                                  0x000A
#define PORTABLE_VOL_SET_TONE_ID				0x0035		
#define VOL_SET_TONE_ID                                         0x0027		
#define VOL_FEEDBACK_TONE                                       0x0047
#define BT_CONNECTING_SUCCESS_TONE                              0x0077
#define BT_DISCONNECTING_SUCCESS_TONE                           0x0078
#define NEGATIVE_INDICATION_TONE                                0x0039
/* 'ToneVolumeControl' field */
#define XCMP_MSG_TONE_VOL_CTRL_CURRENT_VOL			0x00

/* 'ToneControl' field */
#define XCMP_MSG_TONE_CTRL_STOP					0x00
#define XCMP_MSG_TONE_CTRL_START				0x01
#define XCMP_MSG_TONE_CTRL_DISABLE				0x02
#define XCMP_MSG_TONE_CTRL_ENABLE				0x03

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
// Make sure that data is byte aligned
#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct  
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T	tone_specifics_frequency;
  UINT16_T	tone_specifics_pattern;
}tone_frequency_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT8_T	tone_specifics_repetition;
  UINT8_T	tone_specifics_timebase;
  UINT8_T	tone_specifics_priority;
  UINT8_T	tone_specifics_numfrequencies;
  UINT8_T	frequency[XCMP_MSG_TONE_CTRL_MAX_FRQ_NUMBER];   //tone_frequency_t
}tone_specifics_t;

typedef struct 
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T	opcode;	
  UINT8_T	ToneControl;			
  UINT16_T	ToneIdentifier; 
  UINT8_T	ToneVolumeCtrl;
  UINT8_T	ToneSpecifics[XCMP_MSG_TONE_SPECIFICS_SIZE];
}xcmp_msg_tone_control_broadcast_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T    opcode;
  UINT8_T     result;
  UINT16_T    toneIdentifier;
  UINT16_T    duration;
}xcmp_msg_tone_control_reply_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
  UINT16_T		opcode;
  UINT8_T		ToneControl;
  UINT16_T		ToneIdentifier;
  UINT8_T		ToneVolumeCtrl;
  tone_specifics_t	SpecificTone;
}xcmp_msg_tone_control_request_t;
#if __ICCAVR32__
#pragma pack()
#endif
//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/******************************************************************************************
 *  FUNCTION NAME: xcmp_msg_tx_tone_cntlr_broadcast()
 *
 *  DESCRIPTION: This function will build and send the TONE CTRL BROADCAST message  
 ******************************************************************************************/
success_failure_t xcmp_msg_tx_tone_cntlr_broadcast(UINT16_T device_id, UINT8_T control, UINT16_T identifier, UINT8_T volume, UINT8_T * tone_spec, UINT8_T tone_spec_size);
/******************************************************************************************
 *  FUNCTION NAME: xcmp_msg_tx_tone_cntlr_reply()
 *
 *  DESCRIPTION: This function will build the TONECTRLREQ message based on events  
 ******************************************************************************************/
success_failure_t xcmp_msg_tx_tone_cntlr_reply(UINT16_T device_id, xcmp_reply_result_t result, UINT16_T identifier, UINT16_T duration);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_tone_cntlr_request()
	
	DESCRIPTION: This function processes the Tone Control request.
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_tone_cntlr_request(UINT16_T device_id, UINT8_T payload_length);
/******************************************************************************************
 *  FUNCTION NAME: xcmp_msg_tx_tone_cntlr_request()
 *
 *  DESCRIPTION: This function will build the TONECTRLREQ message based on events  
 ******************************************************************************************/
success_failure_t xcmp_msg_tx_tone_cntlr_request(UINT16_T xnl_devid, UINT8_T control, UINT16_T identifier, UINT8_T vol_ctrl, UINT8_T * tone_spec, UINT8_T tone_spec_freq_size);
/* Description: This function receives Tone Control request message.
 * Parameters:
 *		tone_control: Type of tone action to perform. Stop: 0x00, Start: 0x01
*/
void received_xcmp_tone_control_msg_rqst(UINT16_T xnl_devid, xcmp_msg_tone_control_request_t tone_ctrl_rqst);
void received_xcmp_tone_control_msg_rply(UINT16_T xnl_devid, xcmp_msg_tone_control_reply_t tone_ctrl_rply);
#endif // XCMP_MSG_TONE_CNTRL