/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2014 MOTOROLA SOLUTIONS,INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_unsupported_req.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for Unsupported XCMP Request messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xcmp_config.h"
#include "xnl.h"
#include "xnl_config.h"
#include "xcmp.h"

/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       02/02/2014           CCMPD01873731       Library style interfaces
* Abhishek Trivedi       06/05/2014           CCMPD01900617       Version Request Support
**--------------------------- End of History Template----------------------------- */

/*=============================================================================
	FUNCTION: xcmp_msg_tx_unsupported_xcmp_msg_reply()

	DESCRIPTION: This function sends an "unsupported XCMP msg" reply when an 
				unsupported XCMP opcode request msg is received.
=============================================================================*/
success_failure_t xcmp_msg_tx_unsupported_xcmp_msg_reply(UINT16_T xnl_devid, UINT16_T unsupported_xcmp_opcode)
{
  UINT8_T outgoing_msg[UNSUPPORTED_MSG_REPLY_XCMP_PAYLOAD];
  
  unsupported_xcmp_opcode |= XCMP_MSG_OPCODE_REPLY;
  
  outgoing_msg[0] = (unsupported_xcmp_opcode >> 8) & 0x00FFu;
  outgoing_msg[1] = unsupported_xcmp_opcode & 0x00FFu;
  outgoing_msg[2] = UNSUPPORTED_MSG_REPLY_RESULT_CODE;
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, outgoing_msg, UNSUPPORTED_MSG_REPLY_XCMP_PAYLOAD, XNL_UNSUPPORTED_REQ); 
}
/* End of xcmp_msg_tx_unsupported_xcmp_msg_reply() */

/*=============================================================================
	FUNCTION: xcmp_msg_send_invalid_xcmp_msg_reply()

	DESCRIPTION: This function sends an "invalid xcmp parameter" reply when an 
              xcmp message with invalid parameter request is received.

	ARGUMENTS PASSED: Opcode of invalid XCMP message.

	REFERENCE ARGUMENTS PASSED: none

	RETURN VALUE: none
=============================================================================*/
success_failure_t xcmp_msg_send_invalid_xcmp_msg_reply(UINT16_T xnl_devid, UINT16_T invalid_xcmp_parameter, UINT8_T echo_function, UINT8_T echo_reqd)
{
  UINT8_T outgoing_msg[INVALID_MSG_REPLY_XCMP_PAYLOAD];
  UINT8_T msg_size = MIN_INVALID_MSG_REPLY_XCMP_PAYLOAD;
  
  invalid_xcmp_parameter |= XCMP_MSG_OPCODE_REPLY;
  
  outgoing_msg[0] = (invalid_xcmp_parameter >> 8) & 0x00FFu;
  outgoing_msg[1] = (UINT8_T)invalid_xcmp_parameter;  
  outgoing_msg[2] = INVALID_MSG_REPLY_RESULT_CODE;

  if(echo_reqd)
  {
    outgoing_msg[3] = echo_function;
    msg_size++;
  }
  
  // Pass messge to XNL layer
  return xnl_send_data_msg(xnl_devid, outgoing_msg, msg_size, XNL_UNSUPPORTED_REQ);
}
/* End of xcmp_msg_send_invalid_xcmp_msg_reply() */

/*=============================================================================
	FUNCTION: xcmp_msg_rx_unsupported_xcmp_msg_request()

	DESCRIPTION: This function notifies the user application when an 
				unsupported XCMP request msg is received.
=============================================================================*/
void xcmp_msg_rx_unsupported_xcmp_msg_request(UINT16_T xnl_devid, UINT16_T xcmp_opcode)
{
  // Notify user application
  receive_xcmp_unsupported_msg_rqst(xnl_devid, xcmp_opcode);
}