/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_ver_info.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Version Information messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number      Description
* Abhishek Trivedi       09/06/2013          CCMPD01827271        XNL-XCMP Host
* Abhishek Trivedi       11/8/2013           CCMPD01834482        Updates for XNL-XCMP 
* Abhishek Trivedi       03/18/2014	     CCMPD01873731	  Rework for XNL-XCMP 
* Abhishek Trivedi       06/05/2014          CCMPD01900617        Version Request Support
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ver_info_request()

	DESCRIPTION: Send Version Info request message 
=============================================================================*/
success_failure_t xcmp_msg_tx_ver_info_request(UINT16_T xnl_devid, ver_info_request_type_t type)
{
  xcmp_msg_ver_info_request_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_ver_info_request_t);
  
  outgoing_msg.opcode			= XCMP_MSG_OPCODE_REQUEST_VERSION_INFO;
  outgoing_msg.ver_type			= type;
  
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REQUEST);
}
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ver_info_reply()

	DESCRIPTION: Send Version Info reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_ver_info_reply(UINT16_T xnl_devid, UINT8_T result, UINT8_T* ver_ptr, UINT8_T size)
{
  xcmp_msg_ver_info_reply_t outgoing_msg;
  UINT8_T i = 0;
  UINT8_T message_size = 0;
  
  outgoing_msg.opcode			= XCMP_MSG_OPCODE_REPLY_VERSION_INFO;
  outgoing_msg.result			= result;
  //add 3 bytes to message size for opcode and result
  message_size += 3;
  if(result == XCMP_MSG_RESULT_SUCCESS)
  {
    for(i=0; i<size && i<MAX_VERSION_SIZE; i++, message_size++)
    {
      outgoing_msg.version_buffer[i] = *ver_ptr++;
    }
  }
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REPLY);  
}
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ver_info_rqst()

	DESCRIPTION: Process Version Info request message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ver_info_rqst(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_ver_info_request_t incoming_msg;
  
  if(payload_length >= VER_INFO_RQST_SIZE)
  {
    incoming_msg.opcode     = XCMP_MSG_OPCODE_REQUEST_VERSION_INFO;
    incoming_msg.ver_type   = xcmp_get_1byte();
    
    // Pass decoded message to user application
    received_xcmp_ver_info_msg_rqst(xnl_devid, incoming_msg);   
    
    return XCMP_SUCCESS;
  }
  else
  {
    //XCMP message size too short
    return XCMP_INSUFFICIENT_DATA;
  }	  
}
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ver_info_reply()

	DESCRIPTION: Process Version Info reply message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ver_info_reply(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_ver_info_reply_t incoming_msg;
  UINT8_T i, remaining_length = 0;
  
  if(payload_length >= MIN_VER_INFO_MSG_REPLY_SIZE)
  {
    incoming_msg.opcode			= XCMP_MSG_OPCODE_REPLY_VERSION_INFO;
    incoming_msg.result			= xcmp_get_1byte();
    
    // Request failed or not supported
    if(incoming_msg.result != XCMP_MSG_RESULT_SUCCESS)
    {
      incoming_msg.version_size = 0x00;
    }
    else
    {
      // 3 bytes read
      remaining_length = payload_length - 3;
      
      // Get version data size
      incoming_msg.version_size = remaining_length;
              
      // Clear payload_length to be a counter
      for(i = 0; (i < remaining_length) && (i < MAX_VERSION_SIZE); i++)
      {
        incoming_msg.version_buffer[i] = xcmp_get_1byte();
      }
    }
    // Pass decoded message to user application
    received_xcmp_ver_info_msg_rply(xnl_devid, incoming_msg);
    
    return XCMP_SUCCESS;
  }
  else
  {
    //XCMP message size too short
    return XCMP_INSUFFICIENT_DATA;
  }			

}

