#ifndef XCMP_MSG_VER_INFO_H 
#define XCMP_MSG_VER_INFO_H
/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013 MOTOROLA SOLUTIONS, INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_ver_info.h
#
# --------------------------- General Description -----------------------------
# This is the XCMP message header file for Version Info message.
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013          CCMPD01827271           XNL-XCMP Host
* Abhishek Trivedi       06/05/2014          CCMPD01900617        Version Request Support
* Abhishek Trivedi       11/02/2014          CCMPD01943851        Differentiate PRODUCT_ID defines
**--------------------------- End of History Template-----------------------------*/
//------------------------------------------------------------------------------
//      Defines
//------------------------------------------------------------------------------
#define XCMP_MSG_OPCODE_REQUEST_VERSION_INFO		0x000F
#define XCMP_MSG_OPCODE_REPLY_VERSION_INFO		0x800F

#define VER_INFO_RQST_SIZE                              3
#define MIN_VER_INFO_MSG_REPLY_SIZE			3
#define MAX_VERSION_SIZE				25

//------------------------------------------------------------------------------
//    ENUMS &  STRUCTURES
//------------------------------------------------------------------------------
typedef enum
{
  HOST_SW_VER		= 0x00,
  XCMP_PRODUCT_ID       = 0x46,        
  ACCY_NAME		= 0xC0,
  ACCY_HW_VER		= 0xC1
}ver_info_request_type_t;

#if __ICCAVR32__
#pragma pack(1)
#endif
typedef struct  
#if (defined __GNUC__)
__attribute__((__packed__))
#endif 
{
	UINT16_T	opcode;
	UINT8_T		ver_type;
}xcmp_msg_ver_info_request_t;

typedef struct
#if (defined __GNUC__)
__attribute__((__packed__))
#endif   
{
	UINT16_T	opcode;
	UINT8_T		result;
	UINT8_T		version_buffer[MAX_VERSION_SIZE];
	UINT8_T		version_size;
}xcmp_msg_ver_info_reply_t;
#if __ICCAVR32__
#pragma pack()
#endif

//------------------------------------------------------------------------------
//      FUNCTION PROTOTYPES
//------------------------------------------------------------------------------
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ver_info_request()

	DESCRIPTION: Send Version Info request message 
=============================================================================*/
success_failure_t xcmp_msg_tx_ver_info_request(UINT16_T device_id, ver_info_request_type_t type);
/*=============================================================================
	FUNCTION: xcmp_msg_tx_ver_info_reply()

	DESCRIPTION: Send Version Info reply message 
=============================================================================*/
success_failure_t xcmp_msg_tx_ver_info_reply(UINT16_T device_id, UINT8_T result, UINT8_T* ver_ptr, UINT8_T size);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ver_info_rqst()

	DESCRIPTION: Process Version Info request message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ver_info_rqst(UINT16_T xnl_devid, UINT8_T payload_length);
/*=============================================================================
	FUNCTION: xcmp_msg_rx_ver_info_reply()

	DESCRIPTION: Process Version Info reply message.
=============================================================================*/
xcmp_return_value_t xcmp_msg_rx_ver_info_reply(UINT16_T device_id, UINT8_T payload_length);
/* Description: The function receives version info sent from accessory.
 * Parameters:
 *		result: XCMP reply result code. See xcmp_reply_result_t.
 *				If result code is not XCMP_MSG_RESULT_SUCCESS, all other
 *				params should be 0 or NULL.
 *		version_buffer: a pointer to the version data buffer.
 *		version_size: the size of data in version_buffer.
 *			Default maximum buffer size is 50, defined in xcmp_msg_ver_info.h
*/
void received_xcmp_ver_info_msg_rply(UINT16_T xnl_devid, xcmp_msg_ver_info_reply_t ver_info_rply);

void received_xcmp_ver_info_msg_rqst(UINT16_T xnl_devid, xcmp_msg_ver_info_request_t ver_info_rqst);
#endif	//XCMP_MSG_VER_INFO_H