/*################################################################################
#
#                  F U N C T I O N S P E C I F I C A T I O N
#             COPYRIGHT 2011,2013-2014 MOTOROLA SOLUTIONS INC. ALL RIGHTS RESERVED.
#                    MOTOROLA CONFIDENTIAL RESTRICTED
#
#################################################################################
#
# FILE NAME: xcmp_msg_vol_ctrl.c
#
# --------------------------- General Description -----------------------------
# The file includes handler function for XCMP Volume Control messages. 
#
# --------------------------- HEADER FILE INCLUDES ----------------------------*/
#include "xnl.h"
#include "xcmp_config.h"
/************************************************************************************
*
*--------------------------------- Revision History ----------------------------------
*
*   AUTHOR               Date Modified        Tracking Number         Description
* Abhishek Trivedi       09/06/2013           CCMPD01827271          XNL-XCMP Host
* Abhishek Trivedi       03/18/2014	      CCMPD01873731	     Rework for XNL-XCMP 
**--------------------------- End of History Template-----------------------------
* *********************************************************************************/

/* ***************************************************************************
                                DEFINES
   ************************************************************************** */

/* ***************************************************************************
                                ENUMS & STRUCTURES
   ************************************************************************** */

/* ***************************************************************************
                                GLOBAL VARIABLES
   ************************************************************************** */                                               

/* ***************************************************************************
                                EXTERNAL VARIABLES
   ************************************************************************** */

/* ***************************************************************************
                                EXTERNAL FUNCTIONS
   ************************************************************************** */

/* ***************************************************************************
                                FUNCTION PROTOTYPES
   ************************************************************************** */
/*=============================================================================
	FUNCTION: xcmp_msg_tx_volume_control_request()

	DESCRIPTION: This function sends a Volume Control Request XCMP message .
=============================================================================*/
success_failure_t xcmp_msg_tx_volume_control_request(UINT16_T xnl_devid, volume_ctrl_func_t function, UINT8_T vol_data, UINT8_T send_opt_param)
{
  xcmp_msg_volume_ctrl_request_msg_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_volume_ctrl_request_msg_t);

  outgoing_msg.opcode         = XCMP_MSG_OPCODE_REQUEST_VOL_CNTRL;
  outgoing_msg.attenuator_no  = (UINT16_T)ACCY_VOLUME_ATTE_NUM_ALL_SPKR;
  outgoing_msg.function       = (UINT8_T)function;
  if(send_opt_param != 0)
  {
    outgoing_msg.volume_data    = vol_data;
      // XNL to send data
    return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REQUEST);
  }
  else
  {
    return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, (message_size - 1), XNL_DATA_MSG_REQUEST);
  }
}

/*=============================================================================
	FUNCTION: xcmp_msg_tx_volume_control_reply()

	DESCRIPTION: This function sends a Volume Control reply XCMP message.
=============================================================================*/
success_failure_t xcmp_msg_tx_volume_control_reply(UINT16_T xnl_devid, xcmp_reply_result_t result, volume_ctrl_func_t function, UINT8_T volume_data, UINT8_T send_opt_param)
{
  xcmp_msg_volume_ctrl_reply_msg_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_volume_ctrl_reply_msg_t);

  outgoing_msg.opcode			= XCMP_MSG_OPCODE_REPLY_VOL_CNTRL;
  outgoing_msg.result			= result;
  outgoing_msg.attenuator_no		= (UINT16_T)ACCY_VOLUME_ATTE_NUM_ALL_SPKR;
  outgoing_msg.function			= function;
  if(send_opt_param != 0)
  {
    outgoing_msg.volume_data    = volume_data;
      // XNL to send data
    return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_REPLY);
  }
  else
  {
    return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, (message_size - 1), XNL_DATA_MSG_REPLY);
  }
		
}

/*=============================================================================
	FUNCTION: xcmp_msg_tx_volume_control_broadcast()

	DESCRIPTION: This function sends a Volume Control broadcast XCMP message.
=============================================================================*/
success_failure_t xcmp_msg_tx_volume_control_broadcast(UINT16_T xnl_devid, UINT8_T volume_data, UINT8_T audio_parameter)
{
  xcmp_msg_volume_ctrl_broadcast_msg_t outgoing_msg;
  UINT8_T message_size = sizeof(xcmp_msg_volume_ctrl_broadcast_msg_t);

      // Stuff the message
  outgoing_msg.opcode			= XCMP_MSG_OPCODE_BROADCAST_VOL_CNTRL;
  outgoing_msg.attenuator_no		= (UINT16_T)ACCY_VOLUME_ATTE_NUM_ALL_SPKR;
  outgoing_msg.volume_data		= volume_data;
  outgoing_msg.audio_parameter	        = audio_parameter;
                      
  // XNL to send data
  return xnl_send_data_msg(xnl_devid, (UINT8_T *)&outgoing_msg, message_size, XNL_DATA_MSG_BRDCST);
}

/*=============================================================================
	FUNCTION: xcmp_msg_rx_volume_control_request()

	DESCRIPTION: This function processes the Volume Control Reply 
                     message received from the radio. 
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_volume_control_request(UINT16_T xnl_devid, UINT8_T payload_length)
{
  xcmp_msg_volume_ctrl_request_msg_t incoming_msg;
  
  if ( payload_length >= MIN_VOL_CNTRL_RQST_MSG_SIZE)  
  {
    incoming_msg.opcode         = XCMP_MSG_OPCODE_REQUEST_VOL_CNTRL;   
    incoming_msg.attenuator_no	= xcmp_get_2bytes();
    incoming_msg.function	= xcmp_get_1byte();
    
    if(payload_length > MIN_VOL_CNTRL_RQST_MSG_SIZE)    //optional parameter
    {
      incoming_msg.volume_data	= xcmp_get_1byte();
    }
     //Pass decoded message to user application
    received_xcmp_volume_control_msg_rqst(xnl_devid, incoming_msg, payload_length);        
     
    return XCMP_SUCCESS;
  }
  else
  {
      return XCMP_INSUFFICIENT_DATA;
  }
} 

/*=============================================================================
	FUNCTION: xcmp_msg_rx_volume_control_reply()

	DESCRIPTION: This function processes the Volume Control Reply 
                     message received from the radio. 
==============================================================================*/
xcmp_return_value_t xcmp_msg_rx_volume_control_reply(UINT16_T xnl_devid, UINT8_T payload_length)
{
    xcmp_msg_volume_ctrl_reply_msg_t incoming_msg;

    if ( payload_length >= MIN_VOL_CNTRL_RPLY_MSG_SIZE)  
    {
      incoming_msg.result		= xcmp_get_1byte();    
      incoming_msg.attenuator_no	= xcmp_get_2bytes();
      incoming_msg.function		= xcmp_get_1byte();

      if(payload_length > MIN_VOL_CNTRL_RQST_MSG_SIZE)    //optional parameter
      {
        incoming_msg.volume_data	= xcmp_get_1byte();
      }
      //Pass decoded message to user application
      received_xcmp_volume_control_msg_rply(xnl_devid, incoming_msg, payload_length);
		
      return XCMP_SUCCESS;
    }
    // Probably this is a reply for an unsupported request message the Host sent.
    else if ( payload_length == XCMP_MSG_UNSUPPORT_REPLY_MIN_SIZE )
    {
      incoming_msg.result	= xcmp_get_1byte();
      //Pass result to user application, set other fields to be 0 or null
      received_xcmp_volume_control_msg_rply(xnl_devid, incoming_msg, payload_length);
            
      return XCMP_SUCCESS;
    }
    else
    {
      return XCMP_INSUFFICIENT_DATA;
    }
} 
